/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteSet<T> {
    private volatile Set<T> set = new HashSet<T>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T t) {
        Set<T> set = this.set;
        synchronized (set) {
            HashSet<T> hashSet = new HashSet<T>(this.set);
            hashSet.add(t);
            this.set = hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        Set<T> set = this.set;
        synchronized (set) {
            HashSet<T> hashSet = new HashSet<T>(this.set);
            boolean bl = hashSet.remove(t);
            this.set = hashSet;
            return bl;
        }
    }

    public boolean contains(T t) {
        return this.set.contains(t);
    }

    public int size() {
        return this.set.size();
    }

    public Iterator<T> iterator() {
        return new CopyOnWriteSetIterator(this.set.iterator());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyOnWriteSetIterator
    implements Iterator<T> {
        private Iterator<T> it;
        private T last;

        protected CopyOnWriteSetIterator(Iterator<T> iterator) {
            this.it = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteSet.this.remove(this.last);
        }
    }
}

