/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationManager;
import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.lws.LightWeightSeed;
import com.aelitis.azureus.core.lws.LightWeightSeedManager;
import com.aelitis.azureus.core.messenger.config.PlatformSubscriptionsMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearchListener;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.security.CryptoECCUtils;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionAssociationLookup;
import com.aelitis.azureus.core.subs.SubscriptionDownloadListener;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionLookupListener;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerListener;
import com.aelitis.azureus.core.subs.SubscriptionPopularityListener;
import com.aelitis.azureus.core.subs.SubscriptionScheduler;
import com.aelitis.azureus.core.subs.impl.SubscriptionBodyImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionResultImpl;
import com.aelitis.azureus.core.subs.impl.SubscriptionSchedulerImpl;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import com.aelitis.azureus.plugins.dht.DHTPluginContact;
import com.aelitis.azureus.plugins.dht.DHTPluginKeyStats;
import com.aelitis.azureus.plugins.dht.DHTPluginOperationListener;
import com.aelitis.azureus.plugins.dht.DHTPluginValue;
import com.aelitis.azureus.plugins.magnet.MagnetPlugin;
import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class SubscriptionManagerImpl
implements SubscriptionManager,
AEDiagnosticsEvidenceGenerator {
    private static final String CONFIG_FILE = "subscriptions.config";
    private static final String LOGGER_NAME = "Subscriptions";
    private static final String CONFIG_MAX_RESULTS = "subscriptions.max.non.deleted.results";
    private static final String CONFIG_AUTO_START_DLS = "subscriptions.auto.start.downloads";
    private static final String CONFIG_AUTO_START_MIN_MB = "subscriptions.auto.start.min.mb";
    private static final String CONFIG_AUTO_START_MAX_MB = "subscriptions.auto.start.max.mb";
    private static final String RSS_ENABLE_CONFIG_KEY = "subscriptions.config.rss_enable";
    private static final int DELETE_UNUSED_AFTER_MILLIS = 1209600000;
    private static SubscriptionManagerImpl singleton;
    private static boolean pre_initialised;
    private static final int random_seed;
    private boolean started;
    private static final int TIMER_PERIOD = 30000;
    private static final int ASSOC_CHECK_PERIOD = 300000;
    private static final int ASSOC_CHECK_TICKS = 10;
    private static final int SERVER_PUB_CHECK_PERIOD = 600000;
    private static final int SERVER_PUB_CHECK_TICKS = 20;
    private static final int TIDY_POT_ASSOC_PERIOD = 1800000;
    private static final int TIDY_POT_ASSOC_TICKS = 60;
    private static final int SET_SELECTED_PERIOD = 82800000;
    private static final int SET_SELECTED_FIRST_TICK = 6;
    private static final int SET_SELECTED_TICKS = 2760;
    private static final Object SP_LAST_ATTEMPTED;
    private static final Object SP_CONSEC_FAIL;
    private volatile DHTPlugin dht_plugin;
    private List<SubscriptionImpl> subscriptions = new ArrayList<SubscriptionImpl>();
    private boolean config_dirty;
    private static final int PUB_ASSOC_CONC_MAX = 3;
    private int publish_associations_active;
    private boolean publish_subscription_active;
    private TorrentAttribute ta_subs_download;
    private TorrentAttribute ta_subs_download_rd;
    private TorrentAttribute ta_subscription_info;
    private TorrentAttribute ta_category;
    private boolean periodic_lookup_in_progress;
    private int priority_lookup_pending;
    private CopyOnWriteList<SubscriptionManagerListener> listeners = new CopyOnWriteList();
    private SubscriptionSchedulerImpl scheduler;
    private List<Object[]> potential_associations = new ArrayList<Object[]>();
    private Map<HashWrapper, Object[]> potential_associations2 = new HashMap<HashWrapper, Object[]>();
    private boolean meta_search_listener_added;
    private Pattern exclusion_pattern = Pattern.compile("azdev[0-9]+\\.azureus\\.com");
    private AEDiagnosticsLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preInitialise() {
        Class<SubscriptionManagerImpl> clazz = SubscriptionManagerImpl.class;
        synchronized (SubscriptionManagerImpl.class) {
            if (pre_initialised) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            pre_initialised = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

                public void process(VuzeFile[] vuzeFileArray, int n) {
                    for (int i = 0; i < vuzeFileArray.length; ++i) {
                        VuzeFile vuzeFile = vuzeFileArray[i];
                        VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                        for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                            VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                            int n2 = vuzeFileComponent.getType();
                            if (n2 != 16 && n2 != 32) continue;
                            try {
                                ((SubscriptionManagerImpl)SubscriptionManagerImpl.getSingleton(false)).importSubscription(n2, vuzeFileComponent.getContent(), (n & 0x30) == 0);
                                vuzeFileComponent.setProcessed();
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                    }
                }
            });
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionManager getSingleton(boolean bl) {
        SubscriptionManagerImpl.preInitialise();
        Class<SubscriptionManagerImpl> clazz = SubscriptionManagerImpl.class;
        synchronized (SubscriptionManagerImpl.class) {
            if (singleton != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return singleton;
            }
            singleton = new SubscriptionManagerImpl(bl);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (!bl) {
                singleton.initialise();
            }
            return singleton;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionManagerImpl(boolean bl) {
        if (!bl) {
            this.loadConfig();
            AEDiagnostics.addEvidenceGenerator(this);
            CustomizationManager customizationManager = CustomizationManagerFactory.getSingleton();
            Customization customization = customizationManager.getActiveCustomization();
            if (customization != null) {
                boolean bl2;
                String string = COConfigurationManager.getStringParameter("subscriptions.custom.name", "");
                String string2 = COConfigurationManager.getStringParameter("subscriptions.custom.version", "0");
                boolean bl3 = !string.equals(customization.getName());
                boolean bl4 = bl2 = Constants.compareVersions(string2, customization.getVersion()) < 0;
                if (bl3 || bl2) {
                    this.log("Customization: checking templates for " + customization.getName() + "/" + customization.getVersion());
                    try {
                        InputStream[] inputStreamArray = customization.getResources("subs");
                        for (int i = 0; i < inputStreamArray.length; ++i) {
                            Throwable throwable4;
                            Object var18_17;
                            InputStream inputStream = inputStreamArray[i];
                            try {
                                VuzeFile vuzeFile = VuzeFileHandler.getSingleton().loadVuzeFile(inputStream);
                                if (vuzeFile != null) {
                                    VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                                    for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                                        VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                                        int n = vuzeFileComponent.getType();
                                        if (n != 16 && n != 32) continue;
                                        try {
                                            this.importSubscription(n, vuzeFileComponent.getContent(), false);
                                            vuzeFileComponent.setProcessed();
                                            continue;
                                        }
                                        catch (Throwable throwable2) {
                                            Debug.printStackTrace(throwable2);
                                        }
                                    }
                                }
                                var18_17 = null;
                            }
                            catch (Throwable throwable3) {
                                var18_17 = null;
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    // empty catch block
                                }
                                throw throwable3;
                            }
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {}
                        }
                        Object var21_20 = null;
                    }
                    catch (Throwable throwable) {
                        Object var21_21 = null;
                        COConfigurationManager.setParameter("subscriptions.custom.name", customization.getName());
                        COConfigurationManager.setParameter("subscriptions.custom.version", customization.getVersion());
                        throw throwable;
                    }
                    COConfigurationManager.setParameter("subscriptions.custom.name", customization.getName());
                    COConfigurationManager.setParameter("subscriptions.custom.version", customization.getVersion());
                    {
                    }
                }
            }
            this.scheduler = new SubscriptionSchedulerImpl(this);
        }
    }

    protected void initialise() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore azureusCore) {
                SubscriptionManagerImpl.this.initWithCore(azureusCore);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initWithCore(AzureusCore azureusCore) {
        Object object = this;
        synchronized (object) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        object = PluginInitializer.getDefaultInterface();
        TorrentManager torrentManager = object.getTorrentManager();
        this.ta_subs_download = torrentManager.getPluginAttribute("azsubs.subs_dl");
        this.ta_subs_download_rd = torrentManager.getPluginAttribute("azsubs.subs_dl_rd");
        this.ta_subscription_info = torrentManager.getPluginAttribute("azsubs.subs_info");
        this.ta_category = torrentManager.getAttribute("Category");
        PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
        if (pluginInterface != null) {
            this.dht_plugin = (DHTPlugin)pluginInterface.getPlugin();
            object.getDownloadManager().addListener(new DownloadManagerListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void downloadAdded(Download download) {
                    Torrent torrent = download.getTorrent();
                    if (torrent != null) {
                        Object[] objectArray;
                        byte[] byArray = torrent.getHash();
                        SubscriptionImpl[] subscriptionImplArray = SubscriptionManagerImpl.this.potential_associations2;
                        synchronized (subscriptionImplArray) {
                            objectArray = (Object[])SubscriptionManagerImpl.this.potential_associations2.remove(new HashWrapper(byArray));
                        }
                        if (objectArray != null) {
                            subscriptionImplArray = (SubscriptionImpl[])objectArray[0];
                            String string = "";
                            for (int i = 0; i < subscriptionImplArray.length; ++i) {
                                string = string + (i == 0 ? "" : ",") + subscriptionImplArray[i].getName();
                            }
                            SubscriptionManagerImpl.this.log("Applying deferred asocciation for " + ByteFormatter.encodeString(byArray) + " -> " + string);
                            SubscriptionManagerImpl.this.recordAssociationsSupport(byArray, subscriptionImplArray, (Boolean)objectArray[1]);
                        }
                    }
                }

                public void downloadRemoved(Download download) {
                }
            }, false);
            TorrentUtils.addTorrentAttributeListener(new TorrentUtils.torrentAttributeListener(){

                public void attributeSet(TOTorrent tOTorrent, String string, Object object) {
                    if (string == "obtained_from") {
                        try {
                            SubscriptionManagerImpl.this.checkPotentialAssociations(tOTorrent.getHash(), (String)object);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            });
            DelayedTask delayedTask = UtilitiesImpl.addDelayedTask(LOGGER_NAME, new Runnable((PluginInterface)object){
                final /* synthetic */ PluginInterface val$default_pi;
                {
                    this.val$default_pi = pluginInterface;
                }

                public void run() {
                    new AEThread2("Subscriptions:delayInit", true){

                        public void run() {
                            this.asyncInit();
                        }
                    }.start();
                }

                protected void asyncInit() {
                    int n;
                    Download[] downloadArray = this.val$default_pi.getDownloadManager().getDownloads();
                    for (n = 0; n < downloadArray.length; ++n) {
                        boolean bl;
                        Download download = downloadArray[n];
                        if (!download.getBooleanAttribute(SubscriptionManagerImpl.this.ta_subs_download)) continue;
                        Map map = download.getMapAttribute(SubscriptionManagerImpl.this.ta_subs_download_rd);
                        if (map == null) {
                            bl = true;
                        } else {
                            boolean bl2 = bl = !SubscriptionManagerImpl.this.recoverSubscriptionUpdate(download, map);
                        }
                        if (!bl) continue;
                        SubscriptionManagerImpl.this.removeDownload(download, true);
                    }
                    this.val$default_pi.getDownloadManager().addListener(new DownloadManagerListener(){

                        public void downloadAdded(final Download download) {
                            if (download.isPersistent()) {
                                if (!SubscriptionManagerImpl.this.dht_plugin.isInitialising()) {
                                    SubscriptionManagerImpl.this.lookupAssociations(download.getMapAttribute(SubscriptionManagerImpl.this.ta_subscription_info) == null);
                                } else {
                                    new AEThread2("Subscriptions:delayInit", true){

                                        public void run() {
                                            SubscriptionManagerImpl.this.lookupAssociations(download.getMapAttribute(SubscriptionManagerImpl.this.ta_subscription_info) == null);
                                        }
                                    }.start();
                                }
                            }
                        }

                        public void downloadRemoved(Download download) {
                        }
                    }, false);
                    for (n = 0; n < 3 && !SubscriptionManagerImpl.this.publishAssociations(); ++n) {
                    }
                    SubscriptionManagerImpl.this.publishSubscriptions();
                    COConfigurationManager.addParameterListener(SubscriptionManagerImpl.CONFIG_MAX_RESULTS, new ParameterListener(){

                        public void parameterChanged(String string) {
                            final int n = COConfigurationManager.getIntParameter(SubscriptionManagerImpl.CONFIG_MAX_RESULTS);
                            new AEThread2("Subs:max results changer", true){

                                public void run() {
                                    SubscriptionManagerImpl.this.checkMaxResults(n);
                                }
                            }.start();
                        }
                    });
                    SimpleTimer.addPeriodicEvent("SubscriptionChecker", 30000L, new TimerEventPerformer(){
                        private int ticks;

                        public void perform(TimerEvent timerEvent2) {
                            ++this.ticks;
                            SubscriptionManagerImpl.this.checkStuff(this.ticks);
                        }
                    });
                }
            });
            delayedTask.queue();
        }
    }

    protected void checkMaxResults(int n) {
        Subscription[] subscriptionArray = this.getSubscriptions();
        for (int i = 0; i < subscriptionArray.length; ++i) {
            ((SubscriptionHistoryImpl)subscriptionArray[i].getHistory()).checkMaxResults(n);
        }
    }

    public SubscriptionScheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isRSSPublishEnabled() {
        return COConfigurationManager.getBooleanParameter(RSS_ENABLE_CONFIG_KEY, false);
    }

    public void setRSSPublishEnabled(boolean bl) {
        COConfigurationManager.setParameter(RSS_ENABLE_CONFIG_KEY, bl);
    }

    public String getRSSLink() {
        return "http://frostwire.wordpress.com";
    }

    public Subscription create(String string, boolean bl, String string2) throws SubscriptionException {
        string = this.getUniqueName(string);
        SubscriptionImpl subscriptionImpl = new SubscriptionImpl(this, string, bl, null, string2, 1);
        this.log("Created new subscription: " + subscriptionImpl.getString());
        if (subscriptionImpl.isPublic()) {
            this.updatePublicSubscription(subscriptionImpl);
        }
        return this.addSubscription(subscriptionImpl);
    }

    public Subscription createSingletonRSS(String string, URL uRL, int n) throws SubscriptionException {
        return this.createSingletonRSSSupport(string, uRL, true, n, 1, true);
    }

    protected SubscriptionImpl lookupSingletonRSS(String string, URL uRL, boolean bl, int n) throws SubscriptionException {
        this.checkURL(uRL);
        Map map = this.getSingletonMap(string, uRL, bl, n);
        byte[] byArray = SubscriptionBodyImpl.deriveSingletonShortID(map);
        return this.getSubscriptionFromSID(byArray);
    }

    protected Subscription createSingletonRSSSupport(String string, URL uRL, boolean bl, int n, int n2, boolean bl2) throws SubscriptionException {
        this.checkURL(uRL);
        try {
            SubscriptionImpl subscriptionImpl = this.lookupSingletonRSS(string, uRL, bl, n);
            if (subscriptionImpl != null) {
                return subscriptionImpl;
            }
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().createRSSEngine(string, uRL);
            String string2 = SubscriptionImpl.getSkeletonJSON(engine, n);
            Map map = this.getSingletonMap(string, uRL, bl, n);
            SubscriptionImpl subscriptionImpl2 = new SubscriptionImpl(this, string, bl, map, string2, n2);
            subscriptionImpl2.setSubscribed(bl2);
            this.log("Created new singleton subscription: " + subscriptionImpl2.getString());
            subscriptionImpl2 = this.addSubscription(subscriptionImpl2);
            return subscriptionImpl2;
        }
        catch (SubscriptionException subscriptionException) {
            throw subscriptionException;
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Failed to create subscription", throwable);
        }
    }

    protected String getUniqueName(String string) {
        for (int i = 0; i < 1024; ++i) {
            String string2 = string + (i == 0 ? "" : " (" + i + ")");
            if (this.getSubscriptionFromName(string2) != null) continue;
            return string2;
        }
        return string;
    }

    protected Map getSingletonMap(String string, URL uRL, boolean bl, int n) throws SubscriptionException {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("key", uRL.toExternalForm().getBytes("UTF-8"));
            String string2 = string.length() > 64 ? string.substring(0, 64) : string;
            hashMap.put("name", string2);
            if (n != 120) {
                hashMap.put("ci", new Long(n));
            }
            return hashMap;
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Failed to create subscription", throwable);
        }
    }

    protected SubscriptionImpl createSingletonSubscription(Map map, int n, boolean bl) throws SubscriptionException {
        try {
            String string = ImportExportUtils.importString(map, "name", "(Anonymous)");
            URL uRL = new URL(ImportExportUtils.importString(map, "key"));
            int n2 = (int)ImportExportUtils.importLong(map, "ci", 120L);
            SubscriptionImpl subscriptionImpl = (SubscriptionImpl)this.createSingletonRSSSupport(string, uRL, true, n2, n, bl);
            return subscriptionImpl;
        }
        catch (Throwable throwable) {
            this.log("Creation of singleton from " + map + " failed", throwable);
            throw new SubscriptionException("Creation of singleton from " + map + " failed", throwable);
        }
    }

    public Subscription createRSS(String string, URL uRL, int n, Map map) throws SubscriptionException {
        this.checkURL(uRL);
        try {
            string = this.getUniqueName(string);
            Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().createRSSEngine(string, uRL);
            String string2 = SubscriptionImpl.getSkeletonJSON(engine, n);
            SubscriptionImpl subscriptionImpl = new SubscriptionImpl(this, engine.getName(), engine.isPublic(), null, string2, 1);
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    subscriptionImpl.setUserData(entry.getKey(), entry.getValue());
                }
            }
            this.log("Created new subscription: " + subscriptionImpl.getString());
            subscriptionImpl = this.addSubscription(subscriptionImpl);
            if (subscriptionImpl.isPublic()) {
                this.updatePublicSubscription(subscriptionImpl);
            }
            return subscriptionImpl;
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Failed to create subscription", throwable);
        }
    }

    protected void checkURL(URL uRL) throws SubscriptionException {
        String string;
        if (uRL.getHost().trim().length() == 0 && !(string = uRL.getProtocol().toLowerCase()).equals("azplug") && !string.equals("file")) {
            throw new SubscriptionException("Invalid URL '" + uRL + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionImpl addSubscription(SubscriptionImpl subscriptionImpl) {
        SubscriptionImpl subscriptionImpl2;
        Object object = this;
        synchronized (object) {
            int n = Collections.binarySearch(this.subscriptions, subscriptionImpl, new Comparator<Subscription>(){

                @Override
                public int compare(Subscription subscription, Subscription subscription2) {
                    return subscription.getID().compareTo(subscription2.getID());
                }
            });
            if (n < 0) {
                subscriptionImpl2 = null;
                n = -1 * n - 1;
                this.subscriptions.add(n, subscriptionImpl);
                this.saveConfig();
            } else {
                subscriptionImpl2 = this.subscriptions.get(n);
            }
        }
        if (subscriptionImpl2 != null) {
            this.log("Attempted to add subscription when already present: " + subscriptionImpl.getString());
            subscriptionImpl.destroy();
            return subscriptionImpl2;
        }
        if (subscriptionImpl.isMine()) {
            this.addMetaSearchListener();
        }
        if (subscriptionImpl.getCachedPopularity() == -1L) {
            try {
                subscriptionImpl.getPopularity(new SubscriptionPopularityListener(){

                    public void gotPopularity(long l) {
                    }

                    public void failed(SubscriptionException subscriptionException) {
                    }
                });
            }
            catch (Throwable throwable) {
                this.log("", throwable);
            }
        }
        object = this.listeners.iterator();
        while (object.hasNext()) {
            try {
                ((SubscriptionManagerListener)object.next()).subscriptionAdded(subscriptionImpl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (subscriptionImpl.isSubscribed() && subscriptionImpl.isPublic()) {
            this.setSelected(subscriptionImpl);
        }
        if (this.dht_plugin != null) {
            new AEThread2("Publish check", true){

                public void run() {
                    SubscriptionManagerImpl.this.publishSubscriptions();
                }
            }.start();
        }
        return subscriptionImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetaSearchListener() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.meta_search_listener_added) {
                return;
            }
            this.meta_search_listener_added = true;
        }
        MetaSearchManagerFactory.getSingleton().getMetaSearch().addListener(new MetaSearchListener(){

            public void engineAdded(Engine engine) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void engineUpdated(Engine engine) {
                9 var2_2 = this;
                synchronized (var2_2) {
                    for (int i = 0; i < SubscriptionManagerImpl.this.subscriptions.size(); ++i) {
                        SubscriptionImpl subscriptionImpl = (SubscriptionImpl)SubscriptionManagerImpl.this.subscriptions.get(i);
                        if (!subscriptionImpl.isMine()) continue;
                        subscriptionImpl.engineUpdated(engine);
                    }
                }
            }

            public void engineRemoved(Engine engine) {
            }
        });
    }

    protected void changeSubscription(SubscriptionImpl subscriptionImpl) {
        if (!subscriptionImpl.isRemoved()) {
            Iterator<SubscriptionManagerListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().subscriptionChanged(subscriptionImpl);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    protected void selectSubscription(SubscriptionImpl subscriptionImpl) {
        if (!subscriptionImpl.isRemoved()) {
            Iterator<SubscriptionManagerListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().subscriptionSelected(subscriptionImpl);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSubscription(SubscriptionImpl subscriptionImpl) {
        Iterator<SubscriptionManagerListener> iterator = this;
        synchronized (iterator) {
            if (this.subscriptions.remove(subscriptionImpl)) {
                this.saveConfig();
                try {
                    FileUtil.deleteResilientFile(this.getResultsFile(subscriptionImpl));
                    File file = this.getVuzeFile(subscriptionImpl);
                    file.delete();
                    new File(file.getParent(), file.getName() + ".bak").delete();
                }
                catch (Throwable throwable) {
                    this.log("Failed to delete results file", throwable);
                }
            } else {
                return;
            }
        }
        try {
            iterator = subscriptionImpl.getEngine(true);
            if (iterator.getType() == 4) {
                iterator.delete();
                this.log("Removed engine " + iterator.getName() + " due to subscription removal");
            }
        }
        catch (Throwable throwable) {
            this.log("Failed to check for engine deletion", throwable);
        }
        iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().subscriptionRemoved(subscriptionImpl);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void updatePublicSubscription(SubscriptionImpl subscriptionImpl) {
        if (subscriptionImpl.isSingleton()) {
            subscriptionImpl.setServerPublished();
        } else {
            Long l = (Long)subscriptionImpl.getUserData(SP_LAST_ATTEMPTED);
            Long l2 = (Long)subscriptionImpl.getUserData(SP_CONSEC_FAIL);
            if (l != null && l2 != null) {
                long l3 = 600000L;
                int n = 0;
                while ((long)n < l2 && (l3 <<= 1) <= 86400000L) {
                    ++n;
                }
                if (l + l3 > SystemTime.getMonotonousTime()) {
                    return;
                }
            }
            try {
                File file = this.getVuzeFile(subscriptionImpl);
                byte[] byArray = FileUtil.readFileAsByteArray(file);
                byte[] byArray2 = Base64.encode(byArray);
                PlatformSubscriptionsMessenger.updateSubscription(!subscriptionImpl.getServerPublished(), subscriptionImpl.getName(), subscriptionImpl.getPublicKey(), subscriptionImpl.getPrivateKey(), subscriptionImpl.getShortID(), subscriptionImpl.getVersion(), new String(byArray2));
                subscriptionImpl.setUserData(SP_LAST_ATTEMPTED, null);
                subscriptionImpl.setUserData(SP_CONSEC_FAIL, null);
                subscriptionImpl.setServerPublished();
                this.log("    Updated public subscription " + subscriptionImpl.getString());
            }
            catch (Throwable throwable) {
                this.log("    Failed to update public subscription " + subscriptionImpl.getString(), throwable);
                subscriptionImpl.setUserData(SP_LAST_ATTEMPTED, new Long(SystemTime.getMonotonousTime()));
                subscriptionImpl.setUserData(SP_CONSEC_FAIL, new Long(l2 == null ? 1L : l2 + 1L));
                subscriptionImpl.setServerPublicationOutstanding();
            }
        }
    }

    protected void checkSingletonPublish(SubscriptionImpl subscriptionImpl) throws SubscriptionException {
        if (subscriptionImpl.getSingletonPublishAttempted()) {
            throw new SubscriptionException("Singleton publish already attempted");
        }
        subscriptionImpl.setSingletonPublishAttempted();
        try {
            File file = this.getVuzeFile(subscriptionImpl);
            byte[] byArray = FileUtil.readFileAsByteArray(file);
            byte[] byArray2 = Base64.encode(byArray);
            KeyPair keyPair = CryptoECCUtils.createKeys();
            byte[] byArray3 = CryptoECCUtils.keyToRawdata(keyPair.getPublic());
            byte[] byArray4 = CryptoECCUtils.keyToRawdata(keyPair.getPrivate());
            PlatformSubscriptionsMessenger.updateSubscription(true, subscriptionImpl.getName(), byArray3, byArray4, subscriptionImpl.getShortID(), 1, new String(byArray2));
            this.log("    created singleton public subscription " + subscriptionImpl.getString());
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Failed to publish singleton", throwable);
        }
    }

    protected void checkServerPublications(List list) {
        for (int i = 0; i < list.size(); ++i) {
            SubscriptionImpl subscriptionImpl = (SubscriptionImpl)list.get(i);
            if (!subscriptionImpl.getServerPublicationOutstanding()) continue;
            this.updatePublicSubscription(subscriptionImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkStuff(int n) {
        ArrayList<SubscriptionImpl> arrayList;
        long l = SystemTime.getCurrentTime();
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<SubscriptionImpl>(this.subscriptions);
        }
        object = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            long l2;
            SubscriptionImpl subscriptionImpl = (SubscriptionImpl)arrayList.get(i);
            if (!subscriptionImpl.isMine() && !subscriptionImpl.isSubscribed() && (l2 = l - subscriptionImpl.getAddTime()) > 1209600000L) {
                if (object != null && subscriptionImpl.getAddTime() >= ((SubscriptionImpl)object).getAddTime()) continue;
                object = subscriptionImpl;
                continue;
            }
            subscriptionImpl.checkPublish();
        }
        if (object != null) {
            this.log("Removing unsubscribed subscription '" + ((SubscriptionImpl)object).getName() + "' as expired");
            ((SubscriptionImpl)object).remove();
        }
        if (n % 10 == 0) {
            this.lookupAssociations(false);
        }
        if (n % 20 == 0) {
            this.checkServerPublications(arrayList);
        }
        if (n % 60 == 0) {
            this.tidyPotentialAssociations();
        }
        if (n == 6 || n % 2760 == 0) {
            this.setSelected(arrayList);
        }
    }

    public Subscription importSubscription(int n, Map map, boolean bl) throws SubscriptionException {
        boolean bl2 = true;
        try {
            try {
                if (n == 32) {
                    Object object;
                    String string = new String((byte[])map.get("name"), "UTF-8");
                    URL uRL = new URL(new String((byte[])map.get("url"), "UTF-8"));
                    Long l = (Long)map.get("check_interval_mins");
                    int n2 = l == null ? 120 : l.intValue();
                    Long l2 = (Long)map.get("public");
                    boolean bl3 = l2 == null ? true : l2 == 1L;
                    SubscriptionImpl subscriptionImpl = this.lookupSingletonRSS(string, uRL, bl3, n2);
                    if (UrlFilter.getInstance().urlCanRPC(uRL.toExternalForm())) {
                        bl = false;
                    }
                    if (subscriptionImpl != null && subscriptionImpl.isSubscribed()) {
                        if (bl) {
                            UIManager uIManager = StaticUtilities.getUIManager(120000L);
                            String string2 = MessageText.getString("subscript.add.dup.desc", new String[]{subscriptionImpl.getName()});
                            uIManager.showMessageBox("subscript.add.dup.title", "!" + string2 + "!", 1L);
                        }
                        this.selectSubscription(subscriptionImpl);
                        return subscriptionImpl;
                    }
                    if (bl) {
                        object = StaticUtilities.getUIManager(120000L);
                        String string3 = MessageText.getString("subscript.add.desc", new String[]{string});
                        long l3 = object.showMessageBox("subscript.add.title", "!" + string3 + "!", 12L);
                        if (l3 != 4L) {
                            bl2 = false;
                            throw new SubscriptionException("User declined addition");
                        }
                    }
                    if (subscriptionImpl == null) {
                        object = (SubscriptionImpl)this.createSingletonRSSSupport(string, uRL, bl3, n2, 2, true);
                        this.log("Imported new singleton subscription: " + ((SubscriptionImpl)object).getString());
                        return object;
                    }
                    subscriptionImpl.setSubscribed(true);
                    this.selectSubscription(subscriptionImpl);
                    return subscriptionImpl;
                }
                SubscriptionBodyImpl subscriptionBodyImpl = new SubscriptionBodyImpl(this, map);
                SubscriptionImpl subscriptionImpl = this.getSubscriptionFromSID(subscriptionBodyImpl.getShortID());
                if (subscriptionImpl != null && subscriptionImpl.isSubscribed()) {
                    if (subscriptionImpl.getVersion() >= subscriptionBodyImpl.getVersion()) {
                        this.log("Not upgrading subscription: " + subscriptionImpl.getString() + " as supplied (" + subscriptionBodyImpl.getVersion() + ") is not more recent than existing (" + subscriptionImpl.getVersion() + ")");
                        if (bl) {
                            UIManager uIManager = StaticUtilities.getUIManager(120000L);
                            String string = MessageText.getString("subscript.add.dup.desc", new String[]{subscriptionImpl.getName()});
                            uIManager.showMessageBox("subscript.add.dup.title", "!" + string + "!", 1L);
                        }
                        this.selectSubscription(subscriptionImpl);
                        return subscriptionImpl;
                    }
                    if (bl) {
                        UIManager uIManager = StaticUtilities.getUIManager(120000L);
                        String string = MessageText.getString("subscript.add.upgrade.desc", new String[]{subscriptionImpl.getName()});
                        long l = uIManager.showMessageBox("subscript.add.upgrade.title", "!" + string + "!", 12L);
                        if (l != 4L) {
                            throw new SubscriptionException("User declined upgrade");
                        }
                    }
                    this.log("Upgrading subscription: " + subscriptionImpl.getString());
                    subscriptionImpl.upgrade(subscriptionBodyImpl);
                    this.saveConfig();
                    this.subscriptionUpdated();
                    return subscriptionImpl;
                }
                SubscriptionImpl subscriptionImpl2 = new SubscriptionImpl(this, subscriptionBodyImpl, 2, true);
                if (bl) {
                    UIManager uIManager = StaticUtilities.getUIManager(120000L);
                    String string = MessageText.getString("subscript.add.desc", new String[]{subscriptionImpl2.getName()});
                    long l = uIManager.showMessageBox("subscript.add.title", "!" + string + "!", 12L);
                    if (l != 4L) {
                        throw new SubscriptionException("User declined addition");
                    }
                }
                this.log("Imported new subscription: " + subscriptionImpl2.getString());
                if (subscriptionImpl != null) {
                    subscriptionImpl.remove();
                }
                subscriptionImpl2 = this.addSubscription(subscriptionImpl2);
                return subscriptionImpl2;
            }
            catch (Throwable throwable) {
                throw new SubscriptionException("Subscription import failed", throwable);
            }
        }
        catch (SubscriptionException subscriptionException) {
            if (bl && bl2) {
                UIManager uIManager = StaticUtilities.getUIManager(120000L);
                String string = MessageText.getString("subscript.import.fail.desc", new String[]{Debug.getNestedExceptionMessage(subscriptionException)});
                uIManager.showMessageBox("subscript.import.fail.title", "!" + string + "!", 1L);
            }
            throw subscriptionException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription[] getSubscriptions() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            return this.subscriptions.toArray(new SubscriptionImpl[this.subscriptions.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription[] getSubscriptions(boolean bl) {
        if (!bl) {
            return this.getSubscriptions();
        }
        ArrayList<SubscriptionImpl> arrayList = new ArrayList<SubscriptionImpl>();
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            for (int i = 0; i < this.subscriptions.size(); ++i) {
                SubscriptionImpl subscriptionImpl = this.subscriptions.get(i);
                if (!subscriptionImpl.isSubscribed()) continue;
                arrayList.add(subscriptionImpl);
            }
        }
        return arrayList.toArray(new SubscriptionImpl[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SubscriptionImpl getSubscriptionFromName(String string) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            for (int i = 0; i < this.subscriptions.size(); ++i) {
                SubscriptionImpl subscriptionImpl = this.subscriptions.get(i);
                if (!subscriptionImpl.getName().equalsIgnoreCase(string)) continue;
                return subscriptionImpl;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription getSubscriptionByID(String string) {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            int n = Collections.binarySearch(this.subscriptions, string, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = object instanceof Subscription ? ((Subscription)object).getID() : object.toString();
                    String string2 = object2 instanceof Subscription ? ((Subscription)object2).getID() : object2.toString();
                    return string.compareTo(string2);
                }
            });
            if (n >= 0) {
                return this.subscriptions.get(n);
            }
        }
        return null;
    }

    protected SubscriptionImpl getSubscriptionFromSID(byte[] byArray) {
        return (SubscriptionImpl)this.getSubscriptionByID(Base32.encode(byArray));
    }

    protected File getSubsDir() throws IOException {
        File file = new File(SystemProperties.getUserPath());
        if (!(file = new File(file, "subs")).exists() && !file.mkdirs()) {
            throw new IOException("Failed to create '" + file + "'");
        }
        return file;
    }

    protected File getVuzeFile(SubscriptionImpl subscriptionImpl) throws IOException {
        File file = this.getSubsDir();
        return new File(file, ByteFormatter.encodeString(subscriptionImpl.getShortID()) + ".vuze");
    }

    protected File getResultsFile(SubscriptionImpl subscriptionImpl) throws IOException {
        File file = this.getSubsDir();
        return new File(file, ByteFormatter.encodeString(subscriptionImpl.getShortID()) + ".results");
    }

    public Subscription[] getKnownSubscriptions(byte[] byArray) {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        try {
            List list;
            Map map;
            Download download = pluginInterface.getDownloadManager().getDownload(byArray);
            if (download != null && (map = download.getMapAttribute(this.ta_subscription_info)) != null && (list = (List)map.get("s")) != null && list.size() > 0) {
                ArrayList<SubscriptionImpl> arrayList = new ArrayList<SubscriptionImpl>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    byte[] byArray2 = (byte[])list.get(i);
                    SubscriptionImpl subscriptionImpl = this.getSubscriptionFromSID(byArray2);
                    if (subscriptionImpl == null || !this.isVisible(subscriptionImpl)) continue;
                    arrayList.add(subscriptionImpl);
                }
                return arrayList.toArray(new Subscription[arrayList.size()]);
            }
        }
        catch (Throwable throwable) {
            this.log("Failed to get known subscriptions", throwable);
        }
        return new Subscription[0];
    }

    protected boolean subscriptionExists(Download download, SubscriptionImpl subscriptionImpl) {
        List list;
        byte[] byArray = subscriptionImpl.getShortID();
        Map map = download.getMapAttribute(this.ta_subscription_info);
        if (map != null && (list = (List)map.get("s")) != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                byte[] byArray2 = (byte[])list.get(i);
                if (!Arrays.equals(byArray2, byArray)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isVisible(SubscriptionImpl subscriptionImpl) {
        if (Constants.isCVSVersion() || subscriptionImpl.isSubscribed()) {
            return true;
        }
        try {
            Engine engine = subscriptionImpl.getEngine(true);
            if (engine instanceof WebEngine) {
                String string = ((WebEngine)engine).getSearchUrl();
                try {
                    String string2 = new URL(string).getHost();
                    return !this.exclusion_pattern.matcher(string2).matches();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return true;
        }
        catch (Throwable throwable) {
            this.log("isVisible failed for " + subscriptionImpl.getString(), throwable);
            return false;
        }
    }

    public Subscription[] getLinkedSubscriptions(byte[] byArray) {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        try {
            List list;
            Map map;
            Download download = pluginInterface.getDownloadManager().getDownload(byArray);
            if (download != null && (map = download.getMapAttribute(this.ta_subscription_info)) != null && (list = (List)map.get("s")) != null && list.size() > 0) {
                ArrayList<SubscriptionImpl> arrayList = new ArrayList<SubscriptionImpl>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    byte[] byArray2 = (byte[])list.get(i);
                    SubscriptionImpl subscriptionImpl = this.getSubscriptionFromSID(byArray2);
                    if (subscriptionImpl == null || !subscriptionImpl.hasAssociation(byArray)) continue;
                    arrayList.add(subscriptionImpl);
                }
                return arrayList.toArray(new Subscription[arrayList.size()]);
            }
        }
        catch (Throwable throwable) {
            this.log("Failed to get known subscriptions", throwable);
        }
        return new Subscription[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupAssociations(boolean bl) {
        Object object = this;
        synchronized (object) {
            if (this.periodic_lookup_in_progress) {
                if (bl) {
                    ++this.priority_lookup_pending;
                }
                return;
            }
            this.periodic_lookup_in_progress = true;
        }
        try {
            object = PluginInitializer.getDefaultInterface();
            Download[] downloadArray = object.getDownloadManager().getDownloads();
            long l = SystemTime.getCurrentTime();
            long l2 = 0L;
            Download download = null;
            for (int i = 0; i < downloadArray.length; ++i) {
                long l3;
                int n;
                List list;
                int n2;
                long l4;
                Download download2 = downloadArray[i];
                if (download2.getTorrent() == null || !download2.isPersistent()) continue;
                LightHashMap lightHashMap = download2.getMapAttribute(this.ta_subscription_info);
                lightHashMap = lightHashMap == null ? new LightHashMap() : new LightHashMap(lightHashMap);
                Long l5 = (Long)lightHashMap.get("lc");
                long l6 = l4 = l5 == null ? 0L : l5;
                if (l4 > l) {
                    l4 = l;
                    lightHashMap.put("lc", new Long(l4));
                    download2.setMapAttribute(this.ta_subscription_info, lightHashMap);
                }
                int n3 = n2 = (list = (List)lightHashMap.get("s")) == null ? 0 : list.size();
                if (n2 > 8 || l - l4 < (long)(n = (n2 + 1) * 24 * 60 * 60 * 1000 + (int)((l3 = download2.getCreationTime()) % 4L * 60L * 60L * 1000L)) || l3 <= l2) continue;
                l2 = l3;
                download = download2;
            }
            if (download != null) {
                byte[] byArray = download.getTorrent().getHash();
                this.log("Association lookup starts for " + download.getName() + "/" + ByteFormatter.encodeString(byArray));
                this.lookupAssociationsSupport(byArray, new SubscriptionLookupListener(){

                    public void found(byte[] byArray, Subscription subscription) {
                    }

                    public void failed(byte[] byArray, SubscriptionException subscriptionException) {
                        SubscriptionManagerImpl.this.log("Association lookup failed for " + ByteFormatter.encodeString(byArray), subscriptionException);
                        SubscriptionManagerImpl.this.associationLookupComplete();
                    }

                    public void complete(byte[] byArray, Subscription[] subscriptionArray) {
                        SubscriptionManagerImpl.this.log("Association lookup complete for " + ByteFormatter.encodeString(byArray));
                        SubscriptionManagerImpl.this.associationLookupComplete();
                    }
                });
            } else {
                this.associationLookupComplete();
            }
        }
        catch (Throwable throwable) {
            this.log("Association lookup check failed", throwable);
            this.associationLookupComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void associationLookupComplete() {
        boolean bl;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            this.periodic_lookup_in_progress = false;
            boolean bl2 = bl = this.priority_lookup_pending > 0;
            if (bl) {
                --this.priority_lookup_pending;
            }
        }
        if (bl) {
            new AEThread2("SM:priAssLookup", true){

                public void run() {
                    SubscriptionManagerImpl.this.lookupAssociations(false);
                }
            }.start();
        }
    }

    protected void setSelected(List list) {
        block14: {
            Object object;
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int i = 0; i < list.size(); ++i) {
                object = (SubscriptionImpl)list.get(i);
                if (!((SubscriptionImpl)object).isSubscribed()) continue;
                if (((SubscriptionImpl)object).isPublic()) {
                    arrayList2.add(object);
                    arrayList.add(((SubscriptionImpl)object).getShortID());
                    continue;
                }
                this.checkInitialDownload((SubscriptionImpl)object);
            }
            if (arrayList.size() > 0) {
                try {
                    int n;
                    List[] listArray = PlatformSubscriptionsMessenger.setSelected(arrayList);
                    object = listArray[0];
                    List list2 = listArray[1];
                    this.log("Popularity update: updated " + arrayList.size());
                    final ArrayList<SubscriptionImpl> arrayList3 = new ArrayList<SubscriptionImpl>();
                    for (n = 0; n < arrayList.size(); ++n) {
                        SubscriptionImpl subscriptionImpl = (SubscriptionImpl)arrayList2.get(n);
                        int n2 = ((Long)object.get(n)).intValue();
                        if (n2 > subscriptionImpl.getVersion()) {
                            this.updateSubscription(subscriptionImpl, n2);
                        } else {
                            this.checkInitialDownload(subscriptionImpl);
                        }
                        if (n2 > 0) {
                            try {
                                long l = (Long)list2.get(n);
                                if (l < 0L || l == subscriptionImpl.getCachedPopularity()) continue;
                                subscriptionImpl.setCachedPopularity(l);
                            }
                            catch (Throwable throwable) {
                                this.log("Popularity update: Failed to extract popularity", throwable);
                            }
                            continue;
                        }
                        arrayList3.add(subscriptionImpl);
                    }
                    if (arrayList3.size() <= 3) {
                        for (n = 0; n < arrayList3.size(); ++n) {
                            this.updatePopularityFromDHT((SubscriptionImpl)arrayList3.get(n), false);
                        }
                        break block14;
                    }
                    new AEThread2("SM:asyncPop", true){

                        public void run() {
                            for (int i = 0; i < arrayList3.size(); ++i) {
                                SubscriptionManagerImpl.this.updatePopularityFromDHT((SubscriptionImpl)arrayList3.get(i), true);
                            }
                        }
                    }.start();
                }
                catch (Throwable throwable) {
                    this.log("Popularity update: Failed to record selected subscriptions", throwable);
                }
            } else {
                this.log("Popularity update: No selected, public subscriptions");
            }
        }
    }

    protected void checkUpgrade(SubscriptionImpl subscriptionImpl) {
        this.setSelected(subscriptionImpl);
    }

    protected void setSelected(final SubscriptionImpl subscriptionImpl) {
        if (subscriptionImpl.isSubscribed()) {
            if (subscriptionImpl.isPublic()) {
                new DelayedEvent("SM:setSelected", 0L, new AERunnable(){

                    public void runSupport() {
                        block11: {
                            try {
                                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                                arrayList.add(subscriptionImpl.getShortID());
                                List[] listArray = PlatformSubscriptionsMessenger.setSelected(arrayList);
                                SubscriptionManagerImpl.this.log("setSelected: " + subscriptionImpl.getName());
                                int n = ((Long)listArray[0].get(0)).intValue();
                                if (n == 0) {
                                    if (subscriptionImpl.isSingleton()) {
                                        SubscriptionManagerImpl.this.checkSingletonPublish(subscriptionImpl);
                                    }
                                } else if (n > subscriptionImpl.getVersion()) {
                                    SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, n);
                                } else {
                                    SubscriptionManagerImpl.this.checkInitialDownload(subscriptionImpl);
                                }
                                if (n > 0) {
                                    try {
                                        long l = (Long)listArray[1].get(0);
                                        if (l >= 0L && l != subscriptionImpl.getCachedPopularity()) {
                                            subscriptionImpl.setCachedPopularity(l);
                                        }
                                        break block11;
                                    }
                                    catch (Throwable throwable) {
                                        SubscriptionManagerImpl.this.log("Popularity update: Failed to extract popularity", throwable);
                                    }
                                    break block11;
                                }
                                SubscriptionManagerImpl.this.updatePopularityFromDHT(subscriptionImpl, true);
                            }
                            catch (Throwable throwable) {
                                SubscriptionManagerImpl.this.log("setSelected: failed for " + subscriptionImpl.getName(), throwable);
                            }
                        }
                    }
                });
            } else {
                this.checkInitialDownload(subscriptionImpl);
            }
        }
    }

    protected void checkInitialDownload(SubscriptionImpl subscriptionImpl) {
        if (subscriptionImpl.getHistory().getLastScanTime() == 0L) {
            this.scheduler.download(subscriptionImpl, true, new SubscriptionDownloadListener(){

                public void complete(Subscription subscription) {
                    SubscriptionManagerImpl.this.log("Initial download of " + subscription.getName() + " complete");
                }

                public void failed(Subscription subscription, SubscriptionException subscriptionException) {
                    SubscriptionManagerImpl.this.log("Initial download of " + subscription.getName() + " failed", subscriptionException);
                }
            });
        }
    }

    public SubscriptionAssociationLookup lookupAssociations(final byte[] byArray, final SubscriptionLookupListener subscriptionLookupListener) throws SubscriptionException {
        if (this.dht_plugin != null && !this.dht_plugin.isInitialising()) {
            return this.lookupAssociationsSupport(byArray, subscriptionLookupListener);
        }
        final boolean[] blArray = new boolean[]{false};
        final SubscriptionAssociationLookup[] subscriptionAssociationLookupArray = new SubscriptionAssociationLookup[]{null};
        SubscriptionAssociationLookup subscriptionAssociationLookup = new SubscriptionAssociationLookup(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                SubscriptionManagerImpl.this.log("    Association lookup cancelled");
                SubscriptionAssociationLookup[] subscriptionAssociationLookupArray2 = subscriptionAssociationLookupArray;
                synchronized (subscriptionAssociationLookupArray) {
                    blArray[0] = true;
                    if (subscriptionAssociationLookupArray[0] != null) {
                        subscriptionAssociationLookupArray[0].cancel();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
        new AEThread2("SM:initwait", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SubscriptionAssociationLookup subscriptionAssociationLookup = SubscriptionManagerImpl.this.lookupAssociationsSupport(byArray, subscriptionLookupListener);
                    SubscriptionAssociationLookup[] subscriptionAssociationLookupArray2 = subscriptionAssociationLookupArray;
                    synchronized (subscriptionAssociationLookupArray) {
                        subscriptionAssociationLookupArray[0] = subscriptionAssociationLookup;
                        if (blArray[0]) {
                            subscriptionAssociationLookup.cancel();
                        }
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                    }
                }
                catch (SubscriptionException subscriptionException) {
                    subscriptionLookupListener.failed(byArray, subscriptionException);
                }
                {
                    return;
                }
            }
        }.start();
        return subscriptionAssociationLookup;
    }

    protected SubscriptionAssociationLookup lookupAssociationsSupport(final byte[] byArray, final SubscriptionLookupListener subscriptionLookupListener) throws SubscriptionException {
        this.log("Looking up associations for '" + ByteFormatter.encodeString(byArray));
        String string = "subscription:assoc:" + ByteFormatter.encodeString(byArray);
        final boolean[] blArray = new boolean[]{false};
        this.dht_plugin.get(string.getBytes(), "Subscription association read: " + ByteFormatter.encodeString(byArray), (byte)0, 30, 60000L, true, true, new DHTPluginOperationListener(){
            private Map<HashWrapper, Integer> hits = new HashMap<HashWrapper, Integer>();
            private AESemaphore hits_sem = new AESemaphore("Subs:lookup");
            private List<Subscription> found_subscriptions = new ArrayList<Subscription>();
            private boolean complete;

            public void diversified() {
            }

            public void starts(byte[] byArray2) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                if (this.isCancelled2()) {
                    return;
                }
                byte[] byArray3 = dHTPluginValue.getValue();
                if (byArray3.length > 4) {
                    int n = byArray3[0] << 16 & 0xFF0000 | byArray3[1] << 8 & 0xFF00 | byArray3[2] & 0xFF;
                    byte[] byArray2 = new byte[byArray3.length - 4];
                    System.arraycopy(byArray3, 4, byArray2, 0, byArray2.length);
                    HashWrapper hashWrapper = new HashWrapper(byArray2);
                    boolean bl = false;
                    Object object = this;
                    synchronized (object) {
                        if (this.complete) {
                            return;
                        }
                        Integer n2 = this.hits.get(hashWrapper);
                        if (n2 != null) {
                            if (n > n2) {
                                this.hits.put(hashWrapper, new Integer(n));
                            }
                        } else {
                            bl = true;
                            this.hits.put(hashWrapper, new Integer(n));
                        }
                    }
                    if (bl) {
                        SubscriptionManagerImpl.this.log("    Found subscription " + ByteFormatter.encodeString(byArray2) + " version " + n);
                        object = SubscriptionManagerImpl.this.getSubscriptionFromSID(byArray2);
                        if (object != null) {
                            this.found_subscriptions.add((Subscription)object);
                            try {
                                subscriptionLookupListener.found(byArray, (Subscription)object);
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                            this.hits_sem.release();
                        } else {
                            SubscriptionManagerImpl.this.lookupSubscription(byArray, byArray2, n, new subsLookupListener(){
                                private boolean sem_done = false;

                                public void found(byte[] byArray, Subscription subscription) {
                                }

                                public void complete(byte[] byArray, Subscription[] subscriptionArray) {
                                    this.done(subscriptionArray);
                                }

                                public void failed(byte[] byArray, SubscriptionException subscriptionException) {
                                    this.done(new Subscription[0]);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                protected void done(Subscription[] subscriptionArray) {
                                    if (this.isCancelled()) {
                                        return;
                                    }
                                    1 var2_2 = this;
                                    synchronized (var2_2) {
                                        if (this.sem_done) {
                                            return;
                                        }
                                        this.sem_done = true;
                                    }
                                    if (subscriptionArray.length > 0) {
                                        found_subscriptions.add(subscriptionArray[0]);
                                        try {
                                            subscriptionLookupListener.found(byArray, subscriptionArray[0]);
                                        }
                                        catch (Throwable throwable) {
                                            Debug.printStackTrace(throwable);
                                        }
                                    }
                                    hits_sem.release();
                                }

                                public boolean isCancelled() {
                                    return this.isCancelled2();
                                }
                            });
                        }
                    }
                }
            }

            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            }

            public void complete(byte[] byArray2, boolean bl) {
                new AEThread2("Subs:lookup wait", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Subscription[] subscriptionArray;
                        int n;
                        2 var2_1 = this;
                        synchronized (var2_1) {
                            if (complete) {
                                return;
                            }
                            complete = true;
                            n = hits.size();
                        }
                        for (int i = 0; i < n; ++i) {
                            if (this.isCancelled2()) {
                                return;
                            }
                            hits_sem.reserve();
                        }
                        if (this.isCancelled2()) {
                            return;
                        }
                        2 var3_6 = this;
                        synchronized (var3_6) {
                            subscriptionArray = found_subscriptions.toArray(new SubscriptionImpl[found_subscriptions.size()]);
                        }
                        SubscriptionManagerImpl.this.log("    Association lookup complete - " + subscriptionArray.length + " found");
                        try {
                            SubscriptionManagerImpl.this.recordAssociations(byArray, (SubscriptionImpl[])subscriptionArray, true);
                            Object var6_8 = null;
                            subscriptionLookupListener.complete(byArray, subscriptionArray);
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            subscriptionLookupListener.complete(byArray, subscriptionArray);
                            throw throwable;
                        }
                    }
                }.start();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected boolean isCancelled2() {
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return blArray[0];
                }
            }
        });
        return new SubscriptionAssociationLookup(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void cancel() {
                SubscriptionManagerImpl.this.log("    Association lookup cancelled");
                boolean[] blArray2 = blArray;
                synchronized (blArray) {
                    blArray[0] = true;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        };
    }

    protected void getPopularity(SubscriptionImpl subscriptionImpl, SubscriptionPopularityListener subscriptionPopularityListener) throws SubscriptionException {
        try {
            long l = PlatformSubscriptionsMessenger.getPopularityBySID(subscriptionImpl.getShortID());
            if (l >= 0L) {
                this.log("Got popularity of " + subscriptionImpl.getName() + " from platform: " + l);
                subscriptionPopularityListener.gotPopularity(l);
                return;
            }
            if (subscriptionImpl.isSingleton()) {
                try {
                    this.checkSingletonPublish(subscriptionImpl);
                    subscriptionPopularityListener.gotPopularity(subscriptionImpl.isSubscribed() ? 1L : 0L);
                    return;
                }
                catch (Throwable throwable) {
                    this.log("    failed to create singleton public subscription " + subscriptionImpl.getString(), throwable);
                }
            }
        }
        catch (Throwable throwable) {
            this.log("Subscription lookup via platform failed", throwable);
        }
        this.getPopularityFromDHT(subscriptionImpl, subscriptionPopularityListener, true);
    }

    protected void getPopularityFromDHT(final SubscriptionImpl subscriptionImpl, final SubscriptionPopularityListener subscriptionPopularityListener, final boolean bl) {
        if (this.dht_plugin != null && !this.dht_plugin.isInitialising()) {
            this.getPopularitySupport(subscriptionImpl, subscriptionPopularityListener, bl);
        } else {
            new AEThread2("SM:popwait", true){

                public void run() {
                    SubscriptionManagerImpl.this.getPopularitySupport(subscriptionImpl, subscriptionPopularityListener, bl);
                }
            }.start();
        }
    }

    protected void updatePopularityFromDHT(final SubscriptionImpl subscriptionImpl, boolean bl) {
        this.getPopularityFromDHT(subscriptionImpl, new SubscriptionPopularityListener(){

            public void gotPopularity(long l) {
                subscriptionImpl.setCachedPopularity(l);
            }

            public void failed(SubscriptionException subscriptionException) {
                SubscriptionManagerImpl.this.log("Failed to update subscription popularity from DHT", subscriptionException);
            }
        }, bl);
    }

    protected void getPopularitySupport(final SubscriptionImpl subscriptionImpl, final SubscriptionPopularityListener subscriptionPopularityListener, final boolean bl) {
        this.log("Getting popularity of " + subscriptionImpl.getName() + " from DHT");
        byte[] byArray = subscriptionImpl.getPublicationHash();
        final AESemaphore aESemaphore = new AESemaphore("SM:pop");
        final long[] lArray = new long[]{-1L};
        this.dht_plugin.get(byArray, "Popularity lookup for subscription " + subscriptionImpl.getName(), (byte)8, 5, 15000L, false, true, new DHTPluginOperationListener(){
            private boolean diversified;
            private int hits = 0;

            public void diversified() {
                this.diversified = true;
            }

            public void starts(byte[] byArray) {
            }

            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                DHTPluginKeyStats dHTPluginKeyStats = SubscriptionManagerImpl.this.dht_plugin.decodeStats(dHTPluginValue);
                lArray[0] = Math.max(lArray[0], (long)dHTPluginKeyStats.getEntryCount());
                ++this.hits;
                if (this.hits >= 3) {
                    this.done();
                }
            }

            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            }

            public void complete(byte[] byArray, boolean bl2) {
                if (this.diversified) {
                    lArray[0] = lArray[0] * 11L;
                    if (lArray[0] == 0L) {
                        lArray[0] = 10L;
                    }
                }
                this.done();
            }

            protected void done() {
                if (bl) {
                    aESemaphore.release();
                } else if (lArray[0] == -1L) {
                    SubscriptionManagerImpl.this.log("Failed to get popularity of " + subscriptionImpl.getName() + " from DHT");
                    subscriptionPopularityListener.failed(new SubscriptionException("Timeout"));
                } else {
                    SubscriptionManagerImpl.this.log("Get popularity of " + subscriptionImpl.getName() + " from DHT: " + lArray[0]);
                    subscriptionPopularityListener.gotPopularity(lArray[0]);
                }
            }
        });
        if (bl) {
            aESemaphore.reserve(15000L);
            if (lArray[0] == -1L) {
                this.log("Failed to get popularity of " + subscriptionImpl.getName() + " from DHT");
                subscriptionPopularityListener.failed(new SubscriptionException("Timeout"));
            } else {
                this.log("Get popularity of " + subscriptionImpl.getName() + " from DHT: " + lArray[0]);
                subscriptionPopularityListener.gotPopularity(lArray[0]);
            }
        }
    }

    protected void lookupSubscription(final byte[] byArray, final byte[] byArray2, final int n, final subsLookupListener subsLookupListener2) {
        try {
            SubscriptionImpl subscriptionImpl = this.getSubscriptionFromPlatform(byArray2, 3);
            this.log("Added temporary subscription: " + subscriptionImpl.getString());
            subscriptionImpl = this.addSubscription(subscriptionImpl);
            subsLookupListener2.complete(byArray, new Subscription[]{subscriptionImpl});
            return;
        }
        catch (Throwable throwable) {
            if (subsLookupListener2.isCancelled()) {
                return;
            }
            final String string = ByteFormatter.encodeString(byArray2);
            this.log("Subscription lookup via platform for " + string + " failed", throwable);
            if (this.getSubscriptionDownloadCount() > 8) {
                this.log("Too many existing subscription downloads");
                subsLookupListener2.complete(byArray, new Subscription[0]);
                return;
            }
            this.log("Subscription lookup via DHT starts for " + string);
            String string2 = "subscription:publish:" + ByteFormatter.encodeString(byArray2) + ":" + n;
            this.dht_plugin.get(string2.getBytes(), "Subscription lookup read: " + ByteFormatter.encodeString(byArray2) + ":" + n, (byte)0, 12, 60000L, false, true, new DHTPluginOperationListener(){
                private boolean listener_handled;

                public void diversified() {
                }

                public void starts(byte[] byArray3) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    block14: {
                        byte[] byArray3 = dHTPluginValue.getValue();
                        try {
                            final Map map = SubscriptionManagerImpl.this.decodeSubscriptionDetails(byArray3);
                            if (SubscriptionImpl.getPublicationVersion(map) == n) {
                                Map map2 = (Map)map.get("x");
                                if (map2 == null) {
                                    23 var6_7 = this;
                                    synchronized (var6_7) {
                                        if (this.listener_handled) {
                                            return;
                                        }
                                        this.listener_handled = true;
                                    }
                                    SubscriptionManagerImpl.this.log("    found " + string + ", non-singleton");
                                    new AEThread2("Subs:lookup download", true){

                                        public void run() {
                                            SubscriptionManagerImpl.this.downloadSubscription(byArray, SubscriptionImpl.getPublicationHash(map), byArray2, n, SubscriptionImpl.getPublicationSize(map), subsLookupListener2);
                                        }
                                    }.start();
                                    break block14;
                                }
                                Object object = this;
                                synchronized (object) {
                                    if (this.listener_handled) {
                                        return;
                                    }
                                    this.listener_handled = true;
                                }
                                SubscriptionManagerImpl.this.log("    found " + string + ", singleton");
                                try {
                                    object = SubscriptionManagerImpl.this.createSingletonSubscription(map2, 3, false);
                                    subsLookupListener2.complete(byArray, new Subscription[]{object});
                                }
                                catch (Throwable throwable) {
                                    subsLookupListener2.failed(byArray, new SubscriptionException("Subscription creation failed", throwable));
                                }
                                break block14;
                            }
                            SubscriptionManagerImpl.this.log("    found " + string + " but version mismatch");
                        }
                        catch (Throwable throwable) {
                            SubscriptionManagerImpl.this.log("    found " + string + " but verification failed", throwable);
                        }
                    }
                }

                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void complete(byte[] byArray3, boolean bl) {
                    if (subsLookupListener2.isCancelled()) {
                        return;
                    }
                    SubscriptionManagerImpl.this.log("    " + string + " complete");
                    23 var3_3 = this;
                    synchronized (var3_3) {
                        if (!this.listener_handled) {
                            this.listener_handled = true;
                            subsLookupListener2.complete(byArray, new Subscription[0]);
                        }
                    }
                }
            });
            return;
        }
    }

    protected SubscriptionImpl getSubscriptionFromPlatform(byte[] byArray, int n) throws SubscriptionException {
        try {
            PlatformSubscriptionsMessenger.subscriptionDetails subscriptionDetails2 = PlatformSubscriptionsMessenger.getSubscriptionBySID(byArray);
            SubscriptionImpl subscriptionImpl = this.getSubscriptionFromVuzeFileContent(byArray, n, subscriptionDetails2.getContent());
            int n2 = subscriptionDetails2.getPopularity();
            if (n2 >= 0) {
                subscriptionImpl.setCachedPopularity(n2);
            }
            return subscriptionImpl;
        }
        catch (SubscriptionException subscriptionException) {
            throw subscriptionException;
        }
        catch (Throwable throwable) {
            throw new SubscriptionException("Failed to read subscription from platform", throwable);
        }
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFile(byte[] byArray, int n, File file) throws SubscriptionException {
        String string;
        VuzeFileHandler vuzeFileHandler = VuzeFileHandler.getSingleton();
        VuzeFile vuzeFile = vuzeFileHandler.loadVuzeFile(string = file.getAbsolutePath());
        if (vuzeFile == null) {
            this.log("Failed to load vuze file from " + string);
            throw new SubscriptionException("Failed to load vuze file from " + string);
        }
        return this.getSubscriptionFromVuzeFile(byArray, n, vuzeFile);
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFileContent(byte[] byArray, int n, String string) throws SubscriptionException {
        VuzeFileHandler vuzeFileHandler = VuzeFileHandler.getSingleton();
        VuzeFile vuzeFile = vuzeFileHandler.loadVuzeFile(Base64.decode(string));
        if (vuzeFile == null) {
            this.log("Failed to load vuze file from " + string);
            throw new SubscriptionException("Failed to load vuze file from content");
        }
        return this.getSubscriptionFromVuzeFile(byArray, n, vuzeFile);
    }

    protected SubscriptionImpl getSubscriptionFromVuzeFile(byte[] byArray, int n, VuzeFile vuzeFile) throws SubscriptionException {
        VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
        for (int i = 0; i < vuzeFileComponentArray.length; ++i) {
            VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[i];
            if (vuzeFileComponent.getType() != 16) continue;
            Map map = vuzeFileComponent.getContent();
            try {
                SubscriptionBodyImpl subscriptionBodyImpl = new SubscriptionBodyImpl(this, map);
                SubscriptionImpl subscriptionImpl = new SubscriptionImpl(this, subscriptionBodyImpl, n, false);
                if (!Arrays.equals(subscriptionImpl.getShortID(), byArray)) continue;
                return subscriptionImpl;
            }
            catch (Throwable throwable) {
                this.log("Subscription decode failed", throwable);
            }
        }
        throw new SubscriptionException("Subscription not found");
    }

    protected void downloadSubscription(final byte[] byArray, byte[] byArray2, final byte[] byArray3, int n, int n2, final subsLookupListener subsLookupListener2) {
        try {
            Object[] objectArray = this.downloadTorrent(byArray2, n2);
            if (subsLookupListener2.isCancelled()) {
                return;
            }
            if (objectArray == null) {
                subsLookupListener2.complete(byArray, new Subscription[0]);
                return;
            }
            this.downloadSubscription((TOTorrent)objectArray[0], (InetSocketAddress)objectArray[1], byArray3, n, "Subscription " + ByteFormatter.encodeString(byArray3) + " for " + ByteFormatter.encodeString(byArray), new downloadListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void complete(File file) {
                    boolean bl = false;
                    try {
                        try {
                            if (!subsLookupListener2.isCancelled()) {
                                SubscriptionImpl subscriptionImpl = SubscriptionManagerImpl.this.getSubscriptionFromVuzeFile(byArray3, 3, file);
                                SubscriptionManagerImpl.this.log("Added temporary subscription: " + subscriptionImpl.getString());
                                subscriptionImpl = SubscriptionManagerImpl.this.addSubscription(subscriptionImpl);
                                subsLookupListener2.complete(byArray, new Subscription[]{subscriptionImpl});
                                return;
                            }
                            Object var5_3 = null;
                            if (bl) return;
                        }
                        catch (Throwable throwable) {
                            SubscriptionManagerImpl.this.log("Subscription decode failed", throwable);
                            Object var5_5 = null;
                            if (bl) return;
                            subsLookupListener2.complete(byArray, new Subscription[0]);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (bl) throw throwable;
                        subsLookupListener2.complete(byArray, new Subscription[0]);
                        throw throwable;
                    }
                    subsLookupListener2.complete(byArray, new Subscription[0]);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void complete(Download download, File file) {
                    File file2 = new File(download.getSavePath());
                    try {
                        try {
                            SubscriptionManagerImpl.this.removeDownload(download, false);
                            this.complete(file2);
                        }
                        catch (Throwable throwable) {
                            SubscriptionManagerImpl.this.log("Failed to remove download", throwable);
                            subsLookupListener2.complete(byArray, new Subscription[0]);
                            Object var6_5 = null;
                            file.delete();
                            file2.delete();
                            return;
                        }
                        Object var6_4 = null;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        file.delete();
                        file2.delete();
                        throw throwable;
                    }
                    file2.delete();
                }

                public void failed(Throwable throwable) {
                    subsLookupListener2.complete(byArray, new Subscription[0]);
                }

                public Map getRecoveryData() {
                    return null;
                }

                public boolean isCancelled() {
                    return subsLookupListener2.isCancelled();
                }
            });
        }
        catch (Throwable throwable) {
            this.log("Subscription download failed", throwable);
            subsLookupListener2.complete(byArray, new Subscription[0]);
        }
    }

    protected int getSubscriptionDownloadCount() {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        Download[] downloadArray = pluginInterface.getDownloadManager().getDownloads();
        int n = 0;
        for (int i = 0; i < downloadArray.length; ++i) {
            Download download = downloadArray[i];
            if (!download.getBooleanAttribute(this.ta_subs_download)) continue;
            ++n;
        }
        return n;
    }

    protected void associationAdded(SubscriptionImpl subscriptionImpl, byte[] byArray) {
        this.recordAssociations(byArray, new SubscriptionImpl[]{subscriptionImpl}, false);
        if (this.dht_plugin != null) {
            this.publishAssociations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPotentialAssociation(SubscriptionImpl subscriptionImpl, String string, String string2) {
        if (string2 == null) {
            Debug.out("Attempt to add null key!");
            return;
        }
        this.log("Added potential association: " + subscriptionImpl.getName() + "/" + string + " -> " + string2);
        List<Object[]> list = this.potential_associations;
        synchronized (list) {
            this.potential_associations.add(new Object[]{subscriptionImpl, string, string2, new Long(System.currentTimeMillis())});
            if (this.potential_associations.size() > 512) {
                this.potential_associations.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPotentialAssociations(byte[] byArray, String string) {
        this.log("Checking potential association: " + string + " -> " + ByteFormatter.encodeString(byArray));
        SubscriptionImpl subscriptionImpl = null;
        String string2 = null;
        Object object = this.potential_associations;
        synchronized (object) {
            Iterator<Object[]> iterator = this.potential_associations.iterator();
            while (iterator.hasNext()) {
                Object[] objectArray = iterator.next();
                String string3 = (String)objectArray[2];
                if (!string.startsWith(string3)) continue;
                subscriptionImpl = (SubscriptionImpl)objectArray[0];
                string2 = (String)objectArray[1];
                this.log("    key matched to subscription " + subscriptionImpl.getName() + "/" + string2);
                iterator.remove();
                break;
            }
        }
        if (subscriptionImpl == null) {
            this.log("    no potential associations found");
        } else {
            object = subscriptionImpl.getHistory().getResult(string2);
            if (object != null) {
                this.log("    result found, marking as read");
                object.setRead(true);
            } else {
                this.log("    result not found");
            }
            this.log("    adding association");
            subscriptionImpl.addAssociation(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tidyPotentialAssociations() {
        SubscriptionImpl[] subscriptionImplArray;
        Object object;
        Iterator<Object> iterator;
        long l = SystemTime.getCurrentTime();
        Object object2 = this.potential_associations;
        synchronized (object2) {
            iterator = this.potential_associations.iterator();
            while (iterator.hasNext() && this.potential_associations.size() > 16) {
                object = iterator.next();
                long l2 = (Long)object[3];
                if (l2 > l) {
                    object[3] = new Long(l);
                    continue;
                }
                if (l - l2 <= 3600000L) continue;
                SubscriptionImpl subscriptionImpl = (SubscriptionImpl)object[0];
                String string = (String)object[1];
                subscriptionImplArray = (SubscriptionImpl[])object[2];
                this.log("Removing expired potential association: " + subscriptionImpl.getName() + "/" + string + " -> " + (String)subscriptionImplArray);
                iterator.remove();
            }
        }
        object2 = this.potential_associations2;
        synchronized (object2) {
            iterator = this.potential_associations2.entrySet().iterator();
            while (iterator.hasNext() && this.potential_associations2.size() > 16) {
                object = (Map.Entry)iterator.next();
                byte[] byArray = ((HashWrapper)object.getKey()).getBytes();
                Object[] objectArray = (Object[])object.getValue();
                long l3 = (Long)objectArray[2];
                if (l3 > l) {
                    objectArray[2] = new Long(l);
                    continue;
                }
                if (l - l3 <= 3600000L) continue;
                subscriptionImplArray = (SubscriptionImpl[])objectArray[0];
                String string = "";
                for (int i = 0; i < subscriptionImplArray.length; ++i) {
                    string = string + (i == 0 ? "" : ",") + subscriptionImplArray[i].getName();
                }
                this.log("Removing expired potential association: " + ByteFormatter.encodeString(byArray) + " -> " + string);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordAssociations(byte[] byArray, SubscriptionImpl[] subscriptionImplArray, boolean bl) {
        HashWrapper hashWrapper = new HashWrapper(byArray);
        Map<HashWrapper, Object[]> map = this.potential_associations2;
        synchronized (map) {
            this.potential_associations2.put(hashWrapper, new Object[]{subscriptionImplArray, new Boolean(bl), new Long(SystemTime.getCurrentTime())});
        }
        if (this.recordAssociationsSupport(byArray, subscriptionImplArray, bl)) {
            map = this.potential_associations2;
            synchronized (map) {
                this.potential_associations2.remove(hashWrapper);
            }
        } else {
            this.log("Deferring association for " + ByteFormatter.encodeString(byArray));
        }
    }

    protected boolean recordAssociationsSupport(byte[] byArray, SubscriptionImpl[] subscriptionImplArray, boolean bl) {
        Object object;
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            object = pluginInterface.getDownloadManager().getDownload(byArray);
            if (object != null) {
                ArrayList<byte[]> arrayList;
                Map map;
                if (subscriptionImplArray.length > 0 && (map = subscriptionImplArray[0].getCategory()) != null && (arrayList = object.getAttribute(this.ta_category)) == null) {
                    object.setAttribute(this.ta_category, (String)((Object)map));
                }
                bl2 = true;
                map = object.getMapAttribute(this.ta_subscription_info);
                map = map == null ? new LightHashMap() : new LightHashMap(map);
                arrayList = (List)map.get("s");
                for (int i = 0; i < subscriptionImplArray.length; ++i) {
                    byte[] byArray2 = subscriptionImplArray[i].getShortID();
                    if (arrayList == null) {
                        arrayList = new ArrayList<byte[]>();
                        arrayList.add(byArray2);
                        bl3 = true;
                        map.put("s", arrayList);
                        continue;
                    }
                    boolean bl4 = false;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        byte[] byArray3 = (byte[])arrayList.get(j);
                        if (!Arrays.equals(byArray2, byArray3)) continue;
                        bl4 = true;
                        break;
                    }
                    if (bl4) continue;
                    arrayList.add(byArray2);
                    bl3 = true;
                }
                if (bl) {
                    map.put("lc", new Long(SystemTime.getCurrentTime()));
                    bl3 = true;
                }
                if (bl3) {
                    object.setMapAttribute(this.ta_subscription_info, map);
                }
            }
        }
        catch (Throwable throwable) {
            this.log("Failed to record associations", throwable);
        }
        if (bl3) {
            object = this.listeners.iterator();
            while (object.hasNext()) {
                try {
                    ((SubscriptionManagerListener)object.next()).associationsChanged(byArray);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean publishAssociations() {
        SubscriptionImpl subscriptionImpl = null;
        SubscriptionImpl.association association2 = null;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.publish_associations_active >= 3) {
                return false;
            }
            ++this.publish_associations_active;
            ArrayList<SubscriptionImpl> arrayList = new ArrayList<SubscriptionImpl>(this.subscriptions);
            Collections.shuffle(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                SubscriptionImpl subscriptionImpl2 = (SubscriptionImpl)arrayList.get(i);
                if (!subscriptionImpl2.isSubscribed() || !subscriptionImpl2.isPublic() || (association2 = subscriptionImpl2.getAssociationForPublish()) == null) continue;
                subscriptionImpl = subscriptionImpl2;
                break;
            }
        }
        if (association2 != null) {
            this.publishAssociation(subscriptionImpl, association2);
            return false;
        }
        this.log("Publishing Associations Complete");
        subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            --this.publish_associations_active;
        }
        return true;
    }

    protected void publishAssociation(final SubscriptionImpl subscriptionImpl, final SubscriptionImpl.association association2) {
        this.log("Checking association '" + subscriptionImpl.getString() + "' -> '" + association2.getString() + "'");
        byte[] byArray = subscriptionImpl.getShortID();
        int n = subscriptionImpl.getVersion();
        byte[] byArray2 = association2.getHash();
        final String string = "subscription:assoc:" + ByteFormatter.encodeString(byArray2);
        final byte[] byArray3 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray3, 4, byArray.length);
        byArray3[0] = (byte)(n >> 16);
        byArray3[1] = (byte)(n >> 8);
        byArray3[2] = (byte)n;
        byArray3[3] = (byte)subscriptionImpl.getFixedRandom();
        this.dht_plugin.get(string.getBytes(), "Subscription association read: " + ByteFormatter.encodeString(byArray2), (byte)0, 30, 60000L, false, false, new DHTPluginOperationListener(){
            private int hits;
            private boolean diversified;
            private int max_ver;

            public void diversified() {
                this.diversified = true;
            }

            public void starts(byte[] byArray) {
            }

            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                byte[] byArray = dHTPluginValue.getValue();
                if (byArray.length == byArray3.length) {
                    int n;
                    boolean bl = false;
                    for (n = 4; n < byArray.length; ++n) {
                        if (byArray[n] == byArray3[n]) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        ++this.hits;
                        n = byArray[0] << 16 & 0xFF0000 | byArray[1] << 8 & 0xFF00 | byArray[2] & 0xFF;
                        if (n > this.max_ver) {
                            this.max_ver = n;
                        }
                    }
                }
            }

            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            }

            public void complete(byte[] byArray, boolean bl) {
                SubscriptionManagerImpl.this.log("Checked association '" + subscriptionImpl.getString() + "' -> '" + association2.getString() + "' - max_ver=" + this.max_ver + ",hits=" + this.hits + ",div=" + this.diversified);
                if (this.max_ver > subscriptionImpl.getVersion() && !subscriptionImpl.isMine()) {
                    SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, this.max_ver);
                }
                if (this.hits == 0 && this.diversified || this.hits < 6 && !this.diversified) {
                    SubscriptionManagerImpl.this.log("    Publishing association '" + subscriptionImpl.getString() + "' -> '" + association2.getString() + "', existing=" + this.hits);
                    byte by = 16;
                    if (this.hits < 3 && !this.diversified) {
                        by = (byte)(by | 0x20);
                    }
                    SubscriptionManagerImpl.this.dht_plugin.put(string.getBytes(), "Subscription association write: " + ByteFormatter.encodeString(association2.getHash()) + " -> " + ByteFormatter.encodeString(subscriptionImpl.getShortID()) + ":" + subscriptionImpl.getVersion(), byArray3, by, new DHTPluginOperationListener(){

                        public void diversified() {
                        }

                        public void starts(byte[] byArray) {
                        }

                        public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                        }

                        public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                        }

                        public void complete(byte[] byArray, boolean bl) {
                            SubscriptionManagerImpl.this.log("        completed '" + subscriptionImpl.getString() + "' -> '" + association2.getString() + "'");
                            this.publishNext();
                        }
                    });
                } else {
                    SubscriptionManagerImpl.this.log("    Not publishing association '" + subscriptionImpl.getString() + "' -> '" + association2.getString() + "', existing =" + this.hits);
                    this.publishNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void publishNext() {
                25 var1_1 = this;
                synchronized (var1_1) {
                    SubscriptionManagerImpl.this.publish_associations_active--;
                }
                SubscriptionManagerImpl.this.publishAssociations();
            }
        });
    }

    protected void subscriptionUpdated() {
        if (this.dht_plugin != null) {
            this.publishSubscriptions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishSubscriptions() {
        block13: {
            SubscriptionManagerImpl subscriptionManagerImpl;
            ArrayList<SubscriptionImpl> arrayList;
            SubscriptionManagerImpl subscriptionManagerImpl2 = this;
            synchronized (subscriptionManagerImpl2) {
                if (this.publish_subscription_active) {
                    return;
                }
                arrayList = new ArrayList<SubscriptionImpl>(this.subscriptions);
                this.publish_subscription_active = true;
            }
            boolean bl = false;
            try {
                Collections.shuffle(arrayList);
                for (int i = 0; i < arrayList.size(); ++i) {
                    SubscriptionImpl subscriptionImpl = (SubscriptionImpl)arrayList.get(i);
                    if (!subscriptionImpl.isSubscribed() || !subscriptionImpl.isPublic() || subscriptionImpl.getPublished()) continue;
                    subscriptionImpl.setPublished(true);
                    this.publishSubscription(subscriptionImpl);
                    bl = true;
                    break;
                }
                Object var6_7 = null;
                if (bl) break block13;
                this.log("Publishing Subscriptions Complete");
                subscriptionManagerImpl = this;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (!bl) {
                    this.log("Publishing Subscriptions Complete");
                    SubscriptionManagerImpl subscriptionManagerImpl3 = this;
                    synchronized (subscriptionManagerImpl3) {
                        this.publish_subscription_active = false;
                    }
                }
                throw throwable;
            }
            synchronized (subscriptionManagerImpl) {
                this.publish_subscription_active = false;
            }
        }
    }

    protected void publishSubscription(final SubscriptionImpl subscriptionImpl) {
        this.log("Checking subscription publication '" + subscriptionImpl.getString() + "'");
        byte[] byArray = subscriptionImpl.getShortID();
        int n = subscriptionImpl.getVersion();
        final String string = "subscription:publish:" + ByteFormatter.encodeString(byArray) + ":" + n;
        this.dht_plugin.get(string.getBytes(), "Subscription presence read: " + ByteFormatter.encodeString(byArray) + ":" + n, (byte)0, 24, 60000L, false, false, new DHTPluginOperationListener(){
            private int hits;
            private boolean diversified;

            public void diversified() {
                this.diversified = true;
            }

            public void starts(byte[] byArray) {
            }

            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                byte[] byArray = dHTPluginValue.getValue();
                try {
                    Map map = SubscriptionManagerImpl.this.decodeSubscriptionDetails(byArray);
                    if (subscriptionImpl.getVerifiedPublicationVersion(map) == subscriptionImpl.getVersion()) {
                        ++this.hits;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }

            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
            }

            public void complete(byte[] byArray, boolean bl) {
                SubscriptionManagerImpl.this.log("Checked subscription publication '" + subscriptionImpl.getString() + "' - hits=" + this.hits + ",div=" + this.diversified);
                if (this.hits == 0 && this.diversified || this.hits < 6 && !this.diversified) {
                    SubscriptionManagerImpl.this.log("    Publishing subscription '" + subscriptionImpl.getString() + ", existing=" + this.hits);
                    try {
                        byte[] byArray2 = SubscriptionManagerImpl.this.encodeSubscriptionDetails(subscriptionImpl);
                        byte by = 0;
                        if (this.hits < 3 && !this.diversified) {
                            by = (byte)(by | 0x20);
                        }
                        SubscriptionManagerImpl.this.dht_plugin.put(string.getBytes(), "Subscription presence write: " + ByteFormatter.encodeString(subscriptionImpl.getShortID()) + ":" + subscriptionImpl.getVersion(), byArray2, by, new DHTPluginOperationListener(){

                            public void diversified() {
                            }

                            public void starts(byte[] byArray) {
                            }

                            public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                            }

                            public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                            }

                            public void complete(byte[] byArray, boolean bl) {
                                SubscriptionManagerImpl.this.log("        completed '" + subscriptionImpl.getString() + "'");
                                this.publishNext();
                            }
                        });
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        this.publishNext();
                    }
                } else {
                    SubscriptionManagerImpl.this.log("    Not publishing subscription '" + subscriptionImpl.getString() + "', existing =" + this.hits);
                    this.publishNext();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void publishNext() {
                26 var1_1 = this;
                synchronized (var1_1) {
                    SubscriptionManagerImpl.this.publish_subscription_active = false;
                }
                SubscriptionManagerImpl.this.publishSubscriptions();
            }
        });
    }

    protected void updateSubscription(final SubscriptionImpl subscriptionImpl, final int n) {
        this.log("Subscription " + subscriptionImpl.getString() + " - higher version found: " + n);
        if (!subscriptionImpl.canAutoUpgradeCheck()) {
            this.log("    Checked too recently or not updateable, ignoring");
            return;
        }
        if (subscriptionImpl.getHighestUserPromptedVersion() >= n) {
            this.log("    User has already been prompted for version " + n + " so ignoring");
            return;
        }
        byte[] byArray = subscriptionImpl.getShortID();
        try {
            PlatformSubscriptionsMessenger.subscriptionDetails subscriptionDetails2 = PlatformSubscriptionsMessenger.getSubscriptionBySID(byArray);
            if (!this.askIfCanUpgrade(subscriptionImpl, n)) {
                return;
            }
            VuzeFileHandler vuzeFileHandler = VuzeFileHandler.getSingleton();
            VuzeFile vuzeFile = vuzeFileHandler.loadVuzeFile(Base64.decode(subscriptionDetails2.getContent()));
            vuzeFileHandler.handleFiles(new VuzeFile[]{vuzeFile}, 16);
            return;
        }
        catch (Throwable throwable) {
            this.log("Failed to read subscription from platform, trying DHT");
            this.log("Checking subscription '" + subscriptionImpl.getString() + "' upgrade to version " + n);
            String string = "subscription:publish:" + ByteFormatter.encodeString(byArray) + ":" + n;
            this.dht_plugin.get(string.getBytes(), "Subscription update read: " + ByteFormatter.encodeString(byArray) + ":" + n, (byte)0, 12, 60000L, false, false, new DHTPluginOperationListener(){
                private byte[] verified_hash;
                private int verified_size;

                public void diversified() {
                }

                public void starts(byte[] byArray) {
                }

                public void valueRead(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                    byte[] byArray = dHTPluginValue.getValue();
                    try {
                        Map map = SubscriptionManagerImpl.this.decodeSubscriptionDetails(byArray);
                        if (this.verified_hash == null && subscriptionImpl.getVerifiedPublicationVersion(map) == n) {
                            this.verified_hash = SubscriptionImpl.getPublicationHash(map);
                            this.verified_size = SubscriptionImpl.getPublicationSize(map);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }

                public void valueWritten(DHTPluginContact dHTPluginContact, DHTPluginValue dHTPluginValue) {
                }

                public void complete(byte[] byArray, boolean bl) {
                    if (this.verified_hash != null) {
                        SubscriptionManagerImpl.this.log("    Subscription '" + subscriptionImpl.getString() + " upgrade verified as authentic");
                        SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, n, this.verified_hash, this.verified_size);
                    } else {
                        SubscriptionManagerImpl.this.log("    Subscription '" + subscriptionImpl.getString() + " upgrade not verified");
                    }
                }
            });
            return;
        }
    }

    protected byte[] encodeSubscriptionDetails(SubscriptionImpl subscriptionImpl) throws IOException {
        byte[] byArray;
        byte by;
        Map map = subscriptionImpl.getPublicationDetails();
        map.put("!", new Long(random_seed));
        byte[] byArray2 = BEncoder.encode(map);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gZIPOutputStream.write(byArray2);
        gZIPOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (byArray3.length < byArray2.length) {
            by = 1;
            byArray = byArray3;
        } else {
            by = 0;
            byArray = byArray2;
        }
        byte[] byArray4 = new byte[byArray.length + 1];
        byArray4[0] = by;
        System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
        return byArray4;
    }

    protected Map decodeSubscriptionDetails(byte[] byArray) throws IOException {
        Object object;
        byte[] byArray2;
        if (byArray[0] == 0) {
            byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
        } else {
            object = new GZIPInputStream(new ByteArrayInputStream(byArray, 1, byArray.length - 1));
            byArray2 = FileUtil.readInputStreamAsByteArray((InputStream)object);
            ((GZIPInputStream)object).close();
        }
        object = BDecoder.decode(byArray2);
        object.remove("!");
        return object;
    }

    protected void updateSubscription(final SubscriptionImpl subscriptionImpl, final int n, final byte[] byArray, final int n2) {
        this.log("Subscription " + subscriptionImpl.getString() + " - update hash=" + ByteFormatter.encodeString(byArray) + ", size=" + n2);
        new AEThread2("SubsUpdate", true){

            public void run() {
                try {
                    Object[] objectArray = SubscriptionManagerImpl.this.downloadTorrent(byArray, n2);
                    if (objectArray != null) {
                        SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, n, (TOTorrent)objectArray[0], (InetSocketAddress)objectArray[1]);
                    }
                }
                catch (Throwable throwable) {
                    SubscriptionManagerImpl.this.log("    update failed", throwable);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] downloadTorrent(byte[] byArray, int n) {
        MagnetPlugin magnetPlugin = this.getMagnetPlugin();
        if (magnetPlugin == null) {
            this.log("    Can't download, no magnet plugin");
            return null;
        }
        try {
            final InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[]{null};
            byte[] byArray2 = magnetPlugin.download(new MagnetPluginProgressListener(){

                public void reportSize(long l) {
                }

                public void reportActivity(String string) {
                    SubscriptionManagerImpl.this.log("    MagnetDownload: " + string);
                }

                public void reportCompleteness(int n) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void reportContributor(InetSocketAddress inetSocketAddress) {
                    InetSocketAddress[] inetSocketAddressArray2 = inetSocketAddressArray;
                    synchronized (inetSocketAddressArray) {
                        inetSocketAddressArray[0] = inetSocketAddress;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                public boolean verbose() {
                    return false;
                }
            }, byArray, "", new InetSocketAddress[0], 300000L);
            if (byArray2 == null) {
                this.log("    download failed - timeout");
                return null;
            }
            this.log("Subscription torrent downloaded");
            TOTorrent tOTorrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(byArray2);
            if (tOTorrent.getSize() > (long)(n + 10240)) {
                this.log("Subscription download abandoned, torrent size is " + tOTorrent.getSize() + ", underlying data size is " + n);
                return null;
            }
            if (tOTorrent.getSize() > 0x400000L) {
                this.log("Subscription download abandoned, torrent size is too large (" + tOTorrent.getSize() + ")");
                return null;
            }
            InetSocketAddress[] inetSocketAddressArray2 = inetSocketAddressArray;
            synchronized (inetSocketAddressArray) {
                // ** MonitorExit[var7_8] (shouldn't be in output)
                return new Object[]{tOTorrent, inetSocketAddressArray[0]};
            }
        }
        catch (Throwable throwable) {
            this.log("    download failed", throwable);
            return null;
        }
    }

    protected void downloadSubscription(final TOTorrent tOTorrent, final InetSocketAddress inetSocketAddress, byte[] byArray, int n, String string, final downloadListener downloadListener2) {
        try {
            LightWeightSeed lightWeightSeed = LightWeightSeedManager.getSingleton().get(new HashWrapper(tOTorrent.getHash()));
            if (lightWeightSeed != null) {
                this.log("Light weight seed found");
                downloadListener2.complete(lightWeightSeed.getDataLocation());
            } else {
                Object object;
                String string2 = ByteFormatter.encodeString(byArray);
                File file = this.getSubsDir();
                if (!(file = new File(file, "temp")).exists() && !file.mkdirs()) {
                    throw new IOException("Failed to create dir '" + file + "'");
                }
                final File file2 = new File(file, string2 + "_" + n + ".torrent");
                File file3 = new File(file, string2 + "_" + n + ".vuze");
                PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
                final DownloadManager downloadManager = pluginInterface.getDownloadManager();
                Download download = downloadManager.getDownload(tOTorrent.getHash());
                if (download == null) {
                    this.log("Adding download for subscription '" + new String(tOTorrent.getName()) + "'");
                    boolean bl = this.getSubscriptionFromSID(byArray) != null;
                    PlatformTorrentUtils.setContentTitle(tOTorrent, (bl ? "Update" : "Download") + " for subscription '" + string + "'");
                    TorrentUtils.setFlag(tOTorrent, 1, true);
                    object = new TorrentImpl(tOTorrent);
                    object.setDefaultEncoding();
                    object.writeToFile(file2);
                    download = downloadManager.addDownload((Torrent)object, file2, file3);
                    download.setFlag(4L, true);
                    download.setBooleanAttribute(this.ta_subs_download, true);
                    Map map = downloadListener2.getRecoveryData();
                    if (map != null) {
                        download.setMapAttribute(this.ta_subs_download_rd, map);
                    }
                } else {
                    this.log("Existing download found for subscription '" + new String(tOTorrent.getName()) + "'");
                }
                Download download2 = download;
                object = new TimerEventPeriodic[]{null};
                object[0] = SimpleTimer.addPeriodicEvent("SM:cancelTimer", 10000L, new TimerEventPerformer((TimerEventPeriodic[])object, download2, file2){
                    private long start_time = SystemTime.getMonotonousTime();
                    final /* synthetic */ TimerEventPeriodic[] val$event;
                    final /* synthetic */ Download val$f_download;
                    final /* synthetic */ File val$torrent_file;
                    {
                        this.val$event = timerEventPeriodicArray;
                        this.val$f_download = download;
                        this.val$torrent_file = file;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent timerEvent2) {
                        boolean bl = false;
                        try {
                            Download download = downloadManager.getDownload(tOTorrent.getHash());
                            if (downloadListener2.isCancelled() || download == null) {
                                bl = true;
                            } else {
                                int n = download.getState();
                                if (n == 8) {
                                    SubscriptionManagerImpl.this.log("Download entered error state, removing");
                                    bl = true;
                                } else {
                                    long l = SystemTime.getMonotonousTime();
                                    long l2 = l - this.start_time;
                                    if (l2 > 120000L) {
                                        DownloadScrapeResult downloadScrapeResult = download.getLastScrapeResult();
                                        if (downloadScrapeResult == null || downloadScrapeResult.getSeedCount() <= 0) {
                                            SubscriptionManagerImpl.this.log("Download has no seeds, removing");
                                            bl = true;
                                        }
                                    } else if (l2 > 240000L) {
                                        if (download.getStats().getDownloaded() == 0L) {
                                            SubscriptionManagerImpl.this.log("Download has zero downloaded, removing");
                                            bl = true;
                                        }
                                    } else if (l2 > 600000L) {
                                        SubscriptionManagerImpl.this.log("Download hasn't completed in permitted time, removing");
                                        bl = true;
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            SubscriptionManagerImpl.this.log("Download failed", throwable);
                            bl = true;
                        }
                        if (bl && this.val$event[0] != null) {
                            try {
                                this.val$event[0].cancel();
                                if (!downloadListener2.isCancelled()) {
                                    downloadListener2.failed(new SubscriptionException("Download abandoned"));
                                }
                                Object var11_9 = null;
                                SubscriptionManagerImpl.this.removeDownload(this.val$f_download, true);
                                this.val$torrent_file.delete();
                            }
                            catch (Throwable throwable) {
                                Object var11_10 = null;
                                SubscriptionManagerImpl.this.removeDownload(this.val$f_download, true);
                                this.val$torrent_file.delete();
                                throw throwable;
                            }
                            {
                            }
                        }
                    }
                });
                download.addCompletionListener(new DownloadCompletionListener(){

                    public void onCompletion(Download download) {
                        downloadListener2.complete(download, file2);
                    }
                });
                if (download.isComplete()) {
                    downloadListener2.complete(download, file2);
                } else {
                    download.setForceStart(true);
                    if (inetSocketAddress != null) {
                        download.addPeerListener(new DownloadPeerListener(){

                            public void peerManagerAdded(Download download, PeerManager peerManager) {
                                InetSocketAddress inetSocketAddress3 = AddressUtils.adjustTCPAddress(inetSocketAddress, true);
                                InetSocketAddress inetSocketAddress2 = AddressUtils.adjustUDPAddress(inetSocketAddress, true);
                                SubscriptionManagerImpl.this.log("    Injecting peer into download: " + inetSocketAddress3);
                                peerManager.addPeer(inetSocketAddress3.getAddress().getHostAddress(), inetSocketAddress3.getPort(), inetSocketAddress2.getPort(), true);
                            }

                            public void peerManagerRemoved(Download download, PeerManager peerManager) {
                            }
                        });
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.log("Failed to add download", throwable);
            downloadListener2.failed(throwable);
        }
    }

    protected void updateSubscription(final SubscriptionImpl subscriptionImpl, final int n, TOTorrent tOTorrent, InetSocketAddress inetSocketAddress) {
        this.log("Subscription " + subscriptionImpl.getString() + " - update torrent: " + new String(tOTorrent.getName()));
        if (!this.askIfCanUpgrade(subscriptionImpl, n)) {
            return;
        }
        this.downloadSubscription(tOTorrent, inetSocketAddress, subscriptionImpl.getShortID(), n, subscriptionImpl.getName(), new downloadListener(){

            public void complete(File file) {
                SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, file);
            }

            public void complete(Download download, File file) {
                SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, download, file, new File(download.getSavePath()));
            }

            public void failed(Throwable throwable) {
                SubscriptionManagerImpl.this.log("Failed to download subscription", throwable);
            }

            public Map getRecoveryData() {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("sid", subscriptionImpl.getShortID());
                hashMap.put("ver", new Long(n));
                return hashMap;
            }

            public boolean isCancelled() {
                return false;
            }
        });
    }

    protected boolean askIfCanUpgrade(SubscriptionImpl subscriptionImpl, int n) {
        subscriptionImpl.setHighestUserPromptedVersion(n);
        UIManager uIManager = StaticUtilities.getUIManager(120000L);
        String string = MessageText.getString("subscript.add.upgradeto.desc", new String[]{String.valueOf(n), subscriptionImpl.getName()});
        long l = uIManager.showMessageBox("subscript.add.upgrade.title", "!" + string + "!", 12L);
        if (l != 4L) {
            this.log("    User declined upgrade");
            return false;
        }
        return true;
    }

    protected boolean recoverSubscriptionUpdate(Download download, final Map map) {
        byte[] byArray = (byte[])map.get("sid");
        int n = ((Long)map.get("ver")).intValue();
        final SubscriptionImpl subscriptionImpl = this.getSubscriptionFromSID(byArray);
        if (subscriptionImpl == null) {
            this.log("Can't recover '" + download.getName() + "' - subscription " + ByteFormatter.encodeString(byArray) + " not found");
            return false;
        }
        this.downloadSubscription(((TorrentImpl)download.getTorrent()).getTorrent(), null, subscriptionImpl.getShortID(), n, subscriptionImpl.getName(), new downloadListener(){

            public void complete(File file) {
                SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, file);
            }

            public void complete(Download download, File file) {
                SubscriptionManagerImpl.this.updateSubscription(subscriptionImpl, download, file, new File(download.getSavePath()));
            }

            public void failed(Throwable throwable) {
                SubscriptionManagerImpl.this.log("Failed to download subscription", throwable);
            }

            public Map getRecoveryData() {
                return map;
            }

            public boolean isCancelled() {
                return false;
            }
        });
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateSubscription(SubscriptionImpl subscriptionImpl, Download download, File file, File file2) {
        try {
            this.removeDownload(download, false);
            try {
                this.updateSubscription(subscriptionImpl, file2);
                Object var6_5 = null;
                if (!file2.delete()) {
                    this.log("Failed to delete update file '" + file2 + "'");
                }
                if (!file.delete()) {
                    this.log("Failed to delete update torrent '" + file + "'");
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (!file2.delete()) {
                    this.log("Failed to delete update file '" + file2 + "'");
                }
                if (!file.delete()) {
                    this.log("Failed to delete update torrent '" + file + "'");
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            this.log("Failed to remove update download", throwable);
        }
    }

    protected void removeDownload(Download download, boolean bl) {
        try {
            download.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            download.remove(true, bl);
            this.log("Removed download '" + download.getName() + "'");
        }
        catch (Throwable throwable) {
            this.log("Failed to remove download '" + download.getName() + "'", throwable);
        }
    }

    protected void updateSubscription(SubscriptionImpl subscriptionImpl, File file) {
        this.log("Updating subscription '" + subscriptionImpl.getString() + " using '" + file + "'");
        VuzeFileHandler vuzeFileHandler = VuzeFileHandler.getSingleton();
        VuzeFile vuzeFile = vuzeFileHandler.loadVuzeFile(file.getAbsolutePath());
        vuzeFileHandler.handleFiles(new VuzeFile[]{vuzeFile}, 16);
    }

    protected MagnetPlugin getMagnetPlugin() {
        PluginInterface pluginInterface = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(MagnetPlugin.class);
        if (pluginInterface == null) {
            return null;
        }
        return (MagnetPlugin)pluginInterface.getPlugin();
    }

    protected Engine getEngine(SubscriptionImpl subscriptionImpl, Map map, boolean bl) throws SubscriptionException {
        long l = (Long)map.get("engine_id");
        Engine engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().getEngine(l);
        if (engine != null) {
            return engine;
        }
        if (!bl) {
            try {
                if (l >= 0L && l < Integer.MAX_VALUE) {
                    this.log("Engine " + l + " not present, loading");
                    try {
                        engine = MetaSearchManagerFactory.getSingleton().getMetaSearch().addEngine(l);
                        return engine;
                    }
                    catch (Throwable throwable) {
                        throw new SubscriptionException("Failed to load engine '" + l + "'", throwable);
                    }
                }
            }
            catch (Throwable throwable) {
                this.log("Failed to load search template", throwable);
            }
        }
        if ((engine = subscriptionImpl.extractEngine(map, l)) != null) {
            return engine;
        }
        throw new SubscriptionException("Failed to extract engine id " + l);
    }

    protected SubscriptionResultImpl[] loadResults(SubscriptionImpl subscriptionImpl) {
        ArrayList<SubscriptionResultImpl> arrayList = new ArrayList<SubscriptionResultImpl>();
        try {
            File file = this.getResultsFile(subscriptionImpl);
            Map map = FileUtil.readResilientFile(file);
            List list = (List)map.get("results");
            if (list != null) {
                SubscriptionHistoryImpl subscriptionHistoryImpl = (SubscriptionHistoryImpl)subscriptionImpl.getHistory();
                for (int i = 0; i < list.size(); ++i) {
                    Map map2 = (Map)list.get(i);
                    try {
                        SubscriptionResultImpl subscriptionResultImpl = new SubscriptionResultImpl(subscriptionHistoryImpl, map2);
                        arrayList.add(subscriptionResultImpl);
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to decode result '" + map2 + "'", throwable);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            this.log("Failed to load results for '" + subscriptionImpl.getName() + "' - continuing with empty result set", throwable);
        }
        return arrayList.toArray(new SubscriptionResultImpl[arrayList.size()]);
    }

    protected void setCategoryOnExisting(SubscriptionImpl subscriptionImpl, String string, String string2) {
        Download[] downloadArray;
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        for (Download download : downloadArray = pluginInterface.getDownloadManager().getDownloads()) {
            String string3;
            if (!this.subscriptionExists(download, subscriptionImpl) || (string3 = download.getAttribute(this.ta_category)) != null && !string3.equals(string)) continue;
            download.setAttribute(this.ta_category, string2);
        }
    }

    public int getMaxNonDeletedResults() {
        return COConfigurationManager.getIntParameter(CONFIG_MAX_RESULTS);
    }

    public void setMaxNonDeletedResults(int n) {
        if (n != this.getMaxNonDeletedResults()) {
            COConfigurationManager.setParameter(CONFIG_MAX_RESULTS, n);
        }
    }

    public boolean getAutoStartDownloads() {
        return COConfigurationManager.getBooleanParameter(CONFIG_AUTO_START_DLS);
    }

    public void setAutoStartDownloads(boolean bl) {
        if (bl != this.getAutoStartDownloads()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_DLS, bl);
        }
    }

    public int getAutoStartMinMB() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_START_MIN_MB);
    }

    public void setAutoStartMinMB(int n) {
        if (n != this.getAutoStartMinMB()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_MIN_MB, n);
        }
    }

    public int getAutoStartMaxMB() {
        return COConfigurationManager.getIntParameter(CONFIG_AUTO_START_MAX_MB);
    }

    public void setAutoStartMaxMB(int n) {
        if (n != this.getAutoStartMaxMB()) {
            COConfigurationManager.setParameter(CONFIG_AUTO_START_MAX_MB, n);
        }
    }

    protected boolean shouldAutoStart(Torrent torrent) {
        if (this.getAutoStartDownloads()) {
            long l = (long)(this.getAutoStartMinMB() * 1024) * 1024L;
            long l2 = (long)(this.getAutoStartMaxMB() * 1024) * 1024L;
            if (l <= 0L && l2 <= 0L) {
                return true;
            }
            long l3 = torrent.getSize();
            if (l > 0L && l3 < l) {
                return false;
            }
            return l2 <= 0L || l3 <= l2;
        }
        return false;
    }

    protected void saveResults(SubscriptionImpl subscriptionImpl, SubscriptionResultImpl[] subscriptionResultImplArray) {
        try {
            File file = this.getResultsFile(subscriptionImpl);
            HashMap hashMap = new HashMap();
            ArrayList<Map> arrayList = new ArrayList<Map>(subscriptionResultImplArray.length);
            hashMap.put("results", arrayList);
            for (int i = 0; i < subscriptionResultImplArray.length; ++i) {
                arrayList.add(subscriptionResultImplArray[i].toBEncodedMap());
            }
            FileUtil.writeResilientFile(file, hashMap);
        }
        catch (Throwable throwable) {
            this.log("Failed to save results for '" + subscriptionImpl.getName(), throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfig() {
        if (!FileUtil.resilientConfigFileExists(CONFIG_FILE)) {
            return;
        }
        this.log("Loading configuration");
        boolean bl = false;
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            Map map = FileUtil.readResilientConfigFile(CONFIG_FILE);
            List list = (List)map.get("subs");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    Map map2 = (Map)list.get(i);
                    try {
                        SubscriptionImpl subscriptionImpl = new SubscriptionImpl(this, map2);
                        int n = Collections.binarySearch(this.subscriptions, subscriptionImpl, new Comparator<Subscription>(){

                            @Override
                            public int compare(Subscription subscription, Subscription subscription2) {
                                return subscription.getID().compareTo(subscription2.getID());
                            }
                        });
                        if (n < 0) {
                            n = -1 * n - 1;
                            this.subscriptions.add(n, subscriptionImpl);
                        }
                        if (subscriptionImpl.isMine()) {
                            bl = true;
                        }
                        this.log("    loaded " + subscriptionImpl.getString());
                        continue;
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to import subscription from " + map2, throwable);
                    }
                }
            }
        }
        if (bl) {
            this.addMetaSearchListener();
        }
    }

    protected void configDirty(SubscriptionImpl subscriptionImpl) {
        this.changeSubscription(subscriptionImpl);
        this.configDirty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configDirty() {
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            if (this.config_dirty) {
                return;
            }
            this.config_dirty = true;
            new DelayedEvent("Subscriptions:save", 5000L, new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    36 var1_1 = this;
                    synchronized (var1_1) {
                        if (!SubscriptionManagerImpl.this.config_dirty) {
                            return;
                        }
                        SubscriptionManagerImpl.this.saveConfig();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveConfig() {
        this.log("Saving configuration");
        SubscriptionManagerImpl subscriptionManagerImpl = this;
        synchronized (subscriptionManagerImpl) {
            this.config_dirty = false;
            if (this.subscriptions.size() == 0) {
                FileUtil.deleteResilientConfigFile(CONFIG_FILE);
            } else {
                HashMap hashMap = new HashMap();
                ArrayList<Map> arrayList = new ArrayList<Map>();
                hashMap.put("subs", arrayList);
                for (SubscriptionImpl subscriptionImpl : this.subscriptions) {
                    try {
                        arrayList.add(subscriptionImpl.toMap());
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to save subscription " + subscriptionImpl.getString(), throwable);
                    }
                }
                FileUtil.writeResilientConfigFile(CONFIG_FILE, hashMap);
            }
        }
    }

    protected synchronized AEDiagnosticsLogger getLogger() {
        if (this.logger == null) {
            this.logger = AEDiagnostics.getLogger(LOGGER_NAME);
        }
        return this.logger;
    }

    public void log(String string, Throwable throwable) {
        AEDiagnosticsLogger aEDiagnosticsLogger = this.getLogger();
        aEDiagnosticsLogger.log(string);
        aEDiagnosticsLogger.log(throwable);
    }

    public void log(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = this.getLogger();
        aEDiagnosticsLogger.log(string);
    }

    public void addListener(SubscriptionManagerListener subscriptionManagerListener) {
        this.listeners.add(subscriptionManagerListener);
    }

    public void removeListener(SubscriptionManagerListener subscriptionManagerListener) {
        this.listeners.remove(subscriptionManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println(LOGGER_NAME);
        try {
            indentWriter.indent();
            Subscription[] subscriptionArray = this.getSubscriptions();
            for (int i = 0; i < subscriptionArray.length; ++i) {
                SubscriptionImpl subscriptionImpl = (SubscriptionImpl)subscriptionArray[i];
                subscriptionImpl.generate(indentWriter);
            }
            Object var6_5 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        try {
            VuzeFile vuzeFile = VuzeFileHandler.getSingleton().create();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("name", "lalalal");
            hashMap.put("url", "http://www.vuze.com/feed/publisher/ALL/1");
            hashMap.put("public", new Long(0L));
            hashMap.put("check_interval_mins", new Long(345L));
            vuzeFile.addComponent(32, hashMap);
            vuzeFile.write(new File("C:\\temp\\srss_2.vuze"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        random_seed = RandomUtils.nextInt(256);
        SP_LAST_ATTEMPTED = new Object();
        SP_CONSEC_FAIL = new Object();
    }

    protected static interface downloadListener {
        public void complete(File var1);

        public void complete(Download var1, File var2);

        public void failed(Throwable var1);

        public Map getRecoveryData();

        public boolean isCancelled();
    }

    static interface subsLookupListener
    extends SubscriptionLookupListener {
        public boolean isCancelled();
    }
}

