/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import org.gudy.azureus2.core3.internat.MessageText;

public class SpeedLimitConfidence
implements Comparable {
    public static final SpeedLimitConfidence NONE = new SpeedLimitConfidence("NONE", 0, -0.1f);
    public static final SpeedLimitConfidence LOW = new SpeedLimitConfidence("LOW", 1, 0.0f);
    public static final SpeedLimitConfidence MED = new SpeedLimitConfidence("MED", 2, 0.5f);
    public static final SpeedLimitConfidence HIGH = new SpeedLimitConfidence("HIGH", 3, 0.8f);
    public static final SpeedLimitConfidence ABSOLUTE = new SpeedLimitConfidence("ABSOLUTE", 4, 1.0f);
    private final String name;
    private final int order;
    private final float estimateType;
    private static final String MESSAGE_BUNDLE_PREFIX = "SpeedTestWizard.name.conf.level.";

    private SpeedLimitConfidence(String string, int n, float f) {
        this.name = string;
        this.order = n;
        this.estimateType = f;
    }

    public static SpeedLimitConfidence convertType(float f) {
        if (f <= SpeedLimitConfidence.NONE.estimateType) {
            return NONE;
        }
        if (f <= SpeedLimitConfidence.LOW.estimateType) {
            return LOW;
        }
        if (f <= SpeedLimitConfidence.MED.estimateType) {
            return MED;
        }
        if (f <= SpeedLimitConfidence.HIGH.estimateType) {
            return HIGH;
        }
        return ABSOLUTE;
    }

    public static SpeedLimitConfidence parseString(String string) {
        SpeedLimitConfidence speedLimitConfidence = NONE;
        if (string == null) {
            return speedLimitConfidence;
        }
        if ("NONE".equalsIgnoreCase(string)) {
            return NONE;
        }
        if ("LOW".equalsIgnoreCase(string)) {
            return LOW;
        }
        if ("MED".equalsIgnoreCase(string)) {
            return MED;
        }
        if ("HIGH".equalsIgnoreCase(string)) {
            return HIGH;
        }
        if ("ABSOLUTE".equalsIgnoreCase(string)) {
            return ABSOLUTE;
        }
        return speedLimitConfidence;
    }

    public float asEstimateType() {
        return this.estimateType;
    }

    public static String asEstimateTypeString(float f) {
        if (f == -0.1f) {
            return "Unknown";
        }
        if (f == 0.0f) {
            return "Estimate";
        }
        if (f == 1.0f) {
            return "Fixed";
        }
        return "";
    }

    public String getString() {
        return this.name;
    }

    public String getInternationalizedString() {
        return MessageText.getString(MESSAGE_BUNDLE_PREFIX + this.name.toLowerCase());
    }

    public boolean isGreater(SpeedLimitConfidence speedLimitConfidence) {
        return this.compareTo(speedLimitConfidence) > 0;
    }

    public int compareTo(SpeedLimitConfidence speedLimitConfidence) {
        return this.order - speedLimitConfidence.order;
    }

    public int compareTo(Object object) {
        if (!(object instanceof SpeedLimitConfidence)) {
            throw new ClassCastException("Only comparable to SpeedLimitConfidence class.");
        }
        SpeedLimitConfidence speedLimitConfidence = (SpeedLimitConfidence)object;
        return this.compareTo(speedLimitConfidence);
    }
}

