/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMConfigurationAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedLimitConfidence;
import org.gudy.azureus2.core3.config.COConfigurationManager;

public class SMConfigurationAdapterImpl
implements SMConfigurationAdapter {
    public SpeedManagerLimitEstimate getUploadLimit() {
        int n = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.upload.max.limit");
        SpeedLimitConfidence speedLimitConfidence = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter("SpeedLimitMonitor.setting.upload.limit.conf"));
        return new SMConfigLimitEstimate(n, speedLimitConfidence);
    }

    public SpeedManagerLimitEstimate getDownloadLimit() {
        int n = COConfigurationManager.getIntParameter("SpeedManagerAlgorithmProviderV2.setting.download.max.limit");
        SpeedLimitConfidence speedLimitConfidence = SpeedLimitConfidence.parseString(COConfigurationManager.getStringParameter("SpeedLimitMonitor.setting.download.limit.conf"));
        return new SMConfigLimitEstimate(n, speedLimitConfidence);
    }

    public void setUploadLimit(SpeedManagerLimitEstimate speedManagerLimitEstimate) {
    }

    public void setDownloadLimit(SpeedManagerLimitEstimate speedManagerLimitEstimate) {
    }

    static class SMConfigLimitEstimate
    implements SpeedManagerLimitEstimate {
        final int bytesPerSec;
        final float limitEstimateType;

        public SMConfigLimitEstimate(int n, SpeedLimitConfidence speedLimitConfidence) {
            this.bytesPerSec = n;
            this.limitEstimateType = speedLimitConfidence.asEstimateType();
        }

        public int getBytesPerSec() {
            return this.bytesPerSec;
        }

        public float getEstimateType() {
            return this.limitEstimateType;
        }

        public float getMetricRating() {
            return 0.0f;
        }

        public int[][] getSegments() {
            return new int[0][];
        }

        public long getWhen() {
            return 0L;
        }

        public String getString() {
            StringBuffer stringBuffer = new StringBuffer("estiamte: ");
            stringBuffer.append(this.bytesPerSec);
            stringBuffer.append(" (").append(this.limitEstimateType).append(") ");
            return stringBuffer.toString();
        }
    }
}

