/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import com.aelitis.azureus.core.speedmanager.impl.SpeedManagerAlgorithmProviderAdapter;
import com.aelitis.azureus.core.speedmanager.impl.v2.PSMonitorListener;
import com.aelitis.azureus.core.speedmanager.impl.v2.SMInstance;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.speedmanager.impl.v2.TransferMode;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.SystemTime;

public class PingSpaceMon {
    private static final long INTERVAL = 900000L;
    long nextCheck = System.currentTimeMillis() + 900000L;
    TransferMode mode;
    List listeners = new ArrayList();

    public void addListener(PSMonitorListener pSMonitorListener) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            PSMonitorListener pSMonitorListener2 = (PSMonitorListener)this.listeners.get(i);
            if (pSMonitorListener2 != pSMonitorListener) continue;
            SpeedManagerLogger.trace("Not logging same listener twice. listener=" + pSMonitorListener.toString());
            return;
        }
        this.listeners.add(pSMonitorListener);
    }

    public boolean removeListener(PSMonitorListener pSMonitorListener) {
        return this.listeners.remove(pSMonitorListener);
    }

    boolean checkForLowerLimits() {
        long l = SystemTime.getCurrentTime();
        if (l > this.nextCheck) {
            SpeedManagerLogger.trace("PingSpaceMon checking for lower limits.");
            for (int i = 0; i < this.listeners.size(); ++i) {
                PSMonitorListener pSMonitorListener = (PSMonitorListener)this.listeners.get(i);
                if (pSMonitorListener != null) {
                    pSMonitorListener.notifyUpload(PingSpaceMon.getUploadEstCapacity());
                    continue;
                }
                SpeedManagerLogger.trace("listener index _" + i + "_ was null.");
            }
            this.resetTimer();
            return true;
        }
        return false;
    }

    boolean updateStatus(TransferMode transferMode) {
        if (this.mode == null) {
            this.mode = transferMode;
            return true;
        }
        if (this.mode.getMode() != transferMode.getMode()) {
            this.mode = transferMode;
            this.resetTimer();
            return true;
        }
        return this.checkForLowerLimits();
    }

    void resetTimer() {
        long l = SystemTime.getCurrentTime();
        this.nextCheck = l + 900000L;
        SpeedManagerLogger.trace("Monitor resetting time. Next check in interval.");
    }

    public static SpeedManagerLimitEstimate getUploadLimit(boolean bl) {
        try {
            SMInstance sMInstance = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
            SpeedManagerPingMapper speedManagerPingMapper = speedManagerAlgorithmProviderAdapter.getPingMapper();
            SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManagerPingMapper.getEstimatedUploadLimit(true);
            return speedManagerLimitEstimate;
        }
        catch (Throwable throwable) {
            SpeedManagerLogger.log(throwable.toString());
            throwable.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    public static SpeedManagerLimitEstimate getUploadEstCapacity() {
        try {
            SMInstance sMInstance = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
            SpeedManager speedManager = speedManagerAlgorithmProviderAdapter.getSpeedManager();
            SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManager.getEstimatedUploadCapacityBytesPerSec();
            return speedManagerLimitEstimate;
        }
        catch (Throwable throwable) {
            SpeedManagerLogger.log(throwable.toString());
            throwable.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    public static SpeedManagerLimitEstimate getDownloadLimit() {
        try {
            SMInstance sMInstance = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
            SpeedManagerPingMapper speedManagerPingMapper = speedManagerAlgorithmProviderAdapter.getPingMapper();
            SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManagerPingMapper.getEstimatedDownloadLimit(true);
            return speedManagerLimitEstimate;
        }
        catch (Throwable throwable) {
            SpeedManagerLogger.log(throwable.toString());
            throwable.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    public static SpeedManagerLimitEstimate getDownloadEstCapacity() {
        try {
            SMInstance sMInstance = SMInstance.getInstance();
            SpeedManagerAlgorithmProviderAdapter speedManagerAlgorithmProviderAdapter = sMInstance.getAdapter();
            SpeedManager speedManager = speedManagerAlgorithmProviderAdapter.getSpeedManager();
            SpeedManagerLimitEstimate speedManagerLimitEstimate = speedManager.getEstimatedDownloadCapacityBytesPerSec();
            return speedManagerLimitEstimate;
        }
        catch (Throwable throwable) {
            SpeedManagerLogger.log(throwable.toString());
            throwable.printStackTrace();
            return new DefaultLimitEstimate();
        }
    }

    static class DefaultLimitEstimate
    implements SpeedManagerLimitEstimate {
        DefaultLimitEstimate() {
        }

        public int getBytesPerSec() {
            return 1;
        }

        public float getEstimateType() {
            return -1.0f;
        }

        public float getMetricRating() {
            return -1.0f;
        }

        public int[][] getSegments() {
            return new int[0][];
        }

        public long getWhen() {
            return 0L;
        }

        public String getString() {
            return "default";
        }
    }
}

