/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

public class PingSpaceMapper {
    GridRegion[][] gridRegion;
    int lastDownloadBitsPerSec;
    int lastUploadBitsPerSec;
    int goodPingInMilliSec;
    int badPingInMilliSec;
    int totalPointsInMap = 0;
    private static final int maxMeshIndex = 70;
    public static final int RESULT_UPLOAD_INDEX = 0;
    public static final int RESULT_DOWNLOAD_INDEX = 1;
    static final int GOOD_PING_INDEX = 0;
    static final int ANY_PING_INDEX = 1;

    public PingSpaceMapper(int n, int n2) {
        this.createNewGrid();
        this.goodPingInMilliSec = n;
        this.badPingInMilliSec = n2;
    }

    private void createNewGrid() {
        this.gridRegion = null;
        this.gridRegion = new GridRegion[70][70];
        for (int i = 0; i < 70; ++i) {
            for (int j = 0; j < 70; ++j) {
                this.gridRegion[i][j] = new GridRegion();
            }
        }
    }

    private int convertBitsPerSec2meshIndex(int n) {
        if (n < 0) {
            return 0;
        }
        int n2 = n / 1024;
        if (n2 < 100) {
            return n2 / 10;
        }
        if (n2 < 500) {
            return 10 + (n2 - 100) / 50;
        }
        if (n2 < 5000) {
            return 18 + (n2 - 500) / 100;
        }
        return 63;
    }

    private int convertMeshIndex2bitsPerSec(int n) {
        int n2 = 0;
        if (n <= 0) {
            return 0;
        }
        n2 = n <= 10 ? n * 10 : (n <= 18 ? 100 + (n - 10) * 50 : 500 + (n - 18) * 100);
        return n2 * 1024;
    }

    public void setCurrentTransferRates(int n, int n2) {
        this.lastDownloadBitsPerSec = n;
        this.lastUploadBitsPerSec = n2;
    }

    public void addMetricToMap(int n) {
        int n2 = this.convertBitsPerSec2meshIndex(this.lastDownloadBitsPerSec);
        int n3 = this.convertBitsPerSec2meshIndex(this.lastUploadBitsPerSec);
        ++this.totalPointsInMap;
        if (n < this.goodPingInMilliSec) {
            this.gridRegion[n3][n2].incrementMetricCount(0);
        } else if (n < this.badPingInMilliSec) {
            this.gridRegion[n3][n2].incrementMetricCount(1);
        } else {
            this.gridRegion[n3][n2].incrementMetricCount(2);
        }
    }

    public void reset() {
        this.totalPointsInMap = 0;
        this.createNewGrid();
    }

    private Result getHighestMeshIndexWithGoodPing() {
        Result[] resultArray = this.calculate();
        return resultArray[0];
    }

    private Result getHighestMeshIndexWithAnyPing() {
        Result[] resultArray = this.calculate();
        return resultArray[1];
    }

    public boolean hadChockingPing(boolean bl) {
        int n;
        int n2;
        Result[] resultArray = this.calculate();
        if (bl) {
            n2 = resultArray[0].getDownloadIndex();
            n = resultArray[1].getDownloadIndex();
        } else {
            n2 = resultArray[0].getUploadIndex();
            n = resultArray[1].getUploadIndex();
        }
        return n > n2;
    }

    private Result[] calculate() {
        Result[] resultArray = new Result[]{new Result(), new Result()};
        for (int i = 0; i < 70; ++i) {
            for (int j = 0; j < 70; ++j) {
                int n;
                float f = this.gridRegion[i][j].getRating();
                if (f > 0.0f) {
                    resultArray[0].checkAndUpdate(i, j);
                }
                if ((n = this.gridRegion[i][j].getTotal()) <= 0) continue;
                resultArray[1].checkAndUpdate(i, j);
            }
        }
        return resultArray;
    }

    public int guessUploadLimit() {
        Result result = this.getHighestMeshIndexWithGoodPing();
        int n = result.getUploadIndex();
        return this.convertMeshIndex2bitsPerSec(n);
    }

    public int guessDownloadLimit() {
        Result result = this.getHighestMeshIndexWithGoodPing();
        int n = result.getDownloadIndex();
        return this.convertMeshIndex2bitsPerSec(n);
    }

    static class GridRegion {
        public static final int INDEX_PING_GOOD = 0;
        public static final int INDEX_PING_NEUTRAL = 1;
        public static final int INDEX_PING_BAD = 2;
        int[] pingCount = new int[3];
        int[] uploadBound = new int[2];
        int[] downloadBound = new int[2];

        GridRegion() {
        }

        public void incrementMetricCount(int n) {
            if (n >= 0 && n <= 3) {
                int n2 = n;
                this.pingCount[n2] = this.pingCount[n2] + 1;
            }
        }

        public float getRating() {
            int n = this.getTotal();
            if (n == 0) {
                return 0.0f;
            }
            float f = (float)this.pingCount[0] + 0.3f * (float)this.pingCount[1] - (float)this.pingCount[2];
            return f / (float)n;
        }

        public int getTotal() {
            return this.pingCount[0] + this.pingCount[1] + this.pingCount[2];
        }
    }

    static class Result {
        int highestUploadIndex = 0;
        int highestDownloadIndex = 0;

        Result() {
        }

        public void checkAndUpdate(int n, int n2) {
            if (n > this.highestUploadIndex) {
                this.highestUploadIndex = n;
            }
            if (n2 > this.highestDownloadIndex) {
                this.highestDownloadIndex = n2;
            }
        }

        public int getUploadIndex() {
            return this.highestUploadIndex;
        }

        public int getDownloadIndex() {
            return this.highestDownloadIndex;
        }
    }
}

