/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.speedmanager.impl.v2;

import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import com.aelitis.azureus.core.speedmanager.impl.v2.PingSourceStats;
import com.aelitis.azureus.core.speedmanager.impl.v2.SpeedManagerLogger;
import com.aelitis.azureus.core.util.average.Average;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;

public class PingSourceManager {
    private final Map pingAverages = new HashMap();
    private long lastPingRemoval = 0L;
    private static final long TIME_BETWEEN_BAD_PING_REMOVALS = 120000L;
    private static final long TIME_BETWEEN_SLOW_PING_REMOVALS = 300000L;
    private static final long TIME_BETWEEN_FORCED_CYCLE_REMOVALS = 1800000L;

    public void checkPingSources(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        if (speedManagerPingSourceArray == null) {
            return;
        }
        if (speedManagerPingSourceArray.length < 3) {
            return;
        }
        if (this.checkForBadPing(speedManagerPingSourceArray)) {
            return;
        }
        if (this.checkForSlowSource(speedManagerPingSourceArray)) {
            return;
        }
        this.forcePingSourceChange(speedManagerPingSourceArray);
    }

    private boolean forcePingSourceChange(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        long l = SystemTime.getCurrentTime();
        if (l < this.lastPingRemoval + 1800000L) {
            return false;
        }
        if (speedManagerPingSourceArray.length < 3) {
            return false;
        }
        SpeedManagerPingSource speedManagerPingSource = null;
        double d = 0.0;
        double d2 = 10000.0;
        int n = speedManagerPingSourceArray.length;
        for (int i = 0; i < n; ++i) {
            PingSourceStats pingSourceStats = (PingSourceStats)this.pingAverages.get(speedManagerPingSourceArray[i]);
            Average average = pingSourceStats.getHistory();
            double d3 = average.getAverage();
            if (d3 > d) {
                d = d3;
                speedManagerPingSource = speedManagerPingSourceArray[i];
            }
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        this.resetTimer();
        if (d > 2.0 * d2 && speedManagerPingSource != null) {
            speedManagerPingSource.destroy();
            return true;
        }
        return false;
    }

    private boolean checkForSlowSource(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        long l = SystemTime.getCurrentTime();
        if (l < this.lastPingRemoval + 300000L) {
            return false;
        }
        SpeedManagerPingSource speedManagerPingSource = null;
        if (speedManagerPingSourceArray.length < 3) {
            return false;
        }
        double d = 10000.0;
        double d2 = 10000.0;
        double d3 = 0.0;
        int n = speedManagerPingSourceArray.length;
        for (int i = 0; i < n; ++i) {
            PingSourceStats pingSourceStats = (PingSourceStats)this.pingAverages.get(speedManagerPingSourceArray[i]);
            Average average = pingSourceStats.getHistory();
            double d4 = average.getAverage();
            if (d4 < d) {
                d2 = d;
                d = d4;
            } else if (d4 < d2) {
                d2 = d4;
            }
            if (!(d4 > d3)) continue;
            d3 = d4;
            speedManagerPingSource = speedManagerPingSourceArray[i];
            this.resetTimer();
        }
        double d5 = d + d2;
        boolean bl = false;
        if (d5 * 2.0 < d3 && speedManagerPingSource != null) {
            speedManagerPingSource.destroy();
            SpeedManagerLogger.log("dropping ping source: " + speedManagerPingSource.getAddress() + " for being 2x slower then two fastest.");
            bl = true;
            this.resetTimer();
        }
        return bl;
    }

    private boolean checkForBadPing(SpeedManagerPingSource[] speedManagerPingSourceArray) {
        int n;
        long l = SystemTime.getCurrentTime();
        if (l < this.lastPingRemoval + 120000L) {
            return false;
        }
        double d = 0.0;
        SpeedManagerPingSource speedManagerPingSource = null;
        double d2 = 10000.0;
        int n2 = speedManagerPingSourceArray.length;
        for (n = 0; n < n2; ++n) {
            PingSourceStats pingSourceStats = (PingSourceStats)this.pingAverages.get(speedManagerPingSourceArray[n]);
            if (pingSourceStats == null) continue;
            Average average = pingSourceStats.getLongTermAve();
            double d3 = average.getAverage();
            if (d3 > d) {
                d = d3;
                speedManagerPingSource = speedManagerPingSourceArray[n];
            }
            if (!(d3 < d2)) continue;
            d2 = d3;
        }
        n = 0;
        if (d2 * 8.0 < d && speedManagerPingSource != null) {
            SpeedManagerLogger.log("dropping ping source: " + speedManagerPingSource.getAddress() + " for being 8x greater then min source.");
            speedManagerPingSource.destroy();
            n = 1;
            this.resetTimer();
        }
        return n != 0;
    }

    public void pingSourceFound(SpeedManagerPingSource speedManagerPingSource, boolean bl) {
        PingSourceStats pingSourceStats = new PingSourceStats(speedManagerPingSource);
        this.pingAverages.put(speedManagerPingSource, pingSourceStats);
    }

    public void pingSourceFailed(SpeedManagerPingSource speedManagerPingSource) {
        if (this.pingAverages.remove(speedManagerPingSource) == null) {
            SpeedManagerLogger.log("didn't find source: " + speedManagerPingSource.getAddress().getHostName());
        }
    }

    public void addPingTime(SpeedManagerPingSource speedManagerPingSource) {
        int n;
        if (speedManagerPingSource == null) {
            return;
        }
        PingSourceStats pingSourceStats = (PingSourceStats)this.pingAverages.get(speedManagerPingSource);
        if (pingSourceStats == null) {
            this.pingSourceFound(speedManagerPingSource, false);
            pingSourceStats = (PingSourceStats)this.pingAverages.get(speedManagerPingSource);
            SpeedManagerLogger.trace("added new source from addPingTime.");
        }
        if ((n = speedManagerPingSource.getPingTime()) > 0) {
            pingSourceStats.addPingTime(speedManagerPingSource.getPingTime());
        }
    }

    private void resetTimer() {
        this.lastPingRemoval = SystemTime.getCurrentTime();
    }
}

