/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.uploadslots;

import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;

public class UploadSession {
    protected static final int TYPE_DOWNLOAD = 0;
    protected static final int TYPE_SEED = 1;
    private final PEPeer peer;
    private final int session_type;

    protected UploadSession(PEPeer pEPeer, int n) {
        this.peer = pEPeer;
        this.session_type = n;
    }

    protected int getSessionType() {
        return this.session_type;
    }

    protected void start() {
        UnchokerUtil.performChokeUnchoke(null, this.peer);
    }

    protected void stop() {
        UnchokerUtil.performChokeUnchoke(this.peer, null);
    }

    protected boolean isSameSession(UploadSession uploadSession) {
        if (uploadSession == null) {
            return false;
        }
        return this.peer == uploadSession.peer;
    }

    protected String getStatsTrace() {
        String string = this.peer.getManager().getDisplayName();
        String string2 = this.session_type == 0 ? "DOWNLOADING" : "SEEDING";
        String string3 = " : [" + this.peer.getClient() + "] " + this.peer.getIp() + " :" + this.peer.getPort();
        String string4 = " || (D: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.peer.getStats().getDataReceiveRate()) + ") (U: " + DisplayFormatters.formatByteCountToKiBEtcPerSec(this.peer.getStats().getDataSendRate()) + ")";
        return "[" + string + "] " + string2 + string3 + string4;
    }
}

