/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.unchoker;

import com.aelitis.azureus.core.peermanager.unchoker.Unchoker;
import com.aelitis.azureus.core.peermanager.unchoker.UnchokerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.gudy.azureus2.core3.peer.PEPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeedingUnchoker
implements Unchoker {
    private ArrayList<PEPeer> chokes = new ArrayList();
    private ArrayList<PEPeer> unchokes = new ArrayList();

    protected SeedingUnchoker() {
    }

    @Override
    public boolean isSeedingUnchoker() {
        return true;
    }

    @Override
    public ArrayList<PEPeer> getImmediateUnchokes(int n, ArrayList<PEPeer> arrayList) {
        ArrayList<PEPeer> arrayList2;
        int n2;
        int n3 = arrayList.size();
        if (n > n3) {
            n = n3;
        }
        int n4 = 0;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            arrayList2 = arrayList.get(n2);
            if (arrayList2.isChokedByMe()) continue;
            ++n4;
        }
        n2 = n - n4;
        if (n2 > 0) {
            arrayList2 = UnchokerUtil.getNextOptimisticPeers(arrayList, false, false, n2);
            if (arrayList2 == null) {
                return new ArrayList<PEPeer>(0);
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                ((PEPeer)arrayList2.get(i)).setOptimisticUnchoke(true);
            }
            return arrayList2;
        }
        return new ArrayList<PEPeer>(0);
    }

    @Override
    public void calculateUnchokes(int n, ArrayList<PEPeer> arrayList, boolean bl, boolean bl2) {
        Object object;
        int n2 = (n - 1) / 5 + 1;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = arrayList.get(i);
            if (object.isChokedByMe()) continue;
            if (UnchokerUtil.isUnchokable((PEPeer)object, false)) {
                this.unchokes.add((PEPeer)object);
                continue;
            }
            this.chokes.add((PEPeer)object);
        }
        while (this.unchokes.size() > n) {
            this.chokes.add(this.unchokes.remove(this.unchokes.size() - 1));
        }
        if (bl) {
            Object object2;
            Object object3;
            ArrayList arrayList2 = new ArrayList();
            object = new ArrayList();
            long[] lArray = new long[this.unchokes.size()];
            long[] lArray2 = new long[lArray.length];
            for (int i = 0; i < this.unchokes.size(); ++i) {
                object3 = this.unchokes.get(i);
                long l = object3.getStats().getDataSendRate();
                if (l <= 256L) continue;
                UnchokerUtil.updateLargestValueFirstSort(l, lArray, (PEPeer)object3, arrayList2, 0);
                UnchokerUtil.updateLargestValueFirstSort(object3.getStats().getTotalDataBytesSent(), lArray2, (PEPeer)object3, (ArrayList)object, 0);
            }
            Collections.reverse(arrayList2);
            ArrayList arrayList3 = new ArrayList();
            object3 = new long[arrayList2.size()];
            Arrays.fill((long[])object3, Long.MIN_VALUE);
            for (int i = 0; i < this.unchokes.size(); ++i) {
                object2 = this.unchokes.get(i);
                long l = arrayList2.indexOf(object2);
                long l2 = ((ArrayList)object).indexOf(object2);
                if (l == -1L) continue;
                long l3 = l + l2;
                UnchokerUtil.updateLargestValueFirstSort(l3, (long[])object3, (PEPeer)object2, arrayList3, 0);
            }
            while (arrayList3.size() > n - n2) {
                arrayList3.remove(arrayList3.size() - 1);
            }
            ArrayList<PEPeer> arrayList4 = new ArrayList<PEPeer>();
            object2 = this.unchokes.iterator();
            while (object2.hasNext()) {
                PEPeer pEPeer;
                PEPeer pEPeer2 = (PEPeer)object2.next();
                pEPeer2.setOptimisticUnchoke(false);
                if (arrayList3.contains(pEPeer2) || (pEPeer = UnchokerUtil.getNextOptimisticPeer(arrayList, false, false)) == null) continue;
                this.chokes.add(pEPeer2);
                object2.remove();
                arrayList4.add(pEPeer);
                pEPeer.setOptimisticUnchoke(true);
            }
            for (int i = 0; i < arrayList4.size(); ++i) {
                this.unchokes.add((PEPeer)arrayList4.get(i));
            }
        }
        if (bl2) {
            this.setBuddyUnchokes(n - n2, arrayList);
        }
    }

    private void setBuddyUnchokes(int n, ArrayList<PEPeer> arrayList) {
        int n2;
        int n3;
        if (this.unchokes.isEmpty()) {
            return;
        }
        ArrayList<PEPeer> arrayList2 = new ArrayList<PEPeer>();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            PEPeer pEPeer = arrayList.get(n3);
            if (!pEPeer.isPriorityConnection() || !UnchokerUtil.isUnchokable(pEPeer, true)) continue;
            arrayList2.add(pEPeer);
        }
        Collections.shuffle(arrayList2);
        int n4 = n2 = n > this.unchokes.size() ? this.unchokes.size() : n;
        for (n3 = 0; n3 < n2 && !arrayList2.isEmpty(); ++n3) {
            PEPeer pEPeer = this.unchokes.remove(0);
            if (arrayList2.remove(pEPeer)) {
                this.unchokes.add(pEPeer);
                continue;
            }
            PEPeer pEPeer2 = (PEPeer)arrayList2.remove(arrayList2.size() - 1);
            this.chokes.remove(pEPeer2);
            this.unchokes.add(pEPeer2);
        }
    }

    @Override
    public ArrayList<PEPeer> getChokes() {
        ArrayList<PEPeer> arrayList = this.chokes;
        this.chokes = new ArrayList();
        return arrayList;
    }

    @Override
    public ArrayList<PEPeer> getUnchokes() {
        ArrayList<PEPeer> arrayList = this.unchokes;
        this.unchokes = new ArrayList();
        return arrayList;
    }
}

