/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTMessageDecoder
implements MessageStreamDecoder {
    private static final int MIN_MESSAGE_LENGTH = 1;
    private static final int MAX_MESSAGE_LENGTH = 16512;
    private static final int HANDSHAKE_FAKE_LENGTH = 323119476;
    private static final byte SS = 11;
    private DirectByteBuffer payload_buffer = null;
    private final DirectByteBuffer length_buffer = DirectByteBufferPool.getBuffer((byte)12, 4);
    private final ByteBuffer[] decode_array = new ByteBuffer[]{null, this.length_buffer.getBuffer((byte)11)};
    private boolean reading_length_mode = true;
    private boolean reading_handshake_message = false;
    private int message_length;
    private int pre_read_start_buffer;
    private int pre_read_start_position;
    private boolean last_received_was_keepalive = false;
    private volatile boolean destroyed = false;
    private volatile boolean is_paused = false;
    private ArrayList messages_last_read = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private int percent_complete = -1;

    public int performStreamDecode(Transport transport, int n) throws IOException {
        int n2;
        int n3;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (n2 = n; n2 > 0 && !this.destroyed && !this.is_paused; n2 -= n3) {
            int n4 = this.preReadProcess(n2);
            if (n4 < 1) {
                Debug.out("ERROR BT: bytes_possible < 1");
                break;
            }
            if (this.reading_length_mode) {
                transport.read(this.decode_array, 1, 1);
            } else {
                transport.read(this.decode_array, 0, 2);
            }
            n3 = this.postReadProcess();
            if (n3 < n4) break;
            if (!this.reading_length_mode || !this.last_received_was_keepalive) continue;
            this.last_received_was_keepalive = false;
            break;
        }
        return n - n2;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages_last_read.isEmpty()) {
            return null;
        }
        Message[] messageArray = this.messages_last_read.toArray(new Message[this.messages_last_read.size()]);
        this.messages_last_read.clear();
        return messageArray;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public ByteBuffer destroy() {
        if (this.destroyed) {
            Debug.out("Trying to redestroy message decoder, stack trace follows: " + this);
            Debug.outStackTrace();
        }
        this.is_paused = true;
        this.destroyed = true;
        int n = 0;
        int n2 = 0;
        this.length_buffer.limit((byte)11, 4);
        if (this.reading_length_mode) {
            n = this.length_buffer.position((byte)11);
        } else {
            this.length_buffer.position((byte)11, 4);
            n = 4;
            n2 = this.payload_buffer == null ? 0 : this.payload_buffer.position((byte)11);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n + n2);
        this.length_buffer.flip((byte)11);
        byteBuffer.put(this.length_buffer.getBuffer((byte)11));
        if (this.payload_buffer != null) {
            this.payload_buffer.flip((byte)11);
            byteBuffer.put(this.payload_buffer.getBuffer((byte)11));
        }
        byteBuffer.flip();
        this.length_buffer.returnToPool();
        if (this.payload_buffer != null) {
            this.payload_buffer.returnToPool();
            this.payload_buffer = null;
        }
        for (int i = 0; i < this.messages_last_read.size(); ++i) {
            Message message = (Message)this.messages_last_read.get(i);
            message.destroy();
        }
        this.messages_last_read.clear();
        return byteBuffer;
    }

    private int preReadProcess(int n) {
        if (n < 1) {
            Debug.out("allowed < 1");
        }
        this.decode_array[0] = this.payload_buffer == null ? null : this.payload_buffer.getBuffer((byte)11);
        int n2 = 0;
        boolean bl = false;
        int n3 = this.reading_length_mode ? 1 : 0;
        boolean bl2 = false;
        for (int i = n3; i < 2; ++i) {
            ByteBuffer byteBuffer = this.decode_array[i];
            if (byteBuffer == null) {
                Debug.out("preReadProcess:: bb[" + i + "] == null, decoder destroyed=" + this.destroyed);
            }
            if (bl) {
                byteBuffer.limit(0);
                continue;
            }
            int n4 = byteBuffer.remaining();
            if (n4 < 1) continue;
            if (!bl2) {
                this.pre_read_start_buffer = i;
                this.pre_read_start_position = byteBuffer.position();
                bl2 = true;
            }
            if (n4 > n) {
                byteBuffer.limit(byteBuffer.position() + n);
                n2 += byteBuffer.remaining();
                bl = true;
                continue;
            }
            n2 += n4;
            n -= n4;
        }
        return n2;
    }

    private int postReadProcess() throws IOException {
        int n = 0;
        int n2 = 0;
        if (!this.reading_length_mode && !this.destroyed) {
            this.payload_buffer.limit((byte)11, this.message_length);
            this.length_buffer.limit((byte)11, 4);
            int n3 = this.payload_buffer.position((byte)11) - this.pre_read_start_position;
            if (this.payload_buffer.position((byte)11) > 0) {
                if (BTMessageFactory.getMessageType(this.payload_buffer) == 1) {
                    n2 += n3;
                } else {
                    n += n3;
                }
            }
            if (!this.payload_buffer.hasRemaining((byte)11) && !this.is_paused) {
                this.payload_buffer.position((byte)11, 0);
                DirectByteBuffer directByteBuffer = this.payload_buffer;
                this.payload_buffer = null;
                if (this.reading_handshake_message) {
                    this.reading_handshake_message = false;
                    DirectByteBuffer directByteBuffer2 = DirectByteBufferPool.getBuffer((byte)16, 68);
                    directByteBuffer2.putInt((byte)11, 323119476);
                    directByteBuffer2.put((byte)11, directByteBuffer);
                    directByteBuffer2.flip((byte)11);
                    directByteBuffer.returnToPool();
                    try {
                        Message message = MessageManager.getSingleton().createMessage(BTMessage.ID_BT_HANDSHAKE_BYTES, directByteBuffer2, (byte)1);
                        this.messages_last_read.add(message);
                    }
                    catch (MessageException messageException) {
                        directByteBuffer2.returnToPool();
                        throw new IOException("BT message decode failed: " + messageException.getMessage());
                    }
                    this.pauseDecoding();
                } else {
                    try {
                        this.messages_last_read.add(this.createMessage(directByteBuffer));
                    }
                    catch (Throwable throwable) {
                        directByteBuffer.returnToPoolIfNotFree();
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        throw new IOException("BT message decode failed: " + throwable.getMessage());
                    }
                }
                this.reading_length_mode = true;
                this.percent_complete = -1;
            } else {
                this.percent_complete = this.payload_buffer.position((byte)11) * 100 / this.message_length;
            }
        }
        if (this.reading_length_mode && !this.destroyed) {
            this.length_buffer.limit((byte)11, 4);
            n += this.pre_read_start_buffer == 1 ? this.length_buffer.position((byte)11) - this.pre_read_start_position : this.length_buffer.position((byte)11);
            if (!this.length_buffer.hasRemaining((byte)11)) {
                this.reading_length_mode = false;
                this.length_buffer.position((byte)11, 0);
                this.message_length = this.length_buffer.getInt((byte)11);
                this.length_buffer.position((byte)11, 0);
                if (this.message_length == 323119476) {
                    this.reading_handshake_message = true;
                    this.message_length = 64;
                    this.payload_buffer = DirectByteBufferPool.getBuffer((byte)16, this.message_length);
                } else if (this.message_length == 0) {
                    this.reading_length_mode = true;
                    this.last_received_was_keepalive = true;
                    try {
                        Message message = MessageManager.getSingleton().createMessage(BTMessage.ID_BT_KEEP_ALIVE_BYTES, null, (byte)1);
                        this.messages_last_read.add(message);
                    }
                    catch (MessageException messageException) {
                        throw new IOException("BT message decode failed: " + messageException.getMessage());
                    }
                } else {
                    if (this.message_length < 1 || this.message_length > 16512) {
                        throw new IOException("Invalid message length given for BT message decode: " + this.message_length);
                    }
                    this.payload_buffer = DirectByteBufferPool.getBuffer((byte)23, this.message_length);
                }
            }
        }
        this.protocol_bytes_last_read += n;
        this.data_bytes_last_read += n2;
        return n + n2;
    }

    public void pauseDecoding() {
        this.is_paused = true;
    }

    public void resumeDecoding() {
        this.is_paused = false;
    }

    protected Message createMessage(DirectByteBuffer directByteBuffer) throws MessageException {
        return BTMessageFactory.createBTMessage(directByteBuffer);
    }
}

