/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AZMessageDecoder
implements MessageStreamDecoder {
    private static final int MIN_MESSAGE_LENGTH = 6;
    private static final int MAX_MESSAGE_LENGTH = 131072;
    private static final byte SS = 11;
    private DirectByteBuffer payload_buffer = null;
    private final DirectByteBuffer length_buffer = DirectByteBufferPool.getBuffer((byte)12, 4);
    private final ByteBuffer[] decode_array = new ByteBuffer[]{null, this.length_buffer.getBuffer((byte)11)};
    private boolean reading_length_mode = true;
    private int message_length;
    private int pre_read_start_buffer;
    private int pre_read_start_position;
    private volatile boolean destroyed = false;
    private volatile boolean is_paused = false;
    private ArrayList messages_last_read = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private int percent_complete = -1;
    private byte[] msg_id_bytes = null;
    private boolean msg_id_read_complete = false;
    private boolean last_read_made_progress;
    private int maximum_message_size = 131072;

    public void setMaximumMessageSize(int n) {
        this.maximum_message_size = n;
    }

    public int performStreamDecode(Transport transport, int n) throws IOException {
        int n2;
        int n3;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (n2 = n; n2 > 0 && !this.destroyed; n2 -= n3) {
            if (this.is_paused) {
                Debug.out("AZ decoder paused");
                break;
            }
            int n4 = this.preReadProcess(n2);
            if (n4 < 1) {
                Debug.out("ERROR AZ: bytes_possible < 1");
                break;
            }
            long l = this.reading_length_mode ? transport.read(this.decode_array, 1, 1) : transport.read(this.decode_array, 0, 2);
            this.last_read_made_progress = l > 0L;
            n3 = this.postReadProcess();
            if (n3 >= n4) continue;
            break;
        }
        return n - n2;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages_last_read.isEmpty()) {
            return null;
        }
        Message[] messageArray = this.messages_last_read.toArray(new Message[this.messages_last_read.size()]);
        this.messages_last_read.clear();
        return messageArray;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public boolean getLastReadMadeProgress() {
        return this.last_read_made_progress;
    }

    public ByteBuffer destroy() {
        this.is_paused = true;
        this.destroyed = true;
        this.length_buffer.returnToPool();
        if (this.payload_buffer != null) {
            this.payload_buffer.returnToPool();
            this.payload_buffer = null;
        }
        try {
            for (int i = 0; i < this.messages_last_read.size(); ++i) {
                Message message = (Message)this.messages_last_read.get(i);
                message.destroy();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.messages_last_read.clear();
        return null;
    }

    private int preReadProcess(int n) {
        if (n < 1) {
            Debug.out("allowed < 1");
        }
        this.decode_array[0] = this.payload_buffer == null ? null : this.payload_buffer.getBuffer((byte)11);
        int n2 = 0;
        boolean bl = false;
        int n3 = this.reading_length_mode ? 1 : 0;
        boolean bl2 = false;
        for (int i = n3; i < 2; ++i) {
            ByteBuffer byteBuffer = this.decode_array[i];
            if (byteBuffer == null) {
                Debug.out("preReadProcess:: bb[" + i + "] == null, decoder destroyed=" + this.destroyed);
            }
            if (bl) {
                byteBuffer.limit(0);
                continue;
            }
            int n4 = byteBuffer.remaining();
            if (n4 < 1) continue;
            if (!bl2) {
                this.pre_read_start_buffer = i;
                this.pre_read_start_position = byteBuffer.position();
                bl2 = true;
            }
            if (n4 > n) {
                byteBuffer.limit(byteBuffer.position() + n);
                n2 += byteBuffer.remaining();
                bl = true;
                continue;
            }
            n2 += n4;
            n -= n4;
        }
        return n2;
    }

    private int postReadProcess() throws IOException {
        int n = 0;
        int n2 = 0;
        if (!this.reading_length_mode && !this.destroyed) {
            this.payload_buffer.limit((byte)11, this.message_length);
            this.length_buffer.limit((byte)11, 4);
            int n3 = this.payload_buffer.position((byte)11);
            int n4 = n3 - this.pre_read_start_position;
            if (this.msg_id_bytes == null && n3 >= 4) {
                this.payload_buffer.position((byte)11, 0);
                int n5 = this.payload_buffer.getInt((byte)11);
                this.payload_buffer.position((byte)11, n3);
                if (n5 < 1 || n5 > 1024) {
                    throw new IOException("invalid id_size [" + n5 + "]");
                }
                this.msg_id_bytes = new byte[n5];
            }
            if (this.msg_id_bytes != null && n3 >= this.msg_id_bytes.length + 4) {
                Message message;
                if (!this.msg_id_read_complete) {
                    this.payload_buffer.position((byte)11, 4);
                    this.payload_buffer.get((byte)11, this.msg_id_bytes);
                    this.payload_buffer.position((byte)11, n3);
                    this.msg_id_read_complete = true;
                }
                if ((message = MessageManager.getSingleton().lookupMessage(this.msg_id_bytes)) == null) {
                    Debug.out("Unknown message type '" + new String(this.msg_id_bytes) + "'");
                    throw new IOException("Unknown message type");
                }
                if (message.getType() == 1) {
                    n2 += n4;
                } else {
                    n += n4;
                }
            } else {
                n += n4;
            }
            if (!this.payload_buffer.hasRemaining((byte)11) && !this.is_paused) {
                this.payload_buffer.position((byte)11, 0);
                DirectByteBuffer directByteBuffer = this.payload_buffer;
                this.payload_buffer = null;
                try {
                    Message message = AZMessageFactory.createAZMessage(directByteBuffer);
                    this.messages_last_read.add(message);
                }
                catch (Throwable throwable) {
                    directByteBuffer.returnToPoolIfNotFree();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new IOException("AZ message decode failed: " + throwable.getMessage());
                }
                this.reading_length_mode = true;
                this.percent_complete = -1;
                this.msg_id_bytes = null;
                this.msg_id_read_complete = false;
            } else {
                this.percent_complete = this.payload_buffer.position((byte)11) * 100 / this.message_length;
            }
        }
        if (this.reading_length_mode && !this.destroyed) {
            this.length_buffer.limit((byte)11, 4);
            n += this.pre_read_start_buffer == 1 ? this.length_buffer.position((byte)11) - this.pre_read_start_position : this.length_buffer.position((byte)11);
            if (!this.length_buffer.hasRemaining((byte)11)) {
                this.reading_length_mode = false;
                this.length_buffer.position((byte)11, 0);
                this.message_length = this.length_buffer.getInt((byte)11);
                this.length_buffer.position((byte)11, 0);
                if (this.message_length < 6 || this.message_length > this.maximum_message_size) {
                    throw new IOException("Invalid message length given for AZ message decode: " + this.message_length + " (max=" + this.maximum_message_size + ")");
                }
                this.payload_buffer = DirectByteBufferPool.getBuffer((byte)24, this.message_length);
            }
        }
        this.protocol_bytes_last_read += n;
        this.data_bytes_last_read += n2;
        return n + n2;
    }

    public void pauseDecoding() {
        this.is_paused = true;
    }

    public void resumeDecoding() {
        this.is_paused = false;
    }
}

