/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class HTTPMessage
implements Message {
    public static final String MSG_ID = "HTTP_DATA";
    private static final byte[] MSG_ID_BYTES = "HTTP_DATA".getBytes();
    private static final String MSG_DESC = "HTTP data";
    private DirectByteBuffer[] data;

    protected HTTPMessage(String string) {
        this.data = new DirectByteBuffer[]{new DirectByteBuffer(ByteBuffer.wrap(string.getBytes()))};
    }

    protected HTTPMessage(byte[] byArray) {
        this.data = new DirectByteBuffer[]{new DirectByteBuffer(ByteBuffer.wrap(byArray))};
    }

    public String getID() {
        return MSG_ID;
    }

    public byte[] getIDBytes() {
        return MSG_ID_BYTES;
    }

    public String getFeatureID() {
        return null;
    }

    public int getFeatureSubID() {
        return 0;
    }

    public int getType() {
        return 1;
    }

    public byte getVersion() {
        return 1;
    }

    public String getDescription() {
        return MSG_DESC;
    }

    public DirectByteBuffer[] getData() {
        return this.data;
    }

    public Message deserialize(DirectByteBuffer directByteBuffer, byte by) throws MessageException {
        throw new MessageException("not supported");
    }

    protected RawMessage encode(Message message) {
        return new RawMessageImpl(message, this.data, 2, true, new Message[0]);
    }

    public void destroy() {
        this.data[0].returnToPool();
    }
}

