/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;

public class TransportHelperFilterInserter
implements TransportHelperFilter {
    private TransportHelperFilter target_filter;
    private ByteBuffer read_insert;

    public TransportHelperFilterInserter(TransportHelperFilter transportHelperFilter, ByteBuffer byteBuffer) {
        this.target_filter = transportHelperFilter;
        this.read_insert = byteBuffer;
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.target_filter.write(byteBufferArray, n, n2);
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        long l = 0L;
        if (this.read_insert != null) {
            int n3 = this.read_insert.position();
            for (int i = n; i < n + n2; ++i) {
                ByteBuffer byteBuffer = byteBufferArray[i];
                int n4 = byteBuffer.remaining();
                if (n4 <= 0) continue;
                if (n4 < this.read_insert.remaining()) {
                    int n5 = this.read_insert.limit();
                    this.read_insert.limit(this.read_insert.position() + n4);
                    byteBuffer.put(this.read_insert);
                    this.read_insert.limit(n5);
                } else {
                    byteBuffer.put(this.read_insert);
                }
                if (!this.read_insert.hasRemaining()) break;
            }
            l = this.read_insert.position() - n3;
            if (this.read_insert.hasRemaining()) {
                return l;
            }
            this.read_insert = null;
        }
        return l += this.target_filter.read(byteBufferArray, n, n2);
    }

    public boolean hasBufferedWrite() {
        return this.target_filter.hasBufferedWrite();
    }

    public boolean hasBufferedRead() {
        return this.read_insert != null || this.target_filter.hasBufferedRead();
    }

    public TransportHelper getHelper() {
        return this.target_filter.getHelper();
    }

    public void setTrace(boolean bl) {
        this.target_filter.setTrace(bl);
    }

    public boolean isEncrypted() {
        return this.target_filter.isEncrypted();
    }

    public String getName(boolean bl) {
        return this.target_filter.getName(bl);
    }
}

