/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerUploader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerUploader(NetworkConnectionBase networkConnectionBase, RateHandler rateHandler) {
        this.connection = networkConnectionBase;
        this.rate_handler = rateHandler;
    }

    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    public boolean canProcess(EventWaiter eventWaiter) {
        if (!this.connection.getTransportBase().isReadyForWrite(eventWaiter)) {
            return false;
        }
        if (this.connection.getOutgoingMessageQueue().getTotalSize() < 1) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public int doProcessing(EventWaiter eventWaiter, int n) {
        int n2;
        if (!this.connection.getTransportBase().isReadyForWrite(eventWaiter)) {
            return 0;
        }
        int n3 = this.rate_handler.getCurrentNumBytesAllowed();
        if (n3 < 1) {
            return 0;
        }
        if (n > 0 && n < n3) {
            n3 = n;
        }
        if ((n2 = this.connection.getOutgoingMessageQueue().getTotalSize()) < 1) {
            if (!this.connection.getOutgoingMessageQueue().isDestroyed()) {
                // empty if block
            }
            return 0;
        }
        int n4 = n3 > n2 ? n2 : n3;
        int n5 = 0;
        try {
            n5 = this.connection.getOutgoingMessageQueue().deliverToTransport(n4, false);
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof IOException)) {
                Debug.printStackTrace(throwable);
            }
            this.connection.notifyOfException(throwable);
            return 0;
        }
        if (n5 < 1) {
            return 0;
        }
        this.rate_handler.bytesProcessed(n5);
        return n5;
    }

    public int getPriority() {
        return 0;
    }

    public boolean getPriorityBoost() {
        return this.connection.getOutgoingMessageQueue().getPriorityBoost();
    }

    public long getBytesReadyToWrite() {
        return this.connection.getOutgoingMessageQueue().getTotalSize();
    }

    public int getConnectionCount() {
        return 1;
    }

    public int getReadyConnectionCount(EventWaiter eventWaiter) {
        if (this.connection.getTransportBase().isReadyForWrite(eventWaiter)) {
            return 1;
        }
        return 0;
    }

    public String getString() {
        return "SPU: bytes_allowed=" + this.rate_handler.getCurrentNumBytesAllowed() + " " + this.connection.getString();
    }
}

