/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminHTTPTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminTCPTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminUDPTester;
import java.net.InetAddress;

public class NetworkAdminProtocolImpl
implements NetworkAdminProtocol {
    private AzureusCore core;
    private int type;
    private int port;

    protected NetworkAdminProtocolImpl(AzureusCore azureusCore, int n) {
        this.core = azureusCore;
        this.type = n;
        this.port = -1;
    }

    protected NetworkAdminProtocolImpl(AzureusCore azureusCore, int n, int n2) {
        this.core = azureusCore;
        this.type = n;
        this.port = n2;
    }

    public int getType() {
        return this.type;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress test(NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress) throws NetworkAdminException {
        return this.test(networkAdminNetworkInterfaceAddress, null);
    }

    public InetAddress test(NetworkAdminNetworkInterfaceAddress networkAdminNetworkInterfaceAddress, NetworkAdminProgressListener networkAdminProgressListener) throws NetworkAdminException {
        InetAddress inetAddress;
        InetAddress inetAddress2 = inetAddress = networkAdminNetworkInterfaceAddress == null ? null : networkAdminNetworkInterfaceAddress.getAddress();
        NetworkAdminProtocolTester networkAdminProtocolTester = this.type == 1 ? new NetworkAdminHTTPTester(this.core, networkAdminProgressListener) : (this.type == 2 ? new NetworkAdminTCPTester(this.core, networkAdminProgressListener) : new NetworkAdminUDPTester(this.core, networkAdminProgressListener));
        InetAddress inetAddress3 = this.port <= 0 ? networkAdminProtocolTester.testOutbound(inetAddress, 0) : networkAdminProtocolTester.testInbound(inetAddress, this.port);
        return inetAddress3;
    }

    public String getTypeString() {
        String string = this.type == 1 ? "HTTP" : (this.type == 2 ? "TCP" : "UDP");
        return string;
    }

    public String getName() {
        String string = this.getTypeString();
        if (this.port == -1) {
            return string + " outbound";
        }
        return string + " port " + this.port + " inbound";
    }
}

