/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.nat;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncherAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.nat.NATTraversal;
import com.aelitis.azureus.core.nat.NATTraversalException;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class NATTraverser
implements DHTNATPuncherAdapter {
    public static final int TRAVERSE_REASON_PEER_DATA = 1;
    public static final int TRAVERSE_REASON_GENERIC_MESSAGING = 2;
    private static final int MAX_QUEUE_SIZE = 128;
    private AzureusCore core;
    private DHTNATPuncher puncher;
    private ThreadPool thread_pool = new ThreadPool("NATTraverser", 16, true);
    private Map handlers = new HashMap();

    public NATTraverser(AzureusCore azureusCore) {
        this.core = azureusCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandler(NATTraversalHandler nATTraversalHandler) {
        Map map = this.handlers;
        synchronized (map) {
            this.handlers.put(new Integer(nATTraversalHandler.getType()), nATTraversalHandler);
        }
    }

    public NATTraversal attemptTraversal(final NATTraversalHandler nATTraversalHandler, final InetSocketAddress inetSocketAddress, final Map map, boolean bl, final NATTraversalObserver nATTraversalObserver) {
        final NATTraversal nATTraversal = new NATTraversal(){
            private boolean cancelled;

            public void cancel() {
                this.cancelled = true;
            }

            public boolean isCancelled() {
                return this.cancelled;
            }
        };
        if (bl) {
            this.syncTraverse(nATTraversalHandler, inetSocketAddress, map, nATTraversalObserver);
        } else if (this.thread_pool.getQueueSize() >= 128) {
            Debug.out("NATTraversal queue full");
            nATTraversalObserver.failed(2);
        } else {
            this.thread_pool.run(new AERunnable(){

                public void runSupport() {
                    if (nATTraversal.isCancelled()) {
                        nATTraversalObserver.failed(3);
                    } else {
                        NATTraverser.this.syncTraverse(nATTraversalHandler, inetSocketAddress, map, nATTraversalObserver);
                    }
                }
            });
        }
        return nATTraversal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncTraverse(NATTraversalHandler nATTraversalHandler, InetSocketAddress inetSocketAddress, Map hashMap, NATTraversalObserver nATTraversalObserver) {
        try {
            int n = nATTraversalHandler.getType();
            InetSocketAddress[] inetSocketAddressArray = this;
            synchronized (this) {
                Object object;
                DHTTransportContact[] dHTTransportContactArray;
                if (this.puncher == null) {
                    if (!PluginCoreUtils.isInitialisationComplete()) {
                        nATTraversalObserver.failed(new Exception("NAT traversal failed, initialisation not complete"));
                        // ** MonitorExit[var6_7] (shouldn't be in output)
                        return;
                    }
                    dHTTransportContactArray = this.core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
                    if (dHTTransportContactArray != null && ((DHTPlugin)(object = (DHTPlugin)dHTTransportContactArray.getPlugin())).isEnabled()) {
                        DHT dHT = ((DHTPlugin)object).getDHT(0);
                        if (dHT == null) {
                            dHT = ((DHTPlugin)object).getDHT(1);
                        }
                        if (dHT != null) {
                            this.puncher = dHT.getNATPuncher();
                        }
                    }
                }
                if (this.puncher == null) {
                    nATTraversalObserver.disabled();
                    // ** MonitorExit[var6_7] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
                if (hashMap == null) {
                    hashMap = new HashMap<String, Long>();
                }
                hashMap.put("_travreas", new Long(n));
                inetSocketAddressArray = new InetSocketAddress[]{inetSocketAddress};
                dHTTransportContactArray = new DHTTransportContact[]{null};
                object = this.puncher.punch(nATTraversalHandler.getName(), inetSocketAddressArray, dHTTransportContactArray, hashMap);
                if (object == null) {
                    if (dHTTransportContactArray[0] == null) {
                        nATTraversalObserver.failed(1);
                    } else {
                        nATTraversalObserver.failed(new Exception("NAT traversal failed"));
                    }
                } else {
                    nATTraversalObserver.succeeded(dHTTransportContactArray[0].getAddress(), inetSocketAddressArray[0], (Map)object);
                }
            }
        }
        catch (Throwable throwable) {
            nATTraversalObserver.failed(throwable);
        }
    }

    public Map sendMessage(NATTraversalHandler nATTraversalHandler, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, Map map) throws NATTraversalException {
        if (this.puncher == null) {
            throw new NATTraversalException("Puncher unavailable");
        }
        map.put("_travreas", new Long(nATTraversalHandler.getType()));
        Map map2 = this.puncher.sendMessage(inetSocketAddress, inetSocketAddress2, map);
        if (map2 == null) {
            throw new NATTraversalException("Send message failed");
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getClientData(InetSocketAddress inetSocketAddress, Map map) {
        Long l = (Long)map.get("_travreas");
        if (l != null) {
            NATTraversalHandler nATTraversalHandler;
            Map map2 = this.handlers;
            synchronized (map2) {
                nATTraversalHandler = (NATTraversalHandler)this.handlers.get(new Integer(l.intValue()));
            }
            if (nATTraversalHandler != null) {
                return nATTraversalHandler.process(inetSocketAddress, map);
            }
        }
        return null;
    }
}

