/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web.rss;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.metasearch.impl.web.WebResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSChannel;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSFeed;
import org.gudy.azureus2.plugins.utils.xml.rss.RSSItem;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.json.simple.JSONObject;

public class RSSEngine
extends WebEngine {
    private Pattern seed_leecher_pat = Pattern.compile("([0-9]+)\\s+(seed|leecher)s", 2);

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        return new RSSEngine(metaSearchImpl, map);
    }

    public static Engine importFromJSONString(MetaSearchImpl metaSearchImpl, long l, long l2, float f, String string, JSONObject jSONObject) throws IOException {
        return new RSSEngine(metaSearchImpl, l, l2, f, string, jSONObject);
    }

    public RSSEngine(MetaSearchImpl metaSearchImpl, long l, long l2, float f, String string, String string2, boolean bl, String string3, String string4, String[] stringArray) {
        super(metaSearchImpl, 4, l, l2, f, string, string2, "GMT", false, "EEE, d MMM yyyy HH:mm:ss Z", new FieldMapping[0], bl, string3, string4, stringArray);
    }

    protected RSSEngine(MetaSearchImpl metaSearchImpl, Map map) throws IOException {
        super(metaSearchImpl, map);
    }

    protected RSSEngine(MetaSearchImpl metaSearchImpl, long l, long l2, float f, String string, JSONObject jSONObject) throws IOException {
        super(metaSearchImpl, 1, l, l2, f, string, jSONObject);
    }

    public Map exportToBencodedMap() throws IOException {
        HashMap hashMap = new HashMap();
        super.exportToBencodedMap(hashMap);
        return hashMap;
    }

    public boolean supportsField(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 102: 
            case 103: 
            case 105: {
                return true;
            }
        }
        return false;
    }

    public int getAutoDownloadSupported() {
        return (int)this.getLocalLong("auto_dl_supported", 0L);
    }

    protected Result[] searchSupport(SearchParameter[] searchParameterArray, Map map, int n, int n2, String string, ResultListener resultListener) throws SearchException {
        this.debugStart();
        boolean bl = !map.containsKey("force_full");
        WebEngine.pageDetails pageDetails2 = super.getWebPageContent(searchParameterArray, map, string, bl);
        String string2 = pageDetails2.getContent();
        if (resultListener != null) {
            resultListener.contentReceived(this, string2);
        }
        if (string2 == null || string2.length() == 0) {
            return new Result[0];
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            RSSFeed rSSFeed = StaticUtilities.getRSSFeed(byteArrayInputStream);
            RSSChannel[] rSSChannelArray = rSSFeed.getChannels();
            ArrayList<WebResult> arrayList = new ArrayList<WebResult>();
            block10: for (int i = 0; i < rSSChannelArray.length; ++i) {
                Object object;
                RSSChannel rSSChannel = rSSChannelArray[i];
                SimpleXMLParserDocumentNode[] simpleXMLParserDocumentNodeArray = rSSChannel.getNode().getChildren();
                int n3 = 1;
                for (int j = 0; j < simpleXMLParserDocumentNodeArray.length; ++j) {
                    SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = simpleXMLParserDocumentNodeArray[j];
                    object = simpleXMLParserDocumentNode.getFullName().toLowerCase();
                    if (!((String)object).equals("vuze:auto_dl_enabled") || simpleXMLParserDocumentNode.getValue().equalsIgnoreCase("true")) continue;
                    n3 = 2;
                }
                this.setLocalLong("auto_dl_supported", n3);
                RSSItem[] rSSItemArray = rSSChannel.getItems();
                for (int j = 0; j < rSSItemArray.length; ++j) {
                    String string3;
                    String string4;
                    String string5;
                    Object object2;
                    Object object3;
                    String string6;
                    object = rSSItemArray[j];
                    WebResult webResult = new WebResult(this, this.getRootPage(), this.getBasePage(), this.getDateParser(), "");
                    webResult.setPublishedDate(object.getPublicationDate());
                    webResult.setNameFromHTML(object.getTitle());
                    URL uRL = object.getLink();
                    if (uRL != null) {
                        webResult.setCDPLink(uRL.toExternalForm());
                    }
                    if ((string6 = object.getUID()) != null) {
                        webResult.setUID(string6);
                    }
                    boolean bl2 = false;
                    SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = object.getNode();
                    if (simpleXMLParserDocumentNode != null) {
                        int n4;
                        object3 = simpleXMLParserDocumentNode.getChildren();
                        boolean bl3 = false;
                        for (n4 = 0; n4 < ((Object)object3).length; ++n4) {
                            object2 = object3[n4];
                            string5 = object2.getFullName().toLowerCase();
                            if (!string5.startsWith("vuze:")) continue;
                            bl3 = true;
                            break;
                        }
                        for (n4 = 0; n4 < ((Object)object3).length; ++n4) {
                            SimpleXMLParserDocumentAttribute simpleXMLParserDocumentAttribute;
                            SimpleXMLParserDocumentAttribute simpleXMLParserDocumentAttribute2;
                            Object object4;
                            Object object5;
                            object2 = object3[n4];
                            string5 = object2.getName().toLowerCase();
                            String string7 = object2.getFullName().toLowerCase();
                            String string8 = object2.getValue();
                            if (string5.equals("enclosure")) {
                                object5 = object2.getAttribute("type");
                                if (object5 == null || !object5.getValue().equalsIgnoreCase("application/x-bittorrent")) continue;
                                object4 = object2.getAttribute("url");
                                if (object4 != null) {
                                    webResult.setTorrentLink(object4.getValue());
                                }
                                if ((simpleXMLParserDocumentAttribute2 = object2.getAttribute("length")) == null) continue;
                                webResult.setSizeFromHTML(simpleXMLParserDocumentAttribute2.getValue());
                                continue;
                            }
                            if (string5.equals("category")) {
                                webResult.setCategoryFromHTML(string8);
                                continue;
                            }
                            if (string5.equals("comments")) {
                                webResult.setCommentsFromHTML(string8);
                                continue;
                            }
                            if (string5.equals("link") || string5.equals("guid")) {
                                object5 = string8.toLowerCase();
                                try {
                                    object4 = new URL(string8);
                                    if (((String)object5).endsWith(".torrent") || ((String)object5).startsWith("magnet:") || ((String)object5).startsWith("bc:") || ((String)object5).startsWith("bctp:") || ((String)object5).startsWith("dht:")) {
                                        webResult.setTorrentLink(string8);
                                        continue;
                                    }
                                    if (!string5.equals("link") || bl3) continue;
                                    long l = this.getLocalLong("link_is_torrent", 0L);
                                    if (l == 1L) {
                                        webResult.setTorrentLink(string8);
                                        continue;
                                    }
                                    if (l != 0L && SystemTime.getCurrentTime() - l <= 60000L) continue;
                                    if (this.linkIsToTorrent((URL)object4)) {
                                        webResult.setTorrentLink(string8);
                                        this.setLocalLong("link_is_torrent", 1L);
                                        continue;
                                    }
                                    this.setLocalLong("link_is_torrent", SystemTime.getCurrentTime());
                                }
                                catch (Throwable throwable) {
                                    simpleXMLParserDocumentAttribute2 = object2.getAttribute("type");
                                    if (simpleXMLParserDocumentAttribute2 == null || !simpleXMLParserDocumentAttribute2.getValue().equalsIgnoreCase("application/x-bittorrent") || (simpleXMLParserDocumentAttribute = object2.getAttribute("href")) == null) continue;
                                    String string9 = simpleXMLParserDocumentAttribute.getValue().trim();
                                    try {
                                        webResult.setTorrentLink(new URL(string9).toExternalForm());
                                    }
                                    catch (Throwable throwable2) {}
                                }
                                continue;
                            }
                            if (string5.equals("content") && rSSFeed.isAtomFeed()) {
                                object5 = object2.getAttribute("src");
                                Object object6 = object4 = object5 == null ? null : object5.getValue();
                                if (object4 == null) continue;
                                boolean bl4 = false;
                                simpleXMLParserDocumentAttribute = object2.getAttribute("type");
                                if (simpleXMLParserDocumentAttribute != null && simpleXMLParserDocumentAttribute.getValue().equalsIgnoreCase("application/x-bittorrent")) {
                                    bl4 = true;
                                }
                                if (!bl4) {
                                    boolean bl5 = bl4 = ((String)object4).toLowerCase().indexOf(".torrent") != -1;
                                }
                                if (!bl4) continue;
                                try {
                                    new URL((String)object4);
                                    webResult.setTorrentLink((String)object4);
                                }
                                catch (Throwable throwable) {}
                                continue;
                            }
                            if (string7.equals("vuze:size")) {
                                webResult.setSizeFromHTML(string8);
                                continue;
                            }
                            if (string7.equals("vuze:seeds")) {
                                bl2 = true;
                                webResult.setNbSeedsFromHTML(string8);
                                continue;
                            }
                            if (string7.equals("vuze:superseeds")) {
                                bl2 = true;
                                webResult.setNbSuperSeedsFromHTML(string8);
                                continue;
                            }
                            if (string7.equals("vuze:peers")) {
                                bl2 = true;
                                webResult.setNbPeersFromHTML(string8);
                                continue;
                            }
                            if (string7.equals("vuze:rank")) {
                                webResult.setRankFromHTML(string8);
                                continue;
                            }
                            if (string7.equals("vuze:contenttype")) {
                                object5 = string8.toLowerCase();
                                if (((String)object5).startsWith("video")) {
                                    object5 = "video";
                                } else if (((String)object5).startsWith("audio")) {
                                    object5 = "audio";
                                } else if (((String)object5).startsWith("games")) {
                                    object5 = "game";
                                }
                                webResult.setContentType((String)object5);
                                continue;
                            }
                            if (string7.equals("vuze:downloadurl")) {
                                webResult.setTorrentLink(string8);
                                continue;
                            }
                            if (string7.equals("vuze:playurl")) {
                                webResult.setPlayLink(string8);
                                continue;
                            }
                            if (string7.equals("vuze:drmkey")) {
                                webResult.setDrmKey(string8);
                                continue;
                            }
                            if (!string7.equals("vuze:assethash")) continue;
                            webResult.setHash(string8);
                        }
                    }
                    if (!bl2) {
                        try {
                            object3 = simpleXMLParserDocumentNode.getChild("description");
                            if (object3 != null) {
                                String string10 = object3.getValue().trim();
                                Matcher matcher = this.seed_leecher_pat.matcher(string10);
                                while (matcher.find()) {
                                    object2 = matcher.group(1);
                                    string5 = matcher.group(2);
                                    if (string5.toLowerCase().charAt(0) == 's') {
                                        webResult.setNbSeedsFromHTML((String)object2);
                                        continue;
                                    }
                                    webResult.setNbPeersFromHTML((String)object2);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (((object3 = webResult.getDownloadLink()) == null || ((String)object3).length() == 0) && (string4 = webResult.getName()) != null && (string3 = UrlUtils.parseTextForMagnets(string4)) != null) {
                        webResult.setTorrentLink(string3);
                    }
                    arrayList.add(webResult);
                    if (n2 >= 0 && arrayList.size() == n2) continue block10;
                }
            }
            Result[] resultArray = arrayList.toArray(new Result[arrayList.size()]);
            this.debugLog("success: found " + resultArray.length + " results");
            return resultArray;
        }
        catch (Throwable throwable) {
            this.debugLog("failed: " + Debug.getNestedExceptionMessageAndStack(throwable));
            if (throwable instanceof SearchException) {
                throw (SearchException)throwable;
            }
            throw new SearchException("RSS matching failed", throwable);
        }
    }

    protected boolean linkIsToTorrent(URL uRL) {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("HEAD");
            httpURLConnection.setConnectTimeout(10000);
            httpURLConnection.setReadTimeout(10000);
            String string = httpURLConnection.getContentType();
            this.log("Testing link " + uRL + " to see if torrent link -> content type=" + string);
            return string.equalsIgnoreCase("application/x-bittorrent");
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

