/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl;

import com.aelitis.azureus.core.custom.CustomizationManagerFactory;
import com.aelitis.azureus.core.messenger.config.PlatformMetaSearchMessenger;
import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.MetaSearch;
import com.aelitis.azureus.core.metasearch.MetaSearchException;
import com.aelitis.azureus.core.metasearch.MetaSearchManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerListener;
import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileComponent;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.core.vuzefile.VuzeFileProcessor;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.search.Search;
import org.gudy.azureus2.plugins.utils.search.SearchException;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchListener;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchProviderResults;
import org.gudy.azureus2.plugins.utils.search.SearchResult;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaSearchManagerImpl
implements MetaSearchManager,
UtilitiesImpl.searchManager,
AEDiagnosticsEvidenceGenerator {
    private static final boolean AUTO_MODE_DEFAULT = true;
    private static final String LOGGER_NAME = "MetaSearch";
    private static final int REFRESH_MILLIS = 82800000;
    private static MetaSearchManagerImpl singleton;
    private MetaSearchImpl meta_search;
    private AsyncDispatcher dispatcher = new AsyncDispatcher(10000);
    private AESemaphore initial_refresh_sem = new AESemaphore("MetaSearch:initrefresh");
    private AESemaphore refresh_sem = new AESemaphore("MetaSearch:refresh", 1);
    private boolean checked_customization;
    private AsyncDispatcher op_dispatcher = new AsyncDispatcher(5000);
    private List<MetaSearchManagerListener> listeners = new ArrayList<MetaSearchManagerListener>();
    private List<Map> operations = new ArrayList<Map>();
    private String extension_key;

    public static void preInitialise() {
        VuzeFileHandler.getSingleton().addProcessor(new VuzeFileProcessor(){

            public void process(VuzeFile[] vuzeFileArray, int n) {
                for (int i = 0; i < vuzeFileArray.length; ++i) {
                    VuzeFile vuzeFile = vuzeFileArray[i];
                    VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                    for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                        VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                        int n2 = vuzeFileComponent.getType();
                        if (n2 == 1) {
                            try {
                                Engine engine = MetaSearchManagerImpl.getSingleton().importEngine(vuzeFileComponent.getContent(), (n & 1) == 0);
                                vuzeFileComponent.setProcessed();
                                if (engine == null) continue;
                                vuzeFileComponent.setData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY, engine);
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                            continue;
                        }
                        if (n2 != 256) continue;
                        MetaSearchManagerImpl.getSingleton().addOperation(vuzeFileComponent.getContent());
                        vuzeFileComponent.setProcessed();
                    }
                }
            }
        });
    }

    public static synchronized MetaSearchManagerImpl getSingleton() {
        if (singleton == null) {
            singleton = new MetaSearchManagerImpl();
        }
        return singleton;
    }

    protected MetaSearchManagerImpl() {
        this.meta_search = new MetaSearchImpl(this);
        AEDiagnostics.addEvidenceGenerator(this);
        this.extension_key = COConfigurationManager.getStringParameter("metasearch.extkey.latest", "");
        if (this.extension_key.length() == 0) {
            this.extension_key = null;
        }
        this.setupExtensions();
        SimpleTimer.addPeriodicEvent("MetaSearchRefresh", 82800000L, new TimerEventPerformer(){

            public void perform(TimerEvent timerEvent2) {
                MetaSearchManagerImpl.this.refresh();
            }
        });
        this.refresh();
        UtilitiesImpl.addSearchManager(this);
    }

    @Override
    public void addProvider(PluginInterface pluginInterface, SearchProvider searchProvider) {
        String string = pluginInterface.getPluginID() + "." + searchProvider.getProperty(1);
        try {
            this.meta_search.importFromPlugin(string, searchProvider);
        }
        catch (Throwable throwable) {
            Debug.out("Failed to add search provider '" + string + "' (" + searchProvider + ")", throwable);
        }
    }

    @Override
    public SearchProvider[] getProviders() {
        Engine[] engineArray = this.meta_search.getEngines(true, false);
        SearchProvider[] searchProviderArray = new SearchProvider[engineArray.length];
        for (int i = 0; i < engineArray.length; ++i) {
            searchProviderArray[i] = new engineInfo(engineArray[i]);
        }
        return searchProviderArray;
    }

    @Override
    public Search createSearch(String string, String string2) throws SearchException {
        String[] stringArray = XUXmlWriter.splitWithEscape(string, ',');
        long[] lArray = new long[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            lArray[i] = Long.parseLong(stringArray[i]);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        stringArray = XUXmlWriter.splitWithEscape(string2, ',');
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = XUXmlWriter.splitWithEscape(stringArray[i], '=');
            hashMap.put(stringArray2[0].trim(), stringArray2[1].trim());
        }
        return this.createSearch(lArray, hashMap, null);
    }

    @Override
    public Search createSearch(SearchProvider[] searchProviderArray, Map<String, String> map, SearchListener searchListener) throws SearchException {
        long[] lArray;
        if (searchProviderArray == null) {
            lArray = new long[]{};
        } else {
            lArray = new long[searchProviderArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                Long l = (Long)searchProviderArray[i].getProperty(0);
                if (l == null) {
                    throw new SearchException("Unknown provider - no id available");
                }
                lArray[i] = l;
            }
        }
        return this.createSearch(lArray, map, searchListener);
    }

    protected Search createSearch(long[] lArray, Map<String, String> map, SearchListener searchListener) throws SearchException {
        Engine[] engineArray;
        ArrayList<SearchParameter> arrayList = new ArrayList<SearchParameter>();
        String string = map.get("search_term");
        if (string == null) {
            throw new SearchException("Search term is mandatory");
        }
        arrayList.add(new SearchParameter("s", string));
        String string2 = map.get("mature");
        if (string2 != null) {
            arrayList.add(new SearchParameter("m", string2.toString()));
        }
        SearchParameter[] searchParameterArray = arrayList.toArray(new SearchParameter[arrayList.size()]);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("force_full", "true");
        String string3 = null;
        int n = 256;
        SearchObject searchObject = new SearchObject(searchListener);
        if (lArray.length == 0) {
            engineArray = this.getMetaSearch().search(searchObject, searchParameterArray, string3, hashMap, n);
        } else {
            ArrayList<Engine> arrayList2 = new ArrayList<Engine>();
            for (long l : lArray) {
                Engine engine = this.meta_search.getEngine(l);
                if (engine == null) {
                    throw new SearchException("Unknown engine id - " + l);
                }
                arrayList2.add(engine);
            }
            Engine[] engineArray2 = arrayList2.toArray(new Engine[arrayList2.size()]);
            engineArray = this.getMetaSearch().search(engineArray2, searchObject, searchParameterArray, string3, hashMap, n);
        }
        searchObject.setEnginesUsed(engineArray);
        return searchObject;
    }

    protected void refresh() {
        this.dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (MetaSearchManagerImpl.this.dispatcher.getQueueSize() == 0) {
                    try {
                        MetaSearchManagerImpl.this.syncRefresh();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        });
    }

    protected void ensureEnginesUpToDate() {
        long l;
        long l2 = l = this.meta_search.getEngineCount() == 0 ? 30000L : 10000L;
        if (!this.initial_refresh_sem.reserve(l)) {
            this.log("Timeout waiting for initial refresh to complete, continuing");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void syncRefresh() throws MetaSearchException {
        block48: {
            boolean bl = false;
            boolean bl2 = false;
            try {
                Object object7;
                PlatformMetaSearchMessenger.templateInfo templateInfo2;
                Object object2;
                Object[] objectArray;
                boolean bl3;
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                this.refresh_sem.reserve();
                bl2 = COConfigurationManager.getBooleanParameter("metasearch.refresh.first_run", true);
                if (!this.checked_customization) {
                    this.checked_customization = true;
                    object6 = CustomizationManagerFactory.getSingleton();
                    object5 = object6.getActiveCustomization();
                    if (object5 != null) {
                        object4 = COConfigurationManager.getStringParameter("metasearch.custom.name", "");
                        object3 = COConfigurationManager.getStringParameter("metasearch.custom.version", "0");
                        boolean bl4 = !((String)object4).equals(object5.getName());
                        boolean bl5 = bl3 = Constants.compareVersions((String)object3, object5.getVersion()) < 0;
                        if (bl4 || bl3) {
                            this.log("Customization: checking templates for " + object5.getName() + "/" + object5.getVersion());
                            try {
                                objectArray = object5.getResources("metasearch");
                                if (objectArray.length > 0 && bl4) {
                                    this.log("    setting auto-mode to false");
                                    this.setAutoMode(false);
                                }
                                for (int i = 0; i < objectArray.length; ++i) {
                                    object2 = objectArray[i];
                                    try {
                                        VuzeFile vuzeFile = VuzeFileHandler.getSingleton().loadVuzeFile((InputStream)object2);
                                        if (vuzeFile != null) {
                                            VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
                                            for (int j = 0; j < vuzeFileComponentArray.length; ++j) {
                                                VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[j];
                                                if (vuzeFileComponent.getType() != 1) continue;
                                                try {
                                                    Engine engine = MetaSearchManagerImpl.getSingleton().importEngine(vuzeFileComponent.getContent(), false);
                                                    this.log("    updated " + engine.getName());
                                                    engine.setSelectionState(2);
                                                    continue;
                                                }
                                                catch (Throwable throwable) {
                                                    Debug.printStackTrace(throwable);
                                                }
                                            }
                                        }
                                        templateInfo2 = null;
                                    }
                                    catch (Throwable throwable) {
                                        templateInfo2 = null;
                                        try {
                                            ((InputStream)object2).close();
                                            throw throwable;
                                        }
                                        catch (Throwable object7) {
                                            // empty catch block
                                        }
                                        throw throwable;
                                    }
                                    try {}
                                    catch (Throwable object7) {}
                                    ((InputStream)object2).close();
                                }
                                Object var21_70 = null;
                            }
                            catch (Throwable throwable) {
                                Object var21_71 = null;
                                COConfigurationManager.setParameter("metasearch.custom.name", object5.getName());
                                COConfigurationManager.setParameter("metasearch.custom.version", object5.getVersion());
                                throw throwable;
                            }
                            COConfigurationManager.setParameter("metasearch.custom.name", object5.getName());
                            COConfigurationManager.setParameter("metasearch.custom.version", object5.getVersion());
                        }
                    }
                }
                this.log("Refreshing engines");
                object6 = new HashMap();
                object5 = new HashMap();
                object4 = new HashSet();
                object3 = new HashSet();
                HashSet<Long> hashSet = new HashSet<Long>();
                bl3 = this.isAutoMode();
                objectArray = this.meta_search.getEngines(false, false);
                try {
                    void var16_59;
                    void var16_57;
                    void var13_27;
                    PlatformMetaSearchMessenger.templateInfo[] templateInfoArray = PlatformMetaSearchMessenger.listFeaturedTemplates(this.extension_key);
                    object2 = "";
                    for (int i = 0; i < templateInfoArray.length; ++i) {
                        PlatformMetaSearchMessenger.templateInfo templateInfo3 = templateInfoArray[i];
                        if (!templateInfo3.isVisible()) continue;
                        Long l = new Long(templateInfo3.getId());
                        object6.put(l, templateInfo3);
                        object4.add(l);
                        object2 = (String)object2 + (((String)object2).length() == 0 ? "" : ",") + l;
                    }
                    this.log("Featured templates: " + (String)object2);
                    if (bl3 || bl2) {
                        void var13_23;
                        PlatformMetaSearchMessenger.templateInfo[] templateInfoArray2 = PlatformMetaSearchMessenger.listTopPopularTemplates(this.extension_key);
                        String string = "";
                        String string2 = "";
                        for (int i = 0; i < templateInfoArray2.length; ++i) {
                            PlatformMetaSearchMessenger.templateInfo templateInfo4 = templateInfoArray2[i];
                            if (!templateInfo4.isVisible()) continue;
                            Long l = new Long(templateInfo4.getId());
                            if (bl3) {
                                if (object6.containsKey(l)) continue;
                                object6.put(l, templateInfo4);
                                object3.add(l);
                                String string3 = (String)var13_23 + (var13_23.length() == 0 ? "" : ",") + l;
                                continue;
                            }
                            if (object5.containsKey(l)) continue;
                            object5.put(l, templateInfo4);
                            string2 = string2 + (string2.length() == 0 ? "" : ",") + l;
                        }
                        this.log("Popular templates: " + (String)var13_23);
                        if (string2.length() > 0) {
                            this.log("Pre-load templates: " + (String)var13_23);
                        }
                    }
                    String string = "";
                    boolean bl6 = false;
                    while (var13_27 < objectArray.length) {
                        Object object8 = objectArray[var13_27];
                        Long l = new Long(object8.getId());
                        if (object8.getSource() == 1 && object8.getSelectionState() == 2 && !object6.containsKey(l)) {
                            hashSet.add(l);
                        }
                        ++var13_27;
                    }
                    if (hashSet.size() > 0) {
                        long[] lArray = new long[hashSet.size()];
                        Iterator iterator = hashSet.iterator();
                        int n = 0;
                        while (iterator.hasNext()) {
                            lArray[n++] = (Long)iterator.next();
                        }
                        PlatformMetaSearchMessenger.templateInfo[] templateInfoArray3 = PlatformMetaSearchMessenger.getTemplateDetails(this.extension_key, lArray);
                        for (int i = 0; i < templateInfoArray3.length; ++i) {
                            templateInfo2 = templateInfoArray3[i];
                            if (!templateInfo2.isVisible()) continue;
                            object7 = new Long(templateInfo2.getId());
                            object6.put(object7, templateInfo2);
                            string = string + (string.length() == 0 ? "" : ",") + object7;
                        }
                    }
                    this.log("Manual templates: " + string);
                    HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
                    String string4 = "";
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object9 = objectArray[i];
                        Long l = new Long(object9.getId());
                        hashMap.put(l, object9);
                        string4 = string4 + (string4.length() == 0 ? "" : ",") + l + "[source=" + Engine.ENGINE_SOURCE_STRS[object9.getSource()] + ",type=" + object9.getType() + ",selected=" + Engine.SEL_STATE_STRINGS[object9.getSelectionState()] + "]";
                    }
                    this.log("Existing templates: " + string4);
                    for (Map.Entry entry : object6.entrySet()) {
                        boolean bl7;
                        object5.remove(entry.getKey());
                        long l = (Long)entry.getKey();
                        object7 = (PlatformMetaSearchMessenger.templateInfo)entry.getValue();
                        long l2 = ((PlatformMetaSearchMessenger.templateInfo)object7).getModifiedDate();
                        Engine engine = (Engine)hashMap.get(new Long(l));
                        boolean bl8 = bl7 = engine == null || engine.getLastUpdated() < l2;
                        if (bl7) {
                            PlatformMetaSearchMessenger.templateDetails templateDetails2 = PlatformMetaSearchMessenger.getTemplate(this.extension_key, l);
                            this.log("Downloading definition of template " + l);
                            this.log(templateDetails2.getValue());
                            if (templateDetails2.isVisible()) {
                                try {
                                    engine = this.meta_search.importFromJSONString(templateDetails2.getType() == 1 ? 2 : 1, templateDetails2.getId(), templateDetails2.getModifiedDate(), templateDetails2.getRankBias(), templateDetails2.getName(), templateDetails2.getValue());
                                    engine.setSource(1);
                                    this.meta_search.addEngine(engine);
                                }
                                catch (Throwable throwable) {
                                    this.log("Failed to import engine '" + templateDetails2.getValue() + "'", throwable);
                                }
                            }
                        } else if (engine.getRankBias() != ((PlatformMetaSearchMessenger.templateInfo)object7).getRankBias()) {
                            engine.setRankBias(((PlatformMetaSearchMessenger.templateInfo)object7).getRankBias());
                            this.log("Updating rank bias for " + engine.getString() + " to " + ((PlatformMetaSearchMessenger.templateInfo)object7).getRankBias());
                        } else {
                            this.log("Not updating " + engine.getString() + " as unchanged");
                        }
                        if (engine == null || engine.getSelectionState() != 0) continue;
                        this.log("Auto-selecting " + engine.getString());
                        engine.setSelectionState(1);
                    }
                    for (Map.Entry entry : object5.entrySet()) {
                        long l = (Long)entry.getKey();
                        object7 = (Engine)hashMap.get(new Long(l));
                        if (object7 != null) continue;
                        PlatformMetaSearchMessenger.templateDetails templateDetails3 = PlatformMetaSearchMessenger.getTemplate(this.extension_key, l);
                        this.log("Downloading pre-load definition of template " + l);
                        this.log(templateDetails3.getValue());
                        if (!templateDetails3.isVisible()) continue;
                        try {
                            object7 = this.meta_search.importFromJSONString(templateDetails3.getType() == 1 ? 2 : 1, templateDetails3.getId(), templateDetails3.getModifiedDate(), templateDetails3.getRankBias(), templateDetails3.getName(), templateDetails3.getValue());
                            object7.setSource(1);
                            object7.setSelectionState(0);
                            this.meta_search.addEngine((Engine)object7);
                        }
                        catch (Throwable throwable) {
                            this.log("Failed to import engine '" + templateDetails3.getValue() + "'", throwable);
                        }
                    }
                    boolean bl9 = false;
                    while (var16_57 < objectArray.length) {
                        Object object10 = objectArray[var16_57];
                        if (object10.getSource() == 1 && object10.getSelectionState() == 1 && !object6.containsKey(new Long(object10.getId()))) {
                            this.log("Deselecting " + object10.getString() + " as no longer visible on Vuze");
                            object10.setSelectionState(0);
                        }
                        ++var16_57;
                    }
                    boolean bl10 = false;
                    while (var16_59 < objectArray.length) {
                        Object object11 = objectArray[var16_59];
                        if (object11.getSource() == 1 && object11.getSelectionState() == 2) {
                            object11.recordSelectionState();
                        } else {
                            object11.checkSelectionStateRecorded();
                        }
                        ++var16_59;
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    this.log("Refresh failed", throwable);
                    throw new MetaSearchException("Refresh failed", throwable);
                }
                Object var27_80 = null;
                if (!bl2 || !bl) break block48;
            }
            catch (Throwable throwable) {
                Object var27_81 = null;
                if (bl2 && bl) {
                    COConfigurationManager.setParameter("metasearch.refresh.first_run", false);
                }
                this.refresh_sem.release();
                this.initial_refresh_sem.releaseForever();
                throw throwable;
            }
            COConfigurationManager.setParameter("metasearch.refresh.first_run", false);
        }
        this.refresh_sem.release();
        this.initial_refresh_sem.releaseForever();
    }

    @Override
    public MetaSearch getMetaSearch() {
        return this.meta_search;
    }

    @Override
    public boolean isAutoMode() {
        return COConfigurationManager.getBooleanParameter("metasearch.auto.mode", true);
    }

    protected void setAutoMode(boolean bl) {
        COConfigurationManager.setParameter("metasearch.auto.mode", bl);
    }

    @Override
    public void setSelectedEngines(long[] lArray, boolean bl) throws MetaSearchException {
        try {
            Engine engine;
            long l;
            int n;
            String string = "";
            for (int i = 0; i < lArray.length; ++i) {
                string = string + (i == 0 ? "" : ",") + lArray[i];
            }
            this.log("setSelectedIds: " + string + ", auto=" + bl);
            COConfigurationManager.setParameter("metasearch.auto.mode", bl);
            Engine[] engineArray = this.meta_search.getEngines(false, false);
            HashMap<Long, Engine> hashMap = new HashMap<Long, Engine>();
            for (int i = 0; i < engineArray.length; ++i) {
                hashMap.put(new Long(engineArray[i].getId()), engineArray[i]);
            }
            HashSet<Engine> hashSet = new HashSet<Engine>();
            for (n = 0; n < lArray.length; ++n) {
                l = lArray[n];
                engine = (Engine)hashMap.get(new Long(l));
                if (engine == null) continue;
                engine.setSelectionState(2);
                hashSet.add(engine);
            }
            this.syncRefresh();
            engineArray = this.meta_search.getEngines(false, false);
            for (n = 0; n < lArray.length; ++n) {
                l = lArray[n];
                engine = (Engine)hashMap.get(new Long(l));
                if (engine != null) continue;
                PlatformMetaSearchMessenger.templateDetails templateDetails2 = PlatformMetaSearchMessenger.getTemplate(this.extension_key, l);
                this.log("Downloading definition of template " + l);
                this.log(templateDetails2.getValue());
                Engine engine2 = this.meta_search.importFromJSONString(templateDetails2.getType() == 1 ? 2 : 1, templateDetails2.getId(), templateDetails2.getModifiedDate(), templateDetails2.getRankBias(), templateDetails2.getName(), templateDetails2.getValue());
                engine2.setSelectionState(2);
                engine2.setSource(1);
                this.meta_search.addEngine(engine2);
                hashSet.add(engine2);
            }
            for (n = 0; n < engineArray.length; ++n) {
                Engine engine3 = engineArray[n];
                if (engine3.getSelectionState() != 2 || hashSet.contains(engine3)) continue;
                engine3.setSelectionState(0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (throwable instanceof MetaSearchException) {
                throw (MetaSearchException)throwable;
            }
            throw new MetaSearchException("Failed to set selected engines", throwable);
        }
    }

    @Override
    public Engine addEngine(long l, int n, String string, String string2) throws MetaSearchException {
        if (l == -1L) {
            l = this.getLocalTemplateID();
        }
        try {
            Engine engine = this.meta_search.importFromJSONString(n, l, SystemTime.getCurrentTime(), 1.0f, string, string2);
            engine.setSource(2);
            engine.setSelectionState(2);
            this.meta_search.addEngine(engine);
            return engine;
        }
        catch (Throwable throwable) {
            throw new MetaSearchException("Failed to add engine", throwable);
        }
    }

    @Override
    public Engine importEngine(Map map, boolean bl) throws MetaSearchException {
        try {
            String string;
            UIManager uIManager;
            EngineImpl engineImpl = (EngineImpl)this.meta_search.importFromBEncodedMap(map);
            long l = engineImpl.getId();
            Engine engine = this.meta_search.getEngine(l);
            if (engine != null && engine.sameLogicAs(engineImpl)) {
                if (bl) {
                    UIManager uIManager2 = StaticUtilities.getUIManager(120000L);
                    String string2 = MessageText.getString("metasearch.addtemplate.dup.desc", new String[]{engineImpl.getName()});
                    uIManager2.showMessageBox("metasearch.addtemplate.dup.title", "!" + string2 + "!", 1L);
                }
                return engine;
            }
            if (bl) {
                uIManager = StaticUtilities.getUIManager(120000L);
                string = MessageText.getString("metasearch.addtemplate.desc", new String[]{engineImpl.getName()});
                long l2 = uIManager.showMessageBox("metasearch.addtemplate.title", "!" + string + "!", 12L);
                if (l2 != 4L) {
                    throw new MetaSearchException("User declined the template");
                }
            }
            if (l >= 0L && l < Integer.MAX_VALUE) {
                l = this.getLocalTemplateID();
                engineImpl.setId(l);
            }
            engineImpl.setSource(2);
            engineImpl.setSelectionState(2);
            this.meta_search.addEngine(engineImpl);
            if (bl) {
                uIManager = StaticUtilities.getUIManager(120000L);
                string = MessageText.getString("metasearch.addtemplate.done.desc", new String[]{engineImpl.getName()});
                uIManager.showMessageBox("metasearch.addtemplate.done.title", "!" + string + "!", 1L);
            }
            return engineImpl;
        }
        catch (Throwable throwable) {
            if (bl) {
                UIManager uIManager = StaticUtilities.getUIManager(120000L);
                String string = MessageText.getString("metasearch.addtemplate.failed.desc", new String[]{Debug.getNestedExceptionMessage(throwable)});
                uIManager.showMessageBox("metasearch.addtemplate.failed.title", "!" + string + "!", 1L);
            }
            throw new MetaSearchException("Failed to add engine", throwable);
        }
    }

    public Engine[] loadFromVuzeFile(File file) {
        VuzeFile vuzeFile = VuzeFileHandler.getSingleton().loadVuzeFile(file.getAbsolutePath());
        if (vuzeFile != null) {
            return this.loadFromVuzeFile(vuzeFile);
        }
        return new Engine[0];
    }

    public Engine[] loadFromVuzeFile(VuzeFile vuzeFile) {
        ArrayList<Engine> arrayList = new ArrayList<Engine>();
        VuzeFileComponent[] vuzeFileComponentArray = vuzeFile.getComponents();
        for (int i = 0; i < vuzeFileComponentArray.length; ++i) {
            VuzeFileComponent vuzeFileComponent = vuzeFileComponentArray[i];
            if (vuzeFileComponent.getType() != 1) continue;
            try {
                arrayList.add(this.importEngine(vuzeFileComponent.getContent(), false));
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return arrayList.toArray(new Engine[arrayList.size()]);
    }

    public long getLocalTemplateID() {
        MetaSearchManagerImpl metaSearchManagerImpl = this;
        synchronized (metaSearchManagerImpl) {
            long l;
            Random random = new Random();
            while (this.meta_search.getEngine(l = Integer.MAX_VALUE + (long)random.nextInt(Integer.MAX_VALUE)) != null) {
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MetaSearchManagerListener metaSearchManagerListener) {
        List<MetaSearchManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(metaSearchManagerListener);
        }
        this.dispatchOps();
    }

    @Override
    public void removeListener(MetaSearchManagerListener metaSearchManagerListener) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOperation(Map map) {
        List<MetaSearchManagerListener> list = this.listeners;
        synchronized (list) {
            this.operations.add(map);
        }
        this.dispatchOps();
    }

    private void dispatchOps() {
        this.op_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                ArrayList arrayList;
                ArrayList arrayList2;
                List list = MetaSearchManagerImpl.this.listeners;
                synchronized (list) {
                    if (MetaSearchManagerImpl.this.listeners.size() == 0 || MetaSearchManagerImpl.this.operations.size() == 0) {
                        return;
                    }
                    arrayList2 = new ArrayList(MetaSearchManagerImpl.this.listeners);
                    arrayList = new ArrayList(MetaSearchManagerImpl.this.operations);
                    MetaSearchManagerImpl.this.operations.clear();
                }
                for (MetaSearchManagerListener metaSearchManagerListener : arrayList2) {
                    for (Map map : arrayList) {
                        try {
                            int n = ImportExportUtils.importInt(map, "type", -1);
                            if (n == 1) {
                                String string = ImportExportUtils.importString(map, "term", null);
                                if (string == null) {
                                    Debug.out("search term missing");
                                    continue;
                                }
                                metaSearchManagerListener.searchRequest(string);
                                continue;
                            }
                            Debug.out("unknown operation type " + n);
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                }
            }
        });
    }

    private void setupExtensions() {
        PluginInterface pluginInterface = PluginInitializer.getDefaultInterface();
        final FeatureManager featureManager = pluginInterface.getUtilities().getFeatureManager();
        featureManager.addListener(new FeatureManager.FeatureManagerListener(){

            public void licenceAdded(FeatureManager.Licence licence) {
                MetaSearchManagerImpl.this.getExtensions(featureManager, false);
            }

            public void licenceChanged(FeatureManager.Licence licence) {
                MetaSearchManagerImpl.this.getExtensions(featureManager, false);
            }

            public void licenceRemoved(FeatureManager.Licence licence) {
                MetaSearchManagerImpl.this.getExtensions(featureManager, false);
            }
        });
        if (pluginInterface.getPluginState().isInitialisationComplete()) {
            this.getExtensions(featureManager, true);
        } else {
            pluginInterface.addListener(new PluginListener(){

                public void initializationComplete() {
                    MetaSearchManagerImpl.this.getExtensions(featureManager, false);
                }

                public void closedownInitiated() {
                }

                public void closedownComplete() {
                }
            });
        }
    }

    private void getExtensions(FeatureManager featureManager, boolean bl) {
        FeatureManager.FeatureDetails[] featureDetailsArray;
        String string = this.extension_key;
        String string2 = null;
        for (FeatureManager.FeatureDetails featureDetails : featureDetailsArray = featureManager.getFeatureDetails("core")) {
            String string3;
            if (featureDetails.hasExpired() || (string3 = (String)featureDetails.getProperty("Fingerprint")) == null) continue;
            string2 = featureDetails.getLicence().getShortID() + "-" + string3;
            break;
        }
        if (!(string == string2 || string != null && string2 != null && string.equals(string2))) {
            this.extension_key = string2;
            COConfigurationManager.setParameter("metasearch.extkey.latest", string2 == null ? "" : string2);
            if (!bl) {
                this.refresh();
            }
        }
    }

    protected String getExtensionKey() {
        return this.extension_key;
    }

    public void log(String string, Throwable throwable) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger(LOGGER_NAME);
        aEDiagnosticsLogger.log(string);
        aEDiagnosticsLogger.log(throwable);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string + ": " + Debug.getNestedExceptionMessage(throwable));
        }
    }

    @Override
    public void log(String string) {
        AEDiagnosticsLogger aEDiagnosticsLogger = AEDiagnostics.getLogger(LOGGER_NAME);
        aEDiagnosticsLogger.log(string);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("Metasearch: auto=" + this.isAutoMode());
        try {
            indentWriter.indent();
            this.meta_search.generate(indentWriter);
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    public static void main(String[] stringArray) {
        try {
            VuzeFile vuzeFile = VuzeFileHandler.getSingleton().create();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("type", new Long(1L));
            hashMap.put("term", "donkey");
            vuzeFile.addComponent(256, hashMap);
            vuzeFile.write(new File("C:\\temp\\search.vuze"));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class engineInfo
    implements SearchProvider {
        private Engine engine;
        private boolean complete;

        protected engineInfo(Engine engine) {
            this.engine = engine;
        }

        protected void setComplete() {
            this.complete = true;
        }

        protected boolean isComplete() {
            return this.complete;
        }

        @Override
        public SearchInstance search(Map<String, Object> map, SearchObserver searchObserver) throws SearchException {
            throw new SearchException("Not supported");
        }

        @Override
        public Object getProperty(int n) {
            if (n == 0) {
                return this.engine.getId();
            }
            if (n == 1) {
                return this.engine.getName();
            }
            return null;
        }

        @Override
        public void setProperty(int n, Object object) {
            Debug.out("Not supported");
        }
    }

    protected static class SearchObject
    implements Search,
    ResultListener {
        private SearchListener listener;
        private Map<Long, engineInfo> engine_map = new HashMap<Long, engineInfo>();
        private boolean engines_set;
        private List<SearchProviderResults> pending_results = new ArrayList<SearchProviderResults>();
        private boolean is_complete;

        protected SearchObject(SearchListener searchListener) {
            this.listener = searchListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setEnginesUsed(Engine[] engineArray) {
            boolean bl;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                for (Engine engine : engineArray) {
                    this.getInfo(engine);
                }
                this.engines_set = true;
                bl = this.reportOverallComplete();
            }
            if (this.listener != null && bl) {
                this.listener.completed();
            }
        }

        private boolean reportOverallComplete() {
            if (this.is_complete || !this.engines_set) {
                return false;
            }
            for (engineInfo engineInfo2 : this.engine_map.values()) {
                if (engineInfo2.isComplete()) continue;
                return false;
            }
            this.is_complete = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected engineInfo getInfo(Engine engine) {
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                engineInfo engineInfo2 = this.engine_map.get(engine.getId());
                if (engineInfo2 == null) {
                    engineInfo2 = new engineInfo(engine);
                    this.engine_map.put(engine.getId(), engineInfo2);
                }
                return engineInfo2;
            }
        }

        public void contentReceived(Engine engine, String string) {
        }

        public void matchFound(Engine engine, String[] stringArray) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultsReceived(Engine engine, final Result[] resultArray) {
            SearchProviderResults searchProviderResults;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                final engineInfo engineInfo2 = this.getInfo(engine);
                searchProviderResults = new SearchProviderResults(){

                    public SearchProvider getProvider() {
                        return engineInfo2;
                    }

                    public SearchResult[] getResults() {
                        return SearchObject.this.wrapResults(resultArray);
                    }

                    public boolean isComplete() {
                        return false;
                    }

                    public SearchException getError() {
                        return null;
                    }
                };
                this.pending_results.add(searchProviderResults);
            }
            if (this.listener != null) {
                this.listener.receivedResults(new SearchProviderResults[]{searchProviderResults});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultsComplete(Engine engine) {
            SearchProviderResults searchProviderResults;
            boolean bl;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                final engineInfo engineInfo2 = this.getInfo(engine);
                engineInfo2.setComplete();
                bl = this.reportOverallComplete();
                searchProviderResults = new SearchProviderResults(){

                    public SearchProvider getProvider() {
                        return engineInfo2;
                    }

                    public SearchResult[] getResults() {
                        return new SearchResult[0];
                    }

                    public boolean isComplete() {
                        return true;
                    }

                    public SearchException getError() {
                        return null;
                    }
                };
                this.pending_results.add(searchProviderResults);
            }
            if (this.listener != null) {
                this.listener.receivedResults(new SearchProviderResults[]{searchProviderResults});
                if (bl) {
                    this.listener.completed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void failed(Engine engine, final SearchException searchException) {
            SearchProviderResults searchProviderResults;
            boolean bl;
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                final engineInfo engineInfo2 = this.getInfo(engine);
                engineInfo2.setComplete();
                bl = this.reportOverallComplete();
                searchProviderResults = new SearchProviderResults(){

                    public SearchProvider getProvider() {
                        return engineInfo2;
                    }

                    public SearchResult[] getResults() {
                        return new SearchResult[0];
                    }

                    public boolean isComplete() {
                        return false;
                    }

                    public SearchException getError() {
                        return searchException;
                    }
                };
                this.pending_results.add(searchProviderResults);
            }
            if (this.listener != null) {
                this.listener.receivedResults(new SearchProviderResults[]{searchProviderResults});
                if (bl) {
                    this.listener.completed();
                }
            }
        }

        public void engineFailed(Engine engine, Throwable throwable) {
            this.failed(engine, new SearchException("Search failed", throwable));
        }

        public void engineRequiresLogin(Engine engine, Throwable throwable) {
            this.failed(engine, new SearchException("Authentication required", throwable));
        }

        protected SearchResult[] wrapResults(Result[] resultArray) {
            SearchResult[] searchResultArray = new SearchResult[resultArray.length];
            for (int i = 0; i < searchResultArray.length; ++i) {
                searchResultArray[i] = new resultWrapper(resultArray[i]);
            }
            return searchResultArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SearchProviderResults[] getResults() {
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                SearchProviderResults[] searchProviderResultsArray = this.pending_results.toArray(new SearchProviderResults[this.pending_results.size()]);
                this.pending_results.clear();
                return searchProviderResultsArray;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isComplete() {
            Map<Long, engineInfo> map = this.engine_map;
            synchronized (map) {
                if (!this.is_complete) {
                    return false;
                }
                return this.pending_results.size() <= 0;
                {
                }
            }
        }

        protected static class resultWrapper
        implements SearchResult {
            private Result result;

            protected resultWrapper(Result result) {
                this.result = result;
            }

            public Object getProperty(int n) {
                switch (n) {
                    case 1: {
                        return this.result.getName();
                    }
                    case 2: {
                        return this.result.getPublishedDate();
                    }
                    case 3: {
                        return this.result.getSize();
                    }
                    case 4: {
                        return new Long(this.result.getNbPeers());
                    }
                    case 5: {
                        return new Long(this.result.getNbSeeds());
                    }
                    case 6: {
                        return new Long(this.result.getNbSuperSeeds());
                    }
                    case 7: {
                        return this.result.getCategory();
                    }
                    case 8: {
                        return new Long(this.result.getComments());
                    }
                    case 9: {
                        return new Long(this.result.getVotes());
                    }
                    case 10: {
                        return this.result.getContentType();
                    }
                    case 11: {
                        return this.result.getCDPLink();
                    }
                    case 12: {
                        return this.result.getDownloadLink();
                    }
                    case 13: {
                        return this.result.getPlayLink();
                    }
                    case 14: {
                        return this.result.isPrivate();
                    }
                    case 15: {
                        return this.result.getDRMKey();
                    }
                    case 16: {
                        return this.result.getDownloadButtonLink();
                    }
                    case 17: {
                        float f = this.result.getRank();
                        return new Long(f == -1.0f ? -1L : (long)(f * 100.0f));
                    }
                    case 18: {
                        float f = this.result.getAccuracy();
                        return new Long(f == -1.0f ? -1L : (long)(f * 100.0f));
                    }
                    case 19: {
                        return new Long(this.result.getVotesDown());
                    }
                    case 20: {
                        return this.result.getUID();
                    }
                    case 21: {
                        String string = this.result.getHash();
                        if (string != null) {
                            return Base32.decode(string);
                        }
                        return null;
                    }
                }
                Debug.out("Unknown property type " + n);
                return null;
            }
        }
    }
}

