/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LWSDiskManager;
import com.aelitis.azureus.core.lws.LWSDownload;
import com.aelitis.azureus.core.lws.LWSPeerManagerAdapter;
import com.aelitis.azureus.core.lws.LWSTorrent;
import com.aelitis.azureus.core.lws.LightWeightSeedAdapter;
import com.aelitis.azureus.core.lws.LightWeightSeedManager;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistrationAdapter;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.URL;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeerManagerListener;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerFactory;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class LightWeightSeed
extends LogRelation
implements PeerManagerRegistrationAdapter {
    private static final byte ACT_NONE = 0;
    private static final byte ACT_HAS_PEERS = 2;
    private static final byte ACT_HAS_POTENTIAL_PEERS = 3;
    private static final byte ACT_INCOMING = 4;
    private static final byte ACT_NO_PM = 5;
    private static final byte ACT_TIMING_OUT = 6;
    private static final byte ACT_TRACKER_ANNOUNCE = 7;
    private static final byte ACT_TRACKER_SCRAPE = 8;
    private static final int DEACTIVATION_TIMEOUT = 300000;
    private static final int DEACTIVATION_WITH_POTENTIAL_TIMEOUT = 900000;
    private LightWeightSeedManager manager;
    private LightWeightSeedAdapter adapter;
    private String name;
    private HashWrapper hash;
    private URL announce_url;
    private File data_location;
    private PeerManagerRegistration peer_manager_registration;
    private PEPeerManager peer_manager;
    private LWSDiskManager disk_manager;
    private LWSDownload pseudo_download;
    private LWSTorrent torrent_facade;
    private TRTrackerAnnouncer announcer;
    private TOTorrent actual_torrent;
    private boolean is_running;
    private long last_activity_time;
    private int activation_state = 0;

    protected LightWeightSeed(LightWeightSeedManager lightWeightSeedManager, String string, HashWrapper hashWrapper, URL uRL, File file, LightWeightSeedAdapter lightWeightSeedAdapter) {
        this.manager = lightWeightSeedManager;
        this.name = string;
        this.hash = hashWrapper;
        this.announce_url = uRL;
        this.data_location = file;
        this.adapter = lightWeightSeedAdapter;
    }

    protected String getName() {
        return this.name + "/" + ByteFormatter.encodeString(this.hash.getBytes());
    }

    protected Torrent getTorrent() {
        return new TorrentImpl(this.getTOTorrent(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TOTorrent getTOTorrent(boolean bl) {
        if (bl) {
            LightWeightSeed lightWeightSeed = this;
            synchronized (lightWeightSeed) {
                if (this.actual_torrent == null) {
                    try {
                        this.actual_torrent = this.adapter.getTorrent(this.hash.getBytes(), this.announce_url, this.data_location);
                    }
                    catch (Throwable throwable) {
                        this.log("Failed to get torrent", throwable);
                    }
                    if (this.actual_torrent == null) {
                        throw new RuntimeException("Torrent not available");
                    }
                }
                return this.actual_torrent;
            }
        }
        return this.torrent_facade;
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    public URL getAnnounceURL() {
        return this.announce_url;
    }

    public File getDataLocation() {
        return this.data_location;
    }

    protected long getSize() {
        return this.data_location.length();
    }

    public boolean isPeerSourceEnabled(String string) {
        return true;
    }

    public boolean manualRoute(NetworkConnection networkConnection) {
        return false;
    }

    public byte[][] getSecrets() {
        return new byte[][]{this.hash.getBytes()};
    }

    public boolean activateRequest(InetSocketAddress inetSocketAddress) {
        this.ensureActive("Incoming[" + inetSocketAddress.getAddress().getHostAddress() + "]", (byte)4);
        return true;
    }

    public void deactivateRequest(InetSocketAddress inetSocketAddress) {
    }

    public String getDescription() {
        return "LWS: " + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void start() {
        this.log("Start");
        if (this.is_running) {
            this.log("Start of '" + this.getString() + "' failed - already running");
            return;
        }
        if (this.peer_manager_registration != null) {
            this.log("Start of '" + this.getString() + "' failed - router already registered");
            return;
        }
        if (this.pseudo_download != null) {
            this.log("Start of '" + this.getString() + "' failed - pseudo download already registered");
            return;
        }
        if (this.disk_manager != null) {
            this.log("Start of '" + this.getString() + "' failed - disk manager already started");
            return;
        }
        if (this.peer_manager != null) {
            this.log("Start of '" + this.getString() + "' failed - peer manager already started");
            return;
        }
        try {
            try {
                if (this.torrent_facade == null) {
                    this.torrent_facade = new LWSTorrent(this);
                }
                this.peer_manager_registration = PeerManager.getSingleton().registerLegacyManager(this.hash, this);
                this.announcer = this.createAnnouncer();
                this.pseudo_download = new LWSDownload(this, this.announcer);
                this.manager.addToDHTTracker(this.pseudo_download);
                this.is_running = true;
                this.last_activity_time = SystemTime.getMonotonousTime();
            }
            catch (Throwable throwable) {
                this.log("Start of '" + this.getString() + "' failed", throwable);
                Object var3_2 = null;
                if (this.is_running) {
                    this.log("Started " + this.getString());
                } else {
                    this.stop();
                }
            }
            Object var3_1 = null;
            if (this.is_running) {
                this.log("Started " + this.getString());
            } else {
                this.stop();
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (this.is_running) {
                this.log("Started " + this.getString());
            } else {
                this.stop();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void stop() {
        this.log("Stop");
        try {
            if (this.disk_manager != null) {
                this.disk_manager.stop(false);
                this.disk_manager = null;
            }
            if (this.peer_manager != null) {
                this.peer_manager.stopAll();
                this.peer_manager = null;
            }
            if (this.pseudo_download != null) {
                this.manager.removeFromDHTTracker(this.pseudo_download);
                this.pseudo_download = null;
            }
            if (this.announcer != null) {
                this.announcer.stop(false);
                this.announcer.destroy();
                this.announcer = null;
            }
            if (this.peer_manager_registration != null) {
                this.peer_manager_registration.unregister();
                this.peer_manager_registration = null;
            }
            Object var2_1 = null;
            this.is_running = false;
            this.activation_state = 0;
            this.log("Stopped " + this.getString());
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.is_running = false;
            this.activation_state = 0;
            this.log("Stopped " + this.getString());
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void activate(String string, byte by) {
        this.log("Activate: " + by + "/" + string);
        if (this.activation_state != 0) {
            return;
        }
        try {
            block9: {
                try {
                    this.disk_manager = new LWSDiskManager(this, this.data_location);
                    this.disk_manager.start();
                    if (this.disk_manager.getState() != 4) {
                        this.log("Start of '" + this.getString() + "' failed, disk manager failed = " + this.disk_manager.getErrorMessage());
                        break block9;
                    }
                    this.peer_manager = PEPeerManagerFactory.create(this.announcer.getPeerId(), new LWSPeerManagerAdapter(this, this.peer_manager_registration), this.disk_manager);
                    this.peer_manager.addListener(new PEPeerManagerListener(){

                        public void peerAdded(PEPeerManager pEPeerManager, PEPeer pEPeer) {
                            LightWeightSeed.this.last_activity_time = SystemTime.getMonotonousTime();
                        }

                        public void peerRemoved(PEPeerManager pEPeerManager, PEPeer pEPeer) {
                            LightWeightSeed.this.last_activity_time = SystemTime.getMonotonousTime();
                        }

                        public void peerDiscovered(PEPeerManager pEPeerManager, PeerItem peerItem, PEPeer pEPeer) {
                        }

                        public void pieceAdded(PEPeerManager pEPeerManager, PEPiece pEPiece, PEPeer pEPeer) {
                        }

                        public void pieceRemoved(PEPeerManager pEPeerManager, PEPiece pEPiece) {
                        }

                        public void peerSentBadData(PEPeerManager pEPeerManager, PEPeer pEPeer, int n) {
                        }

                        public void destroyed() {
                        }
                    });
                    this.peer_manager.start();
                    this.announcer.update(true);
                    this.activation_state = by;
                    this.last_activity_time = SystemTime.getMonotonousTime();
                }
                catch (Throwable throwable) {
                    this.log("Activation of '" + this.getString() + "' failed", throwable);
                    Object var5_4 = null;
                    if (this.activation_state == 0) {
                        this.deactivate();
                    }
                }
            }
            Object var5_3 = null;
            if (this.activation_state == 0) {
                this.deactivate();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.activation_state == 0) {
                this.deactivate();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deactivate() {
        this.log("Deactivate");
        try {
            if (this.disk_manager != null) {
                this.disk_manager.stop(false);
                this.disk_manager = null;
            }
            if (this.peer_manager != null) {
                this.peer_manager.stopAll();
                this.peer_manager = null;
            }
            Object var2_1 = null;
            this.activation_state = 0;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.activation_state = 0;
            throw throwable;
        }
    }

    protected synchronized TRTrackerAnnouncer createAnnouncer() throws TRTrackerAnnouncerException {
        TRTrackerAnnouncer tRTrackerAnnouncer = TRTrackerAnnouncerFactory.create((TOTorrent)this.torrent_facade, true);
        tRTrackerAnnouncer.addListener(new TRTrackerAnnouncerListener(){

            public void receivedTrackerResponse(TRTrackerAnnouncerResponse tRTrackerAnnouncerResponse) {
                TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = tRTrackerAnnouncerResponse.getPeers();
                if (tRTrackerAnnouncerResponsePeerArray != null && tRTrackerAnnouncerResponsePeerArray.length > 0) {
                    LightWeightSeed.this.ensureActive("Tracker[" + tRTrackerAnnouncerResponsePeerArray[0].getAddress() + "]", (byte)7);
                } else if (tRTrackerAnnouncerResponse.getScrapeIncompleteCount() > 0) {
                    LightWeightSeed.this.ensureActive("Tracker[scrape]", (byte)8);
                }
                PEPeerManager pEPeerManager = LightWeightSeed.this.peer_manager;
                if (pEPeerManager != null) {
                    pEPeerManager.processTrackerResponse(tRTrackerAnnouncerResponse);
                }
            }

            public void urlChanged(TRTrackerAnnouncer tRTrackerAnnouncer, URL uRL, URL uRL2, boolean bl) {
            }

            public void urlRefresh() {
            }
        });
        tRTrackerAnnouncer.setAnnounceDataProvider(new TRTrackerAnnouncerDataProvider(){

            public String getName() {
                return LightWeightSeed.this.getName();
            }

            public long getTotalSent() {
                return 0L;
            }

            public long getTotalReceived() {
                return 0L;
            }

            public long getFailedHashCheck() {
                return 0L;
            }

            public long getRemaining() {
                return 0L;
            }

            public String getExtensions() {
                return null;
            }

            public int getMaxNewConnectionsAllowed() {
                PEPeerManager pEPeerManager = LightWeightSeed.this.peer_manager;
                if (pEPeerManager == null) {
                    return 8;
                }
                return PeerUtils.numNewConnectionsAllowed(pEPeerManager.getPeerIdentityDataID(), 0);
            }

            public int getPendingConnectionCount() {
                PEPeerManager pEPeerManager = LightWeightSeed.this.peer_manager;
                if (pEPeerManager == null) {
                    return 0;
                }
                return pEPeerManager.getPendingPeerCount();
            }

            public int getConnectedConnectionCount() {
                PEPeerManager pEPeerManager = LightWeightSeed.this.peer_manager;
                if (pEPeerManager == null) {
                    return 0;
                }
                return pEPeerManager.getNbPeers() + pEPeerManager.getNbSeeds();
            }

            public int getUploadSpeedKBSec(boolean bl) {
                return 0;
            }

            public int getCryptoLevel() {
                return 0;
            }

            public boolean isPeerSourceEnabled(String string) {
                return true;
            }

            public void setPeerSources(String[] stringArray) {
            }
        });
        return tRTrackerAnnouncer;
    }

    protected synchronized void ensureActive(String string, byte by) {
        if (this.is_running && this.activation_state == 0) {
            this.activate(string, by);
        }
    }

    protected synchronized void checkDeactivation() {
        if (this.activation_state == 0) {
            return;
        }
        if (this.peer_manager == null) {
            this.activation_state = 5;
            return;
        }
        if (this.peer_manager.getNbPeers() > 0) {
            this.activation_state = 2;
            return;
        }
        long l = SystemTime.getMonotonousTime();
        long l2 = l - this.last_activity_time;
        if (this.peer_manager.hasPotentialConnections() && l2 < 900000L) {
            this.activation_state = 3;
            return;
        }
        if (l2 >= 300000L) {
            this.deactivate();
        } else {
            this.activation_state = 6;
        }
    }

    public void enqueueReadRequest(PEPeer pEPeer, DiskManagerReadRequest diskManagerReadRequest, DiskManagerReadRequestListener diskManagerReadRequestListener) {
        LWSDiskManager lWSDiskManager = this.disk_manager;
        if (lWSDiskManager == null) {
            diskManagerReadRequestListener.readFailed(diskManagerReadRequest, new Throwable("download is stopped"));
        } else {
            lWSDiskManager.enqueueReadRequest(diskManagerReadRequest, diskManagerReadRequestListener);
        }
    }

    public void remove() {
        this.manager.remove(this);
    }

    public String getRelationText() {
        return "LWS: '" + this.getName() + "'";
    }

    public Object[] getQueryableInterfaces() {
        return new Object[0];
    }

    public LogRelation getRelation() {
        return this;
    }

    protected String getString() {
        return this.getName();
    }

    protected void log(String string) {
        Logger.log(new LogEvent(this, LogIDs.CORE, string));
    }

    protected void log(String string, Throwable throwable) {
        Logger.log(new LogEvent((Object)this, LogIDs.CORE, string, throwable));
    }
}

