/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerFileInfoStream
implements DiskManagerFileInfo {
    private StreamFactory stream_factory;
    private File save_to;
    private byte[] hash;
    private context current_context;
    private Object lock = this;

    public DiskManagerFileInfoStream(StreamFactory streamFactory, File file) {
        this.stream_factory = streamFactory;
        this.save_to = file;
        try {
            this.hash = new SHA1Simple().calculateHash(file.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isComplete() {
        Object object = this.lock;
        synchronized (object) {
            return this.save_to.exists();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            if (this.current_context != null) {
                this.current_context.destroy(new Exception("Reset"));
            }
            this.save_to.delete();
        }
    }

    public void setPriority(boolean bl) {
    }

    public void setSkipped(boolean bl) {
        throw new RuntimeException("Not supported");
    }

    public int getNumericPriorty() {
        return 0;
    }

    public void setNumericPriority(int n) {
        throw new RuntimeException("Not supported");
    }

    public void setDeleted(boolean bl) {
    }

    public void setLink(File file) {
        throw new RuntimeException("Not supported");
    }

    public File getLink() {
        return null;
    }

    public int getAccessMode() {
        return 1;
    }

    public long getDownloaded() {
        return this.getLength();
    }

    public long getLength() {
        return -1L;
    }

    public File getFile() {
        return this.save_to;
    }

    public File getFile(boolean bl) {
        return this.save_to;
    }

    public int getIndex() {
        return 0;
    }

    public int getFirstPieceNumber() {
        return 0;
    }

    public long getPieceSize() {
        return 32768L;
    }

    public int getNumPieces() {
        return -1;
    }

    public boolean isPriority() {
        return false;
    }

    public boolean isSkipped() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public byte[] getDownloadHash() throws DownloadException {
        return this.hash;
    }

    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerChannel createChannel() throws DownloadException {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.current_context == null) {
                    this.current_context = new context();
                }
                return this.current_context.createChannel();
            }
        }
        catch (Throwable throwable) {
            throw new DownloadException("Channel creation failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyed(context context2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.current_context == context2) {
                this.current_context = null;
            }
        }
        this.stream_factory.destroyed(context2);
    }

    public static interface StreamFactory {
        public StreamDetails getStream(Object var1) throws IOException;

        public void destroyed(Object var1);

        public static interface StreamDetails {
            public InputStream getStream();

            public boolean hasFailed();
        }
    }

    protected class context {
        private RandomAccessFile raf;
        private StreamFactory.StreamDetails stream_details;
        private boolean stream_got_eof;
        private List<channel> channels = new ArrayList<channel>();
        private List<AESemaphore> waiters = new ArrayList<AESemaphore>();
        private boolean context_destroyed;

        protected context() throws Exception {
            if (DiskManagerFileInfoStream.this.save_to.exists()) {
                this.raf = new RandomAccessFile(DiskManagerFileInfoStream.this.save_to, "r");
                this.stream_got_eof = true;
            } else {
                final File file = new File(DiskManagerFileInfoStream.this.save_to.getAbsolutePath() + "._tmp_");
                this.raf = new RandomAccessFile(file, "rw");
                this.stream_details = DiskManagerFileInfoStream.this.stream_factory.getStream(this);
                final InputStream inputStream = this.stream_details.getStream();
                new AEThread2("DMS:reader", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    public void run() {
                        block38: {
                            byte[] byArray = new byte[131072];
                            while (true) {
                                int n;
                                if ((n = inputStream.read(byArray)) <= 0) {
                                    if (context.this.stream_details.hasFailed()) {
                                        throw new IOException("Stream failed");
                                    }
                                    break;
                                }
                                Object object = DiskManagerFileInfoStream.this.lock;
                                synchronized (object) {
                                    context.this.raf.seek(context.this.raf.length());
                                    context.this.raf.write(byArray, 0, n);
                                    for (AESemaphore aESemaphore : context.this.waiters) {
                                        aESemaphore.release();
                                    }
                                }
                            }
                            context.this.stream_got_eof = true;
                            Object var9_8 = null;
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            throwable = null;
                            Object object = DiskManagerFileInfoStream.this.lock;
                            synchronized (object) {
                                context.this.stream_details = null;
                                if (context.this.stream_got_eof) {
                                    try {
                                        context.this.raf.close();
                                        DiskManagerFileInfoStream.this.save_to.delete();
                                        file.renameTo(DiskManagerFileInfoStream.this.save_to);
                                        context.this.raf = new RandomAccessFile(DiskManagerFileInfoStream.this.save_to, "r");
                                    }
                                    catch (Throwable throwable) {
                                        throwable = throwable;
                                    }
                                }
                            }
                            if (throwable != null) {
                                context.this.destroy(throwable);
                            }
                            break block38;
                            {
                                catch (Throwable throwable) {
                                    context.this.destroy(throwable);
                                    Object var9_9 = null;
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Throwable throwable2) {
                                        // empty catch block
                                    }
                                    throwable2 = null;
                                    Object object2 = DiskManagerFileInfoStream.this.lock;
                                    synchronized (object2) {
                                        context.this.stream_details = null;
                                        if (context.this.stream_got_eof) {
                                            try {
                                                context.this.raf.close();
                                                DiskManagerFileInfoStream.this.save_to.delete();
                                                file.renameTo(DiskManagerFileInfoStream.this.save_to);
                                                context.this.raf = new RandomAccessFile(DiskManagerFileInfoStream.this.save_to, "r");
                                            }
                                            catch (Throwable throwable3) {
                                                throwable2 = throwable3;
                                            }
                                        }
                                    }
                                    if (throwable2 != null) {
                                        context.this.destroy(throwable2);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var9_10 = null;
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    // empty catch block
                                }
                                throwable4 = null;
                                Object object3 = DiskManagerFileInfoStream.this.lock;
                                synchronized (object3) {
                                    context.this.stream_details = null;
                                    if (context.this.stream_got_eof) {
                                        try {
                                            context.this.raf.close();
                                            DiskManagerFileInfoStream.this.save_to.delete();
                                            file.renameTo(DiskManagerFileInfoStream.this.save_to);
                                            context.this.raf = new RandomAccessFile(DiskManagerFileInfoStream.this.save_to, "r");
                                        }
                                        catch (Throwable throwable5) {
                                            throwable4 = throwable5;
                                        }
                                    }
                                }
                                if (throwable4 != null) {
                                    context.this.destroy(throwable4);
                                }
                                throw throwable;
                            }
                        }
                    }
                }.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int read(byte[] byArray, long l, int n) throws IOException {
            AESemaphore aESemaphore;
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                if (this.raf.length() > l) {
                    this.raf.seek(l);
                    return this.raf.read(byArray, 0, n);
                }
                if (this.stream_details == null) {
                    if (this.stream_got_eof) {
                        return -1;
                    }
                    throw new IOException("Premature end of stream (read)");
                }
                aESemaphore = new AESemaphore("DMS:block");
                this.waiters.add(aESemaphore);
            }
            try {
                aESemaphore.reserve(1000L);
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                Object object2 = DiskManagerFileInfoStream.this.lock;
                synchronized (object2) {
                    this.waiters.remove(aESemaphore);
                }
                throw throwable;
            }
            Object object3 = DiskManagerFileInfoStream.this.lock;
            synchronized (object3) {
                this.waiters.remove(aESemaphore);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected channel createChannel() {
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                channel channel2 = new channel();
                this.channels.add(channel2);
                return channel2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeChannel(channel channel2) {
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                this.channels.remove(channel2);
                if (this.channels.size() == 0 && DiskManagerFileInfoStream.this.save_to.exists()) {
                    this.destroy(null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy(Throwable throwable) {
            if (throwable != null) {
                Debug.out(throwable);
            }
            Object object = DiskManagerFileInfoStream.this.lock;
            synchronized (object) {
                if (this.context_destroyed) {
                    return;
                }
                this.context_destroyed = true;
                if (this.channels != null) {
                    ArrayList<channel> arrayList = new ArrayList<channel>(this.channels);
                    for (channel channel2 : arrayList) {
                        channel2.destroy();
                    }
                }
                if (this.raf != null) {
                    try {
                        this.raf.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.raf = null;
                }
                if (this.stream_details != null) {
                    try {
                        this.stream_details.getStream().close();
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                    this.stream_details = null;
                }
                if (throwable != null) {
                    DiskManagerFileInfoStream.this.save_to.delete();
                }
            }
            DiskManagerFileInfoStream.this.destroyed(this);
        }

        protected class channel
        implements DiskManagerChannel {
            private volatile boolean channel_destroyed;
            private volatile long channel_position;

            protected channel() {
            }

            public DiskManagerRequest createRequest() {
                return new request();
            }

            public DiskManagerFileInfo getFile() {
                return DiskManagerFileInfoStream.this;
            }

            public long getPosition() {
                return this.channel_position;
            }

            public boolean isDestroyed() {
                return this.channel_destroyed;
            }

            public void destroy() {
                this.channel_destroyed = true;
                context.this.removeChannel(this);
            }

            protected class request
            implements DiskManagerRequest {
                private long offset;
                private long length;
                private long position;
                private int max_read_chunk = 131072;
                private volatile boolean request_cancelled;
                private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

                protected request() {
                }

                public void setType(int n) {
                    if (n != 1) {
                        throw new RuntimeException("Not supported");
                    }
                }

                public void setOffset(long l) {
                    this.offset = l;
                }

                public void setLength(long l) {
                    this.length = l == -1L ? Long.MAX_VALUE : l;
                }

                public void setMaximumReadChunkSize(int n) {
                    if (n > 16384) {
                        this.max_read_chunk = n;
                    }
                }

                public long getAvailableBytes() {
                    return this.getRemaining();
                }

                public long getRemaining() {
                    return this.length == Long.MAX_VALUE ? this.length : this.offset + this.length - this.position;
                }

                public void run() {
                    try {
                        byte[] byArray = new byte[this.max_read_chunk];
                        long l = this.length;
                        long l2 = this.offset;
                        while (l > 0L) {
                            if (this.request_cancelled) {
                                throw new Exception("Cancelled");
                            }
                            if (channel.this.channel_destroyed) {
                                throw new Exception("Destroyed");
                            }
                            int n = (int)Math.min(l, (long)this.max_read_chunk);
                            int n2 = context.this.read(byArray, l2, n);
                            if (n2 == -1) {
                                if (this.length != Long.MAX_VALUE) {
                                    throw new Exception("Premature end of stream (complete)");
                                }
                                break;
                            }
                            if (n2 == 0) {
                                this.sendEvent(new event(l2));
                                continue;
                            }
                            this.sendEvent(new event(new PooledByteBufferImpl(byArray, 0, n2), l2, n2));
                            l -= (long)n2;
                            l2 += (long)n2;
                        }
                    }
                    catch (Throwable throwable) {
                        this.sendEvent(new event(throwable));
                    }
                }

                public void cancel() {
                    this.request_cancelled = true;
                }

                public void setUserAgent(String string) {
                }

                protected void sendEvent(event event2) {
                    for (DiskManagerListener diskManagerListener : this.listeners) {
                        diskManagerListener.eventOccurred(event2);
                    }
                }

                public void addListener(DiskManagerListener diskManagerListener) {
                    this.listeners.add(diskManagerListener);
                }

                public void removeListener(DiskManagerListener diskManagerListener) {
                    this.listeners.remove(diskManagerListener);
                }

                protected class event
                implements DiskManagerEvent {
                    private int event_type;
                    private Throwable error;
                    private PooledByteBuffer buffer;
                    private long event_offset;
                    private int event_length;

                    protected event(Throwable throwable) {
                        this.event_type = 2;
                        this.error = throwable;
                    }

                    protected event(long l) {
                        this.event_type = 3;
                        this.event_offset = l;
                        channel.this.channel_position = l;
                    }

                    protected event(PooledByteBuffer pooledByteBuffer, long l, int n) {
                        this.event_type = 1;
                        this.buffer = pooledByteBuffer;
                        this.event_offset = l;
                        this.event_length = n;
                        channel.this.channel_position = l + (long)n - 1L;
                    }

                    public int getType() {
                        return this.event_type;
                    }

                    public DiskManagerRequest getRequest() {
                        return request.this;
                    }

                    public long getOffset() {
                        return this.event_offset;
                    }

                    public int getLength() {
                        return this.event_length;
                    }

                    public PooledByteBuffer getBuffer() {
                        return this.buffer;
                    }

                    public Throwable getFailure() {
                        return this.error;
                    }
                }
            }
        }
    }
}

