/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerFileInfoFile
implements DiskManagerFileInfo {
    private byte[] hash;
    private File file;

    public DiskManagerFileInfoFile(File file) {
        this.file = file;
        try {
            this.hash = new SHA1Simple().calculateHash(this.file.getAbsolutePath().getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    public void setPriority(boolean bl) {
    }

    public int getNumericPriorty() {
        return 0;
    }

    public void setNumericPriority(int n) {
        throw new RuntimeException("Not supported");
    }

    public void setSkipped(boolean bl) {
        throw new RuntimeException("Not supported");
    }

    public void setDeleted(boolean bl) {
    }

    public void setLink(File file) {
        throw new RuntimeException("Not supported");
    }

    public File getLink() {
        return null;
    }

    public int getAccessMode() {
        return 1;
    }

    public long getDownloaded() {
        return this.getLength();
    }

    public long getLength() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    public File getFile(boolean bl) {
        return this.file;
    }

    public int getIndex() {
        return 0;
    }

    public int getFirstPieceNumber() {
        return 0;
    }

    public long getPieceSize() {
        return 32768L;
    }

    public int getNumPieces() {
        long l = this.getPieceSize();
        return (int)((this.getLength() + l - 1L) / l);
    }

    public boolean isPriority() {
        return false;
    }

    public boolean isSkipped() {
        return false;
    }

    public boolean isDeleted() {
        return false;
    }

    public byte[] getDownloadHash() {
        return this.hash;
    }

    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    public DiskManagerChannel createChannel() throws DownloadException {
        return new channel();
    }

    protected class channel
    implements DiskManagerChannel {
        private volatile boolean channel_destroyed;
        private volatile long channel_position;

        protected channel() {
        }

        public DiskManagerRequest createRequest() {
            return new request();
        }

        public DiskManagerFileInfo getFile() {
            return DiskManagerFileInfoFile.this;
        }

        public long getPosition() {
            return this.channel_position;
        }

        public boolean isDestroyed() {
            return this.channel_destroyed;
        }

        public void destroy() {
            this.channel_destroyed = true;
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean cancelled;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            public void setType(int n) {
                if (n != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            public void setOffset(long l) {
                this.offset = l;
            }

            public void setLength(long l) {
                if (l < 0L) {
                    throw new RuntimeException("Illegal argument");
                }
                this.length = l;
            }

            public void setMaximumReadChunkSize(int n) {
                this.max_read_chunk = n;
            }

            public long getAvailableBytes() {
                return this.getRemaining();
            }

            public long getRemaining() {
                return this.offset + this.length - this.position;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                RandomAccessFile randomAccessFile = null;
                randomAccessFile = new RandomAccessFile(DiskManagerFileInfoFile.this.file, "r");
                randomAccessFile.seek(this.offset);
                byte[] byArray = new byte[this.max_read_chunk];
                long l = this.length;
                long l2 = this.offset;
                while (l > 0L) {
                    if (this.cancelled) {
                        throw new Exception("Cancelled");
                    }
                    if (channel.this.channel_destroyed) {
                        throw new Exception("Destroyed");
                    }
                    int n = (int)Math.min(l, (long)this.max_read_chunk);
                    int n2 = randomAccessFile.read(byArray, 0, n);
                    this.sendEvent(new event(new PooledByteBufferImpl(byArray, 0, n2), l2, n2));
                    l -= (long)n2;
                    l2 += (long)n2;
                }
                Object var10_8 = null;
                if (randomAccessFile == null) return;
                try {
                    randomAccessFile.close();
                    return;
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                }
                return;
                {
                    catch (Throwable throwable) {
                        this.sendEvent(new event(throwable));
                        Object var10_9 = null;
                        if (randomAccessFile == null) return;
                        try {
                            randomAccessFile.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            Debug.out(throwable2);
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    if (randomAccessFile == null) throw throwable;
                    try {
                        randomAccessFile.close();
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        Debug.out(throwable3);
                    }
                    throw throwable;
                }
            }

            public void cancel() {
                this.cancelled = true;
            }

            public void setUserAgent(String string) {
            }

            protected void sendEvent(event event2) {
                for (DiskManagerListener diskManagerListener : this.listeners) {
                    diskManagerListener.eventOccurred(event2);
                }
            }

            public void addListener(DiskManagerListener diskManagerListener) {
                this.listeners.add(diskManagerListener);
            }

            public void removeListener(DiskManagerListener diskManagerListener) {
                this.listeners.remove(diskManagerListener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable throwable) {
                    this.event_type = 2;
                    this.error = throwable;
                }

                protected event(PooledByteBuffer pooledByteBuffer, long l, int n) {
                    this.event_type = 1;
                    this.buffer = pooledByteBuffer;
                    this.event_offset = l;
                    this.event_length = n;
                    channel.this.channel_position = l + (long)n - 1L;
                }

                public int getType() {
                    return this.event_type;
                }

                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                public long getOffset() {
                    return this.event_offset;
                }

                public int getLength() {
                    return this.event_length;
                }

                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

