/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;

public class CacheFileManagerStatsImpl
implements CacheFileManagerStats {
    protected CacheFileManagerImpl manager;
    protected Average cache_read_average = Average.getInstance(1000, 10);
    protected Average cache_write_average = Average.getInstance(1000, 10);
    protected Average file_read_average = Average.getInstance(1000, 10);
    protected Average file_write_average = Average.getInstance(1000, 5);
    protected long last_cache_read;
    protected long last_cache_write;
    protected long last_file_read;
    protected long last_file_write;
    protected AEMonitor this_mon = new AEMonitor("CacheFileManagerStats");

    protected CacheFileManagerStatsImpl(CacheFileManagerImpl cacheFileManagerImpl) {
        this.manager = cacheFileManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update() {
        try {
            this.this_mon.enter();
            long l = this.manager.getBytesReadFromCache();
            long l2 = l - this.last_cache_read;
            this.last_cache_read = l;
            this.cache_read_average.addValue(l2);
            long l3 = this.manager.getBytesWrittenToCache();
            long l4 = l3 - this.last_cache_write;
            this.last_cache_write = l3;
            this.cache_write_average.addValue(l4);
            long l5 = this.manager.getBytesReadFromFile();
            long l6 = l5 - this.last_file_read;
            this.last_file_read = l5;
            this.file_read_average.addValue(l6);
            long l7 = this.manager.getBytesWrittenToFile();
            long l8 = l7 - this.last_file_write;
            this.last_file_write = l7;
            this.file_write_average.addValue(l8);
            Object var18_9 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var18_10 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public long getSize() {
        return this.manager.getCacheSize();
    }

    public long getUsedSize() {
        return this.manager.getCacheUsed();
    }

    public long getBytesWrittenToCache() {
        return this.manager.getBytesWrittenToCache();
    }

    public long getBytesWrittenToFile() {
        return this.manager.getBytesWrittenToFile();
    }

    public long getBytesReadFromCache() {
        return this.manager.getBytesReadFromCache();
    }

    public long getBytesReadFromFile() {
        return this.manager.getBytesReadFromFile();
    }

    public long getAverageBytesWrittenToCache() {
        return this.cache_write_average.getAverage();
    }

    public long getAverageBytesWrittenToFile() {
        return this.file_write_average.getAverage();
    }

    public long getAverageBytesReadFromCache() {
        return this.cache_read_average.getAverage();
    }

    public long getAverageBytesReadFromFile() {
        return this.file_read_average.getAverage();
    }

    public long getCacheReadCount() {
        return this.manager.getCacheReadCount();
    }

    public long getCacheWriteCount() {
        return this.manager.getCacheWriteCount();
    }

    public long getFileReadCount() {
        return this.manager.getFileReadCount();
    }

    public long getFileWriteCount() {
        return this.manager.getFileWriteCount();
    }

    public boolean[] getBytesInCache(TOTorrent tOTorrent, long[] lArray, long[] lArray2) {
        return this.manager.getBytesInCache(tOTorrent, lArray, lArray2);
    }
}

