/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTUDPPacketRequestQueryStorage
extends DHTUDPPacketRequest {
    protected static final int SPACE = 1356;
    private int header_length;
    private List<Object[]> keys;

    public DHTUDPPacketRequestQueryStorage(DHTTransportUDPImpl dHTTransportUDPImpl, long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportUDPContactImpl dHTTransportUDPContactImpl2) {
        super(dHTTransportUDPImpl, 1038, l, dHTTransportUDPContactImpl, dHTTransportUDPContactImpl2);
    }

    protected DHTUDPPacketRequestQueryStorage(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, DataInputStream dataInputStream, long l, int n) throws IOException {
        super(dHTUDPPacketNetworkHandler, dataInputStream, 1038, l, n);
        this.header_length = dataInputStream.readByte() & 0xFF;
        int n2 = dataInputStream.readShort();
        this.keys = new ArrayList<Object[]>(n2);
        for (int i = 0; i < n2; ++i) {
            int n3 = dataInputStream.readByte() & 0xFF;
            byte[] byArray = new byte[n3];
            dataInputStream.read(byArray);
            int n4 = dataInputStream.readShort();
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(n4);
            this.keys.add(new Object[]{byArray, arrayList});
            int n5 = this.header_length - n3;
            for (int j = 0; j < n4; ++j) {
                byte[] byArray2 = new byte[n5];
                dataInputStream.read(byArray2);
                arrayList.add(byArray2);
            }
        }
        super.postDeserialise(dataInputStream);
    }

    @Override
    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.writeByte(this.header_length & 0xFF);
        dataOutputStream.writeShort(this.keys.size());
        for (Object[] objectArray : this.keys) {
            byte[] byArray = (byte[])objectArray[0];
            dataOutputStream.writeByte(byArray.length);
            dataOutputStream.write(byArray);
            List list = (List)objectArray[1];
            dataOutputStream.writeShort(list.size());
            for (byte[] byArray2 : list) {
                dataOutputStream.write(byArray2);
            }
        }
        super.postSerialise(dataOutputStream);
    }

    protected void setDetails(int n, List<Object[]> list) {
        this.header_length = n;
        this.keys = list;
    }

    protected int getHeaderLength() {
        return this.header_length;
    }

    protected List<Object[]> getKeys() {
        return this.keys;
    }

    @Override
    public String getString() {
        return super.getString();
    }
}

