/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacket;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.SystemTime;

public class DHTUDPPacketRequest
extends PRUDPPacketRequest
implements DHTUDPPacket {
    public static final int DHT_HEADER_SIZE = 41;
    private DHTTransportUDPImpl transport;
    private byte protocol_version;
    private byte vendor_id = (byte)-1;
    private int network;
    private byte originator_version;
    private long originator_time;
    private InetSocketAddress originator_address;
    private int originator_instance_id;
    private long skew;

    public DHTUDPPacketRequest(DHTTransportUDPImpl dHTTransportUDPImpl, int n, long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportUDPContactImpl dHTTransportUDPContactImpl2) {
        super(n, l);
        this.transport = dHTTransportUDPImpl;
        this.protocol_version = dHTTransportUDPContactImpl2.getProtocolVersion();
        if (this.protocol_version > dHTTransportUDPImpl.getProtocolVersion()) {
            this.protocol_version = dHTTransportUDPImpl.getProtocolVersion();
        }
        this.originator_address = dHTTransportUDPContactImpl.getExternalAddress();
        this.originator_instance_id = dHTTransportUDPContactImpl.getInstanceID();
        this.originator_time = SystemTime.getCurrentTime();
    }

    protected DHTUDPPacketRequest(DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler, DataInputStream dataInputStream, int n, long l, int n2) throws IOException {
        super(n, l, n2);
        this.protocol_version = dataInputStream.readByte();
        if (this.protocol_version >= 14) {
            this.vendor_id = dataInputStream.readByte();
        }
        if (this.protocol_version >= 9) {
            this.network = dataInputStream.readInt();
        }
        if (this.protocol_version < (this.network == 1 ? (byte)50 : 22)) {
            throw new IOException("Invalid DHT protocol version, please update Azureus");
        }
        this.transport = dHTUDPPacketNetworkHandler.getTransport(this);
        this.originator_version = this.protocol_version >= 9 ? dataInputStream.readByte() : this.protocol_version;
        this.originator_address = DHTUDPUtils.deserialiseAddress(dataInputStream);
        this.originator_instance_id = dataInputStream.readInt();
        this.originator_time = dataInputStream.readLong();
        this.skew = SystemTime.getCurrentTime() - this.originator_time;
        this.transport.recordSkew(this.originator_address, this.skew);
    }

    protected void postDeserialise(DataInputStream dataInputStream) throws IOException {
        if (this.protocol_version < 9) {
            this.originator_version = dataInputStream.available() > 0 ? dataInputStream.readByte() : this.protocol_version;
            if (this.originator_version > this.getTransport().getProtocolVersion()) {
                this.originator_version = this.getTransport().getProtocolVersion();
            }
        }
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        super.serialise(dataOutputStream);
        dataOutputStream.writeByte(this.protocol_version);
        if (this.protocol_version >= 14) {
            dataOutputStream.writeByte(0);
        }
        if (this.protocol_version >= 9) {
            dataOutputStream.writeInt(this.network);
        }
        if (this.protocol_version >= 9) {
            dataOutputStream.writeByte(this.getTransport().getProtocolVersion());
        }
        try {
            DHTUDPUtils.serialiseAddress(dataOutputStream, this.originator_address);
        }
        catch (DHTTransportException dHTTransportException) {
            throw new IOException(dHTTransportException.getMessage());
        }
        dataOutputStream.writeInt(this.originator_instance_id);
        dataOutputStream.writeLong(this.originator_time);
    }

    protected void postSerialise(DataOutputStream dataOutputStream) throws IOException {
        if (this.protocol_version < 9) {
            dataOutputStream.writeByte(this.getTransport().getProtocolVersion());
        }
    }

    public DHTTransportUDPImpl getTransport() {
        return this.transport;
    }

    protected long getClockSkew() {
        return this.skew;
    }

    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    protected byte getVendorID() {
        return this.vendor_id;
    }

    public int getNetwork() {
        return this.network;
    }

    public void setNetwork(int n) {
        this.network = n;
    }

    protected byte getOriginatorVersion() {
        return this.originator_version;
    }

    protected InetSocketAddress getOriginatorAddress() {
        return this.originator_address;
    }

    protected void setOriginatorAddress(InetSocketAddress inetSocketAddress) {
        this.originator_address = inetSocketAddress;
    }

    protected int getOriginatorInstanceID() {
        return this.originator_instance_id;
    }

    public String getString() {
        return super.getString() + ",[prot=" + this.protocol_version + ",ven=" + this.vendor_id + ",net=" + this.network + ",ov=" + this.originator_version + "]";
    }
}

