/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketData;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyError;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class DHTUDPPacketHelper {
    public static final int PACKET_MAX_BYTES = 1400;
    public static final int ACT_REQUEST_PING = 1024;
    public static final int ACT_REPLY_PING = 1025;
    public static final int ACT_REQUEST_STORE = 1026;
    public static final int ACT_REPLY_STORE = 1027;
    public static final int ACT_REQUEST_FIND_NODE = 1028;
    public static final int ACT_REPLY_FIND_NODE = 1029;
    public static final int ACT_REQUEST_FIND_VALUE = 1030;
    public static final int ACT_REPLY_FIND_VALUE = 1031;
    public static final int ACT_REPLY_ERROR = 1032;
    public static final int ACT_REPLY_STATS = 1033;
    public static final int ACT_REQUEST_STATS = 1034;
    public static final int ACT_DATA = 1035;
    public static final int ACT_REQUEST_KEY_BLOCK = 1036;
    public static final int ACT_REPLY_KEY_BLOCK = 1037;
    public static final int ACT_REQUEST_QUERY_STORE = 1038;
    public static final int ACT_REPLY_QUERY_STORE = 1039;
    private static boolean registered = false;

    protected static void registerCodecs() {
        if (registered) {
            return;
        }
        registered = true;
        PRUDPPacketRequestDecoder pRUDPPacketRequestDecoder = new PRUDPPacketRequestDecoder(){

            public PRUDPPacketRequest decode(PRUDPPacketHandler pRUDPPacketHandler, DataInputStream dataInputStream, long l, int n, int n2) throws IOException {
                if (pRUDPPacketHandler == null) {
                    throw new IOException("No handler available for DHT packet decode");
                }
                DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler = (DHTUDPPacketNetworkHandler)pRUDPPacketHandler.getRequestHandler();
                if (dHTUDPPacketNetworkHandler == null) {
                    throw new IOException("No network handler available for DHT packet decode");
                }
                switch (n) {
                    case 1024: {
                        return new DHTUDPPacketRequestPing(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                    case 1026: {
                        return new DHTUDPPacketRequestStore(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                    case 1028: {
                        return new DHTUDPPacketRequestFindNode(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                    case 1030: {
                        return new DHTUDPPacketRequestFindValue(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                    case 1034: {
                        return new DHTUDPPacketRequestStats(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                    case 1035: {
                        return new DHTUDPPacketData(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                    case 1036: {
                        return new DHTUDPPacketRequestKeyBlock(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                    case 1038: {
                        return new DHTUDPPacketRequestQueryStorage(dHTUDPPacketNetworkHandler, dataInputStream, l, n2);
                    }
                }
                throw new IOException("Unknown action type");
            }
        };
        HashMap<Integer, 1> hashMap = new HashMap<Integer, 1>();
        hashMap.put(new Integer(1024), pRUDPPacketRequestDecoder);
        hashMap.put(new Integer(1026), pRUDPPacketRequestDecoder);
        hashMap.put(new Integer(1028), pRUDPPacketRequestDecoder);
        hashMap.put(new Integer(1030), pRUDPPacketRequestDecoder);
        hashMap.put(new Integer(1034), pRUDPPacketRequestDecoder);
        hashMap.put(new Integer(1035), pRUDPPacketRequestDecoder);
        hashMap.put(new Integer(1036), pRUDPPacketRequestDecoder);
        hashMap.put(new Integer(1038), pRUDPPacketRequestDecoder);
        PRUDPPacketRequest.registerDecoders(hashMap);
        PRUDPPacketReplyDecoder pRUDPPacketReplyDecoder = new PRUDPPacketReplyDecoder(){

            public PRUDPPacketReply decode(PRUDPPacketHandler pRUDPPacketHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n, int n2) throws IOException {
                if (pRUDPPacketHandler == null) {
                    throw new IOException("No handler available for DHT packet decode");
                }
                DHTUDPPacketNetworkHandler dHTUDPPacketNetworkHandler = (DHTUDPPacketNetworkHandler)pRUDPPacketHandler.getRequestHandler();
                if (dHTUDPPacketNetworkHandler == null) {
                    throw new IOException("No network handler available for DHT packet decode");
                }
                switch (n) {
                    case 1025: {
                        return new DHTUDPPacketReplyPing(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                    case 1027: {
                        return new DHTUDPPacketReplyStore(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                    case 1029: {
                        return new DHTUDPPacketReplyFindNode(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                    case 1031: {
                        return new DHTUDPPacketReplyFindValue(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                    case 1032: {
                        return new DHTUDPPacketReplyError(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                    case 1033: {
                        return new DHTUDPPacketReplyStats(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                    case 1037: {
                        return new DHTUDPPacketReplyKeyBlock(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                    case 1039: {
                        return new DHTUDPPacketReplyQueryStorage(dHTUDPPacketNetworkHandler, inetSocketAddress, dataInputStream, n2);
                    }
                }
                throw new IOException("Unknown action type");
            }
        };
        HashMap<Integer, 2> hashMap2 = new HashMap<Integer, 2>();
        hashMap2.put(new Integer(1025), pRUDPPacketReplyDecoder);
        hashMap2.put(new Integer(1027), pRUDPPacketReplyDecoder);
        hashMap2.put(new Integer(1029), pRUDPPacketReplyDecoder);
        hashMap2.put(new Integer(1031), pRUDPPacketReplyDecoder);
        hashMap2.put(new Integer(1032), pRUDPPacketReplyDecoder);
        hashMap2.put(new Integer(1033), pRUDPPacketReplyDecoder);
        hashMap2.put(new Integer(1037), pRUDPPacketReplyDecoder);
        hashMap2.put(new Integer(1039), pRUDPPacketReplyDecoder);
        PRUDPPacketReply.registerDecoders(hashMap2);
    }
}

