/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProvider;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionProviderListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportProgressListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportQueryStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportTransferHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDP;
import com.aelitis.azureus.core.dht.transport.udp.DHTTransportUDPContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPStatsImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketData;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketHelper;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyError;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReplyStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindNode;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestFindValue;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestKeyBlock;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestPing;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestQueryStorage;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStats;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketRequestStore;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandler;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerException;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketHandlerFactory;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketReceiver;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPRequestHandler;
import com.aelitis.azureus.core.dht.transport.util.DHTTransportRequestCounter;
import com.aelitis.azureus.core.util.average.AverageFactory;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTTransportUDPImpl
implements DHTTransportUDP,
DHTUDPRequestHandler {
    public static boolean TEST_EXTERNAL_IP = false;
    public static final int TRANSFER_QUEUE_MAX = 64;
    public static final long MAX_TRANSFER_QUEUE_BYTES = 0x800000L;
    public static final long WRITE_XFER_RESEND_DELAY = 12500L;
    public static final long READ_XFER_REREQUEST_DELAY = 5000L;
    public static final long WRITE_REPLY_TIMEOUT = 60000L;
    public static final int MIN_ADDRESS_CHANGE_PERIOD_INIT_DEFAULT = 300000;
    public static final int MIN_ADDRESS_CHANGE_PERIOD_NEXT_DEFAULT = 600000;
    public static final int STORE_TIMEOUT_MULTIPLIER = 2;
    private static boolean XFER_TRACE = false;
    private String external_address;
    private int min_address_change_period = 300000;
    private byte protocol_version;
    private int network;
    private boolean v6;
    private String ip_override;
    private int port;
    private int max_fails_for_live;
    private int max_fails_for_unknown;
    private long request_timeout;
    private long store_timeout;
    private boolean reachable;
    private boolean reachable_accurate;
    private int dht_send_delay;
    private int dht_receive_delay;
    private DHTLogger logger;
    private DHTUDPPacketHandler packet_handler;
    private DHTTransportRequestHandler request_handler;
    private DHTTransportUDPContactImpl local_contact;
    private Map transfer_handlers = new HashMap();
    private Map read_transfers = new HashMap();
    private Map write_transfers = new HashMap();
    private int active_write_queue_processor_count;
    private long total_bytes_on_transfer_queues;
    private Map call_transfers = new HashMap();
    private long last_address_change;
    private List listeners = new ArrayList();
    private IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private DHTTransportUDPStatsImpl stats;
    private boolean bootstrap_node = false;
    private static final int CONTACT_HISTORY_MAX = 32;
    private static final int CONTACT_HISTORY_PING_SIZE = 24;
    private Map<InetSocketAddress, DHTTransportContact> contact_history = new LinkedHashMap<InetSocketAddress, DHTTransportContact>(32, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetSocketAddress, DHTTransportContact> entry) {
            return this.size() > 32;
        }
    };
    private static final int ROUTABLE_CONTACT_HISTORY_MAX = 128;
    private Map<InetSocketAddress, DHTTransportContact> routable_contact_history = new LinkedHashMap<InetSocketAddress, DHTTransportContact>(128, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetSocketAddress, DHTTransportContact> entry) {
            return this.size() > 128;
        }
    };
    private long other_routable_total;
    private long other_non_routable_total;
    private MovingImmediateAverage routeable_percentage_average = AverageFactory.MovingImmediateAverage(8);
    private static final int RECENT_REPORTS_HISTORY_MAX = 32;
    private Map recent_reports = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 32;
        }
    };
    private static final int STATS_PERIOD = 60000;
    private static final int STATS_DURATION_SECS = 600;
    private static final long STATS_INIT_PERIOD = 900000L;
    private long stats_start_time = SystemTime.getCurrentTime();
    private long last_alien_count;
    private long last_alien_fv_count;
    private Average alien_average = Average.getInstance(60000, 600);
    private Average alien_fv_average = Average.getInstance(60000, 600);
    private Random random;
    private static final int BAD_IP_BLOOM_FILTER_SIZE = 32000;
    private BloomFilter bad_ip_bloom_filter;
    private static AEMonitor class_mon;
    private AEMonitor this_mon = new AEMonitor("DHTTransportUDP");
    private boolean initial_address_change_deferred;
    private boolean address_changing;

    public DHTTransportUDPImpl(byte by, int n, boolean bl, String string, String string2, int n2, int n3, int n4, long l, int n5, int n6, boolean bl2, boolean bl3, DHTLogger dHTLogger) throws DHTTransportException {
        this.protocol_version = by;
        this.network = n;
        this.v6 = bl;
        this.ip_override = string;
        this.port = n2;
        this.max_fails_for_live = n3;
        this.max_fails_for_unknown = n4;
        this.request_timeout = l;
        this.dht_send_delay = n5;
        this.dht_receive_delay = n6;
        this.bootstrap_node = bl2;
        this.reachable = bl3;
        this.logger = dHTLogger;
        this.store_timeout = this.request_timeout * 2L;
        try {
            this.random = RandomUtils.SECURE_RANDOM;
        }
        catch (Throwable throwable) {
            this.random = new Random();
            this.logger.log(throwable);
        }
        int n7 = COConfigurationManager.getIntParameter("dht.udp.net" + this.network + ".routeable_pct", -1);
        if (n7 > 0) {
            this.routeable_percentage_average.update(n7);
        }
        this.createPacketHandler();
        SimpleTimer.addPeriodicEvent("DHTUDP:stats", 60000L, new TimerEventPerformer(){
            private int tick_count;

            public void perform(TimerEvent timerEvent2) {
                DHTTransportUDPImpl.this.updateStats(this.tick_count++);
            }
        });
        String string3 = string2 == null ? (this.v6 ? "::1" : "127.0.0.1") : string2;
        this.getExternalAddress(string3, this.logger);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.external_address, this.port);
        DHTNetworkPositionManager.addProviderListener(new DHTNetworkPositionProviderListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void providerAdded(DHTNetworkPositionProvider dHTNetworkPositionProvider) {
                if (DHTTransportUDPImpl.this.local_contact != null) {
                    DHTTransportUDPImpl.this.local_contact.createNetworkPositions(true);
                    try {
                        DHTTransportUDPImpl.this.this_mon.enter();
                        for (DHTTransportContact dHTTransportContact : DHTTransportUDPImpl.this.contact_history.values()) {
                            dHTTransportContact.createNetworkPositions(false);
                        }
                        for (DHTTransportContact dHTTransportContact : DHTTransportUDPImpl.this.routable_contact_history.values()) {
                            dHTTransportContact.createNetworkPositions(false);
                        }
                        Object var5_6 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                        throw throwable;
                    }
                    for (int i = 0; i < DHTTransportUDPImpl.this.listeners.size(); ++i) {
                        try {
                            ((DHTTransportListener)DHTTransportUDPImpl.this.listeners.get(i)).resetNetworkPositions();
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }

            public void providerRemoved(DHTNetworkPositionProvider dHTNetworkPositionProvider) {
            }
        });
        this.logger.log("Initial external address: " + inetSocketAddress);
        this.local_contact = new DHTTransportUDPContactImpl(true, this, inetSocketAddress, inetSocketAddress, this.protocol_version, this.random.nextInt(), 0L);
    }

    protected void createPacketHandler() throws DHTTransportException {
        DHTUDPPacketHelper.registerCodecs();
        try {
            if (this.packet_handler != null) {
                this.packet_handler.destroy();
            }
            this.packet_handler = DHTUDPPacketHandlerFactory.getHandler(this, this);
        }
        catch (Throwable throwable) {
            throw new DHTTransportException("Failed to get packet handler", throwable);
        }
        this.packet_handler.setDelays(this.dht_send_delay, this.dht_receive_delay, (int)this.request_timeout);
        this.stats_start_time = SystemTime.getCurrentTime();
        if (this.stats == null) {
            this.stats = new DHTTransportUDPStatsImpl(this, this.protocol_version, this.packet_handler.getStats());
        } else {
            this.stats.setStats(this.packet_handler.getStats());
        }
    }

    protected void updateStats(int n) {
        long l = 0L;
        long[] lArray = this.stats.getAliens();
        for (int i = 0; i < lArray.length; ++i) {
            l += lArray[i];
        }
        long l2 = lArray[1];
        this.alien_average.addValue((l - this.last_alien_count) * 60000L / 1000L);
        this.alien_fv_average.addValue((l2 - this.last_alien_fv_count) * 60000L / 1000L);
        this.last_alien_count = l;
        this.last_alien_fv_count = l2;
        long l3 = SystemTime.getCurrentTime();
        if (l3 < this.stats_start_time) {
            this.stats_start_time = l3;
        } else {
            if (Constants.isCVSVersion()) {
                long l4 = this.alien_fv_average.getAverage();
                long l5 = this.alien_average.getAverage();
                this.logger.log("Aliens for net " + this.network + ": " + l4 + "/" + l5);
            }
            if (l3 - this.stats_start_time > 900000L) {
                this.reachable_accurate = true;
                boolean bl = this.reachable;
                this.reachable = this.alien_fv_average.getAverage() > 1L ? true : this.alien_average.getAverage() > 3L;
                if (bl != this.reachable) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        try {
                            ((DHTTransportListener)this.listeners.get(i)).reachabilityChanged(this.reachable);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
            }
        }
        int n2 = this.getRouteablePercentage();
        if (n2 > 0) {
            COConfigurationManager.setParameter("dht.udp.net" + this.network + ".routeable_pct", n2);
        }
    }

    protected void recordSkew(InetSocketAddress inetSocketAddress, long l) {
        if (this.stats != null) {
            this.stats.recordSkew(inetSocketAddress, l);
        }
    }

    protected int getNodeStatus() {
        if (this.bootstrap_node) {
            return 0;
        }
        if (this.reachable_accurate) {
            int n = this.reachable ? 1 : 0;
            return n;
        }
        return -1;
    }

    @Override
    public boolean isReachable() {
        return this.reachable;
    }

    @Override
    public byte getProtocolVersion() {
        return this.protocol_version;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int n) throws DHTTransportException {
        if (n == this.port) {
            return;
        }
        this.port = n;
        this.createPacketHandler();
        this.setLocalContact();
    }

    @Override
    public long getTimeout() {
        return this.request_timeout;
    }

    @Override
    public void setTimeout(long l) {
        if (this.request_timeout == l) {
            return;
        }
        this.request_timeout = l;
        this.store_timeout = this.request_timeout * 2L;
        this.packet_handler.setDelays(this.dht_send_delay, this.dht_receive_delay, (int)this.request_timeout);
    }

    @Override
    public int getNetwork() {
        return this.network;
    }

    public void testInstanceIDChange() throws DHTTransportException {
        this.local_contact = new DHTTransportUDPContactImpl(true, this, this.local_contact.getTransportAddress(), this.local_contact.getExternalAddress(), this.protocol_version, this.random.nextInt(), 0L);
    }

    public void testTransportIDChange() throws DHTTransportException {
        this.external_address = this.external_address.equals("127.0.0.1") ? "192.168.0.2" : "127.0.0.1";
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.external_address, this.port);
        this.local_contact = new DHTTransportUDPContactImpl(true, this, inetSocketAddress, inetSocketAddress, this.protocol_version, this.local_contact.getInstanceID(), 0L);
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((DHTTransportListener)this.listeners.get(i)).localContactChanged(this.local_contact);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    public void testExternalAddressChange() {
        try {
            Iterator<DHTTransportContact> iterator = this.contact_history.values().iterator();
            DHTTransportUDPContactImpl dHTTransportUDPContactImpl = (DHTTransportUDPContactImpl)iterator.next();
            DHTTransportUDPContactImpl dHTTransportUDPContactImpl2 = (DHTTransportUDPContactImpl)iterator.next();
            this.externalAddressChange(dHTTransportUDPContactImpl, dHTTransportUDPContactImpl2.getExternalAddress(), true);
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public void testNetworkAlive(boolean bl) {
        this.packet_handler.testNetworkAlive(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getExternalAddress(String string, DHTLogger dHTLogger) {
        try {
            class_mon.enter();
            String string2 = null;
            try {
                Serializable serializable;
                dHTLogger.log("Obtaining external address");
                if (TEST_EXTERNAL_IP) {
                    string2 = this.v6 ? "::1" : "127.0.0.1";
                    dHTLogger.log("    External IP address obtained from test data: " + string2);
                }
                if (this.ip_override != null) {
                    string2 = this.ip_override;
                    dHTLogger.log("    External IP address explicitly overridden: " + string2);
                }
                if (string2 == null) {
                    try {
                        this.this_mon.enter();
                        serializable = new ArrayList<DHTTransportContact>(this.contact_history.values());
                        Object var6_6 = null;
                        this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                    String string3 = null;
                    int n = 0;
                    int n2 = Math.min(24, serializable.size());
                    dHTLogger.log("    Contacts to search = " + n2);
                    for (int i = 0; i < n2; ++i) {
                        DHTTransportUDPContactImpl dHTTransportUDPContactImpl = (DHTTransportUDPContactImpl)serializable.remove((int)((double)serializable.size() * Math.random()));
                        InetSocketAddress inetSocketAddress = this.askContactForExternalAddress(dHTTransportUDPContactImpl);
                        if (inetSocketAddress != null && inetSocketAddress.getAddress() != null) {
                            String string4 = inetSocketAddress.getAddress().getHostAddress();
                            if (string3 == null) {
                                string3 = string4;
                                dHTLogger.log("    : contact " + dHTTransportUDPContactImpl.getString() + " reported external address as '" + string4 + "'");
                                ++n;
                                continue;
                            }
                            if (string3.equals(string4)) {
                                dHTLogger.log("    : contact " + dHTTransportUDPContactImpl.getString() + " also reported external address as '" + string4 + "'");
                                if (++n != 3) continue;
                                string2 = string3;
                                dHTLogger.log("    External IP address obtained from contacts: " + string3);
                                break;
                            }
                            dHTLogger.log("    : contact " + dHTTransportUDPContactImpl.getString() + " reported external address as '" + string4 + "', abandoning due to mismatch");
                            break;
                        }
                        dHTLogger.log("    : contact " + dHTTransportUDPContactImpl.getString() + " didn't reply");
                    }
                }
                if (string2 == null && (serializable = this.logger.getPluginInterface().getUtilities().getPublicAddress(this.v6)) != null) {
                    string2 = ((InetAddress)serializable).getHostAddress();
                    dHTLogger.log("    External IP address obtained: " + string2);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
            if (string2 == null) {
                string2 = string;
                dHTLogger.log("    External IP address defaulted:  " + string2);
            }
            if (this.external_address == null || !this.external_address.equals(string2)) {
                this.informLocalAddress(string2);
            }
            this.external_address = string2;
            Object var13_16 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected void informLocalAddress(String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((DHTTransportListener)this.listeners.get(i)).currentAddress(string);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void externalAddressChange(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final InetSocketAddress inetSocketAddress, boolean bl) throws DHTTransportException {
        String string;
        block14: {
            block13: {
                block12: {
                    block11: {
                        InetAddress inetAddress = inetSocketAddress.getAddress();
                        if (inetAddress == null) {
                            Debug.out("reported new external address '" + inetSocketAddress + "' is unresolved");
                            throw new DHTTransportException("Address '" + inetSocketAddress + "' is unresolved");
                        }
                        if (inetAddress instanceof Inet4Address && this.v6 || inetAddress instanceof Inet6Address && !this.v6) {
                            return;
                        }
                        string = inetAddress.getHostAddress();
                        if (string.equals(this.external_address)) {
                            return;
                        }
                        try {
                            this.this_mon.enter();
                            long l = SystemTime.getCurrentTime();
                            if (l - this.last_address_change < (long)this.min_address_change_period) {
                                Object var9_8 = null;
                                this.this_mon.exit();
                                return;
                            }
                            if (this.contact_history.size() < 32 && !bl) {
                                if (!this.initial_address_change_deferred) {
                                    this.initial_address_change_deferred = true;
                                    this.logger.log("Node " + dHTTransportUDPContactImpl.getString() + " has reported that the external IP address is '" + inetSocketAddress + "': deferring new checks");
                                    new DelayedEvent("DHTTransportUDP:delayAC", 30000L, new AERunnable(){

                                        public void runSupport() {
                                            try {
                                                DHTTransportUDPImpl.this.externalAddressChange(dHTTransportUDPContactImpl, inetSocketAddress, true);
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                    });
                                }
                                break block11;
                            }
                            this.logger.log("Node " + dHTTransportUDPContactImpl.getString() + " has reported that the external IP address is '" + inetSocketAddress + "'");
                            if (this.invalidExternalAddress(inetAddress)) {
                                this.logger.log("     This is invalid as it is a private address.");
                                break block12;
                            }
                            if (dHTTransportUDPContactImpl.getExternalAddress().getAddress().getHostAddress().equals(string)) {
                                this.logger.log("     This is invalid as it is the same as the reporter's address.");
                                break block13;
                            }
                            this.last_address_change = l;
                            if (this.min_address_change_period == 300000) {
                                this.min_address_change_period = 600000;
                            }
                            break block14;
                        }
                        catch (Throwable throwable) {
                            Object var9_13 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var9_9 = null;
                    this.this_mon.exit();
                    return;
                }
                Object var9_10 = null;
                this.this_mon.exit();
                return;
            }
            Object var9_11 = null;
            this.this_mon.exit();
            return;
        }
        Object var9_12 = null;
        this.this_mon.exit();
        final String string2 = this.external_address;
        new AEThread2("DHTTransportUDP:getAddress", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                try {
                    DHTTransportUDPImpl.this.this_mon.enter();
                    if (DHTTransportUDPImpl.this.address_changing) {
                        Object var2_1 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                        return;
                    }
                    DHTTransportUDPImpl.this.address_changing = true;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    DHTTransportUDPImpl.this.this_mon.exit();
                    throw throwable;
                }
                Object var2_2 = null;
                DHTTransportUDPImpl.this.this_mon.exit();
                DHTTransportUDPImpl.this.getExternalAddress(string, DHTTransportUDPImpl.this.logger);
                if (!string2.equals(DHTTransportUDPImpl.this.external_address)) break block9;
                Object var4_5 = null;
                try {
                    DHTTransportUDPImpl.this.this_mon.enter();
                    DHTTransportUDPImpl.this.address_changing = false;
                    Object var6_8 = null;
                    DHTTransportUDPImpl.this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    DHTTransportUDPImpl.this.this_mon.exit();
                    throw throwable;
                }
                {
                    block9: {
                        return;
                    }
                    DHTTransportUDPImpl.this.setLocalContact();
                }
                Object var4_6 = null;
                try {
                    DHTTransportUDPImpl.this.this_mon.enter();
                    DHTTransportUDPImpl.this.address_changing = false;
                    Object var6_10 = null;
                    DHTTransportUDPImpl.this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var6_11 = null;
                    DHTTransportUDPImpl.this.this_mon.exit();
                    throw throwable;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    try {
                        DHTTransportUDPImpl.this.this_mon.enter();
                        DHTTransportUDPImpl.this.address_changing = false;
                        Object var6_12 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                    }
                    catch (Throwable throwable2) {
                        Object var6_13 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                        throw throwable2;
                    }
                    throw throwable;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void contactAlive(DHTTransportUDPContactImpl dHTTransportUDPContactImpl) {
        try {
            this.this_mon.enter();
            this.contact_history.put(dHTTransportUDPContactImpl.getTransportAddress(), dHTTransportUDPContactImpl);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTTransportContact[] getReachableContacts() {
        try {
            this.this_mon.enter();
            Collection<DHTTransportContact> collection = this.routable_contact_history.values();
            DHTTransportContact[] dHTTransportContactArray = new DHTTransportContact[collection.size()];
            collection.toArray(dHTTransportContactArray);
            DHTTransportContact[] dHTTransportContactArray2 = dHTTransportContactArray;
            Object var5_4 = null;
            this.this_mon.exit();
            return dHTTransportContactArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTTransportContact[] getRecentContacts() {
        try {
            this.this_mon.enter();
            Collection<DHTTransportContact> collection = this.contact_history.values();
            DHTTransportContact[] dHTTransportContactArray = new DHTTransportContact[collection.size()];
            collection.toArray(dHTTransportContactArray);
            DHTTransportContact[] dHTTransportContactArray2 = dHTTransportContactArray;
            Object var5_4 = null;
            this.this_mon.exit();
            return dHTTransportContactArray2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContactStatus(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, int n, boolean bl) {
        try {
            this.this_mon.enter();
            dHTTransportUDPContactImpl.setNodeStatus(n);
            if (dHTTransportUDPContactImpl.getProtocolVersion() >= 12 && n != -1) {
                boolean bl2;
                boolean bl3 = bl2 = (n & 1) != 0;
                if (bl2) {
                    if (bl) {
                        ++this.other_routable_total;
                    }
                    this.routable_contact_history.put(dHTTransportUDPContactImpl.getTransportAddress(), dHTTransportUDPContactImpl);
                } else if (bl) {
                    ++this.other_non_routable_total;
                }
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRouteablePercentage() {
        MovingImmediateAverage movingImmediateAverage = this.routeable_percentage_average;
        synchronized (movingImmediateAverage) {
            int n;
            double d = this.routeable_percentage_average.getAverage();
            long l = this.other_routable_total + this.other_non_routable_total;
            int n2 = l == 0L ? 0 : (int)(this.other_routable_total * 100L / l);
            if (l >= 300L) {
                if (n2 > 0) {
                    d = this.routeable_percentage_average.update(n2);
                    this.other_non_routable_total = 0L;
                    this.other_routable_total = 0L;
                }
            } else if (l >= 100L) {
                if (d == 0.0) {
                    d = n2;
                } else {
                    n = this.routeable_percentage_average.getSampleCount();
                    if (n > 0) {
                        d = ((double)n * d + (double)n2) / (double)(n + 1);
                    }
                }
            }
            if ((n = (int)d) == 0) {
                n = -1;
            }
            return n;
        }
    }

    protected boolean invalidExternalAddress(InetAddress inetAddress) {
        return inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isSiteLocalAddress();
    }

    protected int getMaxFailForLiveCount() {
        return this.max_fails_for_live;
    }

    protected int getMaxFailForUnknownCount() {
        return this.max_fails_for_unknown;
    }

    @Override
    public DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    protected void setLocalContact() {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(this.external_address, this.port);
        try {
            this.local_contact = new DHTTransportUDPContactImpl(true, this, inetSocketAddress, inetSocketAddress, this.protocol_version, this.random.nextInt(), 0L);
            this.logger.log("External address changed: " + inetSocketAddress);
            Debug.out("DHTTransport: address changed to " + inetSocketAddress);
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    ((DHTTransportListener)this.listeners.get(i)).localContactChanged(this.local_contact);
                    continue;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    @Override
    public DHTTransportContact importContact(DataInputStream dataInputStream) throws IOException, DHTTransportException {
        DHTTransportUDPContactImpl dHTTransportUDPContactImpl = DHTUDPUtils.deserialiseContact(this, dataInputStream);
        this.importContact(dHTTransportUDPContactImpl);
        return dHTTransportUDPContactImpl;
    }

    @Override
    public DHTTransportUDPContact importContact(InetSocketAddress inetSocketAddress, byte by) throws DHTTransportException {
        DHTTransportUDPContactImpl dHTTransportUDPContactImpl = new DHTTransportUDPContactImpl(false, this, inetSocketAddress, inetSocketAddress, by, 0, 0L);
        this.importContact(dHTTransportUDPContactImpl);
        return dHTTransportUDPContactImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importContact(DHTTransportUDPContactImpl dHTTransportUDPContactImpl) {
        try {
            this.this_mon.enter();
            if (this.contact_history.size() < 32) {
                this.contact_history.put(dHTTransportUDPContactImpl.getTransportAddress(), dHTTransportUDPContactImpl);
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.request_handler.contactImported(dHTTransportUDPContactImpl);
    }

    public void exportContact(DHTTransportContact dHTTransportContact, DataOutputStream dataOutputStream) throws IOException, DHTTransportException {
        DHTUDPUtils.serialiseContact(dataOutputStream, dHTTransportContact);
    }

    public void removeContact(DHTTransportContact dHTTransportContact) {
        this.request_handler.contactRemoved(dHTTransportContact);
    }

    @Override
    public void setRequestHandler(DHTTransportRequestHandler dHTTransportRequestHandler) {
        this.request_handler = new DHTTransportRequestCounter(dHTTransportRequestHandler, this.stats);
    }

    @Override
    public DHTTransportStats getStats() {
        return this.stats;
    }

    protected void checkAddress(DHTTransportUDPContactImpl dHTTransportUDPContactImpl) throws DHTUDPPacketHandlerException {
        if (this.ip_filter.isEnabled()) {
            byte[] byArray = dHTTransportUDPContactImpl.getTransportAddress().getAddress().getAddress();
            if (this.bad_ip_bloom_filter == null) {
                this.bad_ip_bloom_filter = BloomFilterFactory.createAddOnly(32000);
            } else if (this.bad_ip_bloom_filter.contains(byArray)) {
                throw new DHTUDPPacketHandlerException("IPFilter check fails (repeat)");
            }
            if (this.ip_filter.isInRange(dHTTransportUDPContactImpl.getTransportAddress().getAddress(), "DHT", null, this.logger.isEnabled(2))) {
                if (this.bad_ip_bloom_filter.getEntryCount() >= 3200) {
                    this.bad_ip_bloom_filter = BloomFilterFactory.createAddOnly(32000);
                }
                this.bad_ip_bloom_filter.add(byArray);
                throw new DHTUDPPacketHandlerException("IPFilter check fails");
            }
        }
    }

    protected void sendPing(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTTransportReplyHandler dHTTransportReplyHandler, long l, int n) {
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            final long l2 = this.getConnectionID();
            DHTUDPPacketRequestPing dHTUDPPacketRequestPing = new DHTUDPPacketRequestPing(this, l2, this.local_contact, dHTTransportUDPContactImpl);
            this.stats.pingSent(dHTUDPPacketRequestPing);
            this.requestSendRequestProcessor(dHTTransportUDPContactImpl, dHTUDPPacketRequestPing);
            this.packet_handler.sendAndReceive(dHTUDPPacketRequestPing, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l) {
                    try {
                        if (dHTUDPPacketReply.getConnectionId() != l2) {
                            throw new Exception("connection id mismatch");
                        }
                        dHTTransportUDPContactImpl.setInstanceIDAndVersion(dHTUDPPacketReply.getTargetInstanceID(), dHTUDPPacketReply.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(dHTTransportUDPContactImpl, dHTTransportReplyHandler, dHTUDPPacketReply, l);
                        DHTTransportUDPImpl.this.stats.pingOK();
                        dHTTransportReplyHandler.pingReply(dHTTransportUDPContactImpl, (int)l);
                    }
                    catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                        this.error(dHTUDPPacketHandlerException);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        this.error(new DHTUDPPacketHandlerException("ping failed", throwable));
                    }
                }

                public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                    DHTTransportUDPImpl.this.stats.pingFailed();
                    dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, dHTUDPPacketHandlerException);
                }
            }, l, n);
        }
        catch (Throwable throwable) {
            this.stats.pingFailed();
            dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, throwable);
        }
    }

    protected void sendPing(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportReplyHandler dHTTransportReplyHandler) {
        this.sendPing(dHTTransportUDPContactImpl, dHTTransportReplyHandler, this.request_timeout, 1);
    }

    protected void sendImmediatePing(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportReplyHandler dHTTransportReplyHandler, long l) {
        this.sendPing(dHTTransportUDPContactImpl, dHTTransportReplyHandler, l, 99);
    }

    protected void sendKeyBlockRequest(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray, byte[] byArray2) {
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            final long l = this.getConnectionID();
            DHTUDPPacketRequestKeyBlock dHTUDPPacketRequestKeyBlock = new DHTUDPPacketRequestKeyBlock(this, l, this.local_contact, dHTTransportUDPContactImpl);
            dHTUDPPacketRequestKeyBlock.setKeyBlockDetails(byArray, byArray2);
            this.stats.keyBlockSent(dHTUDPPacketRequestKeyBlock);
            dHTUDPPacketRequestKeyBlock.setRandomID(dHTTransportUDPContactImpl.getRandomID());
            this.requestSendRequestProcessor(dHTTransportUDPContactImpl, dHTUDPPacketRequestKeyBlock);
            this.packet_handler.sendAndReceive(dHTUDPPacketRequestKeyBlock, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l2) {
                    try {
                        if (dHTUDPPacketReply.getConnectionId() != l) {
                            throw new Exception("connection id mismatch");
                        }
                        dHTTransportUDPContactImpl.setInstanceIDAndVersion(dHTUDPPacketReply.getTargetInstanceID(), dHTUDPPacketReply.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(dHTTransportUDPContactImpl, dHTTransportReplyHandler, dHTUDPPacketReply, l2);
                        DHTTransportUDPImpl.this.stats.keyBlockOK();
                        dHTTransportReplyHandler.keyBlockReply(dHTTransportUDPContactImpl);
                    }
                    catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                        this.error(dHTUDPPacketHandlerException);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        this.error(new DHTUDPPacketHandlerException("send key block failed", throwable));
                    }
                }

                public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                    DHTTransportUDPImpl.this.stats.keyBlockFailed();
                    dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, dHTUDPPacketHandlerException);
                }
            }, this.request_timeout, 1);
        }
        catch (Throwable throwable) {
            this.stats.keyBlockFailed();
            dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, throwable);
        }
    }

    protected void sendStats(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTTransportReplyHandler dHTTransportReplyHandler) {
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            final long l = this.getConnectionID();
            DHTUDPPacketRequestStats dHTUDPPacketRequestStats = new DHTUDPPacketRequestStats(this, l, this.local_contact, dHTTransportUDPContactImpl);
            this.stats.statsSent(dHTUDPPacketRequestStats);
            this.requestSendRequestProcessor(dHTTransportUDPContactImpl, dHTUDPPacketRequestStats);
            this.packet_handler.sendAndReceive(dHTUDPPacketRequestStats, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l2) {
                    try {
                        if (dHTUDPPacketReply.getConnectionId() != l) {
                            throw new Exception("connection id mismatch");
                        }
                        dHTTransportUDPContactImpl.setInstanceIDAndVersion(dHTUDPPacketReply.getTargetInstanceID(), dHTUDPPacketReply.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(dHTTransportUDPContactImpl, dHTTransportReplyHandler, dHTUDPPacketReply, l2);
                        DHTUDPPacketReplyStats dHTUDPPacketReplyStats = (DHTUDPPacketReplyStats)dHTUDPPacketReply;
                        DHTTransportUDPImpl.this.stats.statsOK();
                        if (dHTUDPPacketReplyStats.getStatsType() == 1) {
                            dHTTransportReplyHandler.statsReply(dHTTransportUDPContactImpl, dHTUDPPacketReplyStats.getOriginalStats());
                        } else {
                            System.out.println("new stats reply:" + dHTUDPPacketReplyStats.getString());
                        }
                    }
                    catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                        this.error(dHTUDPPacketHandlerException);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        this.error(new DHTUDPPacketHandlerException("stats failed", throwable));
                    }
                }

                public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                    DHTTransportUDPImpl.this.stats.statsFailed();
                    dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, dHTUDPPacketHandlerException);
                }
            }, this.request_timeout, 2);
        }
        catch (Throwable throwable) {
            this.stats.statsFailed();
            dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, throwable);
        }
    }

    protected InetSocketAddress askContactForExternalAddress(DHTTransportUDPContactImpl dHTTransportUDPContactImpl) {
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            long l = this.getConnectionID();
            DHTUDPPacketRequestPing dHTUDPPacketRequestPing = new DHTUDPPacketRequestPing(this, l, this.local_contact, dHTTransportUDPContactImpl);
            this.stats.pingSent(dHTUDPPacketRequestPing);
            final AESemaphore aESemaphore = new AESemaphore("DHTTransUDP:extping");
            final InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[1];
            this.packet_handler.sendAndReceive(dHTUDPPacketRequestPing, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l) {
                    try {
                        DHTUDPPacketReplyError dHTUDPPacketReplyError;
                        if (dHTUDPPacketReply instanceof DHTUDPPacketReplyPing) {
                            inetSocketAddressArray[0] = DHTTransportUDPImpl.this.local_contact.getExternalAddress();
                        } else if (dHTUDPPacketReply instanceof DHTUDPPacketReplyError && (dHTUDPPacketReplyError = (DHTUDPPacketReplyError)dHTUDPPacketReply).getErrorType() == 1) {
                            inetSocketAddressArray[0] = dHTUDPPacketReplyError.getOriginatingAddress();
                        }
                        Object var7_5 = null;
                        aESemaphore.release();
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        aESemaphore.release();
                        throw throwable;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                    try {
                        DHTTransportUDPImpl.this.stats.pingFailed();
                        Object var3_2 = null;
                        aESemaphore.release();
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        aESemaphore.release();
                        throw throwable;
                    }
                }
            }, 5000L, 0);
            aESemaphore.reserve(5000L);
            return inetSocketAddressArray[0];
        }
        catch (Throwable throwable) {
            this.stats.pingFailed();
            return null;
        }
    }

    public void sendStore(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTTransportReplyHandler dHTTransportReplyHandler, byte[][] byArray, DHTTransportValue[][] dHTTransportValueArray, int n) {
        block9: {
            final long l = this.getConnectionID();
            int n2 = 0;
            try {
                this.checkAddress(dHTTransportUDPContactImpl);
                int n3 = 0;
                int n4 = 0;
                while (n3 < byArray.length) {
                    int n5;
                    Object object;
                    ++n2;
                    int n6 = 1359;
                    ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                    ArrayList arrayList2 = new ArrayList();
                    arrayList.add(byArray[n3]);
                    n6 -= byArray[n3].length + 1;
                    arrayList2.add(new ArrayList());
                    while (n6 > 0 && n3 < byArray.length) {
                        if (n4 == dHTTransportValueArray[n3].length) {
                            n4 = 0;
                            if (arrayList.size() == 255 || ++n3 == byArray.length) break;
                            arrayList.add(byArray[n3]);
                            n6 -= byArray[n3].length + 1;
                            arrayList2.add(new ArrayList());
                        }
                        DHTTransportValue dHTTransportValue = dHTTransportValueArray[n3][n4];
                        int n7 = 26 + dHTTransportValue.getValue().length + 1;
                        object = (List)arrayList2.get(arrayList2.size() - 1);
                        if (n6 < n7 || object.size() == 255) break;
                        object.add(dHTTransportValue);
                        n6 -= n7;
                        ++n4;
                    }
                    if ((n5 = arrayList.size()) > 0 && ((List)arrayList2.get(n5 - 1)).size() == 0) {
                        --n5;
                    }
                    if (n5 != 0) {
                        byte[][] byArrayArray = new byte[n5][];
                        object = new DHTTransportValue[n5][];
                        for (int i = 0; i < n5; ++i) {
                            byArrayArray[i] = (byte[])arrayList.get(i);
                            List list = (List)arrayList2.get(i);
                            object[i] = new DHTTransportValue[list.size()];
                            for (int j = 0; j < list.size(); ++j) {
                                object[i][j] = (DHTTransportValue)list.get(j);
                            }
                        }
                        DHTUDPPacketRequestStore dHTUDPPacketRequestStore = new DHTUDPPacketRequestStore(this, l, this.local_contact, dHTTransportUDPContactImpl);
                        this.stats.storeSent(dHTUDPPacketRequestStore);
                        dHTUDPPacketRequestStore.setRandomID(dHTTransportUDPContactImpl.getRandomID());
                        dHTUDPPacketRequestStore.setKeys(byArrayArray);
                        dHTUDPPacketRequestStore.setValueSets((DHTTransportValue[][])object);
                        final int n8 = n2;
                        this.requestSendRequestProcessor(dHTTransportUDPContactImpl, dHTUDPPacketRequestStore);
                        this.packet_handler.sendAndReceive(dHTUDPPacketRequestStore, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                            public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l2) {
                                try {
                                    if (dHTUDPPacketReply.getConnectionId() != l) {
                                        throw new Exception("connection id mismatch: sender=" + inetSocketAddress + ",packet=" + dHTUDPPacketReply.getString());
                                    }
                                    dHTTransportUDPContactImpl.setInstanceIDAndVersion(dHTUDPPacketReply.getTargetInstanceID(), dHTUDPPacketReply.getProtocolVersion());
                                    DHTTransportUDPImpl.this.requestSendReplyProcessor(dHTTransportUDPContactImpl, dHTTransportReplyHandler, dHTUDPPacketReply, l2);
                                    DHTUDPPacketReplyStore dHTUDPPacketReplyStore = (DHTUDPPacketReplyStore)dHTUDPPacketReply;
                                    DHTTransportUDPImpl.this.stats.storeOK();
                                    if (n8 == 1) {
                                        dHTTransportReplyHandler.storeReply(dHTTransportUDPContactImpl, dHTUDPPacketReplyStore.getDiversificationTypes());
                                    }
                                }
                                catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                                    this.error(dHTUDPPacketHandlerException);
                                }
                                catch (Throwable throwable) {
                                    Debug.printStackTrace(throwable);
                                    this.error(new DHTUDPPacketHandlerException("store failed", throwable));
                                }
                            }

                            public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                                DHTTransportUDPImpl.this.stats.storeFailed();
                                if (n8 == 1) {
                                    dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, dHTUDPPacketHandlerException);
                                }
                            }
                        }, this.store_timeout, n);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                this.stats.storeFailed();
                if (n2 > true) break block9;
                dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, throwable);
            }
        }
    }

    public void sendQueryStore(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTTransportReplyHandler dHTTransportReplyHandler, int n, List<Object[]> list) {
        try {
            Object object;
            this.checkAddress(dHTTransportUDPContactImpl);
            final long l = this.getConnectionID();
            Iterator<Object[]> iterator = list.iterator();
            byte[] byArray = null;
            Iterator iterator2 = null;
            ArrayList<DHTUDPPacketRequestQueryStorage> arrayList = new ArrayList<DHTUDPPacketRequestQueryStorage>();
            block2: while (iterator.hasNext()) {
                int n2 = 1356;
                DHTUDPPacketRequestQueryStorage dHTUDPPacketRequestQueryStorage = new DHTUDPPacketRequestQueryStorage(this, l, this.local_contact, dHTTransportUDPContactImpl);
                object = new ArrayList();
                while (n2 > 0 && iterator.hasNext()) {
                    List list2;
                    if (byArray == null) {
                        Object[] objectArray = iterator.next();
                        byArray = (byte[])objectArray[0];
                        list2 = (List)objectArray[1];
                        iterator2 = list2.iterator();
                    }
                    if (iterator2.hasNext()) {
                        int n3 = n + 3;
                        if (n2 < n3) {
                            dHTUDPPacketRequestQueryStorage.setDetails(n, (List<Object[]>)object);
                            arrayList.add(dHTUDPPacketRequestQueryStorage);
                            continue block2;
                        }
                        list2 = new ArrayList();
                        object.add(new Object[]{byArray, list2});
                        int n4 = byArray.length;
                        int n5 = n - n4;
                        n2 -= 3 + n4;
                        while (n2 >= n5 && iterator2.hasNext()) {
                            list2.add(iterator2.next());
                        }
                        continue;
                    }
                    byArray = null;
                }
                if (iterator.hasNext()) continue;
                dHTUDPPacketRequestQueryStorage.setDetails(n, (List<Object[]>)object);
                arrayList.add(dHTUDPPacketRequestQueryStorage);
            }
            final Object[] objectArray = new Object[arrayList.size()];
            int n6 = 0;
            while (n6 < arrayList.size()) {
                object = (DHTUDPPacketRequestQueryStorage)arrayList.get(n6);
                final int n7 = n6++;
                this.stats.queryStoreSent((DHTUDPPacketRequest)object);
                this.requestSendRequestProcessor(dHTTransportUDPContactImpl, (DHTUDPPacketRequest)object);
                this.packet_handler.sendAndReceive((DHTUDPPacketRequest)object, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l2) {
                        try {
                            if (dHTUDPPacketReply.getConnectionId() != l) {
                                throw new Exception("connection id mismatch");
                            }
                            dHTTransportUDPContactImpl.setInstanceIDAndVersion(dHTUDPPacketReply.getTargetInstanceID(), dHTUDPPacketReply.getProtocolVersion());
                            DHTTransportUDPImpl.this.requestSendReplyProcessor(dHTTransportUDPContactImpl, dHTTransportReplyHandler, dHTUDPPacketReply, l2);
                            DHTUDPPacketReplyQueryStorage dHTUDPPacketReplyQueryStorage = (DHTUDPPacketReplyQueryStorage)dHTUDPPacketReply;
                            dHTTransportUDPContactImpl.setRandomID(dHTUDPPacketReplyQueryStorage.getRandomID());
                            DHTTransportUDPImpl.this.stats.queryStoreOK();
                            Object[] objectArray2 = objectArray;
                            synchronized (objectArray) {
                                objectArray[n7] = dHTUDPPacketReplyQueryStorage;
                                this.checkComplete();
                                // ** MonitorExit[var6_7] (shouldn't be in output)
                            }
                        }
                        catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                            this.error(dHTUDPPacketHandlerException);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                            this.error(new DHTUDPPacketHandlerException("queryStore failed", throwable));
                        }
                        {
                            return;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                        DHTTransportUDPImpl.this.stats.queryStoreFailed();
                        Object[] objectArray2 = objectArray;
                        synchronized (objectArray) {
                            objectArray[n7] = dHTUDPPacketHandlerException;
                            this.checkComplete();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }

                    protected void checkComplete() {
                        DHTUDPPacketHandlerException dHTUDPPacketHandlerException = null;
                        for (int i = 0; i < objectArray.length; ++i) {
                            Object object = objectArray[i];
                            if (object == null) {
                                return;
                            }
                            if (!(object instanceof DHTUDPPacketHandlerException)) continue;
                            dHTUDPPacketHandlerException = (DHTUDPPacketHandlerException)object;
                        }
                        if (dHTUDPPacketHandlerException != null) {
                            dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, dHTUDPPacketHandlerException);
                        } else if (objectArray.length == 1) {
                            dHTTransportReplyHandler.queryStoreReply(dHTTransportUDPContactImpl, ((DHTUDPPacketReplyQueryStorage)objectArray[0]).getResponse());
                        } else {
                            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                            for (int i = 0; i < objectArray.length; ++i) {
                                arrayList.addAll(((DHTUDPPacketReplyQueryStorage)objectArray[0]).getResponse());
                            }
                            dHTTransportReplyHandler.queryStoreReply(dHTTransportUDPContactImpl, arrayList);
                        }
                    }
                }, this.request_timeout, 1);
            }
        }
        catch (Throwable throwable) {
            this.stats.queryStoreFailed();
            dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, throwable);
        }
    }

    public void sendFindNode(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray) {
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            final long l = this.getConnectionID();
            DHTUDPPacketRequestFindNode dHTUDPPacketRequestFindNode = new DHTUDPPacketRequestFindNode(this, l, this.local_contact, dHTTransportUDPContactImpl);
            this.stats.findNodeSent(dHTUDPPacketRequestFindNode);
            dHTUDPPacketRequestFindNode.setID(byArray);
            dHTUDPPacketRequestFindNode.setNodeStatus(this.getNodeStatus());
            dHTUDPPacketRequestFindNode.setEstimatedDHTSize(this.request_handler.getTransportEstimatedDHTSize());
            this.requestSendRequestProcessor(dHTTransportUDPContactImpl, dHTUDPPacketRequestFindNode);
            this.packet_handler.sendAndReceive(dHTUDPPacketRequestFindNode, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l2) {
                    try {
                        if (dHTUDPPacketReply.getConnectionId() != l) {
                            throw new Exception("connection id mismatch");
                        }
                        dHTTransportUDPContactImpl.setInstanceIDAndVersion(dHTUDPPacketReply.getTargetInstanceID(), dHTUDPPacketReply.getProtocolVersion());
                        DHTTransportUDPImpl.this.requestSendReplyProcessor(dHTTransportUDPContactImpl, dHTTransportReplyHandler, dHTUDPPacketReply, l2);
                        DHTUDPPacketReplyFindNode dHTUDPPacketReplyFindNode = (DHTUDPPacketReplyFindNode)dHTUDPPacketReply;
                        dHTTransportUDPContactImpl.setRandomID(dHTUDPPacketReplyFindNode.getRandomID());
                        DHTTransportUDPImpl.this.updateContactStatus(dHTTransportUDPContactImpl, dHTUDPPacketReplyFindNode.getNodeStatus(), false);
                        DHTTransportUDPImpl.this.request_handler.setTransportEstimatedDHTSize(dHTUDPPacketReplyFindNode.getEstimatedDHTSize());
                        DHTTransportUDPImpl.this.stats.findNodeOK();
                        DHTTransportContact[] dHTTransportContactArray = dHTUDPPacketReplyFindNode.getContacts();
                        for (int i = 0; DHTTransportUDPImpl.this.contact_history.size() < 32 && i < dHTTransportContactArray.length; ++i) {
                            Object var10_10;
                            DHTTransportUDPContact dHTTransportUDPContact = (DHTTransportUDPContact)dHTTransportContactArray[i];
                            try {
                                DHTTransportUDPImpl.this.this_mon.enter();
                                DHTTransportUDPImpl.this.contact_history.put(dHTTransportUDPContact.getTransportAddress(), dHTTransportUDPContact);
                                var10_10 = null;
                                DHTTransportUDPImpl.this.this_mon.exit();
                                continue;
                            }
                            catch (Throwable throwable) {
                                var10_10 = null;
                                DHTTransportUDPImpl.this.this_mon.exit();
                                throw throwable;
                            }
                        }
                        dHTTransportReplyHandler.findNodeReply(dHTTransportUDPContactImpl, dHTTransportContactArray);
                    }
                    catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                        this.error(dHTUDPPacketHandlerException);
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        this.error(new DHTUDPPacketHandlerException("findNode failed", throwable));
                    }
                }

                public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                    DHTTransportUDPImpl.this.stats.findNodeFailed();
                    dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, dHTUDPPacketHandlerException);
                }
            }, this.request_timeout, 1);
        }
        catch (Throwable throwable) {
            this.stats.findNodeFailed();
            dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, throwable);
        }
    }

    public void sendFindValue(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray, int n, byte by) {
        block2: {
            try {
                this.checkAddress(dHTTransportUDPContactImpl);
                final long l = this.getConnectionID();
                DHTUDPPacketRequestFindValue dHTUDPPacketRequestFindValue = new DHTUDPPacketRequestFindValue(this, l, this.local_contact, dHTTransportUDPContactImpl);
                this.stats.findValueSent(dHTUDPPacketRequestFindValue);
                dHTUDPPacketRequestFindValue.setID(byArray);
                dHTUDPPacketRequestFindValue.setMaximumValues(n);
                dHTUDPPacketRequestFindValue.setFlags(by);
                this.requestSendRequestProcessor(dHTTransportUDPContactImpl, dHTUDPPacketRequestFindValue);
                this.packet_handler.sendAndReceive(dHTUDPPacketRequestFindValue, dHTTransportUDPContactImpl.getTransportAddress(), new DHTUDPPacketReceiver(){

                    public void packetReceived(DHTUDPPacketReply dHTUDPPacketReply, InetSocketAddress inetSocketAddress, long l2) {
                        try {
                            if (dHTUDPPacketReply.getConnectionId() != l) {
                                throw new Exception("connection id mismatch");
                            }
                            dHTTransportUDPContactImpl.setInstanceIDAndVersion(dHTUDPPacketReply.getTargetInstanceID(), dHTUDPPacketReply.getProtocolVersion());
                            DHTTransportUDPImpl.this.requestSendReplyProcessor(dHTTransportUDPContactImpl, dHTTransportReplyHandler, dHTUDPPacketReply, l2);
                            DHTUDPPacketReplyFindValue dHTUDPPacketReplyFindValue = (DHTUDPPacketReplyFindValue)dHTUDPPacketReply;
                            DHTTransportUDPImpl.this.stats.findValueOK();
                            DHTTransportValue[] dHTTransportValueArray = dHTUDPPacketReplyFindValue.getValues();
                            if (dHTTransportValueArray != null) {
                                boolean bl = dHTUDPPacketReplyFindValue.hasContinuation();
                                dHTTransportReplyHandler.findValueReply(dHTTransportUDPContactImpl, dHTTransportValueArray, dHTUDPPacketReplyFindValue.getDiversificationType(), bl);
                            } else {
                                dHTTransportReplyHandler.findValueReply(dHTTransportUDPContactImpl, dHTUDPPacketReplyFindValue.getContacts());
                            }
                        }
                        catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                            this.error(dHTUDPPacketHandlerException);
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                            this.error(new DHTUDPPacketHandlerException("findValue failed", throwable));
                        }
                    }

                    public void error(DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                        DHTTransportUDPImpl.this.stats.findValueFailed();
                        dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, dHTUDPPacketHandlerException);
                    }
                }, this.request_timeout, 0);
            }
            catch (Throwable throwable) {
                if (throwable instanceof DHTUDPPacketHandlerException) break block2;
                this.stats.findValueFailed();
                dHTTransportReplyHandler.failed(dHTTransportUDPContactImpl, throwable);
            }
        }
    }

    protected DHTTransportFullStats getFullStats(DHTTransportUDPContactImpl dHTTransportUDPContactImpl) {
        if (dHTTransportUDPContactImpl == this.local_contact) {
            return this.request_handler.statsRequest(dHTTransportUDPContactImpl);
        }
        final DHTTransportFullStats[] dHTTransportFullStatsArray = new DHTTransportFullStats[]{null};
        final AESemaphore aESemaphore = new AESemaphore("DHTTransportUDP:getFullStats");
        this.sendStats(dHTTransportUDPContactImpl, new DHTTransportReplyHandlerAdapter(){

            public void statsReply(DHTTransportContact dHTTransportContact, DHTTransportFullStats dHTTransportFullStats) {
                dHTTransportFullStatsArray[0] = dHTTransportFullStats;
                aESemaphore.release();
            }

            public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                aESemaphore.release();
            }
        });
        aESemaphore.reserve();
        return dHTTransportFullStatsArray[0];
    }

    protected void sendReadRequest(long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, byte[] byArray, byte[] byArray2) {
        this.sendReadRequest(l, dHTTransportUDPContactImpl, byArray, byArray2, 0, 0);
    }

    protected void sendReadRequest(long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, byte[] byArray, byte[] byArray2, int n, int n2) {
        DHTUDPPacketData dHTUDPPacketData = new DHTUDPPacketData(this, l, this.local_contact, dHTTransportUDPContactImpl);
        dHTUDPPacketData.setDetails((byte)0, byArray, byArray2, new byte[0], n, n2, 0);
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            if (XFER_TRACE) {
                this.logger.log("Transfer read request: key = " + DHTLog.getFullString(byArray2) + ", contact = " + dHTTransportUDPContactImpl.getString());
            }
            this.stats.dataSent(dHTUDPPacketData);
            this.packet_handler.send(dHTUDPPacketData, dHTTransportUDPContactImpl.getTransportAddress());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void sendReadReply(long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) {
        DHTUDPPacketData dHTUDPPacketData = new DHTUDPPacketData(this, l, this.local_contact, dHTTransportUDPContactImpl);
        dHTUDPPacketData.setDetails((byte)1, byArray, byArray2, byArray3, n, n2, n3);
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            if (XFER_TRACE) {
                this.logger.log("Transfer read reply: key = " + DHTLog.getFullString(byArray2) + ", contact = " + dHTTransportUDPContactImpl.getString());
            }
            this.stats.dataSent(dHTUDPPacketData);
            this.packet_handler.send(dHTUDPPacketData, dHTTransportUDPContactImpl.getTransportAddress());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void sendWriteRequest(long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, int n3) {
        DHTUDPPacketData dHTUDPPacketData = new DHTUDPPacketData(this, l, this.local_contact, dHTTransportUDPContactImpl);
        dHTUDPPacketData.setDetails((byte)2, byArray, byArray2, byArray3, n, n2, n3);
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            if (XFER_TRACE) {
                this.logger.log("Transfer write request: key = " + DHTLog.getFullString(byArray2) + ", contact = " + dHTTransportUDPContactImpl.getString());
            }
            this.stats.dataSent(dHTUDPPacketData);
            this.packet_handler.send(dHTUDPPacketData, dHTTransportUDPContactImpl.getTransportAddress());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void sendWriteReply(long l, DHTTransportUDPContactImpl dHTTransportUDPContactImpl, byte[] byArray, byte[] byArray2, int n, int n2) {
        DHTUDPPacketData dHTUDPPacketData = new DHTUDPPacketData(this, l, this.local_contact, dHTTransportUDPContactImpl);
        dHTUDPPacketData.setDetails((byte)3, byArray, byArray2, new byte[0], n, n2, 0);
        try {
            this.checkAddress(dHTTransportUDPContactImpl);
            if (XFER_TRACE) {
                this.logger.log("Transfer write reply: key = " + DHTLog.getFullString(byArray2) + ", contact = " + dHTTransportUDPContactImpl.getString());
            }
            this.stats.dataSent(dHTUDPPacketData);
            this.packet_handler.send(dHTUDPPacketData, dHTTransportUDPContactImpl.getTransportAddress());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void registerTransferHandler(byte[] byArray, DHTTransportTransferHandler dHTTransportTransferHandler) {
        this.logger.log("Transfer handler (" + dHTTransportTransferHandler.getName() + ") registered for key '" + ByteFormatter.encodeString(byArray));
        this.transfer_handlers.put(new HashWrapper(byArray), new transferHandlerInterceptor(dHTTransportTransferHandler));
    }

    protected int handleTransferRequest(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, long l, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, boolean bl, boolean bl2) throws DHTTransportException {
        DHTTransportTransferHandler dHTTransportTransferHandler = (DHTTransportTransferHandler)this.transfer_handlers.get(new HashWrapper(byArray));
        if (dHTTransportTransferHandler == null) {
            this.logger.log("No transfer handler registered for key '" + ByteFormatter.encodeString(byArray) + "'");
            throw new DHTTransportException("No transfer handler registered for " + ByteFormatter.encodeString(byArray));
        }
        if (byArray3 == null) {
            byArray3 = dHTTransportTransferHandler.handleRead(dHTTransportUDPContactImpl, byArray2);
        }
        if (byArray3 == null) {
            return -1;
        }
        if (byArray3.length == 0) {
            if (bl) {
                this.sendWriteRequest(l, dHTTransportUDPContactImpl, byArray, byArray2, byArray3, 0, 0, 0);
            } else {
                this.sendReadReply(l, dHTTransportUDPContactImpl, byArray, byArray2, byArray3, 0, 0, 0);
            }
        } else {
            if (n < 0) {
                n = 0;
            } else if (n >= byArray3.length) {
                this.logger.log("dataRequest: invalid start position");
                return byArray3.length;
            }
            if (n2 <= 0) {
                n2 = byArray3.length;
            } else if (n + n2 > byArray3.length) {
                this.logger.log("dataRequest: invalid length");
                return byArray3.length;
            }
            int n3 = n + n2;
            while (n < n3) {
                int n4 = n3 - n;
                if (n4 > DHTUDPPacketData.MAX_DATA_SIZE) {
                    n4 = DHTUDPPacketData.MAX_DATA_SIZE;
                }
                if (bl) {
                    this.sendWriteRequest(l, dHTTransportUDPContactImpl, byArray, byArray2, byArray3, n, n4, byArray3.length);
                    if (bl2) {
                        break;
                    }
                } else {
                    this.sendReadReply(l, dHTTransportUDPContactImpl, byArray, byArray2, byArray3, n, n4, byArray3.length);
                }
                n += n4;
            }
        }
        return byArray3.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dataRequest(final DHTTransportUDPContactImpl dHTTransportUDPContactImpl, final DHTUDPPacketData dHTUDPPacketData) {
        this.stats.dataReceived();
        byte by = dHTUDPPacketData.getPacketType();
        if (XFER_TRACE) {
            System.out.println("dataRequest: originator=" + dHTTransportUDPContactImpl.getAddress() + ",packet=" + dHTUDPPacketData.getString());
        }
        if (by == 1) {
            transferQueue transferQueue2 = this.lookupTransferQueue(this.read_transfers, dHTUDPPacketData.getConnectionId());
            if (transferQueue2 != null) {
                transferQueue2.add(dHTUDPPacketData);
            }
        } else if (by == 3) {
            transferQueue transferQueue3 = this.lookupTransferQueue(this.write_transfers, dHTUDPPacketData.getConnectionId());
            if (transferQueue3 != null) {
                transferQueue3.add(dHTUDPPacketData);
            }
        } else {
            byte[] byArray = dHTUDPPacketData.getTransferKey();
            if (by == 0) {
                try {
                    this.handleTransferRequest(dHTTransportUDPContactImpl, dHTUDPPacketData.getConnectionId(), byArray, dHTUDPPacketData.getRequestKey(), null, dHTUDPPacketData.getStartPosition(), dHTUDPPacketData.getLength(), false, false);
                }
                catch (DHTTransportException dHTTransportException) {
                    this.logger.log(dHTTransportException);
                }
            } else {
                transferQueue transferQueue4 = this.lookupTransferQueue(this.read_transfers, dHTUDPPacketData.getConnectionId());
                if (transferQueue4 != null) {
                    transferQueue4.add(dHTUDPPacketData);
                } else {
                    final DHTTransportTransferHandler dHTTransportTransferHandler = (DHTTransportTransferHandler)this.transfer_handlers.get(new HashWrapper(byArray));
                    if (dHTTransportTransferHandler == null) {
                        this.logger.log("No transfer handler registered for key '" + ByteFormatter.encodeString(byArray) + "'");
                    } else {
                        try {
                            final transferQueue transferQueue5 = new transferQueue(this.read_transfers, dHTUDPPacketData.getConnectionId());
                            transferQueue5.add(dHTUDPPacketData);
                            try {
                                this.this_mon.enter();
                                if (this.active_write_queue_processor_count >= 64) {
                                    transferQueue5.destroy();
                                    throw new DHTTransportException("Active write queue process thread limit exceeded");
                                }
                                ++this.active_write_queue_processor_count;
                                if (XFER_TRACE) {
                                    System.out.println("active_write_queue_processor_count=" + this.active_write_queue_processor_count);
                                }
                                Object var9_12 = null;
                                this.this_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var9_13 = null;
                                this.this_mon.exit();
                                throw throwable;
                            }
                            new AEThread2("DHTTransportUDP:writeQueueProcessor", true){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public void run() {
                                    try {
                                        block13: {
                                            try {
                                                byte[] byArray;
                                                byte[] byArray2 = DHTTransportUDPImpl.this.runTransferQueue(transferQueue5, new DHTTransportProgressListener(){

                                                    public void reportSize(long l) {
                                                        if (XFER_TRACE) {
                                                            System.out.println("writeXfer: size=" + l);
                                                        }
                                                    }

                                                    public void reportActivity(String string) {
                                                        if (XFER_TRACE) {
                                                            System.out.println("writeXfer: act=" + string);
                                                        }
                                                    }

                                                    public void reportCompleteness(int n) {
                                                        if (XFER_TRACE) {
                                                            System.out.println("writeXfer: %=" + n);
                                                        }
                                                    }
                                                }, dHTTransportUDPContactImpl, dHTUDPPacketData.getTransferKey(), dHTUDPPacketData.getRequestKey(), 60000L, false);
                                                if (byArray2 == null) break block13;
                                                if (dHTUDPPacketData.getStartPosition() != 0 || dHTUDPPacketData.getLength() != dHTUDPPacketData.getTotalLength()) {
                                                    DHTTransportUDPImpl.this.sendWriteReply(dHTUDPPacketData.getConnectionId(), dHTTransportUDPContactImpl, dHTUDPPacketData.getTransferKey(), dHTUDPPacketData.getRequestKey(), 0, dHTUDPPacketData.getTotalLength());
                                                }
                                                if ((byArray = dHTTransportTransferHandler.handleWrite(dHTTransportUDPContactImpl, dHTUDPPacketData.getRequestKey(), byArray2)) != null) {
                                                    DHTTransportUDPImpl.this.writeTransfer(new DHTTransportProgressListener(){

                                                        public void reportSize(long l) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: size=" + l);
                                                            }
                                                        }

                                                        public void reportActivity(String string) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: act=" + string);
                                                            }
                                                        }

                                                        public void reportCompleteness(int n) {
                                                            if (XFER_TRACE) {
                                                                System.out.println("writeXferReply: %=" + n);
                                                            }
                                                        }
                                                    }, dHTTransportUDPContactImpl, dHTUDPPacketData.getTransferKey(), dHTUDPPacketData.getRequestKey(), byArray, 60000L);
                                                }
                                            }
                                            catch (DHTTransportException dHTTransportException) {
                                                DHTTransportUDPImpl.this.logger.log("Failed to process transfer queue: " + Debug.getNestedExceptionMessage(dHTTransportException));
                                                Object var4_5 = null;
                                                try {
                                                    DHTTransportUDPImpl.this.this_mon.enter();
                                                    DHTTransportUDPImpl.this.active_write_queue_processor_count--;
                                                    if (XFER_TRACE) {
                                                        System.out.println("active_write_queue_processor_count=" + DHTTransportUDPImpl.this.active_write_queue_processor_count);
                                                    }
                                                    Object var6_9 = null;
                                                    DHTTransportUDPImpl.this.this_mon.exit();
                                                    return;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var6_10 = null;
                                                    DHTTransportUDPImpl.this.this_mon.exit();
                                                    throw throwable;
                                                }
                                            }
                                        }
                                        Object var4_4 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var4_6 = null;
                                        try {}
                                        catch (Throwable throwable2) {
                                            Object var6_12 = null;
                                            DHTTransportUDPImpl.this.this_mon.exit();
                                            throw throwable2;
                                        }
                                        DHTTransportUDPImpl.this.this_mon.enter();
                                        DHTTransportUDPImpl.this.active_write_queue_processor_count--;
                                        if (XFER_TRACE) {
                                            System.out.println("active_write_queue_processor_count=" + DHTTransportUDPImpl.this.active_write_queue_processor_count);
                                        }
                                        Object var6_11 = null;
                                        DHTTransportUDPImpl.this.this_mon.exit();
                                        throw throwable;
                                    }
                                    try {}
                                    catch (Throwable throwable) {
                                        Object var6_8 = null;
                                        DHTTransportUDPImpl.this.this_mon.exit();
                                        throw throwable;
                                    }
                                    DHTTransportUDPImpl.this.this_mon.enter();
                                    DHTTransportUDPImpl.this.active_write_queue_processor_count--;
                                    if (XFER_TRACE) {
                                        System.out.println("active_write_queue_processor_count=" + DHTTransportUDPImpl.this.active_write_queue_processor_count);
                                    }
                                    Object var6_7 = null;
                                    DHTTransportUDPImpl.this.this_mon.exit();
                                }
                            }.start();
                            this.sendWriteReply(dHTUDPPacketData.getConnectionId(), dHTTransportUDPContactImpl, dHTUDPPacketData.getTransferKey(), dHTUDPPacketData.getRequestKey(), dHTUDPPacketData.getStartPosition(), dHTUDPPacketData.getLength());
                        }
                        catch (DHTTransportException dHTTransportException) {
                            this.logger.log("Faild to create transfer queue");
                            this.logger.log(dHTTransportException);
                        }
                    }
                }
            }
        }
    }

    @Override
    public byte[] readTransfer(DHTTransportProgressListener dHTTransportProgressListener, DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2, long l) throws DHTTransportException {
        long l2 = this.getConnectionID();
        transferQueue transferQueue2 = new transferQueue(this.read_transfers, l2);
        return this.runTransferQueue(transferQueue2, dHTTransportProgressListener, dHTTransportContact, byArray, byArray2, l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] runTransferQueue(transferQueue transferQueue2, DHTTransportProgressListener dHTTransportProgressListener, DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2, long l, boolean bl) throws DHTTransportException {
        DHTUDPPacketData dHTUDPPacketData;
        block21: {
            Iterator iterator;
            block20: {
                TreeSet<DHTUDPPacketData> treeSet = new TreeSet<DHTUDPPacketData>(new Comparator(){

                    public int compare(Object object, Object object2) {
                        DHTUDPPacketData dHTUDPPacketData = (DHTUDPPacketData)object;
                        DHTUDPPacketData dHTUDPPacketData2 = (DHTUDPPacketData)object2;
                        return dHTUDPPacketData.getStartPosition() - dHTUDPPacketData2.getStartPosition();
                    }
                });
                int n = 0;
                int n2 = -1;
                int n3 = 0;
                String string = DHTLog.getString2(dHTTransportContact.getID());
                try {
                    long l2 = SystemTime.getCurrentTime();
                    if (bl) {
                        dHTTransportProgressListener.reportActivity(this.getMessageText("request_all", string));
                        ++n;
                        this.sendReadRequest(transferQueue2.getID(), (DHTTransportUDPContactImpl)dHTTransportContact, byArray, byArray2);
                    } else {
                        ++n;
                    }
                    block2: while (SystemTime.getCurrentTime() - l2 <= l) {
                        int n4;
                        dHTUDPPacketData = transferQueue2.receive(5000L);
                        if (dHTUDPPacketData != null) {
                            if (n2 == -1) {
                                n2 = dHTUDPPacketData.getTotalLength();
                                dHTTransportProgressListener.reportSize(n2);
                            }
                            iterator = treeSet.iterator();
                            n4 = 0;
                            while (iterator.hasNext()) {
                                DHTUDPPacketData dHTUDPPacketData2 = (DHTUDPPacketData)iterator.next();
                                if (dHTUDPPacketData2.getStartPosition() >= dHTUDPPacketData.getStartPosition() + dHTUDPPacketData.getLength() || dHTUDPPacketData2.getStartPosition() + dHTUDPPacketData2.getLength() <= dHTUDPPacketData.getStartPosition()) continue;
                                n4 = 1;
                                break;
                            }
                            if (n4 != 0) continue;
                            dHTTransportProgressListener.reportActivity(this.getMessageText("received_bit", new String[]{String.valueOf(dHTUDPPacketData.getStartPosition()), String.valueOf(dHTUDPPacketData.getStartPosition() + dHTUDPPacketData.getLength()), string}));
                            dHTTransportProgressListener.reportCompleteness(n2 == 0 ? 100 : 100 * (n3 += dHTUDPPacketData.getLength()) / n2);
                            treeSet.add(dHTUDPPacketData);
                            iterator = treeSet.iterator();
                            int n5 = 0;
                            int n6 = -1;
                            while (iterator.hasNext()) {
                                DHTUDPPacketData dHTUDPPacketData3 = (DHTUDPPacketData)iterator.next();
                                if (n6 == -1) {
                                    n6 = dHTUDPPacketData3.getTotalLength();
                                }
                                if (dHTUDPPacketData3.getStartPosition() != n5) continue block2;
                                if ((n5 += dHTUDPPacketData3.getLength()) != n6) continue;
                                dHTTransportProgressListener.reportActivity(this.getMessageText("complete"));
                                byte[] byArray3 = new byte[n6];
                                iterator = treeSet.iterator();
                                n5 = 0;
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        byte[] byArray4 = byArray3;
                                        Object var25_25 = null;
                                        transferQueue2.destroy();
                                        return byArray4;
                                    }
                                    dHTUDPPacketData3 = (DHTUDPPacketData)iterator.next();
                                    System.arraycopy(dHTUDPPacketData3.getData(), 0, byArray3, n5, dHTUDPPacketData3.getLength());
                                    n5 += dHTUDPPacketData3.getLength();
                                }
                            }
                            continue;
                        }
                        if (treeSet.size() == 0) {
                            if (n == 2) {
                                dHTTransportProgressListener.reportActivity(this.getMessageText("timeout", string));
                                iterator = null;
                                break block20;
                            } else {
                                ++n;
                                dHTTransportProgressListener.reportActivity(this.getMessageText("rerequest_all", string));
                                this.sendReadRequest(transferQueue2.getID(), (DHTTransportUDPContactImpl)dHTTransportContact, byArray, byArray2);
                                continue;
                            }
                        }
                        iterator = treeSet.iterator();
                        n4 = 0;
                        int n7 = -1;
                        while (iterator.hasNext()) {
                            DHTUDPPacketData dHTUDPPacketData4 = (DHTUDPPacketData)iterator.next();
                            if (n7 == -1) {
                                n7 = dHTUDPPacketData4.getTotalLength();
                            }
                            if (dHTUDPPacketData4.getStartPosition() != n4) {
                                dHTTransportProgressListener.reportActivity(this.getMessageText("rerequest_bit", new String[]{String.valueOf(n4), String.valueOf(dHTUDPPacketData4.getStartPosition()), string}));
                                this.sendReadRequest(transferQueue2.getID(), (DHTTransportUDPContactImpl)dHTTransportContact, byArray, byArray2, n4, dHTUDPPacketData4.getStartPosition() - n4);
                            }
                            n4 = dHTUDPPacketData4.getStartPosition() + dHTUDPPacketData4.getLength();
                        }
                        if (n4 == n7) continue;
                        dHTTransportProgressListener.reportActivity(this.getMessageText("rerequest_bit", new String[]{String.valueOf(n4), String.valueOf(n7), string}));
                        this.sendReadRequest(transferQueue2.getID(), (DHTTransportUDPContactImpl)dHTTransportContact, byArray, byArray2, n4, n7 - n4);
                    }
                    if (treeSet.size() == 0) {
                        dHTTransportProgressListener.reportActivity(this.getMessageText("timeout", string));
                    } else {
                        dHTTransportProgressListener.reportActivity(this.getMessageText("timeout_some", new String[]{String.valueOf(treeSet.size()), string}));
                    }
                    dHTUDPPacketData = null;
                    break block21;
                }
                catch (Throwable throwable) {
                    Object var25_28 = null;
                    transferQueue2.destroy();
                    throw throwable;
                }
            }
            Object var25_26 = null;
            transferQueue2.destroy();
            return iterator;
        }
        Object var25_27 = null;
        transferQueue2.destroy();
        return dHTUDPPacketData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTransfer(DHTTransportProgressListener dHTTransportProgressListener, DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2, byte[] byArray3, long l) throws DHTTransportException {
        transferQueue transferQueue2 = null;
        try {
            boolean bl;
            block9: {
                long l2 = this.getConnectionID();
                transferQueue2 = new transferQueue(this.write_transfers, l2);
                bl = false;
                boolean bl2 = false;
                int n = 0;
                int n2 = byArray3.length;
                long l3 = SystemTime.getCurrentTime();
                long l4 = 0L;
                while (true) {
                    DHTUDPPacketData dHTUDPPacketData;
                    long l5;
                    if ((l5 = SystemTime.getCurrentTime()) < l3) {
                        l3 = l5;
                        l4 = 0L;
                    } else if (l5 - l3 > l) break block9;
                    long l6 = l5 - l4;
                    if (l6 >= 12500L) {
                        dHTTransportProgressListener.reportActivity(this.getMessageText(n == 0 ? "sending" : "resending"));
                        ++n;
                        n2 = this.handleTransferRequest((DHTTransportUDPContactImpl)dHTTransportContact, l2, byArray, byArray2, byArray3, -1, -1, true, bl2);
                        l4 = l5;
                        l6 = 0L;
                    }
                    if ((dHTUDPPacketData = transferQueue2.receive(12500L - l6)) == null) continue;
                    l4 = l5;
                    bl2 = true;
                    if (dHTUDPPacketData.getStartPosition() == 0 && dHTUDPPacketData.getLength() == n2) break;
                }
                bl = true;
            }
            if (!bl) {
                dHTTransportProgressListener.reportActivity(this.getMessageText("send_timeout"));
                throw new DHTTransportException("Timeout");
            }
            dHTTransportProgressListener.reportCompleteness(100);
            dHTTransportProgressListener.reportActivity(this.getMessageText("send_complete"));
            Object var25_18 = null;
            if (transferQueue2 != null) {
                transferQueue2.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var25_19 = null;
            if (transferQueue2 != null) {
                transferQueue2.destroy();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] writeReadTransfer(DHTTransportProgressListener dHTTransportProgressListener, DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2, long l) throws DHTTransportException {
        byte[] byArray3;
        byte[] byArray4 = new byte[20];
        this.random.nextBytes(byArray4);
        AESemaphore aESemaphore = new AESemaphore("DHTTransportUDP:calSem");
        HashWrapper hashWrapper = new HashWrapper(byArray4);
        try {
            this.this_mon.enter();
            this.call_transfers.put(hashWrapper, aESemaphore);
            byArray3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.writeTransfer(dHTTransportProgressListener, dHTTransportContact, byArray, byArray4, byArray2, l);
        if (aESemaphore.reserve(l)) {
            block6: {
                try {
                    this.this_mon.enter();
                    Object v = this.call_transfers.remove(hashWrapper);
                    if (!(v instanceof byte[])) break block6;
                    byArray3 = (byte[])v;
                    Object var13_13 = null;
                    this.this_mon.exit();
                    return byArray3;
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            Object var13_14 = null;
            this.this_mon.exit();
        }
        throw new DHTTransportException("timeout");
    }

    @Override
    public void process(DHTUDPPacketRequest dHTUDPPacketRequest, boolean bl) {
        if (this.request_handler == null) {
            this.logger.log("Ignoring packet as not yet ready to process");
            return;
        }
        try {
            boolean bl2;
            this.stats.incomingRequestReceived(dHTUDPPacketRequest, bl);
            InetSocketAddress inetSocketAddress = dHTUDPPacketRequest.getAddress();
            DHTTransportUDPContactImpl dHTTransportUDPContactImpl = new DHTTransportUDPContactImpl(false, this, inetSocketAddress, dHTUDPPacketRequest.getOriginatorAddress(), dHTUDPPacketRequest.getOriginatorVersion(), dHTUDPPacketRequest.getOriginatorInstanceID(), dHTUDPPacketRequest.getClockSkew());
            try {
                this.checkAddress(dHTTransportUDPContactImpl);
            }
            catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
                return;
            }
            this.requestReceiveRequestProcessor(dHTTransportUDPContactImpl, dHTUDPPacketRequest);
            boolean bl3 = bl2 = !dHTTransportUDPContactImpl.addressMatchesID();
            if (bl2 && !this.bootstrap_node) {
                String string = dHTTransportUDPContactImpl.getString();
                if (this.recent_reports.get(string) == null) {
                    this.recent_reports.put(string, "");
                    this.logger.log("Node " + string + " has incorrect ID, reporting it to them");
                }
                DHTUDPPacketReplyError dHTUDPPacketReplyError = new DHTUDPPacketReplyError(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                dHTUDPPacketReplyError.setErrorType(1);
                dHTUDPPacketReplyError.setOriginatingAddress(dHTTransportUDPContactImpl.getTransportAddress());
                this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyError);
                this.packet_handler.send(dHTUDPPacketReplyError, dHTUDPPacketRequest.getAddress());
            } else {
                if (bl2) {
                    dHTTransportUDPContactImpl = new DHTTransportUDPContactImpl(false, this, inetSocketAddress, inetSocketAddress, dHTUDPPacketRequest.getOriginatorVersion(), dHTUDPPacketRequest.getOriginatorInstanceID(), dHTUDPPacketRequest.getClockSkew());
                } else {
                    this.contactAlive(dHTTransportUDPContactImpl);
                }
                if (dHTUDPPacketRequest instanceof DHTUDPPacketRequestPing) {
                    if (!this.bootstrap_node) {
                        this.request_handler.pingRequest(dHTTransportUDPContactImpl);
                        DHTUDPPacketReplyPing dHTUDPPacketReplyPing = new DHTUDPPacketReplyPing(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                        this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyPing);
                        this.packet_handler.send(dHTUDPPacketReplyPing, dHTUDPPacketRequest.getAddress());
                    }
                } else if (dHTUDPPacketRequest instanceof DHTUDPPacketRequestKeyBlock) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestKeyBlock dHTUDPPacketRequestKeyBlock = (DHTUDPPacketRequestKeyBlock)dHTUDPPacketRequest;
                        dHTTransportUDPContactImpl.setRandomID(dHTUDPPacketRequestKeyBlock.getRandomID());
                        this.request_handler.keyBlockRequest(dHTTransportUDPContactImpl, dHTUDPPacketRequestKeyBlock.getKeyBlockRequest(), dHTUDPPacketRequestKeyBlock.getKeyBlockSignature());
                        DHTUDPPacketReplyKeyBlock dHTUDPPacketReplyKeyBlock = new DHTUDPPacketReplyKeyBlock(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                        this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyKeyBlock);
                        this.packet_handler.send(dHTUDPPacketReplyKeyBlock, dHTUDPPacketRequest.getAddress());
                    }
                } else if (dHTUDPPacketRequest instanceof DHTUDPPacketRequestStats) {
                    DHTUDPPacketRequestStats dHTUDPPacketRequestStats = (DHTUDPPacketRequestStats)dHTUDPPacketRequest;
                    DHTUDPPacketReplyStats dHTUDPPacketReplyStats = new DHTUDPPacketReplyStats(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                    int n = dHTUDPPacketRequestStats.getStatsType();
                    if (n == 1) {
                        DHTTransportFullStats dHTTransportFullStats = this.request_handler.statsRequest(dHTTransportUDPContactImpl);
                        dHTUDPPacketReplyStats.setOriginalStats(dHTTransportFullStats);
                    } else if (n == 2) {
                        DHTNetworkPositionProvider dHTNetworkPositionProvider = DHTNetworkPositionManager.getProvider((byte)5);
                        byte[] byArray = new byte[]{};
                        if (dHTNetworkPositionProvider != null) {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                            dHTNetworkPositionProvider.serialiseStats(dataOutputStream);
                            dataOutputStream.flush();
                            byArray = byteArrayOutputStream.toByteArray();
                        }
                        dHTUDPPacketReplyStats.setNewStats(byArray, 5);
                    } else {
                        throw new IOException("Uknown stats type '" + n + "'");
                    }
                    this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyStats);
                    this.packet_handler.send(dHTUDPPacketReplyStats, dHTUDPPacketRequest.getAddress());
                } else if (dHTUDPPacketRequest instanceof DHTUDPPacketRequestStore) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestStore dHTUDPPacketRequestStore = (DHTUDPPacketRequestStore)dHTUDPPacketRequest;
                        dHTTransportUDPContactImpl.setRandomID(dHTUDPPacketRequestStore.getRandomID());
                        DHTTransportStoreReply dHTTransportStoreReply = this.request_handler.storeRequest(dHTTransportUDPContactImpl, dHTUDPPacketRequestStore.getKeys(), dHTUDPPacketRequestStore.getValueSets());
                        if (dHTTransportStoreReply.blocked()) {
                            if (dHTTransportUDPContactImpl.getProtocolVersion() >= 14) {
                                DHTUDPPacketReplyError dHTUDPPacketReplyError = new DHTUDPPacketReplyError(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                                dHTUDPPacketReplyError.setErrorType(2);
                                dHTUDPPacketReplyError.setKeyBlockDetails(dHTTransportStoreReply.getBlockRequest(), dHTTransportStoreReply.getBlockSignature());
                                this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyError);
                                this.packet_handler.send(dHTUDPPacketReplyError, dHTUDPPacketRequest.getAddress());
                            } else {
                                DHTUDPPacketReplyStore dHTUDPPacketReplyStore = new DHTUDPPacketReplyStore(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                                dHTUDPPacketReplyStore.setDiversificationTypes(new byte[dHTUDPPacketRequestStore.getKeys().length]);
                                this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyStore);
                                this.packet_handler.send(dHTUDPPacketReplyStore, dHTUDPPacketRequest.getAddress());
                            }
                        } else {
                            DHTUDPPacketReplyStore dHTUDPPacketReplyStore = new DHTUDPPacketReplyStore(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                            dHTUDPPacketReplyStore.setDiversificationTypes(dHTTransportStoreReply.getDiversificationTypes());
                            this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyStore);
                            this.packet_handler.send(dHTUDPPacketReplyStore, dHTUDPPacketRequest.getAddress());
                        }
                    }
                } else if (dHTUDPPacketRequest instanceof DHTUDPPacketRequestQueryStorage) {
                    DHTUDPPacketRequestQueryStorage dHTUDPPacketRequestQueryStorage = (DHTUDPPacketRequestQueryStorage)dHTUDPPacketRequest;
                    DHTTransportQueryStoreReply dHTTransportQueryStoreReply = this.request_handler.queryStoreRequest(dHTTransportUDPContactImpl, dHTUDPPacketRequestQueryStorage.getHeaderLength(), dHTUDPPacketRequestQueryStorage.getKeys());
                    DHTUDPPacketReplyQueryStorage dHTUDPPacketReplyQueryStorage = new DHTUDPPacketReplyQueryStorage(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                    dHTUDPPacketReplyQueryStorage.setRandomID(dHTTransportUDPContactImpl.getRandomID());
                    dHTUDPPacketReplyQueryStorage.setResponse(dHTTransportQueryStoreReply.getHeaderSize(), dHTTransportQueryStoreReply.getEntries());
                    this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyQueryStorage);
                    this.packet_handler.send(dHTUDPPacketReplyQueryStorage, dHTUDPPacketRequest.getAddress());
                } else if (dHTUDPPacketRequest instanceof DHTUDPPacketRequestFindNode) {
                    DHTUDPPacketRequestFindNode dHTUDPPacketRequestFindNode = (DHTUDPPacketRequestFindNode)dHTUDPPacketRequest;
                    boolean bl4 = this.bootstrap_node ? bl2 || Arrays.equals(dHTUDPPacketRequestFindNode.getID(), dHTTransportUDPContactImpl.getID()) : true;
                    if (bl4) {
                        if (dHTUDPPacketRequestFindNode.getProtocolVersion() >= 22) {
                            this.updateContactStatus(dHTTransportUDPContactImpl, dHTUDPPacketRequestFindNode.getNodeStatus(), true);
                            this.request_handler.setTransportEstimatedDHTSize(dHTUDPPacketRequestFindNode.getEstimatedDHTSize());
                        }
                        DHTTransportContact[] dHTTransportContactArray = this.request_handler.findNodeRequest(dHTTransportUDPContactImpl, dHTUDPPacketRequestFindNode.getID());
                        DHTUDPPacketReplyFindNode dHTUDPPacketReplyFindNode = new DHTUDPPacketReplyFindNode(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                        dHTUDPPacketReplyFindNode.setRandomID(dHTTransportUDPContactImpl.getRandomID());
                        dHTUDPPacketReplyFindNode.setNodeStatus(this.getNodeStatus());
                        dHTUDPPacketReplyFindNode.setEstimatedDHTSize(this.request_handler.getTransportEstimatedDHTSize());
                        dHTUDPPacketReplyFindNode.setContacts(dHTTransportContactArray);
                        this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyFindNode);
                        this.packet_handler.send(dHTUDPPacketReplyFindNode, dHTUDPPacketRequest.getAddress());
                    }
                } else if (dHTUDPPacketRequest instanceof DHTUDPPacketRequestFindValue) {
                    if (!this.bootstrap_node) {
                        DHTUDPPacketRequestFindValue dHTUDPPacketRequestFindValue = (DHTUDPPacketRequestFindValue)dHTUDPPacketRequest;
                        DHTTransportFindValueReply dHTTransportFindValueReply = this.request_handler.findValueRequest(dHTTransportUDPContactImpl, dHTUDPPacketRequestFindValue.getID(), dHTUDPPacketRequestFindValue.getMaximumValues(), dHTUDPPacketRequestFindValue.getFlags());
                        if (dHTTransportFindValueReply.blocked()) {
                            if (dHTTransportUDPContactImpl.getProtocolVersion() >= 14) {
                                DHTUDPPacketReplyError dHTUDPPacketReplyError = new DHTUDPPacketReplyError(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                                dHTUDPPacketReplyError.setErrorType(2);
                                dHTUDPPacketReplyError.setKeyBlockDetails(dHTTransportFindValueReply.getBlockedKey(), dHTTransportFindValueReply.getBlockedSignature());
                                this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyError);
                                this.packet_handler.send(dHTUDPPacketReplyError, dHTUDPPacketRequest.getAddress());
                            } else {
                                DHTUDPPacketReplyFindValue dHTUDPPacketReplyFindValue = new DHTUDPPacketReplyFindValue(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                                dHTUDPPacketReplyFindValue.setValues(new DHTTransportValue[0], (byte)1, false);
                                this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyFindValue);
                                this.packet_handler.send(dHTUDPPacketReplyFindValue, dHTUDPPacketRequest.getAddress());
                            }
                        } else {
                            DHTUDPPacketReplyFindValue dHTUDPPacketReplyFindValue = new DHTUDPPacketReplyFindValue(this, dHTUDPPacketRequest.getTransactionId(), dHTUDPPacketRequest.getConnectionId(), this.local_contact, dHTTransportUDPContactImpl);
                            if (dHTTransportFindValueReply.hit()) {
                                DHTTransportValue[] dHTTransportValueArray;
                                DHTTransportValue[] dHTTransportValueArray2 = dHTTransportFindValueReply.getValues();
                                int n = 1374;
                                ArrayList<DHTTransportValue[]> arrayList = new ArrayList<DHTTransportValue[]>();
                                int n2 = 0;
                                int n3 = 0;
                                while (n3 < dHTTransportValueArray2.length) {
                                    dHTTransportValueArray = dHTTransportValueArray2[n3];
                                    int n4 = dHTTransportValueArray.getValue().length + 26;
                                    if (n2 > 0 && n2 + n4 > n) {
                                        DHTTransportValue[] dHTTransportValueArray3 = new DHTTransportValue[arrayList.size()];
                                        arrayList.toArray(dHTTransportValueArray3);
                                        dHTUDPPacketReplyFindValue.setValues(dHTTransportValueArray3, dHTTransportFindValueReply.getDiversificationType(), true);
                                        this.packet_handler.send(dHTUDPPacketReplyFindValue, dHTUDPPacketRequest.getAddress());
                                        n2 = 0;
                                        arrayList = new ArrayList();
                                        continue;
                                    }
                                    arrayList.add(dHTTransportValueArray);
                                    n2 += n4;
                                    ++n3;
                                }
                                dHTTransportValueArray = new DHTTransportValue[arrayList.size()];
                                arrayList.toArray(dHTTransportValueArray);
                                dHTUDPPacketReplyFindValue.setValues(dHTTransportValueArray, dHTTransportFindValueReply.getDiversificationType(), false);
                                this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyFindValue);
                                this.packet_handler.send(dHTUDPPacketReplyFindValue, dHTUDPPacketRequest.getAddress());
                            } else {
                                dHTUDPPacketReplyFindValue.setContacts(dHTTransportFindValueReply.getContacts());
                                this.requestReceiveReplyProcessor(dHTTransportUDPContactImpl, dHTUDPPacketReplyFindValue);
                                this.packet_handler.send(dHTUDPPacketReplyFindValue, dHTUDPPacketRequest.getAddress());
                            }
                        }
                    }
                } else if (dHTUDPPacketRequest instanceof DHTUDPPacketData) {
                    if (!this.bootstrap_node) {
                        this.dataRequest(dHTTransportUDPContactImpl, (DHTUDPPacketData)dHTUDPPacketRequest);
                    }
                } else {
                    Debug.out("Unexpected packet:" + dHTUDPPacketRequest.toString());
                }
            }
        }
        catch (DHTUDPPacketHandlerException dHTUDPPacketHandlerException) {
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    protected void requestReceiveRequestProcessor(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTUDPPacketRequest dHTUDPPacketRequest) {
    }

    protected void requestReceiveReplyProcessor(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTUDPPacketReply dHTUDPPacketReply) {
        int n = dHTUDPPacketReply.getAction();
        if (n == 1025 || n == 1029 || n == 1031) {
            dHTUDPPacketReply.setNetworkPositions(this.local_contact.getNetworkPositions());
        }
    }

    protected void requestSendRequestProcessor(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTUDPPacketRequest dHTUDPPacketRequest) {
    }

    protected void requestSendReplyProcessor(DHTTransportUDPContactImpl dHTTransportUDPContactImpl, DHTTransportReplyHandler dHTTransportReplyHandler, DHTUDPPacketReply dHTUDPPacketReply, long l) throws DHTUDPPacketHandlerException {
        DHTNetworkPosition[] dHTNetworkPositionArray = dHTUDPPacketReply.getNetworkPositions();
        if (dHTNetworkPositionArray != null) {
            dHTTransportUDPContactImpl.setNetworkPositions(dHTNetworkPositionArray);
            DHTNetworkPositionManager.update(this.local_contact.getNetworkPositions(), dHTTransportUDPContactImpl.getID(), dHTNetworkPositionArray, l);
        }
        if (dHTUDPPacketReply.getAction() == 1032) {
            DHTUDPPacketReplyError dHTUDPPacketReplyError = (DHTUDPPacketReplyError)dHTUDPPacketReply;
            switch (dHTUDPPacketReplyError.getErrorType()) {
                case 1: {
                    try {
                        this.externalAddressChange(dHTTransportUDPContactImpl, dHTUDPPacketReplyError.getOriginatingAddress(), false);
                    }
                    catch (DHTTransportException dHTTransportException) {
                        Debug.printStackTrace(dHTTransportException);
                    }
                    throw new DHTUDPPacketHandlerException("address changed notification");
                }
                case 2: {
                    dHTTransportReplyHandler.keyBlockRequest(dHTTransportUDPContactImpl, dHTUDPPacketReplyError.getKeyBlockRequest(), dHTUDPPacketReplyError.getKeyBlockSignature());
                    this.contactAlive(dHTTransportUDPContactImpl);
                    throw new DHTUDPPacketHandlerException("key blocked");
                }
            }
            throw new DHTUDPPacketHandlerException("unknown error type " + dHTUDPPacketReplyError.getErrorType());
        }
        this.contactAlive(dHTTransportUDPContactImpl);
    }

    protected long getConnectionID() {
        return Long.MIN_VALUE | this.random.nextLong();
    }

    @Override
    public boolean supportsStorage() {
        return !this.bootstrap_node;
    }

    @Override
    public void addListener(DHTTransportListener dHTTransportListener) {
        this.listeners.add(dHTTransportListener);
        if (this.external_address != null) {
            dHTTransportListener.currentAddress(this.external_address);
        }
    }

    @Override
    public void removeListener(DHTTransportListener dHTTransportListener) {
        this.listeners.remove(dHTTransportListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected transferQueue lookupTransferQueue(Map map, long l) {
        try {
            this.this_mon.enter();
            transferQueue transferQueue2 = (transferQueue)map.get(new Long(l));
            Object var6_4 = null;
            this.this_mon.exit();
            return transferQueue2;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected String getMessageText(String string) {
        return MessageText.getString("DHTTransport.report." + string);
    }

    protected String getMessageText(String string, String string2) {
        return MessageText.getString("DHTTransport.report." + string, new String[]{string2});
    }

    protected String getMessageText(String string, String[] stringArray) {
        return MessageText.getString("DHTTransport.report." + string, stringArray);
    }

    static {
        if (XFER_TRACE) {
            System.out.println("**** DHTTransportUDPImpl xfer trace on ****");
        }
        class_mon = new AEMonitor("DHTTransportUDP:class");
    }

    protected class transferHandlerInterceptor
    implements DHTTransportTransferHandler {
        private DHTTransportTransferHandler handler;

        protected transferHandlerInterceptor(DHTTransportTransferHandler dHTTransportTransferHandler) {
            this.handler = dHTTransportTransferHandler;
        }

        public String getName() {
            return this.handler.getName();
        }

        public byte[] handleRead(DHTTransportContact dHTTransportContact, byte[] byArray) {
            return this.handler.handleRead(dHTTransportContact, byArray);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] handleWrite(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
            block3: {
                HashWrapper hashWrapper = new HashWrapper(byArray);
                try {
                    DHTTransportUDPImpl.this.this_mon.enter();
                    Object v = DHTTransportUDPImpl.this.call_transfers.get(hashWrapper);
                    if (!(v instanceof AESemaphore)) break block3;
                    AESemaphore aESemaphore = (AESemaphore)v;
                    DHTTransportUDPImpl.this.call_transfers.put(hashWrapper, byArray2);
                    aESemaphore.release();
                    byte[] byArray3 = null;
                    Object var9_8 = null;
                    DHTTransportUDPImpl.this.this_mon.exit();
                    return byArray3;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    DHTTransportUDPImpl.this.this_mon.exit();
                    throw throwable;
                }
            }
            Object var9_9 = null;
            DHTTransportUDPImpl.this.this_mon.exit();
            return this.handler.handleWrite(dHTTransportContact, byArray, byArray2);
        }
    }

    protected class transferQueue {
        private Map transfers;
        private long id;
        private boolean destroyed;
        private List packets = new ArrayList();
        private AESemaphore packets_sem = new AESemaphore("DHTUDPTransport:transferQueue");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected transferQueue(Map map, long l) throws DHTTransportException {
            this.transfers = map;
            this.id = l;
            try {
                DHTTransportUDPImpl.this.this_mon.enter();
                if (this.transfers.size() > 64) {
                    Debug.out("Transfer queue count limit exceeded");
                    throw new DHTTransportException("Transfer queue limit exceeded");
                }
                Long l2 = new Long(this.id);
                transferQueue transferQueue2 = (transferQueue)this.transfers.get(l2);
                if (transferQueue2 != null) {
                    transferQueue2.destroy();
                }
                this.transfers.put(l2, this);
                Object var8_6 = null;
                DHTTransportUDPImpl.this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                DHTTransportUDPImpl.this.this_mon.exit();
                throw throwable;
            }
        }

        protected long getID() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void add(DHTUDPPacketData dHTUDPPacketData) {
            block6: {
                block5: {
                    try {
                        DHTTransportUDPImpl.this.this_mon.enter();
                        if (this.destroyed) {
                            Object var4_2 = null;
                            DHTTransportUDPImpl.this.this_mon.exit();
                            return;
                        }
                        if (DHTTransportUDPImpl.this.total_bytes_on_transfer_queues > 0x800000L) {
                            Debug.out("Transfer queue byte limit exceeded");
                            break block5;
                        }
                        int n = dHTUDPPacketData.getLength();
                        DHTTransportUDPImpl.this.total_bytes_on_transfer_queues += n;
                        if (XFER_TRACE) {
                            System.out.println("total_bytes_on_transfer_queues=" + DHTTransportUDPImpl.this.total_bytes_on_transfer_queues);
                        }
                        this.packets.add(dHTUDPPacketData);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                        throw throwable;
                    }
                }
                Object var4_3 = null;
                DHTTransportUDPImpl.this.this_mon.exit();
                return;
            }
            Object var4_4 = null;
            DHTTransportUDPImpl.this.this_mon.exit();
            this.packets_sem.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DHTUDPPacketData receive(long l) {
            if (this.packets_sem.reserve(l)) {
                block5: {
                    try {
                        DHTTransportUDPImpl.this.this_mon.enter();
                        if (!this.destroyed) break block5;
                        DHTUDPPacketData dHTUDPPacketData = null;
                        Object var7_4 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                        return dHTUDPPacketData;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        DHTTransportUDPImpl.this.this_mon.exit();
                        throw throwable;
                    }
                }
                DHTUDPPacketData dHTUDPPacketData = (DHTUDPPacketData)this.packets.remove(0);
                int n = dHTUDPPacketData.getLength();
                DHTTransportUDPImpl.this.total_bytes_on_transfer_queues -= n;
                if (XFER_TRACE) {
                    System.out.println("total_bytes_on_transfer_queues=" + DHTTransportUDPImpl.this.total_bytes_on_transfer_queues);
                }
                DHTUDPPacketData dHTUDPPacketData2 = dHTUDPPacketData;
                Object var7_5 = null;
                DHTTransportUDPImpl.this.this_mon.exit();
                return dHTUDPPacketData2;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void destroy() {
            try {
                DHTTransportUDPImpl.this.this_mon.enter();
                this.destroyed = true;
                this.transfers.remove(new Long(this.id));
                for (int i = 0; i < this.packets.size(); ++i) {
                    DHTUDPPacketData dHTUDPPacketData = (DHTUDPPacketData)this.packets.get(i);
                    int n = dHTUDPPacketData.getLength();
                    DHTTransportUDPImpl.this.total_bytes_on_transfer_queues -= n;
                    if (!XFER_TRACE) continue;
                    System.out.println("total_bytes_on_transfer_queues=" + DHTTransportUDPImpl.this.total_bytes_on_transfer_queues);
                }
                this.packets.clear();
                this.packets_sem.releaseForever();
                Object var5_4 = null;
                DHTTransportUDPImpl.this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                DHTTransportUDPImpl.this.this_mon.exit();
                throw throwable;
            }
        }
    }
}

