/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.control.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlListener;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.control.impl.DHTControlContactImpl;
import com.aelitis.azureus.core.dht.control.impl.DHTControlStatsImpl;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.db.DHTDBFactory;
import com.aelitis.azureus.core.dht.db.DHTDBLookupResult;
import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterAdapter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.DHTRouterFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportQueryStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTControlImpl
implements DHTControl,
DHTTransportRequestHandler {
    private static final boolean DISABLE_REPLICATE_ON_JOIN = true;
    public static int EXTERNAL_LOOKUP_CONCURRENCY = 16;
    private static final int EXTERNAL_PUT_CONCURRENCY = 8;
    private static final int RANDOM_QUERY_PERIOD = 300000;
    private static final int INTEGRATION_TIME_MAX = 15000;
    private DHTControlAdapter adapter;
    private DHTTransport transport;
    private DHTTransportContact local_contact;
    private DHTRouter router;
    private DHTDB database;
    private DHTControlStatsImpl stats;
    private DHTLogger logger;
    private int node_id_byte_count;
    private int search_concurrency;
    private int lookup_concurrency;
    private int cache_at_closest_n;
    private int K;
    private int B;
    private int max_rep_per_node;
    private long router_start_time;
    private int router_count;
    private ThreadPool internal_lookup_pool;
    private ThreadPool external_lookup_pool;
    private ThreadPool internal_put_pool;
    private ThreadPool external_put_pool;
    private Map imported_state = new HashMap();
    private volatile boolean seeded;
    private long last_lookup;
    private ListenerManager listeners = ListenerManager.createAsyncManager("DHTControl:listenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            DHTControlListener dHTControlListener = (DHTControlListener)object;
            dHTControlListener.activityChanged((DHTControlActivity)object2, n);
        }
    });
    private List activities = new ArrayList();
    private AEMonitor activity_mon = new AEMonitor("DHTControl:activities");
    protected AEMonitor estimate_mon = new AEMonitor("DHTControl:estimate");
    private long last_dht_estimate_time;
    private long local_dht_estimate;
    private long combined_dht_estimate;
    private int combined_dht_estimate_mag;
    private static final int LOCAL_ESTIMATE_HISTORY = 32;
    private Map local_estimate_values = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 32;
        }
    };
    private static final int REMOTE_ESTIMATE_HISTORY = 128;
    private List remote_estimate_values = new LinkedList();
    protected AEMonitor spoof_mon = new AEMonitor("DHTControl:spoof");
    private Cipher spoof_cipher;
    private SecretKey spoof_key;
    private DHTTransportContact spoof_last_verify_contact;
    private int spoof_last_verify_result;
    private long last_node_add_check;
    private byte[] node_add_check_uninteresting_limit;
    private long rbs_time;
    private byte[] rbs_id = new byte[0];

    public DHTControlImpl(DHTControlAdapter dHTControlAdapter, DHTTransport dHTTransport, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, DHTLogger dHTLogger) {
        this.adapter = dHTControlAdapter;
        this.transport = dHTTransport;
        this.logger = dHTLogger;
        this.K = n;
        this.B = n2;
        this.max_rep_per_node = n3;
        this.search_concurrency = n4;
        this.lookup_concurrency = n5;
        this.cache_at_closest_n = n8;
        this.last_dht_estimate_time = SystemTime.getCurrentTime();
        this.database = DHTDBFactory.create(this.adapter.getStorageAdapter(), n6, n7, this.transport.getProtocolVersion(), this.logger);
        this.internal_lookup_pool = new ThreadPool("DHTControl:internallookups", this.lookup_concurrency);
        this.internal_put_pool = new ThreadPool("DHTControl:internalputs", this.lookup_concurrency);
        this.external_lookup_pool = new ThreadPool("DHTControl:externallookups", EXTERNAL_LOOKUP_CONCURRENCY, true);
        this.external_put_pool = new ThreadPool("DHTControl:puts", 8, true);
        this.createRouter(this.transport.getLocalContact());
        this.node_id_byte_count = this.router.getID().length;
        this.stats = new DHTControlStatsImpl(this);
        if (this.transport.supportsStorage()) {
            try {
                this.spoof_cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
                KeyGenerator keyGenerator = KeyGenerator.getInstance("DESede");
                this.spoof_key = keyGenerator.generateKey();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                this.logger.log(throwable);
            }
        }
        this.transport.setRequestHandler(this);
        this.transport.addListener(new DHTTransportListener(){

            public void localContactChanged(DHTTransportContact dHTTransportContact) {
                DHTTransportContact dHTTransportContact2;
                DHTRouterContact dHTRouterContact;
                int n;
                DHTControlImpl.this.logger.log("Transport ID changed, recreating router");
                List<DHTRouterContact> list = DHTControlImpl.this.router.findBestContacts(0);
                byte[] byArray = DHTControlImpl.this.router.getID();
                DHTControlImpl.this.createRouter(dHTTransportContact);
                Set<DHTTransportContact> set = new sortedTransportContactSet(DHTControlImpl.this.router.getID(), true).getSet();
                for (n = 0; n < list.size(); ++n) {
                    dHTRouterContact = list.get(n);
                    if (Arrays.equals(byArray, dHTRouterContact.getID()) || !dHTRouterContact.isAlive()) continue;
                    dHTTransportContact2 = ((DHTControlContactImpl)dHTRouterContact.getAttachment()).getTransportContact();
                    set.add(dHTTransportContact2);
                }
                for (n = 0; set.size() < 32 && n < list.size(); ++n) {
                    dHTRouterContact = list.get(n);
                    if (Arrays.equals(byArray, dHTRouterContact.getID()) || dHTRouterContact.isAlive()) continue;
                    dHTTransportContact2 = ((DHTControlContactImpl)dHTRouterContact.getAttachment()).getTransportContact();
                    set.add(dHTTransportContact2);
                }
                Iterator<DHTTransportContact> iterator = set.iterator();
                for (int i = 0; iterator.hasNext() && i < 128; ++i) {
                    dHTTransportContact2 = iterator.next();
                    DHTControlImpl.this.router.contactAlive(dHTTransportContact2.getID(), new DHTControlContactImpl(dHTTransportContact2));
                }
                DHTControlImpl.this.seed(false);
            }

            public void resetNetworkPositions() {
                List<DHTRouterContact> list = DHTControlImpl.this.router.getAllContacts();
                for (int i = 0; i < list.size(); ++i) {
                    DHTRouterContact dHTRouterContact = list.get(i);
                    if (DHTControlImpl.this.router.isID(dHTRouterContact.getID())) continue;
                    ((DHTControlContactImpl)dHTRouterContact.getAttachment()).getTransportContact().createNetworkPositions(false);
                }
            }

            public void currentAddress(String string) {
            }

            public void reachabilityChanged(boolean bl) {
            }
        });
    }

    protected void createRouter(DHTTransportContact dHTTransportContact) {
        this.router_start_time = SystemTime.getCurrentTime();
        ++this.router_count;
        this.local_contact = dHTTransportContact;
        if (this.router != null) {
            this.router.destroy();
        }
        this.router = DHTRouterFactory.create(this.K, this.B, this.max_rep_per_node, this.local_contact.getID(), new DHTControlContactImpl(this.local_contact), this.logger);
        this.router.setAdapter(new DHTRouterAdapter(){

            public void requestPing(DHTRouterContact dHTRouterContact) {
                DHTControlImpl.this.requestPing(dHTRouterContact);
            }

            public void requestLookup(byte[] byArray, String string) {
                DHTControlImpl.this.lookup(DHTControlImpl.this.internal_lookup_pool, false, byArray, string, (byte)0, false, 0L, DHTControlImpl.this.search_concurrency, 1, DHTControlImpl.this.router.getK(), new lookupResultHandler(new DHTOperationAdapter()){

                    public void diversify(DHTTransportContact dHTTransportContact, byte by) {
                    }

                    public void closest(List list) {
                    }
                });
            }

            public void requestAdd(DHTRouterContact dHTRouterContact) {
                DHTControlImpl.this.nodeAddedToRouter(dHTRouterContact);
            }
        });
        this.database.setControl(this);
    }

    public long getRouterUptime() {
        long l = SystemTime.getCurrentTime();
        if (l < this.router_start_time) {
            this.router_start_time = l;
        }
        return l - this.router_start_time;
    }

    public int getRouterCount() {
        return this.router_count;
    }

    @Override
    public DHTControlStats getStats() {
        return this.stats;
    }

    @Override
    public DHTTransport getTransport() {
        return this.transport;
    }

    @Override
    public DHTRouter getRouter() {
        return this.router;
    }

    @Override
    public DHTDB getDataBase() {
        return this.database;
    }

    @Override
    public void contactImported(DHTTransportContact dHTTransportContact) {
        this.router.contactKnown(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
    }

    @Override
    public void contactRemoved(DHTTransportContact dHTTransportContact) {
        if (!this.router.isID(dHTTransportContact.getID())) {
            this.router.contactDead(dHTTransportContact.getID(), true);
        }
    }

    @Override
    public void exportState(DataOutputStream dataOutputStream, int n) throws IOException {
        Object object;
        DHTRouterContact dHTRouterContact;
        int n2;
        List<DHTRouterContact> list = this.router.findBestContacts(0);
        ArrayList<DHTRouterContact> arrayList = new ArrayList<DHTRouterContact>();
        ArrayList<DHTRouterContact> arrayList2 = new ArrayList<DHTRouterContact>();
        for (n2 = 0; n2 < list.size(); ++n2) {
            dHTRouterContact = list.get(n2);
            object = (Object[])this.imported_state.get(new HashWrapper(dHTRouterContact.getID()));
            if (object == null) continue;
            if (dHTRouterContact.isAlive()) {
                arrayList.add(dHTRouterContact);
                continue;
            }
            if (dHTRouterContact.isFailing()) continue;
            arrayList2.add(dHTRouterContact);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            dHTRouterContact = list.get(n2);
            if (!dHTRouterContact.isAlive() || arrayList.contains(dHTRouterContact)) continue;
            arrayList.add(dHTRouterContact);
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            dHTRouterContact = (DHTRouterContact)arrayList2.get(n2);
            if (arrayList.contains(dHTRouterContact)) continue;
            arrayList.add(dHTRouterContact);
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            dHTRouterContact = list.get(n2);
            if (arrayList.contains(dHTRouterContact)) continue;
            arrayList.add(dHTRouterContact);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            dHTRouterContact = (DHTRouterContact)iterator.next();
            object = ((DHTControlContactImpl)dHTRouterContact.getAttachment()).getTransportContact();
            if (object.isValid()) continue;
            iterator.remove();
        }
        int n3 = Math.min(n, arrayList.size());
        dataOutputStream.writeInt(n3);
        for (int i = 0; i < n3; ++i) {
            DHTRouterContact dHTRouterContact2 = (DHTRouterContact)arrayList.get(i);
            dataOutputStream.writeLong(dHTRouterContact2.getTimeAlive());
            DHTTransportContact dHTTransportContact = ((DHTControlContactImpl)dHTRouterContact2.getAttachment()).getTransportContact();
            try {
                dHTTransportContact.exportContact(dataOutputStream);
                continue;
            }
            catch (DHTTransportException dHTTransportException) {
                Debug.printStackTrace(dHTTransportException);
                throw new IOException(dHTTransportException.getMessage());
            }
        }
        dataOutputStream.flush();
    }

    @Override
    public void importState(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            try {
                long l = dataInputStream.readLong();
                DHTTransportContact dHTTransportContact = this.transport.importContact(dataInputStream);
                this.imported_state.put(new HashWrapper(dHTTransportContact.getID()), new Object[]{new Long(l), dHTTransportContact});
                continue;
            }
            catch (DHTTransportException dHTTransportException) {
                Debug.printStackTrace(dHTTransportException);
            }
        }
    }

    @Override
    public void seed(final boolean bl) {
        long l;
        final AESemaphore aESemaphore = new AESemaphore("DHTControl:seed");
        this.lookup(this.internal_lookup_pool, false, this.router.getID(), "Seeding DHT", (byte)0, false, 0L, this.search_concurrency * 4, 1, this.router.getK(), new lookupResultHandler(new DHTOperationAdapter()){

            public void diversify(DHTTransportContact dHTTransportContact, byte by) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closest(List list) {
                if (!bl) {
                    aESemaphore.release();
                }
                DHTControlImpl.this.seeded = true;
                try {
                    DHTControlImpl.this.router.seed();
                    Object var3_2 = null;
                    if (bl) {
                        aESemaphore.release();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (bl) {
                        aESemaphore.release();
                    }
                    throw throwable;
                }
            }
        });
        long l2 = SystemTime.getCurrentTime();
        aESemaphore.reserve(15000L);
        long l3 = SystemTime.getCurrentTime();
        if (l3 < l2) {
            l2 = l3;
        }
        if ((l = 15000L - (l3 - l2)) > 500L && !bl) {
            this.logger.log("Initial integration completed, waiting " + l + " ms for second phase to start");
            try {
                Thread.sleep(l);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    @Override
    public boolean isSeeded() {
        return this.seeded;
    }

    protected void poke() {
        long l = SystemTime.getCurrentTime();
        if (l < this.last_lookup || l - this.last_lookup > 300000L) {
            this.last_lookup = l;
            this.external_lookup_pool.run(new DhtTask(this.external_lookup_pool){
                private byte[] target;
                {
                    this.target = new byte[0];
                }

                public void runSupport() {
                    this.target = DHTControlImpl.this.router.refreshRandom();
                }

                protected void cancel() {
                }

                public byte[] getTarget() {
                    return this.target;
                }

                public String getDescription() {
                    return "Random Query";
                }
            });
        }
    }

    @Override
    public void put(byte[] byArray, String string, byte[] byArray2, byte by, byte by2, byte by3, boolean bl, DHTOperationListener dHTOperationListener) {
        if (byArray2.length == 0) {
            throw new RuntimeException("zero length values not supported");
        }
        byte[] byArray3 = this.encodeKey(byArray);
        if (DHTLog.isOn()) {
            DHTLog.log("put for " + DHTLog.getString(byArray3));
        }
        DHTDBValue dHTDBValue = this.database.store(new HashWrapper(byArray3), byArray2, by, by2, by3);
        this.put(this.external_put_pool, bl, byArray3, string, dHTDBValue, by, 0L, true, new HashSet(), 1, dHTOperationListener instanceof DHTOperationListenerDemuxer ? (DHTOperationListenerDemuxer)dHTOperationListener : new DHTOperationListenerDemuxer(dHTOperationListener));
    }

    @Override
    public void putEncodedKey(byte[] byArray, String string, DHTTransportValue dHTTransportValue, long l, boolean bl) {
        this.put(this.internal_put_pool, false, byArray, string, dHTTransportValue, (byte)0, l, bl, new HashSet(), 1, new DHTOperationListenerDemuxer(new DHTOperationAdapter()));
    }

    protected void put(ThreadPool threadPool, boolean bl, byte[] byArray, String string, DHTTransportValue dHTTransportValue, byte by, long l, boolean bl2, Set set, int n, DHTOperationListenerDemuxer dHTOperationListenerDemuxer) {
        this.put(threadPool, bl, byArray, string, new DHTTransportValue[]{dHTTransportValue}, by, l, bl2, set, n, dHTOperationListenerDemuxer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(final ThreadPool threadPool, final boolean bl, byte[] byArray, String string, DHTTransportValue[] dHTTransportValueArray, byte by, long l, boolean bl2, Set set, int n, DHTOperationListenerDemuxer dHTOperationListenerDemuxer) {
        byte[][] byArray2 = this.adapter.diversify(string, null, true, true, byArray, (byte)1, bl2, this.getMaxDivDepth());
        if (byArray2.length == 0) {
            dHTOperationListenerDemuxer.diversified("Over-diversification of [" + string + "]");
            dHTOperationListenerDemuxer.complete(false);
            return;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            final byte[] byArray3 = byArray2[i];
            HashWrapper hashWrapper = new HashWrapper(byArray3);
            Object object = set;
            synchronized (object) {
                if (set.contains(hashWrapper)) {
                    continue;
                }
                set.add(hashWrapper);
            }
            object = Arrays.equals(byArray3, byArray) ? string : "Diversification of [" + string + "]";
            this.lookup(threadPool, bl, byArray3, (String)object, by, false, l, this.search_concurrency, 1, this.router.getK(), new lookupResultHandler(dHTOperationListenerDemuxer, (String)object, dHTTransportValueArray, by, l, dHTOperationListenerDemuxer, set, n){
                final /* synthetic */ String val$this_description;
                final /* synthetic */ DHTTransportValue[] val$values;
                final /* synthetic */ byte val$flags;
                final /* synthetic */ long val$timeout;
                final /* synthetic */ DHTOperationListenerDemuxer val$listener;
                final /* synthetic */ Set val$things_written;
                final /* synthetic */ int val$put_level;
                {
                    this.val$this_description = string;
                    this.val$values = dHTTransportValueArray;
                    this.val$flags = by;
                    this.val$timeout = l;
                    this.val$listener = dHTOperationListenerDemuxer;
                    this.val$things_written = set;
                    this.val$put_level = n;
                    super(dHTOperationListener);
                }

                public void diversify(DHTTransportContact dHTTransportContact, byte by) {
                    Debug.out("Shouldn't get a diversify on a lookup-node");
                }

                public void closest(List list) {
                    DHTControlImpl.this.put(threadPool, bl, new byte[][]{byArray3}, "Store of [" + this.val$this_description + "]", new DHTTransportValue[][]{this.val$values}, this.val$flags, list, this.val$timeout, this.val$listener, true, this.val$things_written, this.val$put_level, false);
                }
            });
        }
    }

    public void putDirectEncodedKeys(byte[][] byArray, String string, DHTTransportValue[][] dHTTransportValueArray, List list) {
        this.put(this.internal_put_pool, false, byArray, string, dHTTransportValueArray, (byte)0, list, 0L, new DHTOperationListenerDemuxer(new DHTOperationAdapter()), false, new HashSet(), 1, false);
    }

    @Override
    public void putDirectEncodedKeys(byte[][] byArray, String string, DHTTransportValue[][] dHTTransportValueArray, DHTTransportContact dHTTransportContact, DHTOperationListener dHTOperationListener) {
        ArrayList<DHTTransportContact> arrayList = new ArrayList<DHTTransportContact>(1);
        arrayList.add(dHTTransportContact);
        this.put(this.internal_put_pool, false, byArray, string, dHTTransportValueArray, (byte)0, arrayList, 0L, new DHTOperationListenerDemuxer(dHTOperationListener), false, new HashSet(), 1, false);
    }

    @Override
    public byte[] getObfuscatedKey(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, 5);
        for (int i = 6; i < n; ++i) {
            if (byArray[i] != 0) continue;
            byArray2[i] = 1;
        }
        byArray2[n - 2] = byArray[n - 2];
        byArray2[n - 1] = byArray[n - 1];
        return byArray2;
    }

    protected byte[] getObfuscatedValue(byte[] byArray) {
        RC4Engine rC4Engine = new RC4Engine();
        KeyParameter keyParameter = new KeyParameter(new SHA1Simple().calculateHash(byArray));
        rC4Engine.init(true, keyParameter);
        byte[] byArray2 = new byte[1024];
        rC4Engine.processBytes(byArray2, 0, 1024, byArray2, 0);
        byte[] byArray3 = new byte[byArray.length];
        rC4Engine.processBytes(byArray, 0, byArray.length, byArray3, 0);
        return byArray3;
    }

    protected DHTTransportValue getObfuscatedValue(final DHTTransportValue dHTTransportValue, byte[] byArray) {
        final byte[] byArray2 = this.getObfuscatedValue(byArray);
        return new DHTTransportValue(){

            public boolean isLocal() {
                return dHTTransportValue.isLocal();
            }

            public long getCreationTime() {
                return dHTTransportValue.getCreationTime();
            }

            public byte[] getValue() {
                return byArray2;
            }

            public int getVersion() {
                return dHTTransportValue.getVersion();
            }

            public DHTTransportContact getOriginator() {
                return dHTTransportValue.getOriginator();
            }

            public int getFlags() {
                return dHTTransportValue.getFlags();
            }

            public int getLifeTimeHours() {
                return dHTTransportValue.getLifeTimeHours();
            }

            public byte getReplicationControl() {
                return dHTTransportValue.getReplicationControl();
            }

            public byte getReplicationFactor() {
                return dHTTransportValue.getReplicationFactor();
            }

            public byte getReplicationFrequencyHours() {
                return dHTTransportValue.getReplicationFrequencyHours();
            }

            public String getString() {
                return "obs: " + dHTTransportValue.getString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void put(final ThreadPool threadPool, final boolean bl, byte[][] byArray, final String string, DHTTransportValue[][] dHTTransportValueArray, final byte by, List list, final long l, final DHTOperationListenerDemuxer dHTOperationListenerDemuxer, final boolean bl2, final Set set, final int n, boolean bl3) {
        DHTTransportValue[][] dHTTransportValueArray2;
        Object object;
        DHTTransportValue[][] dHTTransportValueArray3;
        int n2 = this.getMaxDivDepth();
        if (n > n2) {
            Debug.out("Put level exceeded, terminating diversification (level=" + n + ",max=" + n2 + ")");
            dHTOperationListenerDemuxer.incrementCompletes();
            dHTOperationListenerDemuxer.complete(false);
            return;
        }
        boolean[] blArray = new boolean[byArray.length];
        int n3 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            blArray[i] = !this.database.isKeyBlocked(byArray[i]);
            if (blArray[i]) continue;
            ++n3;
        }
        if (n3 == blArray.length) {
            dHTOperationListenerDemuxer.incrementCompletes();
            dHTOperationListenerDemuxer.complete(false);
            return;
        }
        final byte[][] byArray2 = n3 == 0 ? byArray : (byte[][])new byte[blArray.length - n3][];
        Object object2 = dHTTransportValueArray3 = n3 == 0 ? dHTTransportValueArray : new DHTTransportValue[blArray.length - n3][];
        if (n3 > 0) {
            int n4 = 0;
            for (int i = 0; i < blArray.length; ++i) {
                if (!blArray[i]) continue;
                byArray2[n4] = byArray[i];
                dHTTransportValueArray3[n4] = dHTTransportValueArray[i];
                ++n4;
            }
        }
        if ((by & 0xFFFFFF80) != 0) {
            if (byArray2.length != 1) {
                Debug.out("inconsistent - expected one key");
            }
            if (dHTTransportValueArray3[0].length != 1) {
                Debug.out("inconsistent - expected one value");
            }
            object = new byte[1][];
            dHTTransportValueArray2 = new DHTTransportValue[1][1];
            object[0] = this.getObfuscatedKey(byArray2[0]);
            dHTTransportValueArray2[0][0] = this.getObfuscatedValue(dHTTransportValueArray3[0][0], byArray2[0]);
        } else {
            object = null;
            dHTTransportValueArray2 = null;
        }
        final boolean[] blArray2 = new boolean[byArray2.length];
        int n5 = 0;
        for (int i = 0; i < list.size(); ++i) {
            DHTTransportContact dHTTransportContact = (DHTTransportContact)list.get(i);
            if (this.router.isID(dHTTransportContact.getID())) {
                ++n5;
                continue;
            }
            boolean bl4 = false;
            Set set2 = set;
            synchronized (set2) {
                if (set.contains(dHTTransportContact)) {
                    Debug.out("Put: contact encountered for a second time, ignoring");
                    ++n5;
                    bl4 = true;
                } else {
                    set.add(dHTTransportContact);
                }
            }
            if (bl4) continue;
            try {
                for (int j = 0; j < dHTTransportValueArray3.length; ++j) {
                    for (int k = 0; k < dHTTransportValueArray3[j].length; ++k) {
                        dHTOperationListenerDemuxer.wrote(dHTTransportContact, dHTTransportValueArray3[j][k]);
                    }
                }
                dHTOperationListenerDemuxer.incrementCompletes();
                dHTTransportContact.sendStore(new DHTTransportReplyHandlerAdapter((byte[][])object, dHTTransportContact, dHTTransportValueArray2, bl3){
                    final /* synthetic */ byte[][] val$obs_keys;
                    final /* synthetic */ DHTTransportContact val$contact;
                    final /* synthetic */ DHTTransportValue[][] val$obs_vals;
                    final /* synthetic */ boolean val$immediate;
                    {
                        this.val$obs_keys = byArray22;
                        this.val$contact = dHTTransportContact;
                        this.val$obs_vals = dHTTransportValueArray2;
                        this.val$immediate = bl3;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void storeReply(DHTTransportContact dHTTransportContact, byte[] byArray) {
                        boolean bl3 = false;
                        try {
                            if (DHTLog.isOn()) {
                                DHTLog.log("Store OK " + DHTLog.getString(dHTTransportContact));
                            }
                            DHTControlImpl.this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
                            boolean bl22 = false;
                            if (bl2 && byArray != null) {
                                for (int i = 0; i < byArray.length; ++i) {
                                    if (byArray[i] == 1 || blArray2[i]) continue;
                                    bl22 = true;
                                    blArray2[i] = true;
                                    byte[][] byArray22 = DHTControlImpl.this.adapter.diversify(string, dHTTransportContact, true, false, byArray2[i], byArray[i], false, DHTControlImpl.this.getMaxDivDepth());
                                    DHTControlImpl.this.logDiversification(dHTTransportContact, byArray2, byArray22);
                                    for (int j = 0; j < byArray22.length; ++j) {
                                        DHTControlImpl.this.put(threadPool, bl, byArray22[j], "Diversification of [" + string + "]", dHTTransportValueArray3[i], by, l, false, set, n + 1, dHTOperationListenerDemuxer);
                                    }
                                }
                            }
                            if (!bl22 && this.val$obs_keys != null) {
                                this.val$contact.sendStore(new DHTTransportReplyHandlerAdapter(){

                                    public void storeReply(DHTTransportContact dHTTransportContact, byte[] byArray) {
                                        if (DHTLog.isOn()) {
                                            DHTLog.log("Obs store OK " + DHTLog.getString(dHTTransportContact));
                                        }
                                        dHTOperationListenerDemuxer.complete(false);
                                    }

                                    public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                                        if (DHTLog.isOn()) {
                                            DHTLog.log("Obs store failed " + DHTLog.getString(dHTTransportContact) + " -> failed: " + throwable.getMessage());
                                        }
                                        dHTOperationListenerDemuxer.complete(true);
                                    }
                                }, this.val$obs_keys, this.val$obs_vals, this.val$immediate);
                                bl3 = true;
                            }
                            Object var9_8 = null;
                            if (!bl3) {
                                dHTOperationListenerDemuxer.complete(false);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (!bl3) {
                                dHTOperationListenerDemuxer.complete(false);
                            }
                            throw throwable;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                        try {
                            if (DHTLog.isOn()) {
                                DHTLog.log("Store failed " + DHTLog.getString(dHTTransportContact) + " -> failed: " + throwable.getMessage());
                            }
                            DHTControlImpl.this.router.contactDead(dHTTransportContact.getID(), false);
                            Object var4_3 = null;
                            dHTOperationListenerDemuxer.complete(true);
                        }
                        catch (Throwable throwable2) {
                            Object var4_4 = null;
                            dHTOperationListenerDemuxer.complete(true);
                            throw throwable2;
                        }
                    }

                    public void keyBlockRequest(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray22) {
                        DHTStorageBlock dHTStorageBlock = DHTControlImpl.this.database.keyBlockRequest(null, byArray, byArray22);
                        if (dHTStorageBlock != null) {
                            for (int i = 0; i < byArray2.length; ++i) {
                                if (!Arrays.equals(byArray2[i], dHTStorageBlock.getKey())) continue;
                                byte[] byArray3 = new byte[byArray2[i].length];
                                new Random().nextBytes(byArray3);
                                byArray2[i] = byArray3;
                            }
                        }
                    }
                }, byArray2, dHTTransportValueArray3, bl3);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (n5 == list.size()) {
            dHTOperationListenerDemuxer.incrementCompletes();
            dHTOperationListenerDemuxer.complete(false);
        }
    }

    protected int getMaxDivDepth() {
        if (this.combined_dht_estimate == 0L) {
            this.getEstimatedDHTSize();
        }
        int n = Math.max(2, this.combined_dht_estimate_mag);
        return n;
    }

    protected void logDiversification(DHTTransportContact dHTTransportContact, byte[][] byArray, byte[][] byArray2) {
    }

    @Override
    public DHTTransportValue getLocalValue(byte[] byArray) {
        DHTDBValue dHTDBValue;
        byte[] byArray2 = this.encodeKey(byArray);
        if (DHTLog.isOn()) {
            DHTLog.log("getLocalValue for " + DHTLog.getString(byArray2));
        }
        if ((dHTDBValue = this.database.get(new HashWrapper(byArray2))) == null) {
            return null;
        }
        return dHTDBValue;
    }

    @Override
    public void get(byte[] byArray, String string, byte by, int n, long l, boolean bl, boolean bl2, final DHTOperationListener dHTOperationListener) {
        byte[] byArray2 = this.encodeKey(byArray);
        if (DHTLog.isOn()) {
            DHTLog.log("get for " + DHTLog.getString(byArray2));
        }
        final DhtTaskSet[] dhtTaskSetArray = new DhtTaskSet[]{null};
        DHTOperationListenerDemuxer dHTOperationListenerDemuxer = new DHTOperationListenerDemuxer(new DHTOperationListener(){

            public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                dHTOperationListener.searching(dHTTransportContact, n, n2);
            }

            public void diversified(String string) {
                dHTOperationListener.diversified(string);
            }

            public void found(DHTTransportContact dHTTransportContact, boolean bl) {
                dHTOperationListener.found(dHTTransportContact, bl);
            }

            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                dHTOperationListener.read(dHTTransportContact, dHTTransportValue);
            }

            public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                dHTOperationListener.wrote(dHTTransportContact, dHTTransportValue);
            }

            public void complete(boolean bl) {
                dHTOperationListener.complete(bl);
                if (dhtTaskSetArray[0] != null) {
                    dhtTaskSetArray[0].cancel();
                }
            }
        });
        dhtTaskSetArray[0] = this.getSupport(byArray2, string, by, n, l, bl, bl2, dHTOperationListenerDemuxer);
    }

    @Override
    public boolean isDiversified(byte[] byArray) {
        byte[] byArray2 = this.encodeKey(byArray);
        return this.adapter.isDiversified(byArray2);
    }

    @Override
    public boolean lookup(byte[] byArray, String string, long l, DHTOperationListener dHTOperationListener) {
        return this.lookupEncoded(this.encodeKey(byArray), string, l, false, dHTOperationListener);
    }

    @Override
    public boolean lookupEncoded(byte[] byArray, String string, long l, boolean bl, final DHTOperationListener dHTOperationListener) {
        if (DHTLog.isOn()) {
            DHTLog.log("lookup for " + DHTLog.getString(byArray));
        }
        final AESemaphore aESemaphore = new AESemaphore("DHTControl:lookup");
        final boolean[] blArray = new boolean[]{false};
        DHTOperationListener dHTOperationListener2 = new DHTOperationListener(){

            public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
                dHTOperationListener.searching(dHTTransportContact, n, n2);
            }

            public void found(DHTTransportContact dHTTransportContact, boolean bl) {
            }

            public void diversified(String string) {
                dHTOperationListener.diversified(string);
            }

            public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
            }

            public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
            }

            public void complete(boolean bl) {
                dHTOperationListener.complete(bl);
                aESemaphore.release();
            }
        };
        this.lookup(this.external_lookup_pool, bl, byArray, string, (byte)0, false, l, this.search_concurrency, 1, this.router.getK(), new lookupResultHandler(dHTOperationListener2){

            public void diversify(DHTTransportContact dHTTransportContact, byte by) {
                this.diversified("Diversification of [lookup]");
                blArray[0] = true;
            }

            public void closest(List list) {
                for (int i = 0; i < list.size(); ++i) {
                    dHTOperationListener.found((DHTTransportContact)list.get(i), true);
                }
            }
        });
        aESemaphore.reserve();
        return blArray[0];
    }

    protected DhtTaskSet getSupport(byte[] byArray, final String string, final byte by, final int n, final long l, final boolean bl, final boolean bl2, final DHTOperationListenerDemuxer dHTOperationListenerDemuxer) {
        final DhtTaskSet dhtTaskSet = new DhtTaskSet();
        byte[][] byArray2 = this.adapter.diversify(string, null, false, true, byArray, (byte)1, bl, this.getMaxDivDepth());
        if (byArray2.length == 0) {
            dHTOperationListenerDemuxer.diversified("Over-diversification of [" + string + "]");
            dHTOperationListenerDemuxer.complete(false);
            return dhtTaskSet;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            String string2;
            final boolean[] blArray = new boolean[]{false};
            final byte[] byArray3 = byArray2[i];
            boolean bl3 = !Arrays.equals(byArray3, byArray);
            String string3 = string2 = bl3 ? "Diversification of [" + string + "]" : string;
            if (bl3) {
                dHTOperationListenerDemuxer.diversified(string2);
            }
            boolean bl4 = (by & 8) != 0;
            dhtTaskSet.add(this.lookup(this.external_lookup_pool, bl2, byArray3, string2, by, true, l, bl4 ? this.search_concurrency * 2 : this.search_concurrency, n, this.router.getK(), new lookupResultHandler(dHTOperationListenerDemuxer){
                private List found_values;
                {
                    super(dHTOperationListener);
                    this.found_values = new ArrayList();
                }

                public void diversify(DHTTransportContact dHTTransportContact, byte by2) {
                    this.diversified("Diversification of [" + string2 + "]");
                    if (!blArray[0]) {
                        byte[][] byArray;
                        int n3;
                        blArray[0] = true;
                        int n2 = n3 = n == 0 ? 0 : n - this.found_values.size();
                        if ((n == 0 || n3 > 0) && (byArray = DHTControlImpl.this.adapter.diversify(string, dHTTransportContact, false, false, byArray3, by2, bl, DHTControlImpl.this.getMaxDivDepth())).length > 0) {
                            for (int i = 0; i < byArray.length; ++i) {
                                if (dhtTaskSet.isCancelled()) continue;
                                dhtTaskSet.add(DHTControlImpl.this.getSupport(byArray[i], "Diversification of [" + string2 + "]", by, n3, l, bl, bl2, dHTOperationListenerDemuxer));
                            }
                        }
                    }
                }

                public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
                    this.found_values.add(dHTTransportValue);
                    super.read(dHTTransportContact, dHTTransportValue);
                }

                public void closest(List list) {
                }
            }));
        }
        return dhtTaskSet;
    }

    @Override
    public byte[] remove(byte[] byArray, String string, DHTOperationListener dHTOperationListener) {
        DHTDBValue dHTDBValue;
        byte[] byArray2 = this.encodeKey(byArray);
        if (DHTLog.isOn()) {
            DHTLog.log("remove for " + DHTLog.getString(byArray2));
        }
        if ((dHTDBValue = this.database.remove(this.local_contact, new HashWrapper(byArray2))) == null) {
            return null;
        }
        this.put(this.external_put_pool, false, byArray2, string, dHTDBValue, (byte)dHTDBValue.getFlags(), 0L, true, new HashSet(), 1, new DHTOperationListenerDemuxer(dHTOperationListener));
        return dHTDBValue.getValue();
    }

    @Override
    public byte[] remove(DHTTransportContact[] dHTTransportContactArray, byte[] byArray, String string, DHTOperationListener dHTOperationListener) {
        DHTDBValue dHTDBValue;
        byte[] byArray2 = this.encodeKey(byArray);
        if (DHTLog.isOn()) {
            DHTLog.log("remove for " + DHTLog.getString(byArray2));
        }
        if ((dHTDBValue = this.database.remove(this.local_contact, new HashWrapper(byArray2))) == null) {
            return null;
        }
        ArrayList<DHTTransportContact> arrayList = new ArrayList<DHTTransportContact>(dHTTransportContactArray.length);
        for (int i = 0; i < dHTTransportContactArray.length; ++i) {
            arrayList.add(dHTTransportContactArray[i]);
        }
        this.put(this.external_put_pool, true, new byte[][]{byArray2}, "Store of [" + string + "]", new DHTTransportValue[][]{{dHTDBValue}}, (byte)dHTDBValue.getFlags(), arrayList, 0L, new DHTOperationListenerDemuxer(dHTOperationListener), true, new HashSet(), 1, true);
        return dHTDBValue.getValue();
    }

    protected DhtTask lookup(final ThreadPool threadPool, boolean bl, final byte[] byArray, final String string, final byte by, final boolean bl2, final long l, final int n, final int n2, final int n3, final lookupResultHandler lookupResultHandler2) {
        byte[] byArray2;
        byte[] byArray3;
        if ((by & 0xFFFFFF80) != 0) {
            byArray3 = this.getObfuscatedKey(byArray);
            byArray2 = this.getObfuscatedValue(byArray);
        } else {
            byArray3 = byArray;
            byArray2 = null;
        }
        DhtTask dhtTask = new DhtTask(threadPool){
            boolean timeout_occurred;
            Set contacts_to_query;
            AEMonitor contacts_to_query_mon;
            Map level_map;
            Map contacts_queried;
            Set ok_contacts;
            int idle_searches;
            int active_searches;
            int values_found;
            int value_replies;
            Set values_found_set;
            boolean key_blocked;
            long start;
            TimerEvent timeoutEvent;
            private int runningState;
            private int freeTasksCount;
            private boolean cancelled;
            {
                super(threadPool3);
                this.timeout_occurred = false;
                this.runningState = 1;
                this.freeTasksCount = n;
            }

            public void runSupport() {
                this.startLookup();
            }

            private void startLookup() {
                this.contacts_to_query = DHTControlImpl.this.getClosestContactsSet(byArray3, DHTControlImpl.this.K, false);
                this.contacts_to_query_mon = new AEMonitor("DHTControl:ctq");
                this.level_map = new LightHashMap();
                this.contacts_queried = new LightHashMap();
                this.ok_contacts = new sortedTransportContactSet(byArray3, false).getSet();
                this.values_found_set = new HashSet();
                this.start = SystemTime.getMonotonousTime();
                DHTControlImpl.this.last_lookup = SystemTime.getCurrentTime();
                lookupResultHandler2.incrementCompletes();
                for (DHTTransportContact dHTTransportContact : this.contacts_to_query) {
                    lookupResultHandler2.found(dHTTransportContact, false);
                    this.level_map.put(dHTTransportContact, new Integer(0));
                }
                if (DHTLog.isOn()) {
                    DHTLog.log("lookup for " + DHTLog.getString(byArray3));
                }
                if (bl2 && DHTControlImpl.this.database.isKeyBlocked(byArray3)) {
                    DHTLog.log("lookup: terminates - key blocked");
                    this.terminateLookup(false);
                    return;
                }
                if (l > 0L) {
                    this.timeoutEvent = SimpleTimer.addEvent("DHT lookup timeout", SystemTime.getCurrentTime() + l, new TimerEventPerformer(){

                        public void perform(TimerEvent timerEvent2) {
                            if (DHTLog.isOn()) {
                                DHTLog.log("lookup: terminates - timeout");
                            }
                            timeout_occurred = true;
                            this.terminateLookup(false);
                        }
                    });
                }
                this.lookupSteps();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void terminateLookup(boolean bl) {
                if (this.timeoutEvent != null) {
                    this.timeoutEvent.cancel();
                }
                Object object = this;
                synchronized (object) {
                    if (this.runningState == -1) {
                        return;
                    }
                    this.runningState = -1;
                }
                if (!bl) {
                    object = null;
                    try {
                        this.contacts_to_query_mon.enter();
                        if (DHTLog.isOn()) {
                            DHTLog.log("lookup complete for " + DHTLog.getString(byArray3));
                            DHTLog.log("    queried = " + DHTLog.getString(this.contacts_queried));
                            DHTLog.log("    to query = " + DHTLog.getString(this.contacts_to_query));
                            DHTLog.log("    ok = " + DHTLog.getString(this.ok_contacts));
                        }
                        object = new ArrayList(this.ok_contacts);
                        Collections.reverse(object);
                        if (l <= 0L && !bl2) {
                            DHTControlImpl.this.estimateDHTSize(byArray3, this.contacts_queried, n3);
                        }
                        Object var5_4 = null;
                        this.contacts_to_query_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        this.contacts_to_query_mon.exit();
                        throw throwable;
                    }
                    lookupResultHandler2.closest((List)object);
                }
                lookupResultHandler2.complete(this.timeout_occurred);
                this.releaseToPool();
            }

            private synchronized boolean reserve() {
                if (this.freeTasksCount <= 0 || this.runningState == -1) {
                    if (this.runningState == 1) {
                        this.runningState = 0;
                    }
                    return false;
                }
                --this.freeTasksCount;
                return true;
            }

            private synchronized void release() {
                ++this.freeTasksCount;
                if (this.runningState == 0) {
                    this.runningState = 1;
                    new AEThread2("DHT lookup runner", true){

                        public void run() {
                            threadPool.registerThreadAsChild(worker);
                            this.lookupSteps();
                            threadPool.deregisterThreadAsChild(worker);
                        }
                    }.start();
                }
            }

            protected synchronized void cancel() {
                if (this.runningState != -1) {
                    // empty if block
                }
                this.cancelled = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private void lookupSteps() {
                try {
                    boolean bl = false;
                    while (!this.cancelled) {
                        Object var13_17;
                        block29: {
                            block28: {
                                block27: {
                                    block26: {
                                        block25: {
                                            if (l > 0L) {
                                                long l3 = SystemTime.getMonotonousTime();
                                                long l2 = l - (l3 - this.start);
                                                if (l2 <= 0L) {
                                                    if (DHTLog.isOn()) {
                                                        DHTLog.log("lookup: terminates - timeout");
                                                    }
                                                    this.timeout_occurred = true;
                                                    bl = true;
                                                    break;
                                                }
                                                if (!this.reserve()) {
                                                    break;
                                                }
                                            } else if (!this.reserve()) break;
                                            try {
                                                int n5;
                                                Object object;
                                                DHTNetworkPosition[] dHTNetworkPositionArray;
                                                int n22;
                                                this.contacts_to_query_mon.enter();
                                                if (this.values_found >= n2 || (by & 8) == 0 && this.value_replies >= 2) {
                                                    bl = true;
                                                    var13_17 = null;
                                                    this.contacts_to_query_mon.exit();
                                                    break;
                                                }
                                                if (this.key_blocked) {
                                                    this.contacts_to_query.clear();
                                                }
                                                if (this.contacts_to_query.size() == 0) {
                                                    if (this.active_searches == 0) {
                                                        if (DHTLog.isOn()) {
                                                            DHTLog.log("lookup: terminates - no contacts left to query");
                                                        }
                                                        bl = true;
                                                        break block25;
                                                    }
                                                    ++this.idle_searches;
                                                    break block26;
                                                }
                                                DHTTransportContact dHTTransportContact = (DHTTransportContact)this.contacts_to_query.iterator().next();
                                                if (this.ok_contacts.size() == n3 && (n22 = DHTControlImpl.this.computeAndCompareDistances((dHTNetworkPositionArray = (DHTNetworkPosition[])this.ok_contacts.iterator().next()).getID(), dHTTransportContact.getID(), byArray3)) <= 0) {
                                                    if (DHTLog.isOn()) {
                                                        DHTLog.log("lookup: terminates - we've searched the closest " + n3 + " contacts");
                                                    }
                                                    bl = true;
                                                    break block27;
                                                }
                                                if (this.contacts_queried.size() < n) {
                                                    dHTNetworkPositionArray = DHTControlImpl.this.local_contact.getNetworkPositions();
                                                    DHTTransportContact dHTTransportContact2 = null;
                                                    object = this.contacts_to_query.iterator();
                                                    n5 = n * 2 - this.contacts_queried.size();
                                                    int n32 = 0;
                                                    float f = Float.MAX_VALUE;
                                                    while (object.hasNext() && n32 < n5) {
                                                        ++n32;
                                                        DHTTransportContact dHTTransportContact3 = (DHTTransportContact)object.next();
                                                        DHTNetworkPosition[] dHTNetworkPositionArray2 = dHTTransportContact3.getNetworkPositions();
                                                        float f2 = DHTNetworkPositionManager.estimateRTT(dHTNetworkPositionArray, dHTNetworkPositionArray2);
                                                        if (!Float.isNaN(f2) && f2 < f) {
                                                            f = f2;
                                                            dHTTransportContact2 = dHTTransportContact3;
                                                        }
                                                        if (dHTTransportContact2 == null) continue;
                                                        dHTTransportContact = dHTTransportContact2;
                                                    }
                                                }
                                                dHTNetworkPositionArray = dHTTransportContact;
                                                this.contacts_to_query.remove(dHTTransportContact);
                                                this.contacts_queried.put(new HashWrapper(dHTTransportContact.getID()), dHTTransportContact);
                                                if (DHTControlImpl.this.router.isID(dHTTransportContact.getID())) {
                                                    this.release();
                                                    break block28;
                                                }
                                                final int n4 = (Integer)this.level_map.get(dHTTransportContact);
                                                ++this.active_searches;
                                                lookupResultHandler2.searching(dHTTransportContact, n4, this.active_searches);
                                                object = new DHTTransportReplyHandlerAdapter((DHTTransportContact)dHTNetworkPositionArray){
                                                    private boolean value_reply_received = false;
                                                    final /* synthetic */ DHTTransportContact val$f_closest;
                                                    {
                                                        this.val$f_closest = dHTTransportContact;
                                                    }

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    public void findNodeReply(DHTTransportContact dHTTransportContact, DHTTransportContact[] dHTTransportContactArray) {
                                                        Object v1;
                                                        block12: {
                                                            try {
                                                                DHTTransportContact dHTTransportContact2;
                                                                if (DHTLog.isOn()) {
                                                                    DHTLog.log("findNodeReply: " + DHTLog.getString(dHTTransportContactArray));
                                                                }
                                                                DHTControlImpl.this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
                                                                for (int i = 0; i < dHTTransportContactArray.length; ++i) {
                                                                    dHTTransportContact2 = dHTTransportContactArray[i];
                                                                    if (DHTControlImpl.this.compareDistances(DHTControlImpl.this.router.getID(), dHTTransportContact2.getID()) == 0) continue;
                                                                    DHTControlImpl.this.router.contactKnown(dHTTransportContact2.getID(), new DHTControlContactImpl(dHTTransportContact2));
                                                                }
                                                                try {
                                                                    contacts_to_query_mon.enter();
                                                                    ok_contacts.add(dHTTransportContact);
                                                                    if (ok_contacts.size() > n3) {
                                                                        Iterator iterator = ok_contacts.iterator();
                                                                        iterator.next();
                                                                        iterator.remove();
                                                                    }
                                                                    for (int i = 0; i < dHTTransportContactArray.length; ++i) {
                                                                        dHTTransportContact2 = dHTTransportContactArray[i];
                                                                        if (DHTControlImpl.this.compareDistances(DHTControlImpl.this.router.getID(), dHTTransportContact2.getID()) == 0 || contacts_queried.get(new HashWrapper(dHTTransportContact2.getID())) != null || contacts_to_query.contains(dHTTransportContact2)) continue;
                                                                        if (DHTLog.isOn()) {
                                                                            DHTLog.log("    new contact for query: " + DHTLog.getString(dHTTransportContact2));
                                                                        }
                                                                        contacts_to_query.add(dHTTransportContact2);
                                                                        lookupResultHandler2.found(dHTTransportContact2, false);
                                                                        level_map.put(dHTTransportContact2, new Integer(n4 + 1));
                                                                        if (idle_searches <= 0) continue;
                                                                        --idle_searches;
                                                                        this.release();
                                                                    }
                                                                    Object var6_7 = null;
                                                                    contacts_to_query_mon.exit();
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var6_8 = null;
                                                                    contacts_to_query_mon.exit();
                                                                    throw throwable;
                                                                }
                                                                Object var8_10 = null;
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object v0;
                                                                Object var8_11 = null;
                                                                try {
                                                                    contacts_to_query_mon.enter();
                                                                    --active_searches;
                                                                    v0 = null;
                                                                }
                                                                catch (Throwable throwable2) {
                                                                    v0 = null;
                                                                }
                                                                Object var10_15 = v0;
                                                                contacts_to_query_mon.exit();
                                                                throw throwable;
                                                            }
                                                            try {
                                                                contacts_to_query_mon.enter();
                                                                --active_searches;
                                                                v1 = null;
                                                                break block12;
                                                            }
                                                            catch (Throwable throwable) {
                                                                v1 = null;
                                                            }
                                                            {
                                                            }
                                                        }
                                                        Object var10_14 = v1;
                                                        contacts_to_query_mon.exit();
                                                    }

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    public void findValueReply(DHTTransportContact dHTTransportContact, DHTTransportValue[] dHTTransportValueArray, byte by, boolean bl) {
                                                        block15: {
                                                            if (DHTLog.isOn()) {
                                                                DHTLog.log("findValueReply: " + DHTLog.getString(dHTTransportValueArray) + ",mtc=" + bl + ", dt=" + by);
                                                            }
                                                            boolean bl2 = false;
                                                            if (by == 99) {
                                                                bl2 = true;
                                                                by = 1;
                                                            }
                                                            try {
                                                                if (!key_blocked && by != 1 && (by & 8) == 0) {
                                                                    lookupResultHandler2.diversify(dHTTransportContact, by);
                                                                }
                                                                this.value_reply_received = true;
                                                                DHTControlImpl.this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
                                                                int n = 0;
                                                                if (!key_blocked) {
                                                                    for (int i = 0; i < dHTTransportValueArray.length; ++i) {
                                                                        DHTTransportValue dHTTransportValue = dHTTransportValueArray[i];
                                                                        DHTTransportContact dHTTransportContact2 = dHTTransportValue.getOriginator();
                                                                        byte[] byArray = dHTTransportContact2.getID();
                                                                        byte[] byArray2 = dHTTransportValue.getValue();
                                                                        byte[] byArray3 = new byte[byArray.length + byArray2.length];
                                                                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                                                                        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                                                                        HashWrapper hashWrapper = new HashWrapper(byArray3);
                                                                        if (values_found_set.contains(hashWrapper)) continue;
                                                                        if (byArray2 != null && !bl2) {
                                                                            if (!Arrays.equals(byArray2, byArray2)) continue;
                                                                            bl = true;
                                                                            final 3 var14_14 = this;
                                                                            this.val$f_closest.sendFindValue(new DHTTransportReplyHandlerAdapter(){

                                                                                public void findValueReply(DHTTransportContact dHTTransportContact, DHTTransportValue[] dHTTransportValueArray, byte by, boolean bl) {
                                                                                    if (by == 1) {
                                                                                        var14_14.findValueReply(dHTTransportContact, dHTTransportValueArray, (byte)99, false);
                                                                                    }
                                                                                }

                                                                                public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                                                                                    var14_14.failed(dHTTransportContact, throwable);
                                                                                }
                                                                            }, byArray, 1, by);
                                                                            break;
                                                                        }
                                                                        ++n;
                                                                        values_found_set.add(hashWrapper);
                                                                        lookupResultHandler2.read(dHTTransportContact, dHTTransportValueArray[i]);
                                                                    }
                                                                }
                                                                try {
                                                                    contacts_to_query_mon.enter();
                                                                    if (!bl) {
                                                                        ++value_replies;
                                                                    }
                                                                    values_found += n;
                                                                    Object var16_15 = null;
                                                                    contacts_to_query_mon.exit();
                                                                }
                                                                catch (Throwable throwable) {
                                                                    Object var16_16 = null;
                                                                    contacts_to_query_mon.exit();
                                                                    throw throwable;
                                                                }
                                                                Object var18_18 = null;
                                                                if (bl) break block15;
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object var18_19 = null;
                                                                if (!bl) {
                                                                    try {
                                                                        contacts_to_query_mon.enter();
                                                                        --active_searches;
                                                                        Object var20_22 = null;
                                                                        contacts_to_query_mon.exit();
                                                                    }
                                                                    catch (Throwable throwable2) {
                                                                        Object var20_23 = null;
                                                                        contacts_to_query_mon.exit();
                                                                        throw throwable2;
                                                                    }
                                                                    this.release();
                                                                }
                                                                throw throwable;
                                                            }
                                                            try {
                                                                contacts_to_query_mon.enter();
                                                                --active_searches;
                                                                Object var20_20 = null;
                                                                contacts_to_query_mon.exit();
                                                            }
                                                            catch (Throwable throwable) {
                                                                Object var20_21 = null;
                                                                contacts_to_query_mon.exit();
                                                                throw throwable;
                                                            }
                                                            this.release();
                                                            {
                                                            }
                                                        }
                                                    }

                                                    public void findValueReply(DHTTransportContact dHTTransportContact, DHTTransportContact[] dHTTransportContactArray) {
                                                        this.findNodeReply(dHTTransportContact, dHTTransportContactArray);
                                                    }

                                                    /*
                                                     * WARNING - Removed try catching itself - possible behaviour change.
                                                     */
                                                    public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                                                        Object v1;
                                                        block7: {
                                                            try {
                                                                if (!this.value_reply_received) {
                                                                    if (DHTLog.isOn()) {
                                                                        DHTLog.log("findNode/findValue " + DHTLog.getString(dHTTransportContact) + " -> failed: " + throwable.getMessage());
                                                                    }
                                                                    DHTControlImpl.this.router.contactDead(dHTTransportContact.getID(), false);
                                                                }
                                                                Object var4_3 = null;
                                                            }
                                                            catch (Throwable throwable2) {
                                                                Object v0;
                                                                Object var4_4 = null;
                                                                try {
                                                                    contacts_to_query_mon.enter();
                                                                    --active_searches;
                                                                    v0 = null;
                                                                }
                                                                catch (Throwable throwable3) {
                                                                    v0 = null;
                                                                }
                                                                Object var6_8 = v0;
                                                                contacts_to_query_mon.exit();
                                                                throw throwable2;
                                                            }
                                                            try {
                                                                contacts_to_query_mon.enter();
                                                                --active_searches;
                                                                v1 = null;
                                                                break block7;
                                                            }
                                                            catch (Throwable throwable4) {
                                                                v1 = null;
                                                            }
                                                            {
                                                            }
                                                        }
                                                        Object var6_7 = v1;
                                                        contacts_to_query_mon.exit();
                                                    }

                                                    public void keyBlockRequest(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
                                                        if (DHTControlImpl.this.database.keyBlockRequest(null, byArray, byArray2) != null) {
                                                            key_blocked = true;
                                                        }
                                                    }
                                                };
                                                DHTControlImpl.this.router.recordLookup(byArray3);
                                                if (bl2) {
                                                    n5 = n2 - this.values_found;
                                                    if (n5 <= 0) {
                                                        Debug.out("eh?");
                                                        n5 = 1;
                                                    }
                                                    dHTTransportContact.sendFindValue((DHTTransportReplyHandler)object, byArray3, n5, by);
                                                    break block29;
                                                } else {
                                                    dHTTransportContact.sendFindNode((DHTTransportReplyHandler)object, byArray3);
                                                }
                                                break block29;
                                            }
                                            catch (Throwable throwable) {
                                                var13_17 = null;
                                                this.contacts_to_query_mon.exit();
                                                throw throwable;
                                            }
                                        }
                                        var13_17 = null;
                                        this.contacts_to_query_mon.exit();
                                        break;
                                    }
                                    var13_17 = null;
                                    this.contacts_to_query_mon.exit();
                                    continue;
                                }
                                var13_17 = null;
                                this.contacts_to_query_mon.exit();
                                break;
                            }
                            var13_17 = null;
                            this.contacts_to_query_mon.exit();
                            continue;
                        }
                        var13_17 = null;
                        this.contacts_to_query_mon.exit();
                    }
                    if (bl) {
                        this.terminateLookup(false);
                        return;
                    }
                    if (!this.cancelled) return;
                    this.terminateLookup(true);
                    return;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    this.terminateLookup(true);
                }
            }

            public byte[] getTarget() {
                return byArray3;
            }

            public String getDescription() {
                return string;
            }
        };
        threadPool.run(dhtTask, bl, true);
        return dhtTask;
    }

    @Override
    public void pingRequest(DHTTransportContact dHTTransportContact) {
        if (DHTLog.isOn()) {
            DHTLog.log("pingRequest from " + DHTLog.getString(dHTTransportContact.getID()));
        }
        this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
    }

    @Override
    public void keyBlockRequest(DHTTransportContact dHTTransportContact, byte[] byArray, byte[] byArray2) {
        if (DHTLog.isOn()) {
            DHTLog.log("keyBlockRequest from " + DHTLog.getString(dHTTransportContact.getID()));
        }
        this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
        this.database.keyBlockRequest(dHTTransportContact, byArray, byArray2);
    }

    @Override
    public DHTTransportStoreReply storeRequest(DHTTransportContact dHTTransportContact, byte[][] byArray, DHTTransportValue[][] dHTTransportValueArray) {
        byte[] byArray2 = dHTTransportContact.getID();
        this.router.contactAlive(byArray2, new DHTControlContactImpl(dHTTransportContact));
        if (DHTLog.isOn()) {
            DHTLog.log("storeRequest from " + DHTLog.getString(dHTTransportContact) + ", keys = " + byArray.length);
        }
        byte[] byArray3 = new byte[byArray.length];
        Arrays.fill(byArray3, (byte)1);
        if (byArray.length != dHTTransportValueArray.length) {
            Debug.out("DHTControl:storeRequest - invalid request received from " + dHTTransportContact.getString() + ", keys and values length mismatch");
            return new DHTTransportStoreReplyImpl(byArray3);
        }
        DHTStorageBlock dHTStorageBlock = null;
        if (byArray.length > 0) {
            boolean bl = false;
            Object object = dHTTransportValueArray;
            int n = ((DHTTransportValue[][])object).length;
            for (int i = 0; i < n; ++i) {
                DHTTransportValue[] dHTTransportValueArray2;
                for (DHTTransportValue object2 : dHTTransportValueArray2 = object[i]) {
                    if (Arrays.equals(byArray2, object2.getOriginator().getID())) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
            }
            if (bl && !this.isSeeded()) {
                if (DHTLog.isOn()) {
                    DHTLog.log("Not storing keys as not yet seeded");
                }
            } else if (!this.verifyContact(dHTTransportContact, !bl)) {
                this.logger.log("Verification of contact '" + dHTTransportContact.getName() + "' failed for store operation");
            } else {
                object = this.local_contact.getID();
                n = this.router.getK();
                DHTStorageAdapter dHTStorageAdapter = this.adapter.getStorageAdapter();
                if (dHTStorageAdapter != null && dHTStorageAdapter.getNetwork() != 1) {
                    n += n / 2;
                }
                boolean bl2 = true;
                if (bl) {
                    long l = SystemTime.getMonotonousTime();
                    if (l - this.rbs_time < 10000L && Arrays.equals(byArray2, this.rbs_id)) {
                        bl2 = false;
                    } else {
                        List<DHTTransportContact> list = this.getClosestContactsList((byte[])object, n, true);
                        DHTTransportContact dHTTransportContact2 = list.get(list.size() - 1);
                        if (this.computeAndCompareDistances(dHTTransportContact2.getID(), byArray2, (byte[])object) < 0) {
                            this.rbs_id = byArray2;
                            this.rbs_time = l;
                            if (DHTLog.isOn()) {
                                DHTLog.log("Not storing keys as cache forward and sender too far away");
                            }
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    for (int i = 0; i < byArray.length; ++i) {
                        byte[] byArray4 = byArray[i];
                        HashWrapper hashWrapper = new HashWrapper(byArray4);
                        DHTTransportValue[] dHTTransportValueArray2 = dHTTransportValueArray[i];
                        if (DHTLog.isOn()) {
                            DHTLog.log("    key=" + DHTLog.getString(byArray4) + ", value=" + DHTLog.getString(dHTTransportValueArray2));
                        }
                        if (!this.database.hasKey(hashWrapper) && !this.isIDInClosestContacts((byte[])object, byArray4, n, true)) {
                            if (!DHTLog.isOn()) continue;
                            DHTLog.log("Not storing keys as cache forward and sender too far away");
                            continue;
                        }
                        byArray3[i] = this.database.store(dHTTransportContact, hashWrapper, dHTTransportValueArray2);
                        if (dHTStorageBlock != null) continue;
                        dHTStorageBlock = this.database.getKeyBlockDetails(byArray4);
                    }
                }
            }
        }
        if (dHTStorageBlock == null) {
            return new DHTTransportStoreReplyImpl(byArray3);
        }
        return new DHTTransportStoreReplyImpl(dHTStorageBlock.getRequest(), dHTStorageBlock.getCertificate());
    }

    @Override
    public DHTTransportQueryStoreReply queryStoreRequest(DHTTransportContact dHTTransportContact, int n, List<Object[]> list) {
        this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
        if (DHTLog.isOn()) {
            DHTLog.log("queryStoreRequest from " + DHTLog.getString(dHTTransportContact) + ", header_len=" + n + ", keys=" + list.size());
        }
        int n2 = this.generateSpoofID(dHTTransportContact);
        dHTTransportContact.setRandomID(n2);
        return this.database.queryStore(dHTTransportContact, n, list);
    }

    @Override
    public DHTTransportContact[] findNodeRequest(DHTTransportContact dHTTransportContact, byte[] byArray) {
        if (DHTLog.isOn()) {
            DHTLog.log("findNodeRequest from " + DHTLog.getString(dHTTransportContact.getID()));
        }
        this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
        List<Object> list = byArray.length == this.router.getID().length ? this.getClosestKContactsList(byArray, false) : new ArrayList();
        DHTTransportContact[] dHTTransportContactArray = new DHTTransportContact[list.size()];
        list.toArray(dHTTransportContactArray);
        int n = this.generateSpoofID(dHTTransportContact);
        dHTTransportContact.setRandomID(n);
        return dHTTransportContactArray;
    }

    @Override
    public DHTTransportFindValueReply findValueRequest(DHTTransportContact dHTTransportContact, byte[] byArray, int n, byte by) {
        DHTDBLookupResult dHTDBLookupResult;
        if (DHTLog.isOn()) {
            DHTLog.log("findValueRequest from " + DHTLog.getString(dHTTransportContact.getID()));
        }
        if ((dHTDBLookupResult = this.database.get(dHTTransportContact, new HashWrapper(byArray), n, by, true)) != null) {
            this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
            DHTStorageBlock dHTStorageBlock = this.database.getKeyBlockDetails(byArray);
            if (dHTStorageBlock == null) {
                return new DHTTransportFindValueReplyImpl(dHTDBLookupResult.getDiversificationType(), dHTDBLookupResult.getValues());
            }
            return new DHTTransportFindValueReplyImpl(dHTStorageBlock.getRequest(), dHTStorageBlock.getCertificate());
        }
        return new DHTTransportFindValueReplyImpl(this.findNodeRequest(dHTTransportContact, byArray));
    }

    @Override
    public DHTTransportFullStats statsRequest(DHTTransportContact dHTTransportContact) {
        return this.stats;
    }

    protected void requestPing(DHTRouterContact dHTRouterContact) {
        ((DHTControlContactImpl)dHTRouterContact.getAttachment()).getTransportContact().sendPing(new DHTTransportReplyHandlerAdapter(){

            public void pingReply(DHTTransportContact dHTTransportContact) {
                if (DHTLog.isOn()) {
                    DHTLog.log("ping OK " + DHTLog.getString(dHTTransportContact));
                }
                DHTControlImpl.this.router.contactAlive(dHTTransportContact.getID(), new DHTControlContactImpl(dHTTransportContact));
            }

            public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                if (DHTLog.isOn()) {
                    DHTLog.log("ping " + DHTLog.getString(dHTTransportContact) + " -> failed: " + throwable.getMessage());
                }
                DHTControlImpl.this.router.contactDead(dHTTransportContact.getID(), false);
            }
        });
    }

    protected void nodeAddedToRouter(DHTRouterContact dHTRouterContact) {
        if (!dHTRouterContact.hasBeenAlive()) {
            this.requestPing(dHTRouterContact);
        }
    }

    protected Set<DHTTransportContact> getClosestContactsSet(byte[] byArray, int n, boolean bl) {
        List<DHTRouterContact> list = this.router.findClosestContacts(byArray, n, bl);
        Set<DHTTransportContact> set = new sortedTransportContactSet(byArray, true).getSet();
        long l = list.size();
        int n2 = 0;
        while ((long)n2 < l) {
            set.add(((DHTControlContactImpl)list.get(n2).getAttachment()).getTransportContact());
            ++n2;
        }
        return set;
    }

    @Override
    public List<DHTTransportContact> getClosestKContactsList(byte[] byArray, boolean bl) {
        return this.getClosestContactsList(byArray, this.K, bl);
    }

    @Override
    public List<DHTTransportContact> getClosestContactsList(byte[] byArray, int n, boolean bl) {
        Set<DHTTransportContact> set = this.getClosestContactsSet(byArray, n, bl);
        ArrayList<DHTTransportContact> arrayList = new ArrayList<DHTTransportContact>(n);
        Iterator<DHTTransportContact> iterator = set.iterator();
        while (iterator.hasNext() && arrayList.size() < n) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    protected boolean isIDInClosestContacts(byte[] byArray, byte[] byArray2, int n, boolean bl) {
        List<DHTRouterContact> list = this.router.findClosestContacts(byArray2, n, bl);
        boolean bl2 = false;
        int n2 = 0;
        for (DHTRouterContact dHTRouterContact : list) {
            byte[] byArray3 = dHTRouterContact.getID();
            if (Arrays.equals(byArray, byArray3)) {
                bl2 = true;
                continue;
            }
            if (this.computeAndCompareDistances(byArray3, byArray, byArray2) >= 0) continue;
            ++n2;
        }
        return bl2 && n2 < n;
    }

    protected byte[] encodeKey(byte[] byArray) {
        byte[] byArray2 = new SHA1Simple().calculateHash(byArray);
        byte[] byArray3 = new byte[this.node_id_byte_count];
        System.arraycopy(byArray2, 0, byArray3, 0, this.node_id_byte_count);
        return byArray3;
    }

    @Override
    public int computeAndCompareDistances(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return DHTControlImpl.computeAndCompareDistances2(byArray, byArray2, byArray3);
    }

    protected static int computeAndCompareDistances2(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = (byte)(byArray[i] ^ byArray3[i]);
            byte by2 = (byte)(byArray2[i] ^ byArray3[i]);
            int n = (by & 0xFF) - (by2 & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public byte[] computeDistance(byte[] byArray, byte[] byArray2) {
        return DHTControlImpl.computeDistance2(byArray, byArray2);
    }

    protected static byte[] computeDistance2(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = (byte)(byArray[i] ^ byArray2[i]);
        }
        return byArray3;
    }

    @Override
    public int compareDistances(byte[] byArray, byte[] byArray2) {
        return DHTControlImpl.compareDistances2(byArray, byArray2);
    }

    protected static int compareDistances2(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DHTControlListener dHTControlListener) {
        try {
            this.activity_mon.enter();
            this.listeners.addListener(dHTControlListener);
            for (int i = 0; i < this.activities.size(); ++i) {
                this.listeners.dispatch(1, this.activities.get(i));
            }
            Object var4_3 = null;
            this.activity_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.activity_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void removeListener(DHTControlListener dHTControlListener) {
        this.listeners.removeListener(dHTControlListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTControlActivity[] getActivities() {
        ArrayList arrayList;
        try {
            this.activity_mon.enter();
            arrayList = new ArrayList(this.activities);
            Object var3_2 = null;
            this.activity_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.activity_mon.exit();
            throw throwable;
        }
        DHTControlActivity[] dHTControlActivityArray = new DHTControlActivity[arrayList.size()];
        arrayList.toArray(dHTControlActivityArray);
        return dHTControlActivityArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransportEstimatedDHTSize(int n) {
        if (n > 0) {
            try {
                this.estimate_mon.enter();
                this.remote_estimate_values.add(new Integer(n));
                if (this.remote_estimate_values.size() > 128) {
                    this.remote_estimate_values.remove(0);
                }
                Object var3_2 = null;
                this.estimate_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.estimate_mon.exit();
                throw throwable;
            }
        }
    }

    @Override
    public int getTransportEstimatedDHTSize() {
        return (int)this.local_dht_estimate;
    }

    public int getEstimatedDHTSize() {
        int n;
        long l = SystemTime.getCurrentTime();
        long l2 = l - this.last_dht_estimate_time;
        if (l2 < 0L || l2 > 60000L) {
            this.estimateDHTSize(this.router.getID(), null, this.router.getK());
        }
        if ((n = this.transport.getStats().getRouteablePercentage()) < 25) {
            return (int)this.combined_dht_estimate;
        }
        double d = 100.0 / (double)n;
        return (int)(d * (double)this.combined_dht_estimate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void estimateDHTSize(byte[] byArray, Map map, int n) {
        long l = SystemTime.getCurrentTime();
        long l2 = l - this.last_dht_estimate_time;
        if (l2 < 0L || l2 > 5000L) {
            try {
                Serializable serializable;
                List<DHTTransportContact> list;
                this.estimate_mon.enter();
                this.last_dht_estimate_time = l;
                if (map == null) {
                    list = this.getClosestKContactsList(byArray, false);
                } else {
                    serializable = new sortedTransportContactSet(byArray, true).getSet();
                    serializable.addAll(map.values());
                    list = new ArrayList<DHTTransportContact>((Collection<DHTTransportContact>)((Object)serializable));
                    if (list.size() > 0) {
                        byArray = list.get(0).getID();
                    }
                }
                if (list.size() > 2) {
                    serializable = new BigInteger("0");
                    BigInteger bigInteger = new BigInteger("0");
                    for (int i = 1; i < Math.min(list.size(), n); ++i) {
                        DHTTransportContact dHTTransportContact = list.get(i);
                        byte[] byArray2 = this.computeDistance(byArray, dHTTransportContact.getID());
                        BigInteger bigInteger2 = this.IDToBigInteger(byArray2);
                        BigInteger bigInteger3 = new BigInteger("" + i);
                        serializable = ((BigInteger)serializable).add(bigInteger3.multiply(bigInteger2));
                        bigInteger = bigInteger.add(bigInteger3.multiply(bigInteger3));
                    }
                    byte[] byArray3 = new byte[byArray.length + 1];
                    byArray3[0] = 1;
                    long l3 = ((BigInteger)serializable).compareTo(new BigInteger("0")) == 0 ? 0L : this.IDToBigInteger(byArray3).multiply(bigInteger).divide((BigInteger)serializable).longValue();
                    if (l3 < 1L) {
                        l3 = 1L;
                    }
                    this.local_estimate_values.put(new HashWrapper(byArray), new Long(l3));
                    long l4 = 0L;
                    Iterator iterator = this.local_estimate_values.values().iterator();
                    String string = "";
                    while (iterator.hasNext()) {
                        long l5 = (Long)iterator.next();
                        string = string + (string.length() == 0 ? "" : ",") + l5;
                        l4 += l5;
                    }
                    this.local_dht_estimate = l4 / (long)this.local_estimate_values.size();
                }
                serializable = new ArrayList(new TreeSet(this.remote_estimate_values));
                long l6 = this.local_dht_estimate;
                int n2 = 1;
                for (int i = 3; i < serializable.size() - 3; ++i) {
                    l6 += (long)((Integer)serializable.get(i)).intValue();
                    ++n2;
                }
                this.combined_dht_estimate = l6 / (long)n2;
                long l7 = 10L;
                int n3 = 1;
                while (l7 < this.combined_dht_estimate) {
                    l7 *= 10L;
                    ++n3;
                }
                this.combined_dht_estimate_mag = n3 + 1;
                Object var21_25 = null;
                this.estimate_mon.exit();
            }
            catch (Throwable throwable) {
                Object var21_26 = null;
                this.estimate_mon.exit();
                throw throwable;
            }
        }
    }

    protected BigInteger IDToBigInteger(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF);
            if (string.length() < 2) {
                stringBuilder.append("0");
            }
            stringBuilder.append(string);
        }
        BigInteger bigInteger = new BigInteger(stringBuilder.toString(), 16);
        return bigInteger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int generateSpoofID(DHTTransportContact dHTTransportContact) {
        block6: {
            if (this.spoof_cipher == null) {
                return 0;
            }
            this.spoof_mon.enter();
            if (dHTTransportContact != this.spoof_last_verify_contact) break block6;
            int n = this.spoof_last_verify_result;
            Object var7_5 = null;
            this.spoof_mon.exit();
            return n;
        }
        try {
            this.spoof_cipher.init(1, this.spoof_key);
            byte[] byArray = dHTTransportContact.getAddress().getAddress().getAddress();
            byte[] byArray2 = this.spoof_cipher.doFinal(byArray);
            int n = byArray2[0] << 24 & 0xFF000000 | byArray2[1] << 16 & 0xFF0000 | byArray2[2] << 8 & 0xFF00 | byArray2[3] & 0xFF;
            this.spoof_last_verify_contact = dHTTransportContact;
            this.spoof_last_verify_result = n;
            int n2 = n;
            Object var7_6 = null;
            this.spoof_mon.exit();
            return n2;
        }
        catch (Throwable throwable) {
            try {
                this.logger.log(throwable);
                Object var7_7 = null;
                this.spoof_mon.exit();
            }
            catch (Throwable throwable2) {
                Object var7_8 = null;
                this.spoof_mon.exit();
                throw throwable2;
            }
        }
        return 0;
    }

    @Override
    public boolean verifyContact(DHTTransportContact dHTTransportContact, boolean bl) {
        boolean bl2 = dHTTransportContact.getRandomID() == this.generateSpoofID(dHTTransportContact);
        return bl2;
    }

    public List getContacts() {
        List<DHTRouterContact> list = this.router.getAllContacts();
        ArrayList<DHTRouterContactAttachment> arrayList = new ArrayList<DHTRouterContactAttachment>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DHTRouterContact dHTRouterContact = list.get(i);
            arrayList.add(dHTRouterContact.getAttachment());
        }
        return arrayList;
    }

    @Override
    public void pingAll() {
        List<DHTRouterContact> list = this.router.getAllContacts();
        final AESemaphore aESemaphore = new AESemaphore("pingAll", 32);
        final int[] nArray = new int[]{0, 0};
        for (int i = 0; i < list.size(); ++i) {
            aESemaphore.reserve();
            DHTRouterContact dHTRouterContact = list.get(i);
            ((DHTControlContactImpl)dHTRouterContact.getAttachment()).getTransportContact().sendPing(new DHTTransportReplyHandlerAdapter(){

                public void pingReply(DHTTransportContact dHTTransportContact) {
                    nArray[0] = nArray[0] + 1;
                    this.print();
                    aESemaphore.release();
                }

                public void failed(DHTTransportContact dHTTransportContact, Throwable throwable) {
                    nArray[1] = nArray[1] + 1;
                    this.print();
                    aESemaphore.release();
                }

                protected void print() {
                    System.out.println("ok=" + nArray[0] + ",bad=" + nArray[1]);
                }
            });
        }
    }

    @Override
    public void print(boolean bl) {
        DHTNetworkPosition[] dHTNetworkPositionArray = this.transport.getLocalContact().getNetworkPositions();
        String string = "";
        for (int i = 0; i < dHTNetworkPositionArray.length; ++i) {
            string = string + (i == 0 ? "" : ",") + dHTNetworkPositionArray[i];
        }
        this.logger.log("DHT Details: external IP = " + this.transport.getLocalContact().getAddress() + ", network = " + this.transport.getNetwork() + ", protocol = V" + this.transport.getProtocolVersion() + ", nps = " + string);
        this.router.print();
        this.database.print(bl);
    }

    protected class controlActivity
    implements DHTControlActivity {
        protected ThreadPool tp;
        protected DhtTask task;
        protected int type;

        protected controlActivity(ThreadPool threadPool, DhtTask dhtTask) {
            this.tp = threadPool;
            this.task = dhtTask;
            this.type = threadPool == DHTControlImpl.this.internal_lookup_pool ? 1 : (threadPool == DHTControlImpl.this.external_lookup_pool ? 2 : (threadPool == DHTControlImpl.this.internal_put_pool ? 3 : 4));
        }

        public byte[] getTarget() {
            return this.task.getTarget();
        }

        public String getDescription() {
            return this.task.getDescription();
        }

        public int getType() {
            return this.type;
        }

        public boolean isQueued() {
            return this.tp.isQueued(this.task);
        }

        public String getString() {
            return this.type + ":" + DHTLog.getString(this.getTarget()) + "/" + this.getDescription() + ", q = " + this.isQueued();
        }
    }

    protected static class DhtTaskSet {
        private boolean cancelled;
        private Object things;

        protected DhtTaskSet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(DhtTask dhtTask) {
            DhtTaskSet dhtTaskSet = this;
            synchronized (dhtTaskSet) {
                if (this.cancelled) {
                    dhtTask.cancel();
                    return;
                }
                this.addToThings(dhtTask);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(DhtTaskSet dhtTaskSet) {
            DhtTaskSet dhtTaskSet2 = this;
            synchronized (dhtTaskSet2) {
                if (this.cancelled) {
                    dhtTaskSet.cancel();
                    return;
                }
                this.addToThings(dhtTaskSet);
            }
        }

        private void addToThings(Object object) {
            if (this.things == null) {
                this.things = object;
            } else if (this.things instanceof List) {
                ((List)this.things).add(object);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(this.things);
                arrayList.add(object);
                this.things = arrayList;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancel() {
            Object object;
            Object object2 = this;
            synchronized (object2) {
                if (this.cancelled) {
                    return;
                }
                this.cancelled = true;
                object = this.things;
                this.things = null;
            }
            if (object != null) {
                if (object instanceof DhtTask) {
                    ((DhtTask)object).cancel();
                } else if (object instanceof DhtTaskSet) {
                    ((DhtTaskSet)object).cancel();
                } else {
                    object2 = (List)object;
                    for (int i = 0; i < object2.size(); ++i) {
                        Object e = object2.get(i);
                        if (e instanceof DhtTask) {
                            ((DhtTask)e).cancel();
                            continue;
                        }
                        ((DhtTaskSet)e).cancel();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isCancelled() {
            DhtTaskSet dhtTaskSet = this;
            synchronized (dhtTaskSet) {
                return this.cancelled;
            }
        }
    }

    protected abstract class DhtTask
    extends ThreadPoolTask {
        private controlActivity activity;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected DhtTask(ThreadPool threadPool) {
            this.activity = new controlActivity(threadPool, this);
            try {
                DHTControlImpl.this.activity_mon.enter();
                DHTControlImpl.this.activities.add(this.activity);
                DHTControlImpl.this.listeners.dispatch(1, this.activity);
                Object var4_3 = null;
                DHTControlImpl.this.activity_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                DHTControlImpl.this.activity_mon.exit();
                throw throwable;
            }
        }

        public void taskStarted() {
            DHTControlImpl.this.listeners.dispatch(2, this.activity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskCompleted() {
            try {
                DHTControlImpl.this.activity_mon.enter();
                DHTControlImpl.this.activities.remove(this.activity);
                DHTControlImpl.this.listeners.dispatch(3, this.activity);
                Object var2_1 = null;
                DHTControlImpl.this.activity_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                DHTControlImpl.this.activity_mon.exit();
                throw throwable;
            }
        }

        public void interruptTask() {
        }

        protected abstract void cancel();

        public abstract byte[] getTarget();

        public abstract String getDescription();
    }

    protected static class DHTTransportStoreReplyImpl
    implements DHTTransportStoreReply {
        private byte[] divs;
        private byte[] block_request;
        private byte[] block_sig;

        protected DHTTransportStoreReplyImpl(byte[] byArray) {
            this.divs = byArray;
        }

        protected DHTTransportStoreReplyImpl(byte[] byArray, byte[] byArray2) {
            this.block_request = byArray;
            this.block_sig = byArray2;
        }

        public byte[] getDiversificationTypes() {
            return this.divs;
        }

        public boolean blocked() {
            return this.block_request != null;
        }

        public byte[] getBlockRequest() {
            return this.block_request;
        }

        public byte[] getBlockSignature() {
            return this.block_sig;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class anonContact
    implements DHTTransportContact {
        private static InetSocketAddress anon_address;
        private DHTTransportContact delegate;

        protected anonContact(DHTTransportContact dHTTransportContact) {
            this.delegate = dHTTransportContact;
        }

        @Override
        public int getMaxFailForLiveCount() {
            return this.delegate.getMaxFailForLiveCount();
        }

        @Override
        public int getMaxFailForUnknownCount() {
            return this.delegate.getMaxFailForUnknownCount();
        }

        @Override
        public int getInstanceID() {
            return this.delegate.getInstanceID();
        }

        @Override
        public byte[] getID() {
            Debug.out("hmm");
            return this.delegate.getID();
        }

        @Override
        public byte getProtocolVersion() {
            return this.delegate.getProtocolVersion();
        }

        @Override
        public long getClockSkew() {
            return this.delegate.getClockSkew();
        }

        @Override
        public void setRandomID(int n) {
            this.delegate.setRandomID(n);
        }

        @Override
        public int getRandomID() {
            return this.delegate.getRandomID();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public InetSocketAddress getAddress() {
            return anon_address;
        }

        @Override
        public InetSocketAddress getExternalAddress() {
            return this.getAddress();
        }

        @Override
        public boolean isAlive(long l) {
            return this.delegate.isAlive(l);
        }

        @Override
        public void isAlive(DHTTransportReplyHandler dHTTransportReplyHandler, long l) {
            this.delegate.isAlive(dHTTransportReplyHandler, l);
        }

        @Override
        public boolean isValid() {
            return this.delegate.isValid();
        }

        @Override
        public void sendPing(DHTTransportReplyHandler dHTTransportReplyHandler) {
            this.delegate.sendPing(dHTTransportReplyHandler);
        }

        @Override
        public void sendImmediatePing(DHTTransportReplyHandler dHTTransportReplyHandler, long l) {
            this.delegate.sendImmediatePing(dHTTransportReplyHandler, l);
        }

        @Override
        public void sendStats(DHTTransportReplyHandler dHTTransportReplyHandler) {
            this.delegate.sendStats(dHTTransportReplyHandler);
        }

        @Override
        public void sendStore(DHTTransportReplyHandler dHTTransportReplyHandler, byte[][] byArray, DHTTransportValue[][] dHTTransportValueArray, boolean bl) {
            this.delegate.sendStore(dHTTransportReplyHandler, byArray, dHTTransportValueArray, bl);
        }

        @Override
        public void sendQueryStore(DHTTransportReplyHandler dHTTransportReplyHandler, int n, List<Object[]> list) {
            this.delegate.sendQueryStore(dHTTransportReplyHandler, n, list);
        }

        @Override
        public void sendFindNode(DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray) {
            this.delegate.sendFindNode(dHTTransportReplyHandler, byArray);
        }

        @Override
        public void sendFindValue(DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray, int n, byte by) {
            this.delegate.sendFindValue(dHTTransportReplyHandler, byArray, n, by);
        }

        @Override
        public void sendKeyBlock(DHTTransportReplyHandler dHTTransportReplyHandler, byte[] byArray, byte[] byArray2) {
            this.delegate.sendKeyBlock(dHTTransportReplyHandler, byArray, byArray2);
        }

        @Override
        public DHTTransportFullStats getStats() {
            return this.delegate.getStats();
        }

        @Override
        public void exportContact(DataOutputStream dataOutputStream) throws IOException, DHTTransportException {
            this.delegate.exportContact(dataOutputStream);
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void createNetworkPositions(boolean bl) {
            this.delegate.createNetworkPositions(bl);
        }

        @Override
        public DHTNetworkPosition[] getNetworkPositions() {
            return this.delegate.getNetworkPositions();
        }

        @Override
        public DHTNetworkPosition getNetworkPosition(byte by) {
            return this.delegate.getNetworkPosition(by);
        }

        @Override
        public DHTTransport getTransport() {
            return this.delegate.getTransport();
        }

        @Override
        public String getString() {
            return this.delegate.getString();
        }

        static {
            try {
                anon_address = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), 0);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected static class anonValue
    implements DHTTransportValue {
        private DHTTransportValue delegate;

        protected anonValue(DHTTransportValue dHTTransportValue) {
            this.delegate = dHTTransportValue;
        }

        public boolean isLocal() {
            return this.delegate.isLocal();
        }

        public long getCreationTime() {
            return this.delegate.getCreationTime();
        }

        public byte[] getValue() {
            return this.delegate.getValue();
        }

        public int getVersion() {
            return this.delegate.getVersion();
        }

        public DHTTransportContact getOriginator() {
            return new anonContact(this.delegate.getOriginator());
        }

        public int getFlags() {
            return this.delegate.getFlags();
        }

        public int getLifeTimeHours() {
            return this.delegate.getLifeTimeHours();
        }

        public byte getReplicationControl() {
            return this.delegate.getReplicationControl();
        }

        public byte getReplicationFactor() {
            return this.delegate.getReplicationFactor();
        }

        public byte getReplicationFrequencyHours() {
            return this.delegate.getReplicationFrequencyHours();
        }

        public String getString() {
            return this.delegate.getString();
        }
    }

    protected static class DHTTransportFindValueReplyImpl
    implements DHTTransportFindValueReply {
        private byte dt = 1;
        private DHTTransportValue[] values;
        private DHTTransportContact[] contacts;
        private byte[] blocked_key;
        private byte[] blocked_sig;

        protected DHTTransportFindValueReplyImpl(byte by, DHTTransportValue[] dHTTransportValueArray) {
            this.dt = by;
            this.values = dHTTransportValueArray;
            boolean bl = false;
            for (int i = 0; i < this.values.length; ++i) {
                DHTTransportValue dHTTransportValue = this.values[i];
                if ((dHTTransportValue.getFlags() & 0x10) == 0) continue;
                if (!bl) {
                    this.values = new DHTTransportValue[dHTTransportValueArray.length];
                    System.arraycopy(dHTTransportValueArray, 0, this.values, 0, this.values.length);
                    bl = true;
                }
                this.values[i] = new anonValue(dHTTransportValue);
            }
        }

        protected DHTTransportFindValueReplyImpl(DHTTransportContact[] dHTTransportContactArray) {
            this.contacts = dHTTransportContactArray;
        }

        protected DHTTransportFindValueReplyImpl(byte[] byArray, byte[] byArray2) {
            this.blocked_key = byArray;
            this.blocked_sig = byArray2;
        }

        public byte getDiversificationType() {
            return this.dt;
        }

        public boolean hit() {
            return this.values != null;
        }

        public boolean blocked() {
            return this.blocked_key != null;
        }

        public DHTTransportValue[] getValues() {
            return this.values;
        }

        public DHTTransportContact[] getContacts() {
            return this.contacts;
        }

        public byte[] getBlockedKey() {
            return this.blocked_key;
        }

        public byte[] getBlockedSignature() {
            return this.blocked_sig;
        }
    }

    static abstract class lookupResultHandler
    extends DHTOperationListenerDemuxer {
        protected lookupResultHandler(DHTOperationListener dHTOperationListener) {
            super(dHTOperationListener);
        }

        public abstract void closest(List var1);

        public abstract void diversify(DHTTransportContact var1, byte var2);
    }

    protected static class DHTOperationListenerDemuxer
    implements DHTOperationListener {
        private AEMonitor this_mon = new AEMonitor("DHTOperationListenerDemuxer");
        private DHTOperationListener delegate;
        private boolean complete_fired;
        private boolean complete_included_ok;
        private int complete_count = 0;

        protected DHTOperationListenerDemuxer(DHTOperationListener dHTOperationListener) {
            this.delegate = dHTOperationListener;
            if (this.delegate == null) {
                Debug.out("invalid: null delegate");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementCompletes() {
            try {
                this.this_mon.enter();
                ++this.complete_count;
                Object var2_1 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }

        public void searching(DHTTransportContact dHTTransportContact, int n, int n2) {
            this.delegate.searching(dHTTransportContact, n, n2);
        }

        public void diversified(String string) {
            this.delegate.diversified(string);
        }

        public void found(DHTTransportContact dHTTransportContact, boolean bl) {
            this.delegate.found(dHTTransportContact, bl);
        }

        public void read(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
            this.delegate.read(dHTTransportContact, dHTTransportValue);
        }

        public void wrote(DHTTransportContact dHTTransportContact, DHTTransportValue dHTTransportValue) {
            this.delegate.wrote(dHTTransportContact, dHTTransportValue);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(boolean bl) {
            boolean bl2 = false;
            try {
                this.this_mon.enter();
                if (!bl) {
                    this.complete_included_ok = true;
                }
                --this.complete_count;
                if (this.complete_count <= 0 && !this.complete_fired) {
                    this.complete_fired = true;
                    bl2 = true;
                }
                Object var4_3 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (bl2) {
                this.delegate.complete(!this.complete_included_ok);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class sortedTransportContactSet {
        private TreeSet<DHTTransportContact> tree_set;
        private byte[] pivot;
        private boolean ascending;

        protected sortedTransportContactSet(byte[] byArray, boolean bl) {
            this.pivot = byArray;
            this.ascending = bl;
            this.tree_set = new TreeSet<DHTTransportContact>(new Comparator<DHTTransportContact>(){

                @Override
                public int compare(DHTTransportContact dHTTransportContact, DHTTransportContact dHTTransportContact2) {
                    int n = DHTControlImpl.computeAndCompareDistances2(dHTTransportContact.getID(), dHTTransportContact2.getID(), sortedTransportContactSet.this.pivot);
                    if (sortedTransportContactSet.this.ascending) {
                        return n;
                    }
                    return -n;
                }
            });
        }

        public Set<DHTTransportContact> getSet() {
            return this.tree_set;
        }
    }
}

