/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeProviderAdapter;
import com.aelitis.azureus.core.devices.TranscodeProviderAnalysis;
import com.aelitis.azureus.core.devices.TranscodeProviderJob;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodePipe;
import com.aelitis.azureus.core.devices.impl.TranscodePipeFileSource;
import com.aelitis.azureus.core.devices.impl.TranscodePipeStreamSource;
import com.aelitis.azureus.core.devices.impl.TranscodeProfileImpl;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ipc.IPCInterface;

public class TranscodeProviderVuze
implements TranscodeProvider {
    private static final String PROFILE_PREFIX = "vuzexcode:";
    private TranscodeManagerImpl manager;
    private PluginInterface plugin_interface;
    private volatile TranscodeProfile[] profiles;

    protected TranscodeProviderVuze(TranscodeManagerImpl transcodeManagerImpl, PluginInterface pluginInterface) {
        this.manager = transcodeManagerImpl;
        this.plugin_interface = pluginInterface;
    }

    public int getID() {
        return 1;
    }

    protected void update(PluginInterface pluginInterface) {
        this.plugin_interface = pluginInterface;
        this.profiles = null;
    }

    public String getName() {
        return this.plugin_interface.getPluginName() + ": version=" + this.plugin_interface.getPluginVersion();
    }

    public TranscodeProfile[] getProfiles() {
        if (this.profiles != null) {
            return this.profiles;
        }
        try {
            Map map = (Map)this.plugin_interface.getIPC().invoke("getProfiles", new Object[0]);
            TranscodeProfile[] transcodeProfileArray = new TranscodeProfile[map.size()];
            int n = 0;
            for (Map.Entry entry : map.entrySet()) {
                transcodeProfileArray[n++] = new TranscodeProfileImpl(this, PROFILE_PREFIX + (String)entry.getKey(), (String)entry.getKey(), (Map)entry.getValue());
            }
            this.profiles = transcodeProfileArray;
            return transcodeProfileArray;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new TranscodeProfile[0];
        }
    }

    public TranscodeProfile getProfile(String string) {
        TranscodeProfile[] transcodeProfileArray;
        for (TranscodeProfile transcodeProfile : transcodeProfileArray = this.getProfiles()) {
            if (!transcodeProfile.getUID().equals(string)) continue;
            return transcodeProfile;
        }
        return null;
    }

    public TranscodeProfile addProfile(File file) throws TranscodeException {
        try {
            String string = PROFILE_PREFIX + (String)this.plugin_interface.getIPC().invoke("addProfile", new Object[]{file});
            this.profiles = null;
            return this.getProfile(string);
        }
        catch (Throwable throwable) {
            throw new TranscodeException("Failed to add profile", throwable);
        }
    }

    public TranscodeProviderAnalysis analyse(final TranscodeProviderAdapter transcodeProviderAdapter, DiskManagerFileInfo diskManagerFileInfo, TranscodeProfile transcodeProfile) throws TranscodeException {
        try {
            Object object;
            IPCInterface iPCInterface;
            Object object2;
            Object object3;
            URL uRL = null;
            File file = null;
            long l = diskManagerFileInfo.getLength();
            if (l > 0L && l == diskManagerFileInfo.getDownloaded() && ((File)(object3 = diskManagerFileInfo.getFile())).exists() && ((File)object3).length() == l) {
                file = object3;
            }
            object3 = null;
            if (file == null) {
                object2 = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azupnpav");
                if (object2 == null) {
                    throw new TranscodeException("Media Server plugin not found");
                }
                iPCInterface = object2.getIPC();
                object = (String)iPCInterface.invoke("getContentURL", new Object[]{diskManagerFileInfo});
                if (object != null && ((String)object).length() > 0) {
                    uRL = new URL((String)object);
                    object3 = new TranscodePipeStreamSource(uRL.getPort());
                    uRL = UrlUtils.setPort(uRL, ((TranscodePipe)object3).getPort());
                }
            }
            if (file == null && uRL == null) {
                throw new TranscodeException("File doesn't exist");
            }
            object2 = object3;
            try {
                iPCInterface = this.plugin_interface.getIPC();
                object = uRL != null ? iPCInterface.invoke("analyseContent", new Object[]{uRL, transcodeProfile.getName()}) : iPCInterface.invoke("analyseContent", new Object[]{file, transcodeProfile.getName()});
                final HashMap hashMap = new HashMap();
                TranscodeProviderAnalysisImpl transcodeProviderAnalysisImpl = new TranscodeProviderAnalysisImpl(){

                    @Override
                    public void cancel() {
                        try {
                            iPCInterface.invoke("cancelAnalysis", new Object[]{object});
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }

                    @Override
                    public boolean foundVideoStream() {
                        return this.getLongProperty(3) > 0L;
                    }

                    @Override
                    public boolean getBooleanProperty(int n) {
                        if (n == 1) {
                            return this.getBooleanProperty("xcode_required", true);
                        }
                        Debug.out("Unknown property: " + n);
                        return false;
                    }

                    @Override
                    public void setBooleanProperty(int n, boolean bl) {
                        if (n == 5) {
                            hashMap.put("force_xcode", bl);
                        } else {
                            Debug.out("Unknown property: " + n);
                        }
                    }

                    @Override
                    public long getLongProperty(int n) {
                        if (n == 2) {
                            long l = this.getLongProperty("duration_millis", 0L);
                            long l2 = this.getLongProperty("audio_duration_millis", 0L);
                            if (l <= 0L && l2 > 0L) {
                                l = l2;
                            }
                            if (l2 > 0L && l2 < l) {
                                l = l2;
                            }
                            return l;
                        }
                        if (n == 3) {
                            return this.getLongProperty("video_width", 0L);
                        }
                        if (n == 4) {
                            return this.getLongProperty("video_height", 0L);
                        }
                        if (n == 6) {
                            return this.getLongProperty("source_size", 0L);
                        }
                        if (n == 7) {
                            return this.getLongProperty("estimated_transcoded_size", 0L);
                        }
                        Debug.out("Unknown property: " + n);
                        return 0L;
                    }

                    protected boolean getBooleanProperty(String string, boolean bl) {
                        Boolean bl2 = (Boolean)hashMap.get(string);
                        if (bl2 != null) {
                            return bl2;
                        }
                        return bl;
                    }

                    protected long getLongProperty(String string, long l) {
                        Long l2 = (Long)hashMap.get(string);
                        if (l2 != null) {
                            return l2;
                        }
                        return l;
                    }

                    @Override
                    public Map<String, Object> getResult() {
                        return hashMap;
                    }
                };
                new AEThread2("analysisStatus", true, (TranscodePipe)object2){
                    final /* synthetic */ TranscodePipe val$f_pipe;
                    {
                        this.val$f_pipe = transcodePipe;
                        super(string, bl);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block10: {
                            try {
                                try {
                                    Map map;
                                    long l;
                                    while ((l = ((Long)(map = (Map)iPCInterface.invoke("getAnalysisStatus", new Object[]{object})).get("state")).longValue()) == 0L) {
                                        Thread.sleep(50L);
                                    }
                                    if (l == 1L) {
                                        transcodeProviderAdapter.failed(new TranscodeException("Analysis cancelled"));
                                    } else if (l == 2L) {
                                        transcodeProviderAdapter.failed(new TranscodeException("Analysis failed", (Throwable)map.get("error")));
                                    } else {
                                        hashMap.putAll((Map)map.get("result"));
                                        transcodeProviderAdapter.complete();
                                    }
                                }
                                catch (Throwable throwable) {
                                    transcodeProviderAdapter.failed(new TranscodeException("Failed to get status", throwable));
                                }
                                Object var5_4 = null;
                                if (this.val$f_pipe == null) break block10;
                                this.val$f_pipe.destroy();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                if (this.val$f_pipe != null) {
                                    this.val$f_pipe.destroy();
                                }
                                throw throwable;
                            }
                            {
                            }
                        }
                    }
                }.start();
                return transcodeProviderAnalysisImpl;
            }
            catch (Throwable throwable) {
                if (object3 != null) {
                    ((TranscodePipe)object3).destroy();
                }
                throw throwable;
            }
        }
        catch (TranscodeException transcodeException) {
            throw transcodeException;
        }
        catch (Throwable throwable) {
            throw new TranscodeException("analysis failed", throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TranscodeProviderJob transcode(final TranscodeProviderAdapter transcodeProviderAdapter, TranscodeProviderAnalysis transcodeProviderAnalysis, boolean bl, DiskManagerFileInfo diskManagerFileInfo, TranscodeProfile transcodeProfile, URL uRL) throws TranscodeException {
        try {
            Object object;
            Object object2;
            Object object3;
            PluginInterface pluginInterface = this.plugin_interface.getPluginManager().getPluginInterfaceByID("azupnpav");
            if (pluginInterface == null) {
                throw new TranscodeException("Media Server plugin not found");
            }
            final TranscodeProviderJob[] transcodeProviderJobArray = new TranscodeProviderJob[]{null};
            URL uRL2 = null;
            Object object4 = null;
            if (bl) {
                if (diskManagerFileInfo.getDownloaded() == diskManagerFileInfo.getLength() && ((File)(object3 = diskManagerFileInfo.getFile())).exists() && ((File)object3).length() == diskManagerFileInfo.getLength()) {
                    uRL2 = ((File)object3).toURI().toURL();
                }
                if (uRL2 == null) {
                    this.manager.log("Failed to use direct input as source file doesn't exist/incomplete");
                }
            }
            if (uRL2 == null) {
                object3 = pluginInterface.getIPC();
                object2 = (String)object3.invoke("getContentURL", new Object[]{diskManagerFileInfo});
                if (object2 == null || ((String)object2).length() == 0) {
                    object = diskManagerFileInfo.getFile();
                    if (!((File)object).exists()) throw new TranscodeException("Source file doesn't exist");
                    object4 = new TranscodePipeFileSource((File)object, new TranscodePipe.errorListener(){

                        public void error(Throwable throwable) {
                            transcodeProviderAdapter.failed(new TranscodeException("File access error", throwable));
                            if (transcodeProviderJobArray[0] != null) {
                                transcodeProviderJobArray[0].cancel();
                            }
                        }
                    });
                    uRL2 = new URL("http://127.0.0.1:" + ((TranscodePipe)object4).getPort() + "/");
                } else {
                    uRL2 = new URL((String)object2);
                    object4 = new TranscodePipeStreamSource(uRL2.getPort());
                    uRL2 = UrlUtils.setPort(uRL2, ((TranscodePipe)object4).getPort());
                }
            }
            object3 = object4;
            try {
                TranscodeProviderAdapter transcodeProviderAdapter2;
                object2 = this.plugin_interface.getIPC();
                if (uRL.getProtocol().equals("tcp")) {
                    transcodeProviderAdapter2 = transcodeProviderAdapter;
                    object = object2.invoke("transcodeToTCP", new Object[]{((TranscodeProviderAnalysisImpl)transcodeProviderAnalysis).getResult(), uRL2, transcodeProfile.getName(), uRL.getPort()});
                } else {
                    final File file = new File(uRL.toURI());
                    transcodeProviderAdapter2 = new TranscodeProviderAdapter(){

                        public void updateProgress(int n, int n2, int n3, int n4) {
                            transcodeProviderAdapter.updateProgress(n, n2, n3, n4);
                        }

                        public void streamStats(long l, long l2) {
                            transcodeProviderAdapter.streamStats(l, l2);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void failed(TranscodeException transcodeException) {
                            try {
                                file.delete();
                                Object var3_2 = null;
                                transcodeProviderAdapter.failed(transcodeException);
                            }
                            catch (Throwable throwable) {
                                Object var3_3 = null;
                                transcodeProviderAdapter.failed(transcodeException);
                                throw throwable;
                            }
                        }

                        public void complete() {
                            transcodeProviderAdapter.complete();
                        }
                    };
                    object = object2.invoke("transcodeToFile", new Object[]{((TranscodeProviderAnalysisImpl)transcodeProviderAnalysis).getResult(), uRL2, transcodeProfile.getName(), file});
                }
                new AEThread2("xcodeStatus", true, (TranscodePipe)object3, transcodeProviderAdapter2, (IPCInterface)object2, object){
                    final /* synthetic */ TranscodePipe val$f_pipe;
                    final /* synthetic */ TranscodeProviderAdapter val$adapter;
                    final /* synthetic */ IPCInterface val$ipc;
                    final /* synthetic */ Object val$context;
                    {
                        this.val$f_pipe = transcodePipe;
                        this.val$adapter = transcodeProviderAdapter;
                        this.val$ipc = iPCInterface;
                        this.val$context = object;
                        super(string, bl);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        block10: {
                            try {
                                boolean bl = true;
                                while (bl) {
                                    bl = false;
                                    if (this.val$f_pipe != null) {
                                        this.val$adapter.streamStats(this.val$f_pipe.getConnectionRate(), this.val$f_pipe.getWriteSpeed());
                                    }
                                    try {
                                        Map map = (Map)this.val$ipc.invoke("getTranscodeStatus", new Object[]{this.val$context});
                                        long l = (Long)map.get("state");
                                        if (l == 0L) {
                                            int n = (Integer)map.get("percent");
                                            Integer n2 = (Integer)map.get("eta_secs");
                                            int n3 = n2 == null ? -1 : n2;
                                            Integer n4 = (Integer)map.get("new_width");
                                            int n5 = n4 == null ? 0 : n4;
                                            Integer n6 = (Integer)map.get("new_height");
                                            int n7 = n6 == null ? 0 : n6;
                                            this.val$adapter.updateProgress(n, n3, n5, n7);
                                            if (n == 100) {
                                                this.val$adapter.complete();
                                                continue;
                                            }
                                            bl = true;
                                            Thread.sleep(1000L);
                                            continue;
                                        }
                                        if (l == 1L) {
                                            this.val$adapter.failed(new TranscodeException("Transcode cancelled"));
                                            continue;
                                        }
                                        this.val$adapter.failed(new TranscodeException("Transcode failed", (Throwable)map.get("error")));
                                    }
                                    catch (Throwable throwable) {
                                        this.val$adapter.failed(new TranscodeException("Failed to get status", throwable));
                                    }
                                }
                                Object var13_12 = null;
                                if (this.val$f_pipe == null) break block10;
                                this.val$f_pipe.destroy();
                            }
                            catch (Throwable throwable) {
                                Object var13_13 = null;
                                if (this.val$f_pipe != null) {
                                    this.val$f_pipe.destroy();
                                }
                                throw throwable;
                            }
                            {
                            }
                        }
                    }
                }.start();
                transcodeProviderJobArray[0] = new TranscodeProviderJob((TranscodePipe)object3, (IPCInterface)object2, object){
                    final /* synthetic */ TranscodePipe val$f_pipe;
                    final /* synthetic */ IPCInterface val$ipc;
                    final /* synthetic */ Object val$context;
                    {
                        this.val$f_pipe = transcodePipe;
                        this.val$ipc = iPCInterface;
                        this.val$context = object;
                    }

                    public void pause() {
                        if (this.val$f_pipe != null) {
                            this.val$f_pipe.pause();
                        }
                    }

                    public void resume() {
                        if (this.val$f_pipe != null) {
                            this.val$f_pipe.resume();
                        }
                    }

                    public void cancel() {
                        try {
                            this.val$ipc.invoke("cancelTranscode", new Object[]{this.val$context});
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }

                    public void setMaxBytesPerSecond(int n) {
                        if (this.val$f_pipe != null) {
                            this.val$f_pipe.setMaxBytesPerSecond(n);
                        }
                    }
                };
                return transcodeProviderJobArray[0];
            }
            catch (Throwable throwable) {
                if (object4 == null) throw throwable;
                ((TranscodePipe)object4).destroy();
                throw throwable;
            }
        }
        catch (TranscodeException transcodeException) {
            throw transcodeException;
        }
        catch (Throwable throwable) {
            throw new TranscodeException("transcode failed", throwable);
        }
    }

    public File getAssetDirectory() {
        File file = this.plugin_interface.getPluginconfig().getPluginUserFile("assets");
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    protected void destroy() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface TranscodeProviderAnalysisImpl
    extends TranscodeProviderAnalysis {
        public Map<String, Object> getResult();
    }
}

