/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.TranscodeActionVetoException;
import com.aelitis.azureus.core.devices.TranscodeAnalysisListener;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.impl.DeviceImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeQueueImpl;
import com.aelitis.azureus.core.download.DiskManagerFileInfoFile;
import com.aelitis.azureus.core.messenger.config.PlatformDevicesMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerStats;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranscodeJobImpl
implements TranscodeJob,
DownloadWillBeRemovedListener {
    private static final int TRANSCODE_OK_DL_PERCENT = 90;
    private TranscodeQueueImpl queue;
    private TranscodeTarget target;
    private TranscodeProfile profile;
    private DiskManagerFileInfo file;
    private TranscodeFileImpl transcode_file;
    private boolean is_stream;
    private volatile InputStream stream;
    private AESemaphore stream_sem = new AESemaphore("TJ:s");
    private int transcode_requirement;
    private int state = 0;
    private int percent_complete = 0;
    private int eta = Integer.MAX_VALUE;
    private String error;
    private long started_on;
    private long paused_on;
    private long process_time;
    private boolean use_direct_input;
    private boolean prefer_direct_input;
    private boolean auto_retry_enabled = true;
    private boolean auto_retry;
    private int auto_retry_count;
    private Download download;
    private boolean download_ok;

    protected TranscodeJobImpl(TranscodeQueueImpl transcodeQueueImpl, TranscodeTarget transcodeTarget, TranscodeProfile transcodeProfile, DiskManagerFileInfo diskManagerFileInfo, boolean bl, int n, boolean bl2) throws TranscodeException {
        this.queue = transcodeQueueImpl;
        this.target = transcodeTarget;
        this.profile = transcodeProfile;
        this.file = diskManagerFileInfo;
        this.transcode_requirement = n;
        this.is_stream = bl2;
        if (bl) {
            this.state = 6;
        }
        this.init();
    }

    protected TranscodeJobImpl(TranscodeQueueImpl transcodeQueueImpl, Map<String, Object> map) throws IOException, TranscodeException {
        this.queue = transcodeQueueImpl;
        this.state = ImportExportUtils.importInt(map, "state");
        if (this.state == 1) {
            this.state = 0;
        }
        this.error = ImportExportUtils.importString(map, "error", null);
        String string = ImportExportUtils.importString(map, "target");
        this.target = this.queue.lookupTarget(string);
        String string2 = ImportExportUtils.importString(map, "profile");
        this.profile = this.queue.lookupProfile(string2);
        String string3 = ImportExportUtils.importString(map, "file");
        if (string3 == null) {
            byte[] byArray = ByteFormatter.decodeString(ImportExportUtils.importString(map, "dl_hash"));
            int n = ImportExportUtils.importInt(map, "file_index");
            this.file = this.queue.lookupFile(byArray, n);
        } else {
            this.file = new DiskManagerFileInfoFile(new File(string3));
        }
        this.transcode_requirement = ImportExportUtils.importInt(map, "trans_req", -1);
        this.auto_retry_enabled = ImportExportUtils.importBoolean(map, "ar_enable", true);
        this.prefer_direct_input = ImportExportUtils.importBoolean(map, "pdi", false);
        this.init();
    }

    protected Map<String, Object> toMap() throws IOException {
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ImportExportUtils.exportInt(hashMap, "state", this.state);
            ImportExportUtils.exportString(hashMap, "error", this.error);
            ImportExportUtils.exportString(hashMap, "target", this.target.getID());
            ImportExportUtils.exportString(hashMap, "profile", this.profile.getUID());
            try {
                Download download = this.file.getDownload();
                ImportExportUtils.exportString(hashMap, "dl_hash", ByteFormatter.encodeString(download.getTorrent().getHash()));
                ImportExportUtils.exportInt(hashMap, "file_index", this.file.getIndex());
            }
            catch (DownloadException downloadException) {
                ImportExportUtils.exportString(hashMap, "file", this.file.getFile().getAbsolutePath());
            }
            ImportExportUtils.exportInt(hashMap, "trans_req", this.transcode_requirement);
            ImportExportUtils.exportBoolean(hashMap, "ar_enable", this.auto_retry_enabled);
            ImportExportUtils.exportBoolean(hashMap, "pdi", this.prefer_direct_input);
            return hashMap;
        }
        catch (Throwable throwable) {
            throw new IOException("Export failed: " + Debug.getNestedExceptionMessage(throwable));
        }
    }

    protected void init() throws TranscodeException {
        this.transcode_file = ((DeviceImpl)this.target.getDevice()).allocateFile(this.profile, this.getTranscodeRequirement() == 1, this.file, true);
        try {
            this.download = this.file.getDownload();
            if (this.download != null) {
                this.download.addDownloadWillBeRemovedListener(this);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateStatus(false);
    }

    protected void updateStatus() {
        this.updateStatus(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateStatus(boolean bl) {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.download_ok) {
                return;
            }
            long l = this.file.getDownloaded();
            long l2 = this.file.getLength();
            if (this.download == null || l == l2) {
                this.download_ok = true;
            } else {
                Torrent torrent = this.download.getTorrent();
                if (PlatformTorrentUtils.isContent(torrent, false) || PlatformTorrentUtils.getContentNetworkID(PluginCoreUtils.unwrap(torrent)) == 3L) {
                    this.download_ok = true;
                } else {
                    int n = (int)(100L * l / l2);
                    if (n >= 90) {
                        this.download_ok = true;
                    } else {
                        PeerManager peerManager = this.download.getPeerManager();
                        if (peerManager != null) {
                            PeerManagerStats peerManagerStats = peerManager.getStats();
                            int n2 = peerManagerStats.getConnectedSeeds();
                            int n3 = peerManagerStats.getConnectedLeechers();
                            if (n2 > 10 && n2 > n3) {
                                this.download_ok = true;
                            }
                        }
                    }
                }
            }
        }
        if (this.download_ok && bl) {
            this.queue.jobChanged(this, true, false);
        }
    }

    @Override
    public long getDownloadETA() {
        if (this.download_ok) {
            return 0L;
        }
        if (this.file.getDownloaded() == this.file.getLength()) {
            return 0L;
        }
        if (this.file.isSkipped() || this.file.isDeleted()) {
            return Long.MAX_VALUE;
        }
        try {
            long l = PluginCoreUtils.unwrap(this.download).getStats().getETA();
            if (l < 0L) {
                return Long.MAX_VALUE;
            }
            long l2 = l * 100L / 90L;
            if (l2 == 0L) {
                l2 = 1L;
            }
            return l2;
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return Long.MAX_VALUE;
        }
    }

    protected boolean canUseDirectInput() {
        long l = this.file.getLength();
        return this.file.getDownloaded() == l && this.file.getFile().length() == l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean useDirectInput() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.use_direct_input || this.getPreferDirectInput() && this.canUseDirectInput();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUseDirectInput() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.use_direct_input = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPreferDirectInput(boolean bl) {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.prefer_direct_input = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPreferDirectInput() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.prefer_direct_input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAutoRetry(boolean bl) {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (bl) {
                this.auto_retry = true;
                ++this.auto_retry_count;
            } else {
                this.auto_retry = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isAutoRetry() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.auto_retry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAutoRetryCount() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return this.auto_retry_count;
        }
    }

    @Override
    public void setEnableAutoRetry(boolean bl) {
        this.auto_retry_enabled = bl;
    }

    @Override
    public boolean getEnableAutoRetry() {
        return this.auto_retry_enabled;
    }

    protected boolean isStream() {
        return this.is_stream;
    }

    protected void setStream(InputStream inputStream) {
        this.stream = inputStream;
        this.stream_sem.releaseForever();
    }

    protected InputStream getStream(int n) throws IOException {
        if (this.state == 5) {
            throw new IOException("Transcode job failed: " + this.error);
        }
        if (this.state == 4) {
            throw new IOException("Transcode job cancelled");
        }
        if (this.state == 7) {
            throw new IOException("Transcode job removed");
        }
        this.stream_sem.reserve(n);
        return this.stream;
    }

    @Override
    public void downloadWillBeRemoved(Download download) throws DownloadRemovalVetoException {
        if (this.queue.getIndex(this) != 0 && this.state != 3) {
            throw new DownloadRemovalVetoException(MessageText.getString("devices.xcode.remove.vetoed", new String[]{download.getName()}));
        }
        download.removeDownloadWillBeRemovedListener(this);
    }

    @Override
    public String getName() {
        if (this.download != null) {
            if (this.download.getDiskManagerFileInfo().length == 1) {
                return this.download.getName();
            }
            return this.download.getName() + ": " + this.file.getFile().getName();
        }
        return this.file.getFile().getName();
    }

    protected void reset() {
        this.state = 0;
        this.error = null;
        this.percent_complete = 0;
        this.eta = Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void starts() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.started_on = SystemTime.getMonotonousTime();
            this.paused_on = 0L;
            if (this.state != 2) {
                this.state = 1;
            }
        }
        this.queue.jobChanged(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void failed(Throwable throwable) {
        this.queue.log("Transcode failed", throwable);
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state != 6) {
                this.state = 5;
                this.error = Debug.getNestedExceptionMessage(throwable);
                this.process_time += SystemTime.getMonotonousTime() - this.started_on;
                this.paused_on = 0L;
                this.started_on = 0L;
            }
        }
        this.queue.jobChanged(this, false, true);
        try {
            int n = this.state;
            if (this.state != 6 && !this.isStream() && this.getAutoRetryCount() == 0 && this.canUseDirectInput() && !this.useDirectInput()) {
                n |= 0x100;
            }
            PlatformDevicesMessenger.qosTranscode(this, n);
        }
        catch (Throwable throwable2) {
            Debug.out(throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void complete() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            this.state = 3;
            this.process_time += SystemTime.getMonotonousTime() - this.started_on;
            this.paused_on = 0L;
            this.started_on = 0L;
        }
        if (this.download != null) {
            this.download.removeDownloadWillBeRemovedListener(this);
        }
        this.transcode_file.setComplete(true);
        this.queue.jobChanged(this, false, false);
        try {
            PlatformDevicesMessenger.qosTranscode(this, 3);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    protected void updateProgress(int n, int n2) {
        if (this.percent_complete != n || this.eta != n2) {
            this.percent_complete = n;
            this.eta = n2;
            this.queue.jobChanged(this, false, false);
        }
    }

    @Override
    public TranscodeTarget getTarget() {
        return this.target;
    }

    @Override
    public int getTranscodeRequirement() {
        if (this.transcode_requirement >= 0) {
            return this.transcode_requirement;
        }
        return this.getDevice().getTranscodeRequirement();
    }

    @Override
    public void analyseNow(TranscodeAnalysisListener transcodeAnalysisListener) throws TranscodeException {
        this.queue.analyse(this, transcodeAnalysisListener);
    }

    protected DeviceImpl getDevice() {
        return (DeviceImpl)((Object)this.target);
    }

    @Override
    public TranscodeProfile getProfile() {
        return this.profile;
    }

    @Override
    public DiskManagerFileInfo getFile() {
        return this.file;
    }

    @Override
    public TranscodeFileImpl getTranscodeFile() {
        return this.transcode_file;
    }

    @Override
    public int getIndex() {
        return this.queue.getIndex(this);
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public int getPercentComplete() {
        return this.percent_complete;
    }

    @Override
    public long getETASecs() {
        if (this.eta <= 0) {
            return 0L;
        }
        if (this.eta == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.eta;
    }

    @Override
    public String getETA() {
        if (this.eta < 0) {
            return null;
        }
        if (this.eta == Integer.MAX_VALUE) {
            return "\u221e";
        }
        return TimeFormatter.format(this.eta);
    }

    @Override
    public String getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canPause() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            return !this.use_direct_input;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.use_direct_input) {
                return;
            }
            if (this.state != 1) {
                return;
            }
            this.state = 2;
            this.paused_on = SystemTime.getMonotonousTime();
        }
        this.queue.jobChanged(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state == 2) {
                this.state = 1;
                if (this.paused_on > 0L && this.started_on > 0L) {
                    this.process_time -= SystemTime.getMonotonousTime() - this.paused_on;
                }
            } else {
                return;
            }
        }
        this.queue.jobChanged(this, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queue() {
        boolean bl;
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            bl = this.state == 2;
        }
        if (bl) {
            this.resume();
            return;
        }
        transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state != 0) {
                if (this.state == 1 || this.state == 2) {
                    this.stop();
                }
            } else {
                return;
            }
            this.reset();
            this.use_direct_input = false;
            this.auto_retry = false;
            this.auto_retry_count = 0;
            this.is_stream = false;
        }
        this.queue.jobChanged(this, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            if (this.state == 6) {
                return;
            }
            this.state = 6;
            this.process_time = 0L;
            this.started_on = 0L;
        }
        this.queue.jobChanged(this, true, true);
    }

    @Override
    public void remove() throws TranscodeActionVetoException {
        this.queue.remove(this, false);
    }

    @Override
    public void removeForce() {
        try {
            this.queue.remove(this, true);
        }
        catch (TranscodeActionVetoException transcodeActionVetoException) {
            Debug.out(transcodeActionVetoException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        boolean bl;
        TranscodeJobImpl transcodeJobImpl = this;
        synchronized (transcodeJobImpl) {
            bl = this.state != 3;
            this.state = 7;
        }
        if (bl && !this.isStream()) {
            try {
                this.transcode_file.delete(true);
            }
            catch (Throwable throwable) {
                this.queue.log("Faile to destroy job", throwable);
            }
        }
    }

    @Override
    public void moveUp() {
        this.queue.moveUp(this);
    }

    @Override
    public void moveDown() {
        this.queue.moveDown(this);
    }

    @Override
    public long getProcessTime() {
        if (this.state == 3) {
            return this.process_time;
        }
        if (this.started_on == 0L) {
            if (this.process_time > 0L) {
                return this.process_time;
            }
            return 0L;
        }
        return SystemTime.getMonotonousTime() - this.started_on + this.process_time;
    }

    public void generate(IndentWriter indentWriter) {
        indentWriter.println("target=" + this.target.getID() + ", profile=" + this.profile.getName() + ", file=" + this.file);
        indentWriter.println("tfile=" + this.transcode_file.getString());
        indentWriter.println("stream=" + this.is_stream + ", state=" + this.state + ", treq=" + this.transcode_requirement + ", %=" + this.percent_complete + ", error=" + this.error);
    }
}

