/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceListener;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.devices.impl.DeviceManagerImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeFileImpl;
import com.aelitis.azureus.core.devices.impl.TranscodeManagerImpl;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeviceImpl
implements Device {
    private static final String MY_PACKAGE = "com.aelitis.azureus.core.devices.impl";
    private static final TranscodeProfile blank_profile = new TranscodeProfile(){

        public String getUID() {
            return null;
        }

        public String getName() {
            return "blank";
        }

        public String getDescription() {
            return "blank";
        }

        public boolean isStreamable() {
            return false;
        }

        public String getIconURL() {
            return null;
        }

        public int getIconIndex() {
            return 0;
        }

        public String getFileExtension() {
            return null;
        }

        public String getDeviceClassification() {
            return null;
        }

        public TranscodeProvider getProvider() {
            return null;
        }

        public File getAssetDirectory() {
            return null;
        }
    };
    private static List<Pattern> device_renames = new ArrayList<Pattern>();
    private static final String PP_REND_WORK_DIR = "tt_work_dir";
    private static final String PP_REND_DEF_TRANS_PROF = "tt_def_trans_prof";
    private static final String PP_REND_TRANS_REQ = "tt_req";
    private static final String PP_REND_TRANS_CACHE = "tt_always_cache";
    private static final String PP_REND_RSS_PUB = "tt_rss_pub";
    protected static final String PP_REND_SHOW_CAT = "tt_show_cat";
    protected static final String PP_REND_CLASSIFICATION = "tt_rend_class";
    protected static final String PP_IP_ADDRESS = "rend_ip";
    protected static final String TP_IP_ADDRESS = "DeviceUPnPImpl:ip";
    protected static final String PP_FILTER_FILES = "rend_filter";
    protected static final String PP_COPY_OUTSTANDING = "copy_outstanding";
    protected static final String PP_AUTO_START = "auto_start";
    protected static final String PP_COPY_TO_FOLDER = "copy_to_folder";
    protected static final String PP_AUTO_COPY = "auto_copy";
    protected static final String PP_LIVENESS_DETECTABLE = "live_det";
    protected static final String PP_TIVO_MACHINE = "tivo_machine";
    protected static final String PP_OD_ENABLED = "od_enabled";
    protected static final String PP_OD_SHOWN_FTUX = "od_shown_ftux";
    protected static final String PP_OD_MANUFACTURER = "od_manufacturer";
    protected static final String PP_OD_STATE_CACHE = "od_state_cache";
    protected static final String PP_OD_XFER_CACHE = "od_xfer_cache";
    protected static final String PP_OD_UPNP_DISC_CACHE = "od_upnp_cache";
    protected static final boolean PR_AUTO_START_DEFAULT = true;
    protected static final boolean PP_AUTO_COPY_DEFAULT = false;
    private static final String GENERIC = "generic";
    private DeviceManagerImpl manager;
    private int type;
    private String uid;
    private String secondary_uid;
    private String classification;
    private String name;
    private boolean manual;
    private boolean hidden;
    private long last_seen;
    private boolean can_remove = true;
    private int busy_count;
    private boolean online;
    private boolean transcoding;
    private Map<String, Object> persistent_properties = new LightHashMap<String, Object>(1);
    private Map<Object, Object> transient_properties = new LightHashMap<Object, Object>(1);
    private long device_files_last_mod;
    private boolean device_files_dirty;
    private Map<String, Map<String, ?>> device_files;
    private WeakReference<Map<String, Map<String, ?>>> device_files_ref;
    private CopyOnWriteList<TranscodeTargetListener> listeners = new CopyOnWriteList();
    private Map<Object, String> errors = new HashMap<Object, String>();
    private Map<Object, String> infos = new HashMap<Object, String>();
    private CopyOnWriteList<DeviceListener> device_listeners;

    protected static DeviceImpl importFromBEncodedMapStatic(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        String string = ImportExportUtils.importString(map, "_impl");
        if (string.startsWith(".")) {
            string = MY_PACKAGE + string;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getDeclaredConstructor(DeviceManagerImpl.class, Map.class);
            constructor.setAccessible(true);
            return (DeviceImpl)constructor.newInstance(deviceManagerImpl, map);
        }
        catch (Throwable throwable) {
            Debug.out("Can't construct device for " + string, throwable);
            throw new IOException("Construction failed: " + Debug.getNestedExceptionMessage(throwable));
        }
    }

    private static String modifyDeviceDisplayName(String string) {
        for (Pattern pattern : device_renames) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            String string2 = matcher.group(1);
            return string2;
        }
        return string;
    }

    protected DeviceImpl(DeviceManagerImpl deviceManagerImpl, int n, String string, String string2, boolean bl) {
        this(deviceManagerImpl, n, string, string2, bl, string2);
    }

    protected DeviceImpl(DeviceManagerImpl deviceManagerImpl, int n, String string, String string2, boolean bl, String string3) {
        this.manager = deviceManagerImpl;
        this.type = n;
        this.uid = string;
        this.classification = string2;
        this.name = DeviceImpl.modifyDeviceDisplayName(string3);
        this.manual = bl;
    }

    protected DeviceImpl(DeviceManagerImpl deviceManagerImpl, Map map) throws IOException {
        this.manager = deviceManagerImpl;
        this.type = (int)ImportExportUtils.importLong(map, "_type");
        this.uid = ImportExportUtils.importString(map, "_uid");
        this.classification = ImportExportUtils.importString(map, "_name");
        this.name = ImportExportUtils.importString(map, "_lname");
        if (this.name == null) {
            this.name = this.classification;
        }
        if (ImportExportUtils.importLong(map, "_rn", 0L) == 0L) {
            this.name = DeviceImpl.modifyDeviceDisplayName(this.name);
        }
        this.secondary_uid = ImportExportUtils.importString(map, "_suid");
        this.last_seen = ImportExportUtils.importLong(map, "_ls");
        this.hidden = ImportExportUtils.importBoolean(map, "_hide");
        this.manual = ImportExportUtils.importBoolean(map, "_man");
        if (map.containsKey("_pprops")) {
            this.persistent_properties = (Map)map.get("_pprops");
        }
    }

    protected void exportToBEncodedMap(Map map) throws IOException {
        String string = this.getClass().getName();
        if (string.startsWith(MY_PACKAGE)) {
            string = string.substring(MY_PACKAGE.length());
        }
        ImportExportUtils.exportString(map, "_impl", string);
        ImportExportUtils.exportLong(map, "_type", new Long(this.type));
        ImportExportUtils.exportString(map, "_uid", this.uid);
        ImportExportUtils.exportString(map, "_name", this.classification);
        ImportExportUtils.exportLong(map, "_rn", 1L);
        ImportExportUtils.exportString(map, "_lname", this.name);
        if (this.secondary_uid != null) {
            ImportExportUtils.exportString(map, "_suid", this.secondary_uid);
        }
        ImportExportUtils.exportLong(map, "_ls", new Long(this.last_seen));
        ImportExportUtils.exportBoolean(map, "_hide", this.hidden);
        ImportExportUtils.exportBoolean(map, "_man", this.manual);
        map.put("_pprops", this.persistent_properties);
    }

    protected boolean updateFrom(DeviceImpl deviceImpl, boolean bl) {
        if (this.type != deviceImpl.type) {
            Debug.out("Inconsistent update operation (type)");
            return false;
        }
        String string = deviceImpl.uid;
        String string2 = deviceImpl.secondary_uid;
        if (!this.uid.equals(string)) {
            boolean bl2 = false;
            if (this.secondary_uid == null && string2 == null) {
                bl2 = true;
            } else if (!(this.secondary_uid == null && this.uid.equals(string2) || string2 == null && string.equals(this.secondary_uid) || string2.equals(this.secondary_uid))) {
                bl2 = true;
            }
            if (bl2) {
                Debug.out("Inconsistent update operation (uids)");
                return false;
            }
        }
        if (!this.classification.equals(deviceImpl.classification)) {
            this.classification = deviceImpl.classification;
            this.setDirty();
        }
        if (this.manual != deviceImpl.manual) {
            this.manual = deviceImpl.manual;
            this.setDirty();
        }
        if (bl) {
            this.alive();
        }
        return true;
    }

    protected void initialise() {
        this.updateStatus(0);
    }

    protected void destroy() {
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getID() {
        return this.uid;
    }

    protected void setSecondaryID(String string) {
        this.secondary_uid = string;
    }

    protected String getSecondaryID() {
        return this.secondary_uid;
    }

    public Device getDevice() {
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        if (!this.name.equals(string)) {
            this.name = string;
            this.setDirty();
        }
    }

    @Override
    public String getClassification() {
        String string = this.getPersistentStringProperty(PP_REND_CLASSIFICATION, null);
        if (string != null) {
            return string;
        }
        return this.classification;
    }

    @Override
    public String getShortDescription() {
        if (this.getRendererSpecies() == 3) {
            return "iPad, iPhone, iPod, Apple TV";
        }
        return null;
    }

    public int getRendererSpecies() {
        if (this.classification.equalsIgnoreCase("PS3")) {
            return 1;
        }
        if (this.classification.equalsIgnoreCase("XBox 360")) {
            return 2;
        }
        if (this.classification.equalsIgnoreCase("Wii")) {
            return 4;
        }
        if (this.classification.equalsIgnoreCase("Browser")) {
            return 5;
        }
        return 6;
    }

    protected String getDeviceClassification() {
        switch (this.getRendererSpecies()) {
            case 1: {
                return "sony.PS3";
            }
            case 2: {
                return "microsoft.XBox";
            }
            case 4: {
                return "nintendo.Wii";
            }
            case 5: {
                return "browser.generic";
            }
            case 6: {
                if (this.isManual()) {
                    return this.classification;
                }
                if (this.classification.equals("sony.PSP") || this.classification.startsWith("tivo.")) {
                    return this.classification;
                }
                String string = this.getPersistentStringProperty(PP_REND_CLASSIFICATION, null);
                if (string != null) {
                    return string;
                }
                return GENERIC;
            }
        }
        Debug.out("Unknown classification");
        return GENERIC;
    }

    public boolean isNonSimple() {
        return this.getDeviceClassification() == GENERIC || this.getClassification().startsWith("ms_wmp.");
    }

    @Override
    public boolean isManual() {
        return this.manual;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean bl) {
        if (bl != this.hidden) {
            this.hidden = bl;
            this.setDirty();
        }
    }

    protected void alive() {
        this.last_seen = SystemTime.getCurrentTime();
        if (!this.online) {
            this.online = true;
            this.setDirty(false);
        }
    }

    @Override
    public boolean isLivenessDetectable() {
        return !this.manual;
    }

    @Override
    public boolean isAlive() {
        return this.online;
    }

    protected void dead() {
        if (this.online) {
            this.online = false;
            this.setDirty(false);
        }
    }

    protected void setDirty() {
        this.setDirty(true);
    }

    protected void setDirty(boolean bl) {
        this.manager.configDirty(this, bl);
    }

    protected void updateStatus(int n) {
    }

    @Override
    public void requestAttention() {
        this.manager.requestAttention(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeFileImpl[] getFiles() {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                ArrayList<TranscodeFileImpl> arrayList = new ArrayList<TranscodeFileImpl>();
                Iterator<Map.Entry<String, Map<String, ?>>> iterator = this.device_files.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Map<String, ?>> entry = iterator.next();
                    try {
                        TranscodeFileImpl transcodeFileImpl = new TranscodeFileImpl(this, entry.getKey(), this.device_files);
                        arrayList.add(transcodeFileImpl);
                    }
                    catch (Throwable throwable) {
                        iterator.remove();
                        this.log("Failed to deserialise transcode file", throwable);
                    }
                }
                return arrayList.toArray(new TranscodeFileImpl[arrayList.size()]);
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
            return new TranscodeFileImpl[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeFileImpl allocateFile(TranscodeProfile transcodeProfile, boolean bl, DiskManagerFileInfo diskManagerFileInfo, boolean bl2) throws TranscodeException {
        TranscodeFileImpl transcodeFileImpl = null;
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                String object;
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                if (this.device_files.containsKey(object = ByteFormatter.encodeString(diskManagerFileInfo.getDownloadHash()) + ":" + diskManagerFileInfo.getIndex() + ":" + transcodeProfile.getUID())) {
                    try {
                        transcodeFileImpl = new TranscodeFileImpl(this, object, this.device_files);
                    }
                    catch (Throwable throwable) {
                        this.device_files.remove(object);
                        this.log("Failed to deserialise transcode file", throwable);
                    }
                }
                if (transcodeFileImpl == null) {
                    String string = transcodeProfile.getFileExtension();
                    String string2 = diskManagerFileInfo.getFile(true).getName();
                    if (string != null && !bl) {
                        int n = string2.lastIndexOf(46);
                        if (n != -1) {
                            string2 = string2.substring(0, n);
                        }
                        string2 = string2 + string;
                    }
                    string2 = this.allocateUniqueFileName(string2);
                    File file = this.getWorkingDirectory(true);
                    file = new File(file.getAbsoluteFile(), string2);
                    transcodeFileImpl = new TranscodeFileImpl(this, object, transcodeProfile.getName(), this.device_files, file, bl2);
                    transcodeFileImpl.setSourceFile(diskManagerFileInfo);
                    this.device_files_last_mod = SystemTime.getMonotonousTime();
                    this.device_files_dirty = true;
                } else {
                    transcodeFileImpl.setSourceFile(diskManagerFileInfo);
                    transcodeFileImpl.setProfileName(transcodeProfile.getName());
                }
            }
        }
        catch (Throwable throwable) {
            throw new TranscodeException("File allocation failed", throwable);
        }
        for (TranscodeTargetListener transcodeTargetListener : this.listeners) {
            try {
                transcodeTargetListener.fileAdded(transcodeFileImpl);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        return transcodeFileImpl;
    }

    protected String allocateUniqueFileName(String object) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Map<String, ?> object2 : this.device_files.values()) {
            try {
                hashSet.add(new File(ImportExportUtils.importString(object2, "file")).getName());
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
        for (int i = 0; i < 1024; ++i) {
            Object object2;
            Object object3 = object2 = i == 0 ? object : i + "_" + (String)object;
            if (hashSet.contains(object2)) continue;
            object = object2;
            break;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void revertFileName(TranscodeFileImpl transcodeFileImpl) throws TranscodeException {
        File file = transcodeFileImpl.getCacheFile();
        if (file.exists()) {
            Debug.out("Cache file already allocated, can't rename");
            return;
        }
        File file2 = transcodeFileImpl.getSourceFile().getFile(true);
        String string = file2.getName();
        int n = string.indexOf(46);
        if (n == -1) {
            return;
        }
        String string2 = file.getName();
        if (string2.endsWith(string.substring(n))) {
            return;
        }
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                String string3 = this.allocateUniqueFileName(string);
                transcodeFileImpl.setCacheFile(new File(file.getParentFile(), string3));
            }
        }
        catch (Throwable throwable) {
            throw new TranscodeException("File name revertion failed", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranscodeFileImpl lookupFile(TranscodeProfile transcodeProfile, DiskManagerFileInfo diskManagerFileInfo) {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                String string;
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                if (this.device_files.containsKey(string = ByteFormatter.encodeString(diskManagerFileInfo.getDownloadHash()) + ":" + diskManagerFileInfo.getIndex() + ":" + transcodeProfile.getUID())) {
                    try {
                        return new TranscodeFileImpl(this, string, this.device_files);
                    }
                    catch (Throwable throwable) {
                        this.device_files.remove(string);
                        this.log("Failed to deserialise transcode file", throwable);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TranscodeFileImpl getTranscodeFile(String string) {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                }
                if (this.device_files.containsKey(string)) {
                    try {
                        return new TranscodeFileImpl(this, string, this.device_files);
                    }
                    catch (Throwable throwable) {
                        this.device_files.remove(string);
                        this.log("Failed to deserialise transcode file", throwable);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public File getWorkingDirectory() {
        return this.getWorkingDirectory(false);
    }

    public File getWorkingDirectory(boolean bl) {
        File file;
        String string = this.getPersistentStringProperty(PP_REND_WORK_DIR);
        if (string.length() == 0) {
            file = this.manager.getDefaultWorkingDirectory(bl);
            if (bl) {
                file.mkdirs();
            }
            String string2 = FileUtil.convertOSSpecificChars(this.getName(), true);
            for (int i = 0; i < 1024; ++i) {
                String string3 = string2 + (i == 0 ? "" : "_" + i);
                File file2 = new File(file, string3);
                if (file2.exists()) continue;
                file = file2;
                break;
            }
            string = file.getAbsolutePath();
            if (bl) {
                this.setPersistentStringProperty(PP_REND_WORK_DIR, string);
            }
        }
        if (!(file = new File(string)).exists() && bl) {
            file.mkdirs();
        }
        return file;
    }

    public void setWorkingDirectory(File file) {
        this.setPersistentStringProperty(PP_REND_WORK_DIR, file.getAbsolutePath());
    }

    protected void resetWorkingDirectory() {
        this.setPersistentStringProperty(PP_REND_WORK_DIR, "");
    }

    public TranscodeProfile[] getTranscodeProfiles() {
        String string = this.getDeviceClassification();
        TranscodeProfile[] transcodeProfileArray = this.getTranscodeProfiles(string);
        if (transcodeProfileArray.length > 0) {
            return transcodeProfileArray;
        }
        try {
            String[] stringArray = string.split("\\.");
            for (int i = stringArray.length - 1; i >= 1; --i) {
                String string2 = "";
                for (int j = 0; j < i; ++j) {
                    string2 = string2 + (string2.length() == 0 ? "" : ".") + stringArray[j];
                }
                transcodeProfileArray = this.getTranscodeProfiles(string2 = string2 + (string2.length() == 0 ? "" : ".") + GENERIC);
                if (transcodeProfileArray.length <= 0) continue;
                return transcodeProfileArray;
            }
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        return new TranscodeProfile[0];
    }

    private TranscodeProfile[] getTranscodeProfiles(String string) {
        TranscodeProvider[] transcodeProviderArray;
        ArrayList<TranscodeProfile> arrayList = new ArrayList<TranscodeProfile>();
        DeviceManagerImpl deviceManagerImpl = this.getManager();
        TranscodeManagerImpl transcodeManagerImpl = deviceManagerImpl.getTranscodeManager();
        for (TranscodeProvider transcodeProvider : transcodeProviderArray = transcodeManagerImpl.getProviders()) {
            TranscodeProfile[] transcodeProfileArray;
            for (TranscodeProfile transcodeProfile : transcodeProfileArray = transcodeProvider.getProfiles()) {
                String string2 = transcodeProfile.getDeviceClassification();
                if (string2 == null) {
                    this.log("Device classification missing for " + transcodeProfile.getName());
                    continue;
                }
                if (!string2.toLowerCase().startsWith(string.toLowerCase())) continue;
                arrayList.add(transcodeProfile);
            }
        }
        return arrayList.toArray(new TranscodeProfile[arrayList.size()]);
    }

    public TranscodeProfile getDefaultTranscodeProfile() {
        String string = this.getPersistentStringProperty(PP_REND_DEF_TRANS_PROF);
        DeviceManagerImpl deviceManagerImpl = this.getManager();
        TranscodeManagerImpl transcodeManagerImpl = deviceManagerImpl.getTranscodeManager();
        TranscodeProfile transcodeProfile = transcodeManagerImpl.getProfileFromUID(string);
        if (transcodeProfile != null) {
            return transcodeProfile;
        }
        return null;
    }

    public void setDefaultTranscodeProfile(TranscodeProfile transcodeProfile) {
        if (transcodeProfile == null) {
            this.removePersistentProperty(PP_REND_DEF_TRANS_PROF);
        } else {
            this.setPersistentStringProperty(PP_REND_DEF_TRANS_PROF, transcodeProfile.getUID());
        }
    }

    public TranscodeProfile getBlankProfile() {
        return blank_profile;
    }

    protected void setTranscoding(boolean bl) {
        this.transcoding = bl;
        this.manager.deviceChanged(this, false);
    }

    public boolean isTranscoding() {
        return this.transcoding;
    }

    public int getTranscodeRequirement() {
        return this.getPersistentIntProperty(PP_REND_TRANS_REQ, 2);
    }

    public void setTranscodeRequirement(int n) {
        this.setPersistentIntProperty(PP_REND_TRANS_REQ, n);
    }

    public boolean isAudioCompatible(TranscodeFile transcodeFile) {
        return false;
    }

    public boolean getAlwaysCacheFiles() {
        return this.getPersistentBooleanProperty(PP_REND_TRANS_CACHE, false);
    }

    public void setAlwaysCacheFiles(boolean bl) {
        this.setPersistentBooleanProperty(PP_REND_TRANS_CACHE, bl);
    }

    public boolean isRSSPublishEnabled() {
        return this.getPersistentBooleanProperty(PP_REND_RSS_PUB, true);
    }

    public void setRSSPublishEnabled(boolean bl) {
        this.setPersistentBooleanProperty(PP_REND_RSS_PUB, bl);
    }

    @Override
    public String[][] getDisplayProperties() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        this.getDisplayProperties(arrayList);
        String[][] stringArray = new String[2][arrayList.size()];
        int n = 0;
        for (String[] stringArray2 : arrayList) {
            stringArray[0][n] = stringArray2[0];
            stringArray[1][n] = stringArray2[1];
            ++n;
        }
        return stringArray;
    }

    protected void getDisplayProperties(List<String[]> list) {
        if (!this.name.equals(this.classification)) {
            this.addDP(list, "TableColumn.header.name", this.name);
        }
        this.addDP(list, "TableColumn.header.class", this.classification.toLowerCase());
        this.addDP(list, "!UID!", this.getID());
        if (!this.manual) {
            this.addDP(list, "azbuddy.ui.table.online", this.online);
            this.addDP(list, "device.lastseen", this.last_seen == 0L ? "" : new SimpleDateFormat().format(new Date(this.last_seen)));
        }
    }

    protected void getTTDisplayProperties(List<String[]> list) {
        this.addDP(list, "devices.xcode.working_dir", this.getWorkingDirectory(false).getAbsolutePath());
        this.addDP(list, "devices.xcode.prof_def", this.getDefaultTranscodeProfile());
        this.addDP(list, "devices.xcode.profs", this.getTranscodeProfiles());
        int n = this.getTranscodeRequirement();
        String string = n == 3 ? "device.xcode.always" : (n == 1 ? "device.xcode.never" : "device.xcode.whenreq");
        this.addDP(list, "device.xcode", MessageText.getString(string));
    }

    protected void addDP(List<String[]> list, String string, String string2) {
        list.add(new String[]{string, string2});
    }

    protected void addDP(List<String[]> list, String string, File file) {
        list.add(new String[]{string, file == null ? "" : file.getAbsolutePath()});
    }

    protected void addDP(List<String[]> list, String string, String[] stringArray) {
        String string2 = "";
        for (String string3 : stringArray) {
            string2 = string2 + (string2.length() == 0 ? "" : ",") + string3;
        }
        list.add(new String[]{string, string2});
    }

    protected void addDP(List<String[]> list, String string, boolean bl) {
        list.add(new String[]{string, MessageText.getString(bl ? "GeneralView.yes" : "GeneralView.no")});
    }

    protected void addDP(List<String[]> list, String string, TranscodeProfile transcodeProfile) {
        this.addDP(list, string, transcodeProfile == null ? "" : transcodeProfile.getName());
    }

    protected void addDP(List<String[]> list, String string, TranscodeProfile[] transcodeProfileArray) {
        String[] stringArray = new String[transcodeProfileArray.length];
        for (int i = 0; i < transcodeProfileArray.length; ++i) {
            stringArray[i] = transcodeProfileArray[i].getName();
        }
        this.addDP(list, string, stringArray);
    }

    @Override
    public void setCanRemove(boolean bl) {
        this.can_remove = bl;
    }

    @Override
    public boolean canRemove() {
        return this.can_remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBusy() {
        if (this.isTranscoding()) {
            return true;
        }
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            return this.busy_count > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBusy(boolean bl) {
        boolean bl2 = false;
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            bl2 = bl ? this.busy_count++ == 0 : this.busy_count-- == 1;
        }
        if (bl2) {
            this.manager.deviceChanged(this, false);
        }
    }

    @Override
    public void remove() {
        this.manager.removeDevice(this);
    }

    public String getPersistentStringProperty(String string) {
        return this.getPersistentStringProperty(string, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPersistentStringProperty(String string, String string2) {
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            try {
                byte[] byArray = (byte[])this.persistent_properties.get(string);
                if (byArray == null) {
                    return string2;
                }
                return new String(byArray, "UTF-8");
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return string2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentStringProperty(String string, String string2) {
        boolean bl = false;
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            String string3 = this.getPersistentStringProperty(string);
            if (!string3.equals(string2)) {
                try {
                    if (string2 == null) {
                        this.persistent_properties.remove(string);
                    } else {
                        this.persistent_properties.put(string, string2.getBytes("UTF-8"));
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        if (bl) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Map<String, T> getPersistentMapProperty(String string, Map<String, T> map) {
        Map<String, Object> map2 = this.persistent_properties;
        synchronized (map2) {
            try {
                Map map3 = (Map)this.persistent_properties.get(string);
                if (map3 == null) {
                    return map;
                }
                return map3;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return map;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setPersistentMapProperty(String string, Map<String, T> map) {
        boolean bl = false;
        Map<String, Object> map2 = this.persistent_properties;
        synchronized (map2) {
            Map<String, T> map3 = this.getPersistentMapProperty(string, null);
            if (!BEncoder.mapsAreIdentical(map, map3)) {
                try {
                    if (map == null) {
                        this.persistent_properties.remove(string);
                    } else {
                        this.persistent_properties.put(string, map);
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        if (bl) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePersistentProperty(String string) {
        boolean bl = false;
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            String string2 = this.getPersistentStringProperty(string);
            if (string2 != null) {
                try {
                    this.persistent_properties.remove(string);
                    bl = true;
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        }
        if (bl) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getError() {
        Map<Object, String> map = this.errors;
        synchronized (map) {
            if (this.errors.size() == 0) {
                return null;
            }
            String string = "";
            for (String string2 : this.errors.values()) {
                string = string + (string.length() == 0 ? "" : "; ") + string2;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setError(Object object, String string) {
        String string2;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            Map<Object, String> map = this.errors;
            synchronized (map) {
                bl = this.errors.remove(object) != null;
            }
        }
        Map<Object, String> map = this.errors;
        synchronized (map) {
            string2 = this.errors.put(object, string);
        }
        boolean bl2 = bl = string2 == null || !string2.equals(string);
        if (bl) {
            this.manager.deviceChanged(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInfo() {
        Map<Object, String> map = this.infos;
        synchronized (map) {
            if (this.infos.size() == 0) {
                return null;
            }
            String string = "";
            for (String string2 : this.infos.values()) {
                string = string + (string.length() == 0 ? "" : "; ") + string2;
            }
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInfo(Object object, String string) {
        String string2;
        boolean bl = false;
        if (string == null || string.length() == 0) {
            Map<Object, String> map = this.infos;
            synchronized (map) {
                bl = this.infos.remove(object) != null;
            }
        }
        Map<Object, String> map = this.infos;
        synchronized (map) {
            string2 = this.infos.put(object, string);
        }
        boolean bl2 = bl = string2 == null || !string2.equals(string);
        if (bl) {
            this.manager.deviceChanged(this, false);
        }
    }

    @Override
    public String getStatus() {
        if (this.isLivenessDetectable()) {
            if (this.isAlive()) {
                return MessageText.getString("device.status.online");
            }
            return MessageText.getString("device.od.error.notfound");
        }
        return null;
    }

    public boolean getPersistentBooleanProperty(String string, boolean bl) {
        return this.getPersistentStringProperty(string, bl ? "true" : "false").equals("true");
    }

    public void setPersistentBooleanProperty(String string, boolean bl) {
        this.setPersistentStringProperty(string, bl ? "true" : "false");
    }

    public int getPersistentIntProperty(String string, int n) {
        return Integer.parseInt(this.getPersistentStringProperty(string, String.valueOf(n)));
    }

    public void setPersistentIntProperty(String string, int n) {
        this.setPersistentStringProperty(string, String.valueOf(n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPersistentStringListProperty(String string) {
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            try {
                List list = (List)this.persistent_properties.get(string);
                if (list == null) {
                    return new String[0];
                }
                String[] stringArray = new String[list.size()];
                int n = 0;
                for (byte[] byArray : list) {
                    stringArray[n++] = new String(byArray, "UTF-8");
                }
                return stringArray;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                return new String[0];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPersistentStringListProperty(String string, String[] stringArray) {
        boolean bl = false;
        Map<String, Object> map = this.persistent_properties;
        synchronized (map) {
            try {
                ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
                for (String string2 : stringArray) {
                    arrayList.add(string2.getBytes("UTF-8"));
                }
                this.persistent_properties.put(string, arrayList);
                bl = true;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (bl) {
            this.setDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransientProperty(Object object, Object object2) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            if (object2 == null) {
                this.transient_properties.remove(object);
            } else {
                this.transient_properties.put(object, object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getTransientProperty(Object object) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            return this.transient_properties.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransientProperty(Object object, Object object2, Object object3) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            HashMap<Object, Object> hashMap = (HashMap<Object, Object>)this.transient_properties.get(object);
            if (hashMap == null) {
                if (object3 == null) {
                    return;
                }
                hashMap = new HashMap<Object, Object>();
                this.transient_properties.put(object, hashMap);
            }
            if (object3 == null) {
                hashMap.remove(object2);
                if (hashMap.size() == 0) {
                    this.transient_properties.remove(object);
                }
            } else {
                hashMap.put(object2, object3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getTransientProperty(Object object, Object object2) {
        Map<Object, Object> map = this.transient_properties;
        synchronized (map) {
            Map map2 = (Map)this.transient_properties.get(object);
            if (map2 == null) {
                return null;
            }
            return map2.get(object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_files_dirty) {
                this.saveDeviceFile();
            }
        }
    }

    protected void loadDeviceFile() throws IOException {
        this.device_files_last_mod = SystemTime.getMonotonousTime();
        if (this.device_files_ref != null) {
            this.device_files = (Map)this.device_files_ref.get();
        }
        if (this.device_files == null) {
            Map map = FileUtil.readResilientFile(this.getDeviceFile());
            this.device_files = (Map)map.get("files");
            if (this.device_files == null) {
                this.device_files = new HashMap();
            }
            this.device_files_ref = new WeakReference(this.device_files);
            this.log("Loaded device file for " + this.getName() + ": files=" + this.device_files.size());
        }
        new DelayedEvent("Device:gc", 15000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                DeviceImpl deviceImpl = DeviceImpl.this;
                synchronized (deviceImpl) {
                    if (SystemTime.getMonotonousTime() - DeviceImpl.this.device_files_last_mod >= 15000L) {
                        if (DeviceImpl.this.device_files_dirty) {
                            DeviceImpl.this.saveDeviceFile();
                        }
                        DeviceImpl.this.device_files = null;
                    } else {
                        new DelayedEvent("Device:gc2", 15000L, this);
                    }
                }
            }
        });
    }

    protected URL getStreamURL(TranscodeFileImpl transcodeFileImpl, String string) {
        return this.manager.getStreamURL(transcodeFileImpl, string);
    }

    protected String getMimeType(TranscodeFileImpl transcodeFileImpl) {
        return this.manager.getMimeType(transcodeFileImpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteFile(TranscodeFileImpl transcodeFileImpl, boolean bl, boolean bl2) throws TranscodeException {
        Object object;
        if (transcodeFileImpl.isDeleted()) {
            return;
        }
        if (bl) {
            object = transcodeFileImpl.getCacheFile();
            int n = 0;
            while (((File)object).exists() && !((File)object).delete()) {
                if (n > 3000) {
                    this.log("Failed to remove file '" + ((File)object).getAbsolutePath() + "'");
                    break;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                n += 500;
            }
        }
        if (bl2) {
            try {
                for (TranscodeTargetListener transcodeTargetListener : this.listeners) {
                    try {
                        transcodeTargetListener.fileRemoved(transcodeFileImpl);
                    }
                    catch (Throwable throwable) {
                        Debug.out(throwable);
                    }
                }
                object = this;
                synchronized (object) {
                    if (this.device_files == null) {
                        this.loadDeviceFile();
                    } else {
                        this.device_files_last_mod = SystemTime.getMonotonousTime();
                    }
                    this.device_files.remove(transcodeFileImpl.getKey());
                    this.device_files_dirty = true;
                }
            }
            catch (Throwable throwable) {
                throw new TranscodeException("Delete failed", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fileDirty(TranscodeFileImpl transcodeFileImpl, int n, Object object) {
        try {
            DeviceImpl deviceImpl = this;
            synchronized (deviceImpl) {
                if (this.device_files == null) {
                    this.loadDeviceFile();
                } else {
                    this.device_files_last_mod = SystemTime.getMonotonousTime();
                }
            }
            this.device_files_dirty = true;
        }
        catch (Throwable throwable) {
            Debug.out("Failed to load device file", throwable);
        }
        for (TranscodeTargetListener transcodeTargetListener : this.listeners) {
            try {
                transcodeTargetListener.fileChanged(transcodeFileImpl, n, object);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    protected void saveDeviceFile() {
        this.device_files_dirty = false;
        try {
            this.loadDeviceFile();
            if (this.device_files == null || this.device_files.size() == 0) {
                FileUtil.deleteResilientFile(this.getDeviceFile());
            } else {
                HashMap hashMap = new HashMap();
                hashMap.put("files", this.device_files);
                FileUtil.writeResilientFile(this.getDeviceFile(), hashMap);
            }
        }
        catch (Throwable throwable) {
            Debug.out("Failed to save device file", throwable);
        }
    }

    protected File getDeviceFile() throws IOException {
        File file = this.getDevicesDir();
        return new File(file, FileUtil.convertOSSpecificChars(this.getID(), false) + ".dat");
    }

    protected File getDevicesDir() throws IOException {
        File file = new File(SystemProperties.getUserPath());
        if (!(file = new File(file, "devices")).exists() && !file.mkdirs()) {
            throw new IOException("Failed to create '" + file + "'");
        }
        return file;
    }

    protected DeviceManagerImpl getManager() {
        return this.manager;
    }

    public void addListener(TranscodeTargetListener transcodeTargetListener) {
        if (!this.listeners.contains(transcodeTargetListener)) {
            this.listeners.add(transcodeTargetListener);
        }
    }

    public void removeListener(TranscodeTargetListener transcodeTargetListener) {
        this.listeners.remove(transcodeTargetListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireChanged() {
        List<DeviceListener> list;
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_listeners == null) {
                return;
            }
            list = this.device_listeners.getList();
        }
        for (DeviceListener deviceListener : list) {
            try {
                deviceListener.deviceChanged(this);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DeviceListener deviceListener) {
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_listeners == null) {
                this.device_listeners = new CopyOnWriteList();
            }
            this.device_listeners.add(deviceListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DeviceListener deviceListener) {
        DeviceImpl deviceImpl = this;
        synchronized (deviceImpl) {
            if (this.device_listeners != null) {
                this.device_listeners.remove(deviceListener);
                if (this.device_listeners.size() == 0) {
                    this.device_listeners = null;
                }
            }
        }
    }

    protected void log(String string) {
        this.manager.log(string);
    }

    protected void log(String string, Throwable throwable) {
        this.manager.log(string, throwable);
    }

    @Override
    public String getString() {
        return "type=" + this.type + ",uid=" + this.uid + ",class=" + this.classification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println(this.getName() + "/" + this.getID() + "/" + this.type);
        try {
            indentWriter.indent();
            indentWriter.println("hidden=" + this.hidden + ", last_seen=" + new SimpleDateFormat().format(new Date(this.last_seen)) + ", online=" + this.online + ", transcoding=" + this.transcoding);
            indentWriter.println("p_props=" + this.persistent_properties);
            indentWriter.println("t_props=" + this.transient_properties);
            indentWriter.println("errors=" + this.errors);
            indentWriter.println("infos=" + this.infos);
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    public void generateTT(IndentWriter indentWriter) {
        TranscodeFileImpl[] transcodeFileImplArray = this.getFiles();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (TranscodeFileImpl transcodeFileImpl : transcodeFileImplArray) {
            if (transcodeFileImpl.isComplete()) {
                ++n;
            }
            if (transcodeFileImpl.isCopiedToDevice()) {
                ++n2;
            }
            if (transcodeFileImpl.isDeleted()) {
                ++n3;
            }
            if (!transcodeFileImpl.isTemplate()) continue;
            ++n4;
        }
        indentWriter.println("files=" + transcodeFileImplArray.length + ", comp=" + n + ", copied=" + n2 + ", deleted=" + n3 + ", template=" + n4);
    }

    static {
        try {
            device_renames.add(Pattern.compile("TV\\s*+\\(([^\\)]*)\\)", 2));
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    protected class browseLocationImpl
    implements Device.browseLocation {
        private String name;
        private URL url;

        protected browseLocationImpl(String string, URL uRL) {
            this.name = string;
            this.url = uRL;
        }

        public String getName() {
            return this.name;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

