/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetworkPropertyChangeListener;
import com.aelitis.azureus.core.messenger.config.PlatformVuzeActivitiesMessenger;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;

public class VuzeActivitiesManager {
    public static final long MAX_LIFE_MS = 63072000000L;
    private static final long DEFAULT_PLATFORM_REFRESH = 86400000L;
    private static final String SAVE_FILENAME = "VuzeActivities.config";
    private static ArrayList<VuzeActivitiesListener> listeners = new ArrayList();
    private static ArrayList<VuzeActivitiesEntry> allEntries = new ArrayList();
    private static AEMonitor allEntries_mon = new AEMonitor("VuzeActivityMan");
    private static List<VuzeActivitiesEntry> removedEntries = new ArrayList<VuzeActivitiesEntry>();
    private static PlatformVuzeActivitiesMessenger.GetEntriesReplyListener replyListener;
    private static AEDiagnosticsLogger diag_logger;
    private static Map<String, Long> lastNewsAt;
    private static boolean skipAutoSave;
    private static AEMonitor config_mon;
    private static boolean saveEventsOnClose;

    public static void initialize(final AzureusCore azureusCore) {
        new AEThread2("lazy init", true){

            public void run() {
                VuzeActivitiesManager._initialize(azureusCore);
            }
        }.start();
    }

    private static void _initialize(AzureusCore azureusCore) {
        if (diag_logger != null) {
            diag_logger.log("Initialize Called");
        }
        azureusCore.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void stopping(AzureusCore azureusCore) {
                if (saveEventsOnClose) {
                    VuzeActivitiesManager.saveEventsNow();
                }
            }
        });
        VuzeActivitiesManager.loadEvents();
        ContentNetworkManager contentNetworkManager = ContentNetworkManagerFactory.getSingleton();
        if (contentNetworkManager != null) {
            ContentNetwork[] contentNetworkArray = contentNetworkManager.getContentNetworks();
            contentNetworkManager.addListener(new ContentNetworkListener(){

                public void networkRemoved(ContentNetwork contentNetwork) {
                }

                public void networkChanged(ContentNetwork contentNetwork) {
                }

                public void networkAdded(ContentNetwork contentNetwork) {
                    VuzeActivitiesManager.setupContentNetwork(contentNetwork);
                }

                public void networkAddFailed(long l, Throwable throwable) {
                }
            });
            for (ContentNetwork contentNetwork : contentNetworkArray) {
                VuzeActivitiesManager.setupContentNetwork(contentNetwork);
            }
        }
        replyListener = new PlatformVuzeActivitiesMessenger.GetEntriesReplyListener(){

            public void gotVuzeNewsEntries(VuzeActivitiesEntry[] vuzeActivitiesEntryArray, long l) {
                if (diag_logger != null) {
                    diag_logger.log("Received Reply from platform with " + vuzeActivitiesEntryArray.length + " entries.  Refresh in " + l);
                }
                VuzeActivitiesManager.addEntries(vuzeActivitiesEntryArray);
                if (l <= 0L) {
                    l = 86400000L;
                }
                SimpleTimer.addEvent("GetVuzeNews", SystemTime.getOffsetTime(l), new TimerEventPerformer(){

                    public void perform(TimerEvent timerEvent2) {
                        VuzeActivitiesManager.pullActivitiesNow(5000L, "timer", false);
                    }
                });
            }
        };
        VuzeActivitiesManager.pullActivitiesNow(5000L, "initial", false);
    }

    private static void setupContentNetwork(final ContentNetwork contentNetwork) {
        contentNetwork.addPersistentPropertyChangeListener(new ContentNetworkPropertyChangeListener(){

            public void propertyChanged(String string) {
                boolean bl;
                if (!"active".equals(string)) {
                    return;
                }
                Object object = contentNetwork.getPersistentProperty("active");
                boolean bl2 = bl = object instanceof Boolean ? (Boolean)object : false;
                if (bl) {
                    VuzeActivitiesManager.pullActivitiesNow(2000L, "CN:PropChange", false);
                }
            }
        });
        final String string = contentNetwork.getServiceURL(36);
        if (string != null && string.length() > 0) {
            try {
                SimpleTimer.addPeriodicEvent("act:id", 82800000L, new TimerEventPerformer(){

                    public void perform(TimerEvent timerEvent2) {
                        VuzeActivitiesManager.identify(contentNetwork, string);
                    }
                });
                VuzeActivitiesManager.identify(contentNetwork, string);
            }
            catch (Throwable throwable) {
                Debug.out(throwable);
            }
        }
    }

    private static void identify(ContentNetwork contentNetwork, String string) {
        try {
            String[] stringArray;
            URL uRL = new URL(string);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            UrlUtils.setBrowserHeaders(httpURLConnection, null);
            String string2 = "cn." + contentNetwork.getID() + ".identify.cookie";
            String string3 = COConfigurationManager.getStringParameter(string2, null);
            if (string3 != null) {
                httpURLConnection.setRequestProperty("Cookie", string3 + ";");
            }
            httpURLConnection.setRequestProperty("Connection", "close");
            httpURLConnection.getResponseCode();
            string3 = httpURLConnection.getHeaderField("Set-Cookie");
            if (string3 != null && (stringArray = string3.split(";")).length > 0 && stringArray[0].length() > 0) {
                COConfigurationManager.setParameter(string2, stringArray[0]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void pullActivitiesNow(long l, String string, boolean bl) {
        boolean bl2;
        ContentNetwork contentNetwork = ConstantsVuze.getDefaultContentNetwork();
        if (contentNetwork == null) {
            return;
        }
        Object object = contentNetwork.getPersistentProperty("active");
        boolean bl3 = bl2 = object instanceof Boolean ? (Boolean)object : false;
        if (!bl2) {
            return;
        }
        String string2 = "" + contentNetwork.getID();
        Long l2 = lastNewsAt.get(string2);
        long l3 = l2 != null ? l2 : 0L;
        long l4 = SystemTime.getCurrentTime();
        long l5 = l4 - l3;
        if (!bl && l5 < 5000L) {
            return;
        }
        if (l5 > 63072000000L) {
            l5 = 63072000000L;
        }
        PlatformVuzeActivitiesMessenger.getEntries(contentNetwork.getID(), l5, l, string, replyListener);
    }

    public static void clearLastPullTimes() {
        lastNewsAt = new HashMap<String, Long>();
    }

    public static void resetRemovedEntries() {
        removedEntries.clear();
        VuzeActivitiesManager.saveEvents();
    }

    private static void saveEvents() {
        saveEventsOnClose = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEvents() {
        skipAutoSave = true;
        try {
            Object object;
            Object object22;
            List list;
            long l;
            Map map = FileUtil.readResilientConfigFile(SAVE_FILENAME);
            if (map != null && map.size() > 0 && MapUtils.getMapLong(map, "version", 0L) < 2L) {
                VuzeActivitiesManager.clearLastPullTimes();
                skipAutoSave = false;
                VuzeActivitiesManager.saveEventsNow();
                return;
            }
            long l2 = VuzeActivitiesManager.getCutoffTime();
            try {
                lastNewsAt = MapUtils.getMapMap(map, "LastChecks", new HashMap());
            }
            catch (Exception exception) {
                Debug.out(exception);
            }
            if (lastNewsAt.size() == 0 && (l = MapUtils.getMapLong(map, "LastCheck", 0L)) > 0L) {
                if (l < l2) {
                    l = l2;
                }
                lastNewsAt.put("1", new Long(l));
            }
            if ((list = (List)MapUtils.getMapObject(map, "removed-entries", null, List.class)) != null) {
                for (Object object22 : list) {
                    if (!(object22 instanceof Map) || (object = VuzeActivitiesManager.createEntryFromMap((Map)object22, true)) == null || ((VuzeActivitiesEntry)object).getTimestamp() <= l2) continue;
                    removedEntries.add((VuzeActivitiesEntry)object);
                }
            }
            if (!((object22 = map.get("entries")) instanceof List)) {
                return;
            }
            List list2 = (List)object22;
            object = new ArrayList(list2.size());
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                VuzeActivitiesEntry vuzeActivitiesEntry;
                object22 = iterator.next();
                if (!(object22 instanceof Map) || (vuzeActivitiesEntry = VuzeActivitiesManager.createEntryFromMap((Map)object22, true)) == null || vuzeActivitiesEntry.getTimestamp() <= l2) continue;
                object.add(vuzeActivitiesEntry);
            }
            int n = object.size();
            if (n > 0) {
                VuzeActivitiesManager.addEntries(object.toArray(new VuzeActivitiesEntry[n]));
            }
        }
        finally {
            skipAutoSave = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveEventsNow() {
        if (skipAutoSave) {
            return;
        }
        try {
            config_mon.enter();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("LastChecks", lastNewsAt);
            hashMap.put("version", new Long(2L));
            ArrayList<Map> arrayList = new ArrayList<Map>();
            VuzeActivitiesEntry[] vuzeActivitiesEntryArray = VuzeActivitiesManager.getAllEntries();
            for (int i = 0; i < vuzeActivitiesEntryArray.length; ++i) {
                boolean bl;
                VuzeActivitiesEntry vuzeActivitiesEntry = vuzeActivitiesEntryArray[i];
                if (vuzeActivitiesEntry == null || (bl = "Header".equals(vuzeActivitiesEntry.getTypeID()))) continue;
                arrayList.add(vuzeActivitiesEntry.toMap());
            }
            hashMap.put("entries", arrayList);
            ArrayList<Map> arrayList2 = new ArrayList<Map>();
            for (VuzeActivitiesEntry vuzeActivitiesEntry : removedEntries) {
                arrayList2.add(vuzeActivitiesEntry.toDeletedMap());
            }
            hashMap.put("removed-entries", arrayList2);
            FileUtil.writeResilientConfigFile(SAVE_FILENAME, hashMap);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
        finally {
            config_mon.exit();
        }
    }

    public static long getCutoffTime() {
        return SystemTime.getOffsetTime(-63072000000L);
    }

    public static void addListener(VuzeActivitiesListener vuzeActivitiesListener) {
        listeners.add(vuzeActivitiesListener);
    }

    public static void removeListener(VuzeActivitiesListener vuzeActivitiesListener) {
        listeners.remove(vuzeActivitiesListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static VuzeActivitiesEntry[] addEntries(VuzeActivitiesEntry[] vuzeActivitiesEntryArray) {
        Object object;
        long l = VuzeActivitiesManager.getCutoffTime();
        ArrayList<Object> arrayList = new ArrayList<Object>(vuzeActivitiesEntryArray.length);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(0);
        try {
            allEntries_mon.enter();
            for (int i = 0; i < vuzeActivitiesEntryArray.length; ++i) {
                object = vuzeActivitiesEntryArray[i];
                boolean n = "Header".equals(((VuzeActivitiesEntry)object).getTypeID());
                if (((VuzeActivitiesEntry)object).getTimestamp() < l && !n || removedEntries.contains(object)) continue;
                if (allEntries.contains(object)) {
                    arrayList2.add(object);
                    continue;
                }
                arrayList.add(object);
                allEntries.add((VuzeActivitiesEntry)object);
            }
        }
        finally {
            allEntries_mon.exit();
        }
        VuzeActivitiesEntry[] vuzeActivitiesEntryArray2 = arrayList.toArray(new VuzeActivitiesEntry[arrayList.size()]);
        if (vuzeActivitiesEntryArray2.length > 0) {
            void var7_9;
            VuzeActivitiesManager.saveEventsNow();
            object = listeners.toArray();
            boolean vuzeActivitiesEntry = false;
            while (var7_9 < ((Object[])object).length) {
                VuzeActivitiesListener vuzeActivitiesListener = (VuzeActivitiesListener)object[var7_9];
                vuzeActivitiesListener.vuzeNewsEntriesAdded(vuzeActivitiesEntryArray2);
                ++var7_9;
            }
        }
        if (arrayList2.size() > 0) {
            if (vuzeActivitiesEntryArray2.length == 0) {
                VuzeActivitiesManager.saveEvents();
            }
            for (VuzeActivitiesEntry vuzeActivitiesEntry : arrayList2) {
                VuzeActivitiesManager.triggerEntryChanged(vuzeActivitiesEntry);
            }
        }
        return vuzeActivitiesEntryArray2;
    }

    public static void removeEntries(VuzeActivitiesEntry[] vuzeActivitiesEntryArray) {
        VuzeActivitiesManager.removeEntries(vuzeActivitiesEntryArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntries(VuzeActivitiesEntry[] vuzeActivitiesEntryArray, boolean bl) {
        long l = VuzeActivitiesManager.getCutoffTime();
        try {
            allEntries_mon.enter();
            for (int i = 0; i < vuzeActivitiesEntryArray.length; ++i) {
                VuzeActivitiesEntry vuzeActivitiesEntry = vuzeActivitiesEntryArray[i];
                if (vuzeActivitiesEntry == null) continue;
                allEntries.remove(vuzeActivitiesEntry);
                boolean bl2 = "Header".equals(vuzeActivitiesEntry.getTypeID());
                if (bl || vuzeActivitiesEntry.getTimestamp() <= l || bl2) continue;
                removedEntries.add(vuzeActivitiesEntry);
            }
        }
        finally {
            allEntries_mon.exit();
        }
        Object[] objectArray = listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            VuzeActivitiesListener vuzeActivitiesListener = (VuzeActivitiesListener)objectArray[i];
            vuzeActivitiesListener.vuzeNewsEntriesRemoved(vuzeActivitiesEntryArray);
        }
        VuzeActivitiesManager.saveEventsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VuzeActivitiesEntry getEntryByID(String string) {
        try {
            allEntries_mon.enter();
            for (VuzeActivitiesEntry vuzeActivitiesEntry : allEntries) {
                if (vuzeActivitiesEntry == null) continue;
                String string2 = vuzeActivitiesEntry.getID();
                if (string2 == null || !string2.equals(string)) continue;
                VuzeActivitiesEntry vuzeActivitiesEntry2 = vuzeActivitiesEntry;
                return vuzeActivitiesEntry2;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        return null;
    }

    public static VuzeActivitiesEntry[] getAllEntries() {
        return allEntries.toArray(new VuzeActivitiesEntry[allEntries.size()]);
    }

    public static int getNumEntries() {
        return allEntries.size();
    }

    public static void log(String string) {
        if (diag_logger != null) {
            diag_logger.log(string);
        }
    }

    public static void triggerEntryChanged(VuzeActivitiesEntry vuzeActivitiesEntry) {
        Object[] objectArray = listeners.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            VuzeActivitiesListener vuzeActivitiesListener = (VuzeActivitiesListener)objectArray[i];
            vuzeActivitiesListener.vuzeNewsEntryChanged(vuzeActivitiesEntry);
        }
        VuzeActivitiesManager.saveEvents();
    }

    public static VuzeActivitiesEntry createEntryFromMap(Map map, boolean bl) {
        return VuzeActivitiesManager.createEntryFromMap(1L, map, bl);
    }

    public static VuzeActivitiesEntry createEntryFromMap(long l, Map map, boolean bl) {
        String string = MapUtils.getMapString(map, "typeID", MapUtils.getMapString(map, "type-id", null));
        VuzeActivitiesEntry vuzeActivitiesEntry = new VuzeActivitiesEntry();
        vuzeActivitiesEntry.setContentNetworkID(l);
        if (bl) {
            vuzeActivitiesEntry.loadFromInternalMap(map);
        } else {
            vuzeActivitiesEntry.loadFromExternalMap(map);
        }
        return vuzeActivitiesEntry;
    }

    static {
        lastNewsAt = new HashMap<String, Long>();
        skipAutoSave = true;
        config_mon = new AEMonitor("ConfigMon");
        saveEventsOnClose = false;
        if (System.getProperty("debug.vuzenews", "0").equals("1")) {
            diag_logger = AEDiagnostics.getLogger("v3.vuzenews");
            diag_logger.log("\n\nVuze News Logging Starts");
        } else {
            diag_logger = null;
        }
    }
}

