/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTipManager {
    boolean isShowingKeyTips = false;
    List<KeyTipChain> keyTipChains = new ArrayList<KeyTipChain>();
    protected EventListenerList listenerList = new EventListenerList();
    protected BlockingQueue<Character> processingQueue = new LinkedBlockingQueue<Character>();
    protected ProcessingThread processingThread = new ProcessingThread();
    private Component focusOwner;
    private static final KeyTipManager instance = new KeyTipManager();

    public static KeyTipManager defaultManager() {
        return instance;
    }

    private KeyTipManager() {
        this.processingThread.start();
    }

    public boolean isShowingKeyTips() {
        return !this.keyTipChains.isEmpty();
    }

    public void hideAllKeyTips() {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        this.keyTipChains.clear();
        this.repaintWindows();
        this.tryRestoringFocusOwner();
    }

    private void tryRestoringFocusOwner() {
        if (this.focusOwner != null && this.focusOwner.isDisplayable() && this.focusOwner.isShowing()) {
            this.focusOwner.requestFocus();
        }
    }

    public Collection<KeyTipLink> getCurrentlyShownKeyTips() {
        if (this.keyTipChains.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.keyTipChains.get(this.keyTipChains.size() - 1).links);
    }

    public KeyTipChain getCurrentlyShownKeyTipChain() {
        if (this.keyTipChains.isEmpty()) {
            return null;
        }
        return this.keyTipChains.get(this.keyTipChains.size() - 1);
    }

    public void showPreviousChain() {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        this.keyTipChains.remove(this.keyTipChains.size() - 1);
        if (!this.isShowingKeyTips()) {
            this.tryRestoringFocusOwner();
        }
        this.repaintWindows();
    }

    private void addCommandButtonLinks(Component component, KeyTipChain keyTipChain) {
        JCommandButton jCommandButton;
        KeyTipLink keyTipLink;
        AbstractCommandButton abstractCommandButton = (AbstractCommandButton)component;
        KeyTipLink keyTipLink2 = this.getCommandButtonActionLink(abstractCommandButton);
        if (keyTipLink2 != null) {
            keyTipChain.addLink(keyTipLink2);
        }
        if (component instanceof JCommandButton && (keyTipLink = this.getCommandButtonPopupLink(jCommandButton = (JCommandButton)component)) != null) {
            keyTipChain.addLink(keyTipLink);
        }
    }

    private void populateChain(final Component component, final KeyTipChain keyTipChain) {
        Serializable serializable;
        if (component instanceof AbstractCommandButton) {
            serializable = component.getBounds();
            if (component.isVisible() && component.isShowing()) {
                if (((Rectangle)serializable).height > 0 && ((Rectangle)serializable).width > 0) {
                    this.addCommandButtonLinks(component, keyTipChain);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            Rectangle rectangle = component.getBounds();
                            if (rectangle.height > 0 && rectangle.width > 0) {
                                KeyTipManager.this.addCommandButtonLinks(component, keyTipChain);
                            }
                        }
                    });
                }
            }
        }
        if (component instanceof Container) {
            serializable = (Container)component;
            for (int i = 0; i < ((Container)serializable).getComponentCount(); ++i) {
                this.populateChain(((Container)serializable).getComponent(i), keyTipChain);
            }
        }
    }

    private KeyTipLink getCommandButtonActionLink(final AbstractCommandButton abstractCommandButton) {
        if (abstractCommandButton.getActionKeyTip() != null) {
            final KeyTipLink keyTipLink = new KeyTipLink();
            keyTipLink.comp = abstractCommandButton;
            keyTipLink.keyTipString = abstractCommandButton.getActionKeyTip();
            keyTipLink.prefAnchorPoint = abstractCommandButton.getUI().getKeyTipAnchorCenterPoint();
            keyTipLink.onActivated = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    abstractCommandButton.doActionClick();
                }
            };
            keyTipLink.enabled = abstractCommandButton.getActionModel().isEnabled();
            keyTipLink.traversal = abstractCommandButton.getClass().isAnnotationPresent(HasNextKeyTipChain.class) ? new KeyTipLinkTraversal(){

                public KeyTipChain getNextChain() {
                    List<PopupPanelManager.PopupInfo> list = PopupPanelManager.defaultManager().getShownPath();
                    if (list.size() > 0) {
                        PopupPanelManager.PopupInfo popupInfo = list.get(list.size() - 1);
                        JPopupPanel jPopupPanel = popupInfo.getPopupPanel();
                        KeyTipChain keyTipChain = new KeyTipChain(jPopupPanel);
                        KeyTipManager.this.populateChain(popupInfo.getPopupPanel(), keyTipChain);
                        keyTipChain.parent = keyTipLink.traversal;
                        return keyTipChain;
                    }
                    return null;
                }
            } : null;
            return keyTipLink;
        }
        return null;
    }

    private KeyTipLink getCommandButtonPopupLink(final JCommandButton jCommandButton) {
        if (jCommandButton.getPopupKeyTip() != null) {
            final KeyTipLink keyTipLink = new KeyTipLink();
            keyTipLink.comp = jCommandButton;
            keyTipLink.keyTipString = jCommandButton.getPopupKeyTip();
            keyTipLink.prefAnchorPoint = jCommandButton.getUI().getKeyTipAnchorCenterPoint();
            keyTipLink.onActivated = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (jCommandButton instanceof JCommandMenuButton) {
                        ((JCommandMenuButton)jCommandButton).doActionRollover();
                    }
                    jCommandButton.doPopupClick();
                }
            };
            keyTipLink.enabled = jCommandButton.getPopupModel().isEnabled();
            keyTipLink.traversal = new KeyTipLinkTraversal(){

                public KeyTipChain getNextChain() {
                    List<PopupPanelManager.PopupInfo> list = PopupPanelManager.defaultManager().getShownPath();
                    if (list.size() > 0) {
                        PopupPanelManager.PopupInfo popupInfo = list.get(list.size() - 1);
                        JPopupPanel jPopupPanel = popupInfo.getPopupPanel();
                        KeyTipChain keyTipChain = new KeyTipChain(jPopupPanel);
                        KeyTipManager.this.populateChain(popupInfo.getPopupPanel(), keyTipChain);
                        keyTipChain.parent = keyTipLink.traversal;
                        return keyTipChain;
                    }
                    return null;
                }
            };
            return keyTipLink;
        }
        return null;
    }

    public void handleKeyPress(char c) {
        this.processingQueue.add(Character.valueOf(c));
    }

    private void processNextKeyPress(char c) {
        if (this.keyTipChains.isEmpty()) {
            return;
        }
        KeyTipChain keyTipChain = this.keyTipChains.get(this.keyTipChains.size() - 1);
        for (Object object : keyTipChain.links) {
            Object object2 = ((KeyTipLink)object).keyTipString;
            if (Character.toLowerCase(((String)object2).charAt(keyTipChain.keyTipLookupIndex)) != Character.toLowerCase(c) || ((String)object2).length() != keyTipChain.keyTipLookupIndex + 1) continue;
            if (((KeyTipLink)object).enabled) {
                ((KeyTipLink)object).onActivated.actionPerformed(new ActionEvent(((KeyTipLink)object).comp, 1001, "keyTipActivated"));
                if (((KeyTipLink)object).traversal != null) {
                    SwingUtilities.invokeLater(new Runnable((KeyTipLink)object){
                        final /* synthetic */ KeyTipLink val$link;
                        {
                            this.val$link = keyTipLink;
                        }

                        public void run() {
                            KeyTipChain keyTipChain = this.val$link.traversal.getNextChain();
                            if (keyTipChain != null) {
                                KeyTipChain keyTipChain2 = KeyTipManager.this.keyTipChains.isEmpty() ? null : KeyTipManager.this.keyTipChains.get(KeyTipManager.this.keyTipChains.size() - 1);
                                KeyTipManager.this.keyTipChains.add(keyTipChain);
                                KeyTipManager.this.repaintWindows();
                                if (keyTipChain2 != null) {
                                    for (KeyTipLink keyTipLink : keyTipChain2.links) {
                                        if (!(keyTipLink.comp instanceof JCommandMenuButton)) continue;
                                        keyTipLink.comp.repaint();
                                    }
                                }
                            }
                        }
                    });
                } else {
                    this.hideAllKeyTips();
                }
            }
            return;
        }
        if (keyTipChain.keyTipLookupIndex == 0) {
            KeyTipChain keyTipChain2 = new KeyTipChain(keyTipChain.chainParentComponent);
            keyTipChain2.keyTipLookupIndex = 1;
            for (Object object2 : keyTipChain.links) {
                String string = ((KeyTipLink)object2).keyTipString;
                if (Character.toLowerCase(string.charAt(keyTipChain.keyTipLookupIndex)) != Character.toLowerCase(c) || string.length() != 2) continue;
                KeyTipLink keyTipLink = new KeyTipLink();
                keyTipLink.comp = ((KeyTipLink)object2).comp;
                keyTipLink.enabled = ((KeyTipLink)object2).enabled;
                keyTipLink.keyTipString = ((KeyTipLink)object2).keyTipString;
                keyTipLink.onActivated = ((KeyTipLink)object2).onActivated;
                keyTipLink.prefAnchorPoint = ((KeyTipLink)object2).prefAnchorPoint;
                keyTipLink.traversal = ((KeyTipLink)object2).traversal;
                keyTipChain2.addLink(keyTipLink);
            }
            if (keyTipChain2.links.size() > 0) {
                this.keyTipChains.add(keyTipChain2);
            }
            this.repaintWindows();
            return;
        }
    }

    private void repaintWindows() {
        for (Window container : Window.getWindows()) {
            container.repaint();
        }
        List<PopupPanelManager.PopupInfo> list = PopupPanelManager.defaultManager().getShownPath();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PopupPanelManager.PopupInfo popupInfo = (PopupPanelManager.PopupInfo)iterator.next();
            JPopupPanel jPopupPanel = popupInfo.getPopupPanel();
            jPopupPanel.paintImmediately(new Rectangle(0, 0, jPopupPanel.getWidth(), jPopupPanel.getHeight()));
        }
    }

    public void addKeyTipListener(KeyTipListener keyTipListener) {
        this.listenerList.add(KeyTipListener.class, keyTipListener);
    }

    public void removeKeyTipListener(KeyTipListener keyTipListener) {
        this.listenerList.remove(KeyTipListener.class, keyTipListener);
    }

    public void refreshCurrentChain() {
        KeyTipChain keyTipChain = this.keyTipChains.get(this.keyTipChains.size() - 1);
        if (keyTipChain.parent == null) {
            return;
        }
        KeyTipChain keyTipChain2 = keyTipChain.parent.getNextChain();
        this.keyTipChains.remove(this.keyTipChains.size() - 1);
        this.keyTipChains.add(keyTipChain2);
        this.repaintWindows();
    }

    private class ProcessingThread
    extends Thread {
        public ProcessingThread() {
            this.setName("KeyTipManager processing thread");
            this.setDaemon(true);
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        final char c = KeyTipManager.this.processingQueue.take().charValue();
                        SwingUtilities.invokeAndWait(new Runnable(){

                            public void run() {
                                KeyTipManager.this.processNextKeyPress(c);
                            }
                        });
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    public class KeyTipChain {
        private List<KeyTipLink> links;
        public int keyTipLookupIndex;
        public JComponent chainParentComponent;
        private KeyTipLinkTraversal parent;

        public KeyTipChain(JComponent jComponent) {
            this.chainParentComponent = jComponent;
            this.links = new ArrayList<KeyTipLink>();
            this.keyTipLookupIndex = 0;
        }

        public void addLink(KeyTipLink keyTipLink) {
            this.links.add(keyTipLink);
        }
    }

    public class KeyTipLink {
        public String keyTipString;
        public JComponent comp;
        public Point prefAnchorPoint;
        public ActionListener onActivated;
        public KeyTipLinkTraversal traversal;
        public boolean enabled;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface HasNextKeyTipChain {
    }

    public static class KeyTipEvent
    extends AWTEvent {
        public KeyTipEvent(Object object, int n) {
            super(object, n);
        }
    }

    public static interface KeyTipListener
    extends EventListener {
        public void keyTipsShown(KeyTipEvent var1);

        public void keyTipsHidden(KeyTipEvent var1);
    }

    public static interface KeyTipLinkTraversal {
        public KeyTipChain getNextChain();
    }
}

