/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.bcb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarCallBack;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarExceptionHandler;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbBarModel;
import org.pushingpixels.flamingo.api.bcb.BreadcrumbItem;
import org.pushingpixels.flamingo.internal.ui.bcb.BasicBreadcrumbBarUI;
import org.pushingpixels.flamingo.internal.ui.bcb.BreadcrumbBarUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBreadcrumbBar<T>
extends JComponent {
    private static final long serialVersionUID = 3258407339731400502L;
    protected BreadcrumbBarModel<T> model = new BreadcrumbBarModel();
    protected BreadcrumbBarCallBack<T> callback;
    protected List<BreadcrumbBarExceptionHandler> exceptionHandlers;
    public static final String uiClassID = "BreadcrumbBarUI";

    public JBreadcrumbBar(BreadcrumbBarCallBack<T> breadcrumbBarCallBack) {
        this.callback = breadcrumbBarCallBack;
        if (this.callback != null) {
            this.callback.setup();
        }
        this.exceptionHandlers = new ArrayList<BreadcrumbBarExceptionHandler>();
        this.updateUI();
    }

    public void setPath(List<BreadcrumbItem<T>> list) {
        this.getModel().replace(list);
    }

    public BreadcrumbBarCallBack<T> getCallback() {
        return this.callback;
    }

    public void setUI(BreadcrumbBarUI breadcrumbBarUI) {
        super.setUI(breadcrumbBarUI);
    }

    @Override
    public void updateUI() {
        if (UIManager.get(this.getUIClassID()) != null) {
            this.setUI((BreadcrumbBarUI)UIManager.getUI(this));
        } else {
            this.setUI(new BasicBreadcrumbBarUI());
        }
    }

    @Override
    public BreadcrumbBarUI getUI() {
        return (BreadcrumbBarUI)this.ui;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void addExceptionHandler(BreadcrumbBarExceptionHandler breadcrumbBarExceptionHandler) {
        this.exceptionHandlers.add(breadcrumbBarExceptionHandler);
    }

    public void removeExceptionHandler(BreadcrumbBarExceptionHandler breadcrumbBarExceptionHandler) {
        this.exceptionHandlers.remove(breadcrumbBarExceptionHandler);
    }

    public List<BreadcrumbBarExceptionHandler> getExceptionHandlers() {
        return Collections.unmodifiableList(this.exceptionHandlers);
    }

    public void setThrowsExceptions(boolean bl) {
        if (this.callback != null) {
            this.callback.setThrowsExceptions(bl);
        }
    }

    public BreadcrumbBarModel<T> getModel() {
        return this.model;
    }

    public static interface BreadcrumbBarElement {
        public String getText();

        public int getIndex();
    }
}

