/*
 * Decompiled with CFR 0.152.
 */
package irc.style;

import irc.IRCConfiguration;
import irc.SmileyTable;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.util.Vector;

public class CharactersDrawer {
    private IRCConfiguration _ircConfiguration;
    private char[] _current;
    private int _lineSpacing;

    public CharactersDrawer(IRCConfiguration iRCConfiguration) {
        this._ircConfiguration = iRCConfiguration;
        this._current = new char[256];
        this._lineSpacing = iRCConfiguration.getI("style:linespacing");
    }

    private int getBitmapSmileyWidth(int n, ImageObserver imageObserver) {
        Image image = this._ircConfiguration.getSmileyTable().getImage(n);
        if (image == null) {
            return 0;
        }
        return image.getWidth(imageObserver);
    }

    private int getBitmapSmileyHeight(int n, ImageObserver imageObserver) {
        Image image = this._ircConfiguration.getSmileyTable().getImage(n);
        if (image == null) {
            return 0;
        }
        return image.getHeight(imageObserver);
    }

    private Object drawBitmapSmiley(Graphics graphics, FontMetrics fontMetrics, int n, int n2, int n3, ImageObserver imageObserver) {
        Image image = this._ircConfiguration.getSmileyTable().getImage(n);
        if (image == null) {
            return null;
        }
        int n4 = this.getBitmapSmileyHeight(n, imageObserver);
        n3 -= n4;
        graphics.drawImage(image, n2, n3 += fontMetrics.getDescent(), imageObserver);
        return image;
    }

    private String handleSmiley(String string, String string2, char c) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return string;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + string2.length());
        char c2 = (char)(c + 57344);
        string = string3 + c2 + string4;
        return this.handleSmiley(string, string2, c);
    }

    public String decodeLine(String string) {
        SmileyTable smileyTable = this._ircConfiguration.getSmileyTable();
        int n = smileyTable.getSize();
        for (int i = 0; i < n; ++i) {
            String string2 = smileyTable.getMatch(i);
            string = this.handleSmiley(string, string2, (char)i);
        }
        return string;
    }

    public int getWidth(String string, FontMetrics fontMetrics, ImageObserver imageObserver) {
        if (this._current.length < string.length()) {
            this._current = new char[string.length() * 2];
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\ue000' && c <= '\uf8ff') {
                c = (char)(c - 57344);
                n2 += fontMetrics.charsWidth(this._current, 0, n);
                n = 0;
                n2 += this.getBitmapSmileyWidth(c, imageObserver);
                continue;
            }
            this._current[n++] = c;
        }
        return n2 += fontMetrics.charsWidth(this._current, 0, n);
    }

    public int getHeight(String string, FontMetrics fontMetrics, ImageObserver imageObserver) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\ue000' || c > '\uf8ff' || (n = this.getBitmapSmileyHeight(c = (char)(c - 57344), imageObserver)) <= n2) continue;
            n2 = n;
        }
        n = fontMetrics.getFont().getSize() + 1;
        if (n > n2) {
            n2 = n;
        }
        return n2 + this._lineSpacing;
    }

    public void getWidthHeight(String string, FontMetrics fontMetrics, Dimension dimension, ImageObserver imageObserver) {
        if (this._current.length < string.length()) {
            this._current = new char[string.length() * 2];
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\ue000' && c <= '\uf8ff') {
                c = (char)(c - 57344);
                n3 += fontMetrics.charsWidth(this._current, 0, n);
                n2 = this.getBitmapSmileyHeight(c, imageObserver);
                if (n2 > n4) {
                    n4 = n2;
                }
                n3 += this.getBitmapSmileyWidth(c, imageObserver);
                n = 0;
                continue;
            }
            this._current[n++] = c;
        }
        n3 += fontMetrics.charsWidth(this._current, 0, n);
        n2 = fontMetrics.getFont().getSize() + 1;
        if (n2 > n4) {
            n4 = n2;
        }
        dimension.width = n3;
        dimension.height = n4 + this._lineSpacing;
    }

    public void draw(String string, Graphics graphics, FontMetrics fontMetrics, int n, int n2, ImageObserver imageObserver, Vector vector) {
        if (this._current.length < string.length()) {
            this._current = new char[string.length() * 2];
        }
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '\ue000' && c <= '\uf8ff') {
                c = (char)(c - 57344);
                graphics.drawChars(this._current, 0, n3, n, n2);
                n3 = 0;
                Object object = this.drawBitmapSmiley(graphics, fontMetrics, c, n += fontMetrics.charsWidth(this._current, 0, n3), n2, imageObserver);
                if (vector == null) {
                    vector = new Vector<Object>();
                }
                vector.insertElementAt(object, vector.size());
                n += this.getBitmapSmileyWidth(c, imageObserver);
                continue;
            }
            this._current[n3++] = c;
        }
        graphics.drawChars(this._current, 0, n3, n, n2);
    }
}

