/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.IRCConfiguration;
import irc.RuleList;
import irc.TextProvider;
import irc.gui.pixx.MouseEventConfiguration;
import irc.gui.pixx.NullItem;
import irc.gui.pixx.PixxColorModel;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class PixxConfiguration {
    private IRCConfiguration _config;
    private PixxColorModel _colorModel = new PixxColorModel();
    private TextProvider _textProvider;
    private RuleList _dockingRules;
    private Hashtable _htable;
    private Hashtable _mouseConfig;
    private Vector _highLightWords;
    private Vector _nickMenuVector;
    private NullItem NULL_ITEM = new NullItem();

    public PixxConfiguration(IRCConfiguration iRCConfiguration) {
        this._config = iRCConfiguration;
        this._htable = new Hashtable();
        this._mouseConfig = new Hashtable();
        this._dockingRules = new RuleList();
        this._dockingRules.setDefaultValue(new Boolean(false));
        this._highLightWords = new Vector();
        this._nickMenuVector = new Vector();
    }

    public synchronized Vector getNickMenuVector() {
        return this._nickMenuVector;
    }

    public void setTextProvider(TextProvider textProvider) {
        this._textProvider = textProvider;
    }

    public synchronized void setMouseConfiguration(String string, int n, int n2) {
        int n3;
        switch (n) {
            case 1: {
                n3 = 16;
                break;
            }
            case 2: {
                n3 = 8;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            default: {
                n3 = 16;
            }
        }
        this._mouseConfig.put(string.toLowerCase(Locale.ENGLISH), new MouseEventConfiguration(n3, n2));
    }

    public synchronized boolean matchMouseConfiguration(String string, MouseEvent mouseEvent) {
        if (this.getB("ignoreallmouseevents")) {
            return false;
        }
        MouseEventConfiguration mouseEventConfiguration = (MouseEventConfiguration)this._mouseConfig.get(string.toLowerCase(Locale.ENGLISH));
        if (mouseEventConfiguration == null) {
            throw new Error(string + " : unknown mouse event name");
        }
        if (mouseEventConfiguration.ClickCount != mouseEvent.getClickCount()) {
            return false;
        }
        return (mouseEvent.getModifiers() & mouseEventConfiguration.Mask) != 0;
    }

    public synchronized void set(String string, Object object) {
        if (object == null) {
            object = this.NULL_ITEM;
        }
        this._htable.put(string.toLowerCase(Locale.ENGLISH), object);
    }

    public synchronized void set(String string, int n) {
        this.set(string, new Integer(n));
    }

    public synchronized void set(String string, boolean bl) {
        this.set(string, new Boolean(bl));
    }

    public synchronized Object get(String string) {
        Object v = this._htable.get(string.toLowerCase(Locale.ENGLISH));
        if (v == null) {
            throw new RuntimeException("Unknown configuration property " + string);
        }
        if (v == this.NULL_ITEM) {
            v = null;
        }
        return v;
    }

    public synchronized int getI(String string) {
        Integer n = (Integer)this.get(string);
        return n;
    }

    public synchronized boolean getB(String string) {
        Boolean bl = (Boolean)this.get(string);
        return bl;
    }

    public synchronized String getS(String string) {
        return (String)this.get(string);
    }

    public synchronized void setHighLightConfig(int n, boolean bl, Vector vector) {
        this.set("highlightcolor", n);
        this.set("highlightnick", bl);
        this._highLightWords = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this._highLightWords.insertElementAt(vector.elementAt(i), this._highLightWords.size());
        }
    }

    public synchronized boolean highLightNick() {
        return this.getB("highlightnick") && this.getB("highlight");
    }

    public synchronized Enumeration getHighLightWords() {
        if (!this.getB("highlight")) {
            return new Vector().elements();
        }
        return this._highLightWords.elements();
    }

    public synchronized void addHighLightWord(String string) {
        this._highLightWords.insertElementAt(string, this._highLightWords.size());
    }

    public synchronized void removeHighLightWord(String string) {
        for (int i = 0; i < this._highLightWords.size(); ++i) {
            if (!((String)this._highLightWords.elementAt(i)).equals(string)) continue;
            this._highLightWords.removeElementAt(i);
            --i;
        }
    }

    public void setColorModel(PixxColorModel pixxColorModel) {
        this._colorModel = pixxColorModel;
    }

    public IRCConfiguration getIRCConfiguration() {
        return this._config;
    }

    public PixxColorModel getColorModel() {
        return this._colorModel;
    }

    public Color getColor(int n) {
        return this._colorModel.getColor(n);
    }

    public synchronized void setDockingPolicy(String string, String string2, boolean bl) {
        this._dockingRules.addRule(new String[]{string, string2}, new Boolean(bl));
    }

    public synchronized boolean getDockingPolicy(String string, String string2) {
        return (Boolean)this._dockingRules.findValue(new String[]{string, string2});
    }

    public synchronized String getText(int n) {
        if (n < 32768) {
            return this._config.getText(n);
        }
        return this._textProvider.getString(n);
    }

    public synchronized String getText(int n, String string) {
        if (n < 32768) {
            return this._config.getText(n, string);
        }
        return this._textProvider.getString(n, string);
    }

    public synchronized String getText(int n, String string, String string2) {
        if (n < 32768) {
            return this._config.getText(n, string, string2);
        }
        return this._textProvider.getString(n, string, string2);
    }

    public synchronized String getText(int n, String string, String string2, String string3) {
        if (n < 32768) {
            return this._config.getText(n, string, string2, string3);
        }
        return this._textProvider.getString(n, string, string2, string3);
    }
}

