/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Provider;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.licenses.LicenseType;
import com.limegroup.gnutella.metadata.MetaDataFactory;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.metadata.MetaDataWriter;
import com.limegroup.gnutella.metadata.MetaReader;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.SerialXml;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.IdentityHashSet;
import org.limewire.collection.NameValue;
import org.limewire.collection.StringTrie;
import org.limewire.io.IOUtils;
import org.limewire.util.ConverterObjectInputStream;
import org.limewire.util.GenericsUtils;
import org.limewire.util.I18NConvert;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimeXMLReplyCollection {
    private static final Log LOG = LogFactory.getLog(LimeXMLReplyCollection.class);
    private final String schemaURI;
    private final Map<URN, LimeXMLDocument> mainMap;
    private final Map<URN, LimeXMLDocument> oldMap;
    private final Map<String, StringTrie<List<LimeXMLDocument>>> trieMap;
    private boolean dirty = false;
    private final Provider<FileManager> fileManager;
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;
    private final MetaDataFactory metaDataFactory;
    private final MetaDataReader metaDataReader;
    private final File savedDocsDir;

    LimeXMLReplyCollection(String string, File file, Provider<FileManager> provider, LimeXMLDocumentFactory limeXMLDocumentFactory, MetaDataReader metaDataReader, MetaDataFactory metaDataFactory) {
        this.schemaURI = string;
        this.fileManager = provider;
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
        this.metaDataReader = metaDataReader;
        this.metaDataFactory = metaDataFactory;
        this.trieMap = new HashMap<String, StringTrie<List<LimeXMLDocument>>>();
        this.mainMap = new HashMap<URN, LimeXMLDocument>();
        this.savedDocsDir = file;
        this.oldMap = this.readMapFromDisk();
    }

    public LimeXMLDocument initialize(FileDesc fileDesc, List<? extends LimeXMLDocument> list) {
        URN uRN = fileDesc.getSHA1Urn();
        LimeXMLDocument limeXMLDocument = null;
        for (LimeXMLDocument limeXMLDocument2 : list) {
            if (!limeXMLDocument2.getSchemaURI().equals(this.schemaURI)) continue;
            limeXMLDocument = limeXMLDocument2;
            break;
        }
        if (limeXMLDocument == null) {
            limeXMLDocument = this.oldMap.get(uRN);
        }
        if (limeXMLDocument != null && (limeXMLDocument = this.validate(limeXMLDocument, fileDesc.getFile(), fileDesc)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding old document for file: " + fileDesc.getFile() + ", doc: " + limeXMLDocument);
            }
            this.addReply(fileDesc, limeXMLDocument);
        }
        return limeXMLDocument;
    }

    public LimeXMLDocument createIfNecessary(FileDesc fileDesc) {
        LimeXMLDocument limeXMLDocument = null;
        URN uRN = fileDesc.getSHA1Urn();
        if (!this.mainMap.containsKey(uRN)) {
            File file = fileDesc.getFile();
            if (!(fileDesc.getLimeXMLDocuments().size() != 0 && LimeXMLUtils.isSupportedMultipleFormat(file) || (limeXMLDocument = this.constructDocument(file)) == null)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding newly constructed document for file: " + file + ", doc: " + limeXMLDocument);
                }
                this.addReply(fileDesc, limeXMLDocument);
            }
        }
        return limeXMLDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadFinished() {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            if (((Object)this.oldMap).equals(this.mainMap)) {
                this.dirty = false;
            }
            this.oldMap.clear();
        }
    }

    private LimeXMLDocument validate(LimeXMLDocument limeXMLDocument, File file, FileDesc fileDesc) {
        if (!limeXMLDocument.isCurrent()) {
            LimeXMLDocument limeXMLDocument2;
            if (LOG.isDebugEnabled()) {
                LOG.debug("reconstructing old document: " + file);
            }
            if ((limeXMLDocument2 = this.constructDocument(file)) != null) {
                limeXMLDocument = this.update(limeXMLDocument, limeXMLDocument2);
            } else {
                limeXMLDocument.setCurrent();
            }
        }
        if (!limeXMLDocument.isValid() && (limeXMLDocument = this.constructDocument(file)) == null) {
            return null;
        }
        if (AudioMetaData.isCorrupted(limeXMLDocument)) {
            limeXMLDocument = AudioMetaData.fixCorruption(limeXMLDocument, this.limeXMLDocumentFactory);
            this.mediaFileToDisk(fileDesc, file.getPath(), limeXMLDocument);
        }
        return limeXMLDocument;
    }

    private LimeXMLDocument update(LimeXMLDocument limeXMLDocument, LimeXMLDocument limeXMLDocument2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : limeXMLDocument2.getNameValueSet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
            if (hashMap.containsKey(entry.getKey())) continue;
            hashMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        ArrayList arrayList = new ArrayList(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            arrayList.add(new NameValue((String)entry.getKey(), entry.getValue()));
        }
        return this.limeXMLDocumentFactory.createLimeXMLDocument(arrayList, limeXMLDocument2.getSchemaURI());
    }

    private LimeXMLDocument constructDocument(File file) {
        if (LimeXMLUtils.isSupportedFormatForSchema(file, this.schemaURI)) {
            try {
                LimeXMLDocument limeXMLDocument = this.metaDataReader.readDocument(file);
                if (limeXMLDocument.getSchemaURI().equals(this.schemaURI)) {
                    return limeXMLDocument;
                }
            }
            catch (IOException iOException) {
                LOG.warn("Error creating document", iOException);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getKeyWords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (LimeXMLDocument limeXMLDocument : this.mainMap.values()) {
                if (this.isLWSDoc(limeXMLDocument)) continue;
                arrayList.addAll(limeXMLDocument.getKeyWords());
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getKeyWordsIndivisible() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (LimeXMLDocument limeXMLDocument : this.mainMap.values()) {
                if (this.isLWSDoc(limeXMLDocument)) continue;
                arrayList.addAll(limeXMLDocument.getKeyWordsIndivisible());
            }
        }
        return arrayList;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeywords(LimeXMLDocument limeXMLDocument) {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
                List<LimeXMLDocument> list;
                String string = entry.getKey();
                String string2 = I18NConvert.instance().getNorm(entry.getValue());
                StringTrie<List<LimeXMLDocument>> stringTrie = this.trieMap.get(string);
                if (stringTrie == null) {
                    stringTrie = new StringTrie(true);
                    this.trieMap.put(string, stringTrie);
                }
                if ((list = stringTrie.get(string2)) == null) {
                    list = new LinkedList<LimeXMLDocument>();
                    stringTrie.add(string2, list);
                }
                list.add(limeXMLDocument);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(LimeXMLDocument limeXMLDocument) {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
                String string;
                List<LimeXMLDocument> list;
                String string2 = entry.getKey();
                StringTrie<List<LimeXMLDocument>> stringTrie = this.trieMap.get(string2);
                if (stringTrie == null || (list = stringTrie.get(string = I18NConvert.instance().getNorm(entry.getValue()))) == null) continue;
                list.remove(limeXMLDocument);
                if (list.size() != 0) continue;
                stringTrie.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReply(FileDesc fileDesc, LimeXMLDocument limeXMLDocument) {
        assert (this.getSchemaURI().equals(limeXMLDocument.getSchemaURI()));
        URN uRN = fileDesc.getSHA1Urn();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            this.mainMap.put(uRN, limeXMLDocument);
            if (!this.isLWSDoc(limeXMLDocument)) {
                this.addKeywords(limeXMLDocument);
            }
        }
        fileDesc.addLimeXMLDocument(limeXMLDocument);
    }

    public boolean isLWSDoc(LimeXMLDocument limeXMLDocument) {
        return limeXMLDocument != null && limeXMLDocument.getLicenseString() != null && limeXMLDocument.getLicenseString().equals(LicenseType.LIMEWIRE_STORE_PURCHASE.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            return this.mainMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument getDocForHash(URN uRN) {
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            return this.mainMap.get(uRN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<LimeXMLDocument> getMatchingReplies(LimeXMLDocument limeXMLDocument) {
        IdentityHashSet identityHashSet = null;
        Object object = this.mainMap;
        synchronized (object) {
            for (Map.Entry<String, String> object2 : limeXMLDocument.getNameValueSet()) {
                String string;
                Iterator<List<LimeXMLDocument>> iterator;
                String string2 = object2.getKey();
                StringTrie<List<LimeXMLDocument>> stringTrie = this.trieMap.get(string2);
                if (stringTrie == null || !(iterator = stringTrie.getPrefixedBy(string = object2.getValue())).hasNext()) continue;
                if (identityHashSet == null) {
                    identityHashSet = new IdentityHashSet();
                }
                while (iterator.hasNext()) {
                    identityHashSet.addAll(iterator.next());
                }
            }
        }
        if (identityHashSet == null || identityHashSet.size() == 0) {
            return Collections.emptyList();
        }
        object = null;
        for (LimeXMLDocument limeXMLDocument2 : identityHashSet) {
            if (!LimeXMLUtils.match(limeXMLDocument2, limeXMLDocument, false)) continue;
            if (object == null) {
                object = new LinkedList();
            }
            object.add(limeXMLDocument2);
        }
        if (object == null || object.size() == 0) {
            return Collections.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument replaceDoc(FileDesc fileDesc, LimeXMLDocument limeXMLDocument) {
        assert (this.getSchemaURI().equals(limeXMLDocument.getSchemaURI()));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Replacing doc in FD (" + fileDesc + ") with new doc (" + limeXMLDocument + ")");
        }
        LimeXMLDocument limeXMLDocument2 = null;
        URN uRN = fileDesc.getSHA1Urn();
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            this.dirty = true;
            limeXMLDocument2 = this.mainMap.put(uRN, limeXMLDocument);
            assert (limeXMLDocument2 != null) : "attempted to replace doc that did not exist!!";
            this.removeKeywords(limeXMLDocument2);
            if (!this.isLWSDoc(limeXMLDocument)) {
                this.addKeywords(limeXMLDocument);
            }
        }
        boolean bl = fileDesc.replaceLimeXMLDocument(limeXMLDocument2, limeXMLDocument);
        assert (bl);
        return limeXMLDocument2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDoc(FileDesc fileDesc) {
        LimeXMLDocument limeXMLDocument;
        Map<URN, LimeXMLDocument> map = this.mainMap;
        synchronized (map) {
            limeXMLDocument = this.mainMap.remove(fileDesc.getSHA1Urn());
            if (limeXMLDocument != null) {
                this.dirty = true;
            }
        }
        if (limeXMLDocument != null) {
            fileDesc.removeLimeXMLDocument(limeXMLDocument);
            this.removeKeywords(limeXMLDocument);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("removed: " + limeXMLDocument);
        }
        return limeXMLDocument != null;
    }

    public MetaDataState mediaFileToDisk(FileDesc fileDesc, String string, LimeXMLDocument limeXMLDocument) {
        MetaDataWriter metaDataWriter;
        MetaDataState metaDataState = MetaDataState.UNCHANGED;
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing: " + string + " to disk.");
        }
        if ((metaDataWriter = this.getEditorIfNeeded(string, limeXMLDocument)) != null) {
            metaDataState = this.commitMetaData(string, metaDataWriter);
        }
        assert (metaDataState != MetaDataState.INCORRECT_FILETYPE) : "trying to write data to unwritable file";
        return metaDataState;
    }

    private MetaDataWriter getEditorIfNeeded(String string, LimeXMLDocument limeXMLDocument) {
        if (!LimeXMLUtils.isSupportedEditableFormat(string)) {
            return null;
        }
        MetaDataWriter metaDataWriter = new MetaDataWriter(string, this.metaDataFactory);
        metaDataWriter.populate(limeXMLDocument);
        MetaReader metaReader = null;
        try {
            metaReader = this.metaDataFactory.parse(new File(string));
        }
        catch (IOException iOException) {
            return null;
        }
        if (!metaDataWriter.needsToUpdate(metaReader.getMetaData())) {
            LOG.debug("tag read from disk is same as XML doc.");
            return null;
        }
        return metaDataWriter;
    }

    private MetaDataState commitMetaData(String string, MetaDataWriter metaDataWriter) {
        MetaDataState metaDataState = metaDataWriter.commitMetaData();
        if (LOG.isDebugEnabled()) {
            LOG.debug("wrote data: " + (Object)((Object)metaDataState));
        }
        if (metaDataState == MetaDataState.FILE_DEFECTIVE || metaDataState == MetaDataState.RW_ERROR || metaDataState == MetaDataState.BAD_ID3 || metaDataState == MetaDataState.INCORRECT_FILETYPE) {
            return metaDataState;
        }
        this.fileManager.get().fileChanged(new File(string));
        return metaDataState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeMapToDisk() {
        HashMap<URN, String> hashMap;
        boolean bl = false;
        Object object2 = this.mainMap;
        synchronized (object2) {
            if (!this.dirty) {
                LOG.debug("Not writing because not dirty.");
                return true;
            }
            hashMap = new HashMap<URN, String>(this.mainMap.size());
            for (Map.Entry<URN, LimeXMLDocument> object3 : this.mainMap.entrySet()) {
                hashMap.put(object3.getKey(), object3.getValue().getXmlWithVersion());
            }
            this.dirty = false;
        }
        object2 = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml2");
        File file = ((File)object2).getParentFile();
        if (file != null) {
            file.mkdirs();
        }
        Closeable closeable = null;
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((File)object2)));
            objectOutputStream.writeObject(hashMap);
            objectOutputStream.flush();
            bl = true;
            IOUtils.close(objectOutputStream);
        }
        catch (IOException iOException) {
            LOG.trace("Unable to write", iOException);
        }
        finally {
            IOUtils.close(closeable);
        }
        return bl;
    }

    private Map<URN, LimeXMLDocument> readMapFromDisk() {
        File file = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml2");
        Map<Object, Object> map = null;
        if (file.exists()) {
            map = this.readNewFile(file);
        } else {
            File file2 = new File(this.savedDocsDir, LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml");
            if (file2.exists()) {
                map = this.readOldFile(file2);
                file2.delete();
            }
        }
        return map == null ? new HashMap() : map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URN, LimeXMLDocument> readNewFile(File file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading new format from file: " + file);
        }
        ObjectInputStream objectInputStream = null;
        Map<Object, Object> map = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            map = GenericsUtils.scanForMap(objectInputStream.readObject(), URN.class, String.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable throwable) {
            try {
                LOG.error("Unable to read LimeXMLCollection", throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.close(objectInputStream);
            }
        }
        IOUtils.close(objectInputStream);
        if (map == null) {
            map = Collections.emptyMap();
        }
        HashMap<URN, LimeXMLDocument> hashMap = new HashMap<URN, LimeXMLDocument>(map.size());
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            try {
                hashMap.put((URN)entry.getKey(), this.limeXMLDocumentFactory.createLimeXMLDocument((String)entry.getValue()));
            }
            catch (IOException iOException) {
                LOG.warn("Error creating document for: " + (String)entry.getValue(), iOException);
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), schemaNotFoundException);
            }
            catch (SAXException sAXException) {
                LOG.warn("Error creating document: " + (String)entry.getValue(), sAXException);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<URN, LimeXMLDocument> readOldFile(File file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading old format from file: " + file);
        }
        ConverterObjectInputStream converterObjectInputStream = null;
        Map<Object, Object> map = null;
        try {
            converterObjectInputStream = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
            converterObjectInputStream.addLookup("com.limegroup.gnutella.xml.LimeXMLDocument", SerialXml.class.getName());
            map = GenericsUtils.scanForMap(converterObjectInputStream.readObject(), URN.class, SerialXml.class, GenericsUtils.ScanMode.REMOVE);
        }
        catch (Throwable throwable) {
            try {
                LOG.error("Unable to read LimeXMLCollection", throwable);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                IOUtils.close(converterObjectInputStream);
            }
        }
        IOUtils.close(converterObjectInputStream);
        if (map == null) {
            map = Collections.emptyMap();
        }
        HashMap<URN, LimeXMLDocument> hashMap = new HashMap<URN, LimeXMLDocument>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            try {
                hashMap.put((URN)entry.getKey(), this.limeXMLDocumentFactory.createLimeXMLDocument(((SerialXml)entry.getValue()).getXml(true)));
            }
            catch (IOException iOException) {
                LOG.warn("Error creating document for: " + entry.getValue(), iOException);
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
                LOG.warn("Error creating document: " + entry.getValue(), schemaNotFoundException);
            }
            catch (SAXException sAXException) {
                LOG.warn("Error creating document: " + entry.getValue(), sAXException);
            }
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetaDataState {
        UNCHANGED,
        NORMAL,
        FILE_DEFECTIVE,
        RW_ERROR,
        BAD_ID3,
        FAILED_TITLE,
        FAILED_ARTIST,
        FAILED_ALBUM,
        FAILED_YEAR,
        FAILED_COMMENT,
        FAILED_TRACK,
        FAILED_GENRE,
        HASH_FAILED,
        INCORRECT_FILETYPE;

    }
}

