/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.XMLParsingUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class LimeXMLDocumentHelper {
    private static final Log LOG = LogFactory.getLog(LimeXMLDocumentHelper.class);
    public static final String XML_HEADER = "<?xml version=\"1.0\"?>";
    public static final String XML_NAMESPACE = "xsi:noNamespaceSchemaLocation=\"";
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;

    @Inject
    public LimeXMLDocumentHelper(LimeXMLDocumentFactory limeXMLDocumentFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
    }

    public List<LimeXMLDocument[]> getDocuments(String string, int n) {
        if (string == null || string.equals("") || n <= 0) {
            return Collections.emptyList();
        }
        ArrayList<LimeXMLDocument[]> arrayList = new ArrayList<LimeXMLDocument[]>();
        for (String string2 : XMLParsingUtils.split(string)) {
            XMLParsingUtils.ParseResult parseResult;
            try {
                parseResult = XMLParsingUtils.parse(string2, n);
            }
            catch (SAXException sAXException) {
                LOG.warn("SAX while parsing: " + string2, sAXException);
                continue;
            }
            catch (IOException iOException) {
                LOG.warn("IOX while parsing: " + string, iOException);
                return Collections.emptyList();
            }
            String string3 = parseResult.canonicalKeyPrefix + "index__";
            LimeXMLDocument[] limeXMLDocumentArray = new LimeXMLDocument[n];
            for (Map map : parseResult) {
                String string4 = (String)map.remove(string3);
                if (string4 == null) {
                    return Collections.emptyList();
                }
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    LOG.warn("NFE while parsing", numberFormatException);
                    return Collections.emptyList();
                }
                if (n2 >= limeXMLDocumentArray.length || n2 < 0) {
                    return Collections.emptyList();
                }
                if (map.isEmpty()) continue;
                try {
                    limeXMLDocumentArray[n2] = this.limeXMLDocumentFactory.createLimeXMLDocument(map, parseResult.schemaURI, parseResult.canonicalKeyPrefix);
                }
                catch (IOException iOException) {
                    LOG.debug("", iOException);
                }
            }
            arrayList.add(limeXMLDocumentArray);
        }
        return arrayList;
    }

    public static String getAggregateString(Response[] responseArray) {
        HashMap<LimeXMLSchema, StringBuilder> hashMap = new HashMap<LimeXMLSchema, StringBuilder>();
        for (int i = 0; i < responseArray.length; ++i) {
            LimeXMLDocument limeXMLDocument = responseArray[i].getDocument();
            if (limeXMLDocument == null) continue;
            LimeXMLSchema object = limeXMLDocument.getSchema();
            StringBuilder stringBuilder = (StringBuilder)hashMap.get(object);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
                hashMap.put(object, stringBuilder);
            }
            stringBuilder.append(limeXMLDocument.getAttributeStringWithIndex(i));
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry entry : hashMap.entrySet()) {
            LimeXMLDocumentHelper.buildXML(stringBuilder, (LimeXMLSchema)entry.getKey(), ((StringBuilder)entry.getValue()).toString());
        }
        return stringBuilder.toString();
    }

    public static void buildXML(StringBuilder stringBuilder, LimeXMLSchema limeXMLSchema, String string) {
        stringBuilder.append(XML_HEADER);
        stringBuilder.append("<");
        stringBuilder.append(limeXMLSchema.getRootXMLName());
        stringBuilder.append(" ");
        stringBuilder.append(XML_NAMESPACE);
        stringBuilder.append(limeXMLSchema.getSchemaURI());
        stringBuilder.append("\">");
        stringBuilder.append(string);
        stringBuilder.append("</");
        stringBuilder.append(limeXMLSchema.getRootXMLName());
        stringBuilder.append(">");
    }
}

