/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.settings.SearchSettings;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryUtils {
    private static final List<String> TRIVIAL_WORDS = Arrays.asList("the", "an", "a", "and");

    public static final Set<String> keywords(String string, boolean bl) {
        string = QueryUtils.ripExtension(string);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        String string2 = " -._+/*()\\,";
        char[] cArray = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuilder stringBuilder = new StringBuilder(string2.length() + cArray.length);
        stringBuilder.append(cArray).append(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string, stringBuilder.toString());
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().toLowerCase();
            if (!bl) {
                try {
                    Double.valueOf(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (TRIVIAL_WORDS.contains(string3)) continue;
            linkedHashSet.add(string3);
        }
        return linkedHashSet;
    }

    public static final Set<String> keywords(String string) {
        return QueryUtils.keywords(string, false);
    }

    public static final String removeIllegalChars(String string) {
        String string2 = "";
        String string3 = " -._+/*()\\,";
        char[] cArray = SearchSettings.ILLEGAL_CHARS.getValue();
        StringBuilder stringBuilder = new StringBuilder(string3.length() + cArray.length);
        stringBuilder.append(cArray).append(string3);
        StringTokenizer stringTokenizer = new StringTokenizer(string, stringBuilder.toString());
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken().trim() + " ";
        }
        return string2.trim();
    }

    public static String ripExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    public static String createQueryString(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("null name");
        }
        String string2 = null;
        string = I18NConvert.instance().getNorm(string);
        int n = SearchSettings.MAX_QUERY_LENGTH.getValue();
        Set<String> set = QueryUtils.keywords(string, bl);
        if (set.isEmpty()) {
            string2 = QueryUtils.removeIllegalChars(string);
            string2 = StringUtils.truncate(string2, n);
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = 0;
            for (String string3 : set) {
                if (n2 >= n) break;
                if (n2 + string3.length() >= n) continue;
                if (n2 > 0) {
                    stringBuilder.append(" ");
                    ++n2;
                }
                stringBuilder.append(string3);
                n2 += string3.length();
            }
            if ((string2 = stringBuilder.toString()).equals("")) {
                string2 = StringUtils.truncate(set.iterator().next(), n);
            }
        }
        assert (string2.length() <= n) : "Original filename: " + string + ", converted: " + string2;
        if (!set.isEmpty()) assert (!string2.equals("")) : "Original filename: " + string;
        return string2;
    }

    public static String createQueryString(String string) {
        return QueryUtils.createQueryString(string, false);
    }
}

