/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequestImpl;
import com.limegroup.gnutella.uploader.HTTPUploadSessionManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadType;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.nio.entity.ConsumingNHttpEntity;
import org.apache.http.nio.protocol.SimpleNHttpRequestHandler;
import org.apache.http.protocol.HttpContext;
import org.limewire.io.NetworkUtils;
import org.limewire.util.Base32;

public class PushProxyRequestHandler
extends SimpleNHttpRequestHandler {
    private static final Log LOG = LogFactory.getLog(PushProxyRequestHandler.class);
    public static final String P_SERVER_ID = "ServerId";
    public static final String P_GUID = "guid";
    public static final String P_FILE = "file";
    public static final String P_TLS = "tls";
    private HTTPUploadSessionManager sessionManager;
    private MessageRouter messageRouter;

    @Inject
    PushProxyRequestHandler(HTTPUploadSessionManager hTTPUploadSessionManager, MessageRouter messageRouter) {
        if (hTTPUploadSessionManager == null) {
            throw new IllegalArgumentException();
        }
        if (messageRouter == null) {
            throw new IllegalArgumentException();
        }
        this.sessionManager = hTTPUploadSessionManager;
        this.messageRouter = messageRouter;
    }

    public ConsumingNHttpEntity entityRequest(HttpEntityEnclosingRequest httpEntityEnclosingRequest, HttpContext httpContext) throws HttpException, IOException {
        return null;
    }

    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        HTTPUploader hTTPUploader = null;
        PushProxyRequest pushProxyRequest = this.parsePushProxyRequest(httpRequest);
        if (pushProxyRequest == null) {
            httpResponse.setStatusCode(400);
            hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, UploadType.MALFORMED_REQUEST, "Malformed Request");
            hTTPUploader.setState(Uploader.UploadStatus.MALFORMED_REQUEST);
        } else {
            hTTPUploader = this.sessionManager.getOrCreateUploader(httpRequest, httpContext, UploadType.PUSH_PROXY, pushProxyRequest.clientGUID);
            hTTPUploader.setState(Uploader.UploadStatus.PUSH_PROXY);
            if (!this.sendRequest(pushProxyRequest)) {
                httpResponse.setStatusCode(410);
                httpResponse.setReasonPhrase("Servent not connected");
            } else {
                httpResponse.setStatusCode(202);
                httpResponse.setReasonPhrase("Message sent");
            }
        }
        this.sessionManager.sendResponse(hTTPUploader, httpResponse);
    }

    private PushProxyRequest parsePushProxyRequest(HttpRequest httpRequest) {
        Object object;
        Object object2;
        String string = httpRequest.getRequestLine().getUri();
        int n = string.indexOf(63);
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "=&");
        if (stringTokenizer.countTokens() < 2 || stringTokenizer.countTokens() % 2 != 0) {
            return null;
        }
        Object object3 = null;
        int n2 = 0;
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            object2 = stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
            if (((String)object2).equalsIgnoreCase(P_SERVER_ID)) {
                if (object3 != null) {
                    return null;
                }
                byte[] byArray = Base32.decode((String)object);
                if (byArray.length != 16) {
                    return null;
                }
                object3 = new GUID(byArray).toHexString();
                continue;
            }
            if (((String)object2).equalsIgnoreCase(P_GUID)) {
                if (object3 != null || ((String)object).length() != 32) {
                    return null;
                }
                object3 = object;
                continue;
            }
            if (((String)object2).equalsIgnoreCase(P_FILE)) {
                if (n2 != 0) {
                    return null;
                }
                try {
                    n2 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
                if (n2 >= 0) continue;
                return null;
            }
            if (!((String)object2).equalsIgnoreCase(P_TLS)) continue;
            bl = "true".equalsIgnoreCase((String)object);
        }
        if (object3 == null) {
            return null;
        }
        object2 = httpRequest.getLastHeader(HTTPHeaderName.NODE.httpStringValue());
        if (object2 == null) {
            LOG.info("Missing X-Node header push proxy request");
            return null;
        }
        object = this.getNodeAddress(object2.getValue());
        if (object == null) {
            LOG.info("Invalid node address for push proxy request: " + object2.getValue());
            return null;
        }
        return new PushProxyRequest((String)object3, n2, (InetSocketAddress)object, bl);
    }

    private InetSocketAddress getNodeAddress(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() == 2) {
            try {
                InetAddress inetAddress = InetAddress.getByName(stringTokenizer.nextToken().trim());
                int n = Integer.parseInt(stringTokenizer.nextToken().trim());
                if (NetworkUtils.isValidAddress(inetAddress) && NetworkUtils.isValidPort(n)) {
                    return new InetSocketAddress(inetAddress, n);
                }
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean sendRequest(PushProxyRequest pushProxyRequest) {
        byte[] byArray = GUID.fromHexString(pushProxyRequest.getClientGUID());
        PushRequestImpl pushRequestImpl = new PushRequestImpl(GUID.makeGuid(), 0, byArray, pushProxyRequest.getFileIndex(), pushProxyRequest.getAddress().getAddress().getAddress(), pushProxyRequest.getAddress().getPort(), Message.Network.TCP, pushProxyRequest.isUseTLS());
        try {
            this.messageRouter.sendPushRequest(pushRequestImpl);
        }
        catch (IOException iOException) {
            LOG.debug("Sending of push proxy request failed", iOException);
            return false;
        }
        return true;
    }

    private class PushProxyRequest {
        private String clientGUID;
        private int fileIndex;
        private InetSocketAddress address;
        private boolean useTLS;

        public PushProxyRequest(String string, int n, InetSocketAddress inetSocketAddress, boolean bl) {
            this.clientGUID = string;
            this.fileIndex = n;
            this.address = inetSocketAddress;
            this.useTLS = bl;
        }

        public String getClientGUID() {
            return this.clientGUID;
        }

        public int getFileIndex() {
            return this.fileIndex;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public boolean isUseTLS() {
            return this.useTLS;
        }
    }
}

