/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.uploader.BrowseRequestHandler;
import com.limegroup.gnutella.uploader.FileRequestHandler;
import com.limegroup.gnutella.uploader.FreeLoaderRequestHandler;
import com.limegroup.gnutella.uploader.HTTPHeaderUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.HttpRequestHandlerFactory;
import com.limegroup.gnutella.uploader.LimitReachedRequestHandler;
import com.limegroup.gnutella.uploader.PushProxyRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HttpRequestHandlerFactoryImpl
implements HttpRequestHandlerFactory {
    private final Provider<FileRequestHandler> fileRequestHandlerProvider;
    private final Provider<BrowseRequestHandler> browseRequestHandlerProvider;
    private final Provider<FreeLoaderRequestHandler> freeLoaderRequestHandlerProvider;
    private final Provider<PushProxyRequestHandler> pushProxyRequestHandlerProvider;
    private final HTTPHeaderUtils httpHeaderUtils;
    private final AltLocManager altLocManager;

    @Inject
    public HttpRequestHandlerFactoryImpl(Provider<FileRequestHandler> provider, Provider<BrowseRequestHandler> provider2, Provider<FreeLoaderRequestHandler> provider3, Provider<PushProxyRequestHandler> provider4, HTTPHeaderUtils hTTPHeaderUtils, AltLocManager altLocManager) {
        this.fileRequestHandlerProvider = provider;
        this.browseRequestHandlerProvider = provider2;
        this.freeLoaderRequestHandlerProvider = provider3;
        this.pushProxyRequestHandlerProvider = provider4;
        this.httpHeaderUtils = hTTPHeaderUtils;
        this.altLocManager = altLocManager;
    }

    @Override
    public FileRequestHandler createFileRequestHandler() {
        return this.fileRequestHandlerProvider.get();
    }

    @Override
    public BrowseRequestHandler createBrowseRequestHandler() {
        return this.browseRequestHandlerProvider.get();
    }

    @Override
    public FreeLoaderRequestHandler createFreeLoaderRequestHandler() {
        return this.freeLoaderRequestHandlerProvider.get();
    }

    @Override
    public LimitReachedRequestHandler createLimitReachedRequestHandler(HTTPUploader hTTPUploader) {
        return new LimitReachedRequestHandler(hTTPUploader, this.httpHeaderUtils, this.altLocManager);
    }

    @Override
    public PushProxyRequestHandler createPushProxyRequestHandler() {
        return this.pushProxyRequestHandlerProvider.get();
    }
}

