/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.http.AltLocTracker;
import com.limegroup.gnutella.http.FeaturesWriter;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.limewire.collection.BitNumbers;
import org.limewire.io.Connectable;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HTTPHeaderUtils {
    private final NetworkManager networkManager;
    private final FeaturesWriter featuresWriter;
    private final Provider<ConnectionManager> connectionManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    @Inject
    public HTTPHeaderUtils(FeaturesWriter featuresWriter, NetworkManager networkManager, Provider<ConnectionManager> provider, NetworkInstanceUtils networkInstanceUtils) {
        this.networkManager = networkManager;
        this.featuresWriter = featuresWriter;
        this.connectionManager = provider;
        this.networkInstanceUtils = networkInstanceUtils;
    }

    public void addRangeHeader(HttpResponse httpResponse, HTTPUploader hTTPUploader, FileDesc fileDesc) {
        URN uRN;
        if (fileDesc instanceof IncompleteFileDesc && (uRN = hTTPUploader.getFileDesc().getSHA1Urn()) != null) {
            IncompleteFileDesc incompleteFileDesc = (IncompleteFileDesc)fileDesc;
            httpResponse.addHeader(HTTPHeaderName.AVAILABLE_RANGES.create(incompleteFileDesc));
        }
    }

    public static String encodePushProxies(Collection<? extends IpPort> collection, String string, int n) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Can't encode empty set of proxies");
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        BitNumbers bitNumbers = HTTPHeaderUtils.getTLSIndices(collection, n);
        for (IpPort ipPort : collection) {
            if (n2 >= n) break;
            stringBuilder.append(ipPort.getAddress()).append(":").append(ipPort.getPort()).append(string);
            ++n2;
        }
        if (!bitNumbers.isEmpty()) {
            stringBuilder.insert(0, "pptls=" + bitNumbers.toHexString() + string);
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }

    public Set<Connectable> decodePushProxies(String string, String string2) {
        HashSet<Connectable> hashSet = new HashSet<Connectable>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        BitNumbers bitNumbers = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (hashSet.size() == 0 && string3.startsWith("pptls")) {
                try {
                    String string4 = HTTPUtils.parseValue(string3);
                    if (string4 == null) continue;
                    try {
                        bitNumbers = new BitNumbers(string4);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                catch (IOException iOException) {}
                continue;
            }
            boolean bl = bitNumbers != null && bitNumbers.isSet(hashSet.size());
            try {
                Connectable connectable = NetworkUtils.parseIpPort(string3, bl);
                if (this.networkInstanceUtils.isPrivateAddress(connectable.getInetAddress())) continue;
                hashSet.add(connectable);
            }
            catch (IOException iOException) {
                bitNumbers = null;
            }
        }
        return hashSet;
    }

    public static BitNumbers getTLSIndices(Collection<? extends IpPort> collection) {
        return HTTPHeaderUtils.getTLSIndices(collection, collection.size());
    }

    public static BitNumbers getTLSIndices(Collection<? extends IpPort> collection, int n) {
        BitNumbers bitNumbers = new BitNumbers(n);
        int n2 = 0;
        for (IpPort ipPort : collection) {
            if (n2 >= n) break;
            if (ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                bitNumbers.set(n2);
            }
            ++n2;
        }
        return bitNumbers;
    }

    private String encodePushProxies() {
        if (this.networkManager.acceptedIncomingConnection()) {
            return null;
        }
        Set<Connectable> set = this.connectionManager.get().getPushProxies();
        return !set.isEmpty() ? HTTPHeaderUtils.encodePushProxies(set, ",", 4) : null;
    }

    public List<Header> getFirewalledHeaders() {
        String string = this.encodePushProxies();
        if (string != null) {
            Header header = HTTPHeaderName.PROXIES.create(string);
            if (this.networkManager.canDoFWT()) {
                return Arrays.asList(header, HTTPHeaderName.FWTPORT.create(this.networkManager.getStableUDPPort() + ""));
            }
            return Arrays.asList(header);
        }
        return Collections.emptyList();
    }

    public void addProxyHeader(HttpResponse httpResponse) {
        for (Header header : this.getFirewalledHeaders()) {
            httpResponse.addHeader(header);
        }
    }

    public void addAltLocationsHeader(HttpResponse httpResponse, AltLocTracker altLocTracker, AltLocManager altLocManager) {
        Collection<Object> collection;
        httpResponse.addHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN.create(altLocTracker.getUrn()));
        Collection<DirectAltLoc> collection2 = altLocTracker.getNextSetOfAltsToSend(altLocManager);
        if (collection2.size() > 0) {
            collection = new ArrayList(collection2.size());
            final BitNumbers bitNumbers = new BitNumbers(collection2.size());
            for (DirectAltLoc directAltLoc : collection2) {
                IpPort ipPort = directAltLoc.getHost();
                if (ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                    bitNumbers.set(collection.size());
                }
                collection.add(directAltLoc);
            }
            if (!bitNumbers.isEmpty()) {
                collection.add(0, new HTTPHeaderValue(){

                    public String httpStringValue() {
                        return "tls=" + bitNumbers.toHexString();
                    }
                });
            }
            httpResponse.addHeader(HTTPHeaderName.ALT_LOCATION.create(new HTTPHeaderValueCollection(collection)));
        }
        if (altLocTracker.wantsFAlts() && (collection = altLocTracker.getNextSetOfPushAltsToSend(altLocManager)).size() > 0) {
            httpResponse.addHeader(HTTPHeaderName.FALT_LOCATION.create(new HTTPHeaderValueCollection(collection)));
        }
    }

    public void addFeatures(HttpResponse httpResponse) {
        Set<HTTPHeaderValue> set = this.featuresWriter.getFeaturesValue();
        if (set.size() > 0) {
            httpResponse.addHeader(HTTPHeaderName.FEATURES.create(new HTTPHeaderValueCollection(set)));
        }
    }
}

