/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.spam;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.spam.AddressToken;
import com.limegroup.gnutella.spam.KeywordToken;
import com.limegroup.gnutella.spam.SizeToken;
import com.limegroup.gnutella.spam.Token;
import com.limegroup.gnutella.spam.UrnToken;
import com.limegroup.gnutella.spam.VendorToken;
import com.limegroup.gnutella.spam.XMLKeywordToken;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class Tokenizer {
    private static final Log LOG = LogFactory.getLog(Tokenizer.class);
    private int MIN_KEYWORD_LENGTH = 3;
    private int MAX_KEYWORD_LENGTH = 8;
    private final String KEYWORD_DELIMITERS = " -._+/*()\\,\t";
    private final Provider<IPFilter> ipFilter;

    @Inject
    Tokenizer(Provider<IPFilter> provider) {
        this.ipFilter = provider;
    }

    void initialize(Token token) {
        if (token instanceof AddressToken) {
            ((AddressToken)token).setIpFilter(this.ipFilter);
        }
    }

    public Token[] getTokens(RemoteFileDesc remoteFileDesc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("tokenizing: " + remoteFileDesc);
        }
        HashSet<Token> hashSet = new HashSet<Token>();
        hashSet.addAll(this.getKeywordTokens(remoteFileDesc));
        if (remoteFileDesc.getSHA1Urn() != null) {
            hashSet.add(this.getUrnToken(remoteFileDesc));
        }
        hashSet.add(this.getSizeToken(remoteFileDesc));
        hashSet.add(this.getVendorToken(remoteFileDesc));
        hashSet.add(this.getAddressToken(remoteFileDesc));
        Token[] tokenArray = new Token[hashSet.size()];
        tokenArray = hashSet.toArray(tokenArray);
        return tokenArray;
    }

    public Token[] getTokens(RemoteFileDesc[] remoteFileDescArray) {
        HashSet<Token> hashSet = new HashSet<Token>();
        for (int i = 0; i < remoteFileDescArray.length; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("tokenizing: " + remoteFileDescArray[i]);
            }
            hashSet.addAll(this.getKeywordTokens(remoteFileDescArray[i]));
            if (remoteFileDescArray[i].getSHA1Urn() != null) {
                hashSet.add(this.getUrnToken(remoteFileDescArray[i]));
            }
            hashSet.add(this.getSizeToken(remoteFileDescArray[i]));
            hashSet.add(this.getVendorToken(remoteFileDescArray[i]));
            hashSet.add(this.getAddressToken(remoteFileDescArray[i]));
        }
        Token[] tokenArray = new Token[hashSet.size()];
        tokenArray = hashSet.toArray(tokenArray);
        return tokenArray;
    }

    public Token[] getTokens(QueryRequest queryRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("tokenizing: " + queryRequest);
        }
        HashSet<Token> hashSet = new HashSet<Token>();
        hashSet.addAll(this.getKeywordTokens(queryRequest));
        hashSet.addAll(this.getUrnTokens(queryRequest));
        Token[] tokenArray = new Token[hashSet.size()];
        tokenArray = hashSet.toArray(tokenArray);
        return tokenArray;
    }

    private Token getUrnToken(RemoteFileDesc remoteFileDesc) {
        if (remoteFileDesc.getSHA1Urn() != null) {
            return new UrnToken(remoteFileDesc.getSHA1Urn());
        }
        return null;
    }

    private Set<Token> getUrnTokens(QueryRequest queryRequest) {
        if (queryRequest.getQueryUrns().isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Token> hashSet = new HashSet<Token>();
        for (URN uRN : queryRequest.getQueryUrns()) {
            hashSet.add(new UrnToken(uRN));
        }
        return hashSet;
    }

    private Token getSizeToken(RemoteFileDesc remoteFileDesc) {
        return new SizeToken(remoteFileDesc.getSize());
    }

    private Token getVendorToken(RemoteFileDesc remoteFileDesc) {
        return VendorToken.getToken(remoteFileDesc.getVendor());
    }

    private Token getAddressToken(RemoteFileDesc remoteFileDesc) {
        return new AddressToken(remoteFileDesc.getInetAddress().getAddress(), remoteFileDesc.getPort(), this.ipFilter);
    }

    private Set<Token> getKeywordTokens(RemoteFileDesc remoteFileDesc) {
        return this.getKeywordTokens(remoteFileDesc.getFileName(), remoteFileDesc.getXMLDocument());
    }

    private Set<Token> getKeywordTokens(QueryRequest queryRequest) {
        return this.getKeywordTokens(queryRequest.getQuery(), queryRequest.getRichQuery());
    }

    private Set<Token> getKeywordTokens(String string, LimeXMLDocument limeXMLDocument) {
        Set<Token> set = this.getKeywordTokens(string.toLowerCase(Locale.US));
        if (limeXMLDocument != null) {
            for (Map.Entry<String, String> entry : limeXMLDocument.getNameValueSet()) {
                set.addAll(this.getXMLKeywords(entry.getKey().toString().toLowerCase(Locale.US), entry.getValue().toString().toLowerCase(Locale.US)));
            }
        }
        return set;
    }

    private Set<Token> getXMLKeywords(String string, String string2) {
        string = this.extractSimpleFieldName(string);
        HashSet<Token> hashSet = new HashSet<Token>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, " -._+/*()\\,\t");
        while (stringTokenizer.hasMoreTokens()) {
            byte[] byArray = stringTokenizer.nextToken().getBytes();
            if (byArray.length < this.MIN_KEYWORD_LENGTH) continue;
            if (byArray.length > this.MAX_KEYWORD_LENGTH) {
                byArray = this.truncateArray(byArray, this.MAX_KEYWORD_LENGTH);
            }
            hashSet.add(new XMLKeywordToken(string, byArray));
        }
        return hashSet;
    }

    private byte[] truncateArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return byArray2;
    }

    private byte[] mergeArrays(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length + 1];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = 0;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
        return byArray3;
    }

    private String extractSimpleFieldName(String string) {
        int n = string.lastIndexOf("__");
        int n2 = string.lastIndexOf("__", n - 1);
        return string.substring(n2 + "__".length(), n);
    }

    private Set<Token> getKeywordTokens(String string) {
        HashSet<Token> hashSet = new HashSet<Token>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " -._+/*()\\,\t");
        byte[] byArray = null;
        while (stringTokenizer.hasMoreTokens()) {
            KeywordToken keywordToken;
            byte[] byArray2 = stringTokenizer.nextToken().getBytes();
            if (byArray2.length < this.MIN_KEYWORD_LENGTH) {
                if (byArray != null) {
                    keywordToken = new KeywordToken(this.mergeArrays(byArray, byArray2));
                    hashSet.add(keywordToken);
                }
                byArray = byArray2;
                continue;
            }
            if (byArray2.length > this.MAX_KEYWORD_LENGTH) {
                byArray2 = this.truncateArray(byArray2, this.MAX_KEYWORD_LENGTH);
            }
            keywordToken = new KeywordToken(byArray2);
            hashSet.add(keywordToken);
            if (byArray != null) {
                keywordToken = new KeywordToken(this.mergeArrays(byArray, byArray2));
                hashSet.add(keywordToken);
            }
            byArray = byArray2;
        }
        return hashSet;
    }
}

