/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.video.reader;

import com.limegroup.gnutella.metadata.video.reader.VideoDataReader;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.limewire.io.IOUtils;

public class MOVMetaData
extends VideoDataReader {
    private long length = -1L;

    public MOVMetaData(File file) throws IOException {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseFile(File file) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            this.length = file.length();
            randomAccessFile = new RandomAccessFile(file, "r");
            this.parseAtoms(randomAccessFile);
        }
        catch (Throwable throwable) {
            IOUtils.close(randomAccessFile);
            throw throwable;
        }
        IOUtils.close(randomAccessFile);
    }

    private void parseAtoms(DataInput dataInput) throws IOException {
        Atom atom = null;
        while ((atom = this.nextAtom(dataInput)) != null) {
            if (atom.isType("moov")) {
                this.moov(atom, dataInput);
                break;
            }
            MOVMetaData.skip(atom.remaining, dataInput);
        }
    }

    private void moov(Atom atom, DataInput dataInput) throws IOException {
        Atom atom2 = null;
        for (long i = 0L; i < atom.remaining && (atom2 = this.nextAtom(dataInput)) != null; i += atom2.size) {
            if (atom2.isType("mvhd")) {
                this.mvhd(atom2, dataInput);
                continue;
            }
            if (atom2.isType("cmov")) {
                this.cmov(atom2, dataInput);
                continue;
            }
            if (atom2.isType("trak")) {
                this.trak(atom2, dataInput);
                continue;
            }
            MOVMetaData.skip(atom2.remaining, dataInput);
        }
    }

    private void mvhd(Atom atom, DataInput dataInput) throws IOException {
        assert (atom.remaining == 100L);
        dataInput.skipBytes(12);
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = n2 / n;
        if (n3 > this.videoData.getLength()) {
            this.videoData.setLength(n3);
        }
        long l = atom.remaining - 12L - 4L - 4L;
        assert (l == 80L);
        MOVMetaData.skip(l, dataInput);
    }

    private void cmov(Atom atom, DataInput dataInput) throws IOException {
        Atom atom2 = null;
        for (long i = 0L; i < atom.remaining && (atom2 = this.nextAtom(dataInput)) != null; i += atom2.size) {
            if (atom2.isType("cmvd")) {
                this.cmvd(atom2, dataInput);
                continue;
            }
            MOVMetaData.skip(atom2.remaining, dataInput);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cmvd(Atom atom, DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (atom == null || atom.remaining - 4L > Integer.MAX_VALUE || atom.remaining < 4L) {
            throw new IOException("File smaller than expected");
        }
        byte[] byArray = new byte[(int)(atom.remaining - 4L)];
        dataInput.readFully(byArray);
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(byArray);
            if (n > Integer.MAX_VALUE || n < 0) {
                throw new IOException("Illegal atom size");
            }
            byte[] byArray2 = new byte[n];
            int n2 = -1;
            try {
                n2 = inflater.inflate(byArray2);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(dataFormatException.getMessage());
            }
            finally {
                inflater.end();
            }
            if (n2 < n) {
                throw new EOFException("Decompressed size is less than expected: " + n2 + " < " + n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            try {
                this.parseAtoms(dataInputStream);
            }
            finally {
                dataInputStream.close();
            }
        }
        finally {
            IOUtils.close(inflater);
        }
    }

    private void trak(Atom atom, DataInput dataInput) throws IOException {
        Atom atom2 = null;
        for (long i = 0L; i < atom.remaining && (atom2 = this.nextAtom(dataInput)) != null; i += atom2.size) {
            if (atom2.isType("tkhd")) {
                this.tkhd(atom2, dataInput);
                continue;
            }
            MOVMetaData.skip(atom2.remaining, dataInput);
        }
    }

    private void tkhd(Atom atom, DataInput dataInput) throws IOException {
        assert (atom.remaining == 84L);
        MOVMetaData.skip(76L, dataInput);
        int n = MOVMetaData.toTwoCompliant(dataInput.readInt());
        int n2 = MOVMetaData.toTwoCompliant(dataInput.readInt());
        if (n > this.videoData.getWidth()) {
            this.videoData.setWidth(n);
        }
        if (n2 > this.videoData.getHeight()) {
            this.videoData.setHeight(n2);
        }
    }

    private static int toTwoCompliant(int n) {
        return n / 65536;
    }

    private static long skip(long l, DataInput dataInput) throws IOException {
        long l2;
        int n;
        for (l2 = 0L; l2 < l; l2 += (long)n) {
            n = (int)Math.min(l - l2, Integer.MAX_VALUE);
            int n2 = dataInput.skipBytes(n);
            if (n2 == n) continue;
            throw new EOFException("Could not skip " + n + " bytes: " + n2);
        }
        return l2;
    }

    private Atom nextAtom(DataInput dataInput) throws IOException {
        long l = (long)dataInput.readInt() & 0xFFFFFFFFL;
        if (l == 0L) {
            return null;
        }
        boolean bl = false;
        String string = MOVMetaData.toAtomName(dataInput.readInt());
        if (l == 1L) {
            l = dataInput.readLong();
            bl = true;
        }
        if (l > this.length) {
            throw new IOException("Size is too big: " + l + " > " + this.length);
        }
        return new Atom(string, l, bl);
    }

    private static String toAtomName(int n) throws UnsupportedEncodingException {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return new String(byArray, "8859_1");
    }

    private static class Atom {
        private final String name;
        private final long size;
        private final long remaining;

        private Atom(String string, long l, boolean bl) {
            this.name = string;
            this.size = l;
            this.remaining = bl ? l - 16L : l - 8L;
        }

        public boolean isType(String string) {
            return this.name.equals(string);
        }

        public String toString() {
            return this.name + "/" + this.size + "/" + Long.toHexString(this.size);
        }
    }
}

