/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.writer;

import com.limegroup.gnutella.metadata.MetaData;
import com.limegroup.gnutella.metadata.MetaWriter;
import com.limegroup.gnutella.metadata.audio.AudioMetaData;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import java.io.File;
import java.io.IOException;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioFileIO;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.CannotWriteException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;
import org.limewire.util.FileUtils;

public abstract class AudioDataEditor
implements MetaWriter {
    protected final AudioMetaData audioData = new AudioMetaData();

    public MetaData getMetaData() {
        return this.audioData;
    }

    public void populate(LimeXMLDocument limeXMLDocument) {
        this.audioData.populate(limeXMLDocument);
    }

    protected Tag updateTag(Tag tag, AudioFile audioFile) throws FieldDataInvalidException {
        tag.setAlbum(this.audioData.getAlbum());
        tag.setArtist(this.audioData.getArtist());
        tag.setComment(this.audioData.getComment());
        tag.setGenre(this.audioData.getGenre());
        tag.setTitle(this.audioData.getTitle());
        tag.setYear(this.audioData.getYear());
        tag.setTrack(this.audioData.getTrack());
        return tag;
    }

    protected abstract boolean isValidFileType(String var1);

    protected abstract Tag createTag(AudioFile var1);

    public LimeXMLReplyCollection.MetaDataState commitMetaData(String string) {
        if (!this.isValidFileType(string)) {
            return LimeXMLReplyCollection.MetaDataState.INCORRECT_FILETYPE;
        }
        File file = new File(string);
        FileUtils.setWriteable(file);
        try {
            AudioFile audioFile = AudioFileIO.read(file);
            Tag tag = this.createTag(audioFile);
            tag = this.updateTag(tag, audioFile);
            audioFile.setTag(tag);
            audioFile.commit();
        }
        catch (CannotReadException cannotReadException) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (IOException iOException) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (TagException tagException) {
            return LimeXMLReplyCollection.MetaDataState.FAILED_ALBUM;
        }
        catch (ReadOnlyFileException readOnlyFileException) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        catch (InvalidAudioFrameException invalidAudioFrameException) {
            return LimeXMLReplyCollection.MetaDataState.FAILED_ALBUM;
        }
        catch (CannotWriteException cannotWriteException) {
            return LimeXMLReplyCollection.MetaDataState.RW_ERROR;
        }
        return LimeXMLReplyCollection.MetaDataState.NORMAL;
    }
}

