/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.audio.reader.AudioDataReader;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.AbstractTagFrame;
import org.jaudiotagger.tag.id3.ID3v1Tag;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyTextInfo;

public class MP3MetaData
extends AudioDataReader {
    static final String LICENSE_ID = "TCOP";
    static final String PRIV_ID = "PRIV";

    public MP3MetaData(File file) throws IOException, IllegalArgumentException {
        super(file);
    }

    protected void readTag(AudioFile audioFile, Tag tag) {
        if (tag != null) {
            this.audioData.setTitle(tag.getFirstTitle());
            this.audioData.setArtist(tag.getFirstArtist());
            this.audioData.setAlbum(tag.getFirstAlbum());
            this.audioData.setYear(tag.getFirstYear());
            this.audioData.setComment(tag.getFirstComment());
            this.audioData.setGenre(tag.getFirstGenre());
            try {
                this.audioData.setTrack(tag.getFirstTrack());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            if (!(tag instanceof ID3v1Tag)) {
                this.audioData.setLicense(tag.getFirst(LICENSE_ID));
                MP3File mP3File = (MP3File)audioFile;
                this.audioData.setGenre(this.parseGenre(tag.getFirstGenre()));
                AbstractID3v2Tag abstractID3v2Tag = mP3File.getID3v2Tag();
                if (abstractID3v2Tag != null) {
                    TagField tagField2;
                    List<TagField> list = abstractID3v2Tag.get(PRIV_ID);
                    List<TagField> list2 = abstractID3v2Tag.get(PRIV_ID);
                    for (TagField tagField2 : list) {
                        this.checkLWS(((Object)tagField2).toString());
                    }
                    for (TagField tagField2 : list2) {
                        this.checkLWS(((Object)tagField2).toString());
                        try {
                            this.isPRIVCheck(tagField2.getRawContent());
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    tagField2 = abstractID3v2Tag.getFirstField(LICENSE_ID);
                    if (tagField2 != null && !((AbstractID3v2Frame)tagField2).isEmpty() && ((AbstractTagFrame)((Object)tagField2)).getBody() instanceof AbstractFrameBodyTextInfo) {
                        this.audioData.setLicense(((AbstractFrameBodyTextInfo)((AbstractTagFrame)((Object)tagField2)).getBody()).getText());
                    }
                }
            }
        }
    }

    private void isPRIVCheck(byte[] byArray) {
        try {
            String string = new String(byArray, "UTF-8");
            this.checkLWS(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void checkLWS(String string) {
        if (!(this.audioData.getLicenseType() != null && this.audioData.getLicenseType().equals("NOT CLEARED") || string.indexOf("NOT CLEARED") == -1)) {
            this.audioData.setLicenseType("NOT CLEARED");
        }
    }

    private String parseGenre(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        String string2 = string;
        if (string.charAt(0) == '(') {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != ')') continue;
                n = i + 1;
            }
            string2 = string.substring(n);
        }
        return string2;
    }
}

