/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata.audio.reader;

import com.limegroup.gnutella.metadata.audio.reader.WRMXML;
import com.limegroup.gnutella.metadata.audio.reader.WeedInfo;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.io.CountingInputStream;
import org.limewire.io.IOUtils;
import org.limewire.util.ByteOrder;

public class ASFParser {
    private static final Log LOG = LogFactory.getLog(ASFParser.class);
    private static final int TYPE_STRING = 0;
    private static final int TYPE_BINARY = 1;
    private static final int TYPE_BOOLEAN = 2;
    private static final int TYPE_INT = 3;
    private static final int TYPE_LONG = 4;
    private String _album;
    private String _artist;
    private String _title;
    private String _year;
    private String _copyright;
    private String _rating;
    private String _genre;
    private String _comment;
    private String _drmType;
    private short _track = (short)-1;
    private int _bitrate = -1;
    private int _length = -1;
    private int _width = -1;
    private int _height = -1;
    private boolean _hasAudio;
    private boolean _hasVideo;
    private WeedInfo _weed;
    private WRMXML _wrmdata;

    public String getAlbum() {
        return this._album;
    }

    public String getArtist() {
        return this._artist;
    }

    public String getTitle() {
        return this._title;
    }

    public String getYear() {
        return this._year;
    }

    public String getCopyright() {
        return this._copyright;
    }

    public String getRating() {
        return this._rating;
    }

    public String getGenre() {
        return this._genre;
    }

    public String getComment() {
        return this._comment;
    }

    public short getTrack() {
        return this._track;
    }

    public int getBitrate() {
        return this._bitrate;
    }

    public int getLength() {
        return this._length;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public WeedInfo getWeedInfo() {
        return this._weed;
    }

    public WRMXML getWRMXML() {
        return this._wrmdata;
    }

    public boolean hasAudio() {
        return this._hasAudio;
    }

    public boolean hasVideo() {
        return this._hasVideo;
    }

    public String getLicenseInfo() {
        if (this._weed != null) {
            return this._weed.getLicenseInfo();
        }
        if (this._wrmdata != null && this._drmType != null) {
            return "licensed: " + this._drmType;
        }
        return null;
    }

    public ASFParser(File file) throws IOException {
        this.parseFile(file);
    }

    protected void parseFile(File file) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing file: " + file);
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            this.parse(bufferedInputStream);
        }
        catch (IOException iOException) {
            try {
                LOG.warn("IOX while parsing", iOException);
                throw iOException;
            }
            catch (Throwable throwable) {
                IOUtils.close(bufferedInputStream);
                throw throwable;
            }
        }
        IOUtils.close(bufferedInputStream);
    }

    private void parse(InputStream inputStream) throws IOException {
        CountingInputStream countingInputStream = new CountingInputStream(inputStream);
        DataInputStream dataInputStream = new DataInputStream(countingInputStream);
        byte[] byArray = new byte[IDs.HEADER_ID.length];
        dataInputStream.readFully(byArray);
        if (!Arrays.equals(byArray, IDs.HEADER_ID)) {
            throw new IOException("not an ASF file");
        }
        long l = ByteOrder.leb2long(dataInputStream);
        int n = ByteOrder.leb2int(dataInputStream);
        IOUtils.ensureSkip(dataInputStream, 2L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data Offset: " + l + ", objectCount: " + n);
        }
        if (l < 0L) {
            throw new IOException("ASF file is corrupt. Data offset negative:" + l);
        }
        if (n < 0) {
            throw new IOException("ASF file is corrupt. Object count unreasonable:" + ByteOrder.uint2long(n));
        }
        if (n > 100) {
            throw new IOException("object count very high: " + n);
        }
        byte[] byArray2 = new byte[16];
        for (int i = 0; i < n; ++i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parsing object[" + i + "]");
            }
            dataInputStream.readFully(byArray2);
            long l2 = ByteOrder.leb2long(dataInputStream) - 24L;
            if (l2 < 0L) {
                throw new IOException("ASF file is corrupt.  Object size < 0 :" + l2);
            }
            countingInputStream.clearAmountRead();
            this.readObject(dataInputStream, byArray2, l2);
            int n2 = countingInputStream.getAmountRead();
            if ((long)n2 > l2) {
                throw new IOException("read (" + n2 + ") more than size (" + l2 + ")");
            }
            if ((long)n2 == l2) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipping to next object.  Read: " + n2 + ", size: " + l2);
            }
            IOUtils.ensureSkip(dataInputStream, l2 - (long)n2);
        }
    }

    private void readObject(DataInputStream dataInputStream, byte[] byArray, long l) throws IOException {
        if (Arrays.equals(byArray, IDs.FILE_PROPERTIES_ID)) {
            this.parseFileProperties(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.STREAM_PROPERTIES_ID)) {
            this.parseStreamProperties(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.EXTENDED_STREAM_PROPERTIES_ID)) {
            this.parseExtendedStreamProperties(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.CONTENT_DESCRIPTION_ID)) {
            this.parseContentDescription(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.EXTENDED_CONTENT_DESCRIPTION_ID)) {
            this.parseExtendedContentDescription(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.CONTENT_ENCRYPTION_ID)) {
            this.parseContentEncryption(dataInputStream);
        } else if (Arrays.equals(byArray, IDs.EXTENDED_CONTENT_ENCRYPTION_ID)) {
            this.parseExtendedContentEncryption(dataInputStream);
        } else {
            LOG.debug("Unknown Object, ignoring.");
        }
    }

    private void parseFileProperties(DataInputStream dataInputStream) throws IOException {
        LOG.debug("Parsing file properties");
        IOUtils.ensureSkip(dataInputStream, 48L);
        int n = (int)(ByteOrder.leb2long(dataInputStream) / 10000000L);
        if (n < 0) {
            throw new IOException("ASF file corrupt.  Duration < 0:" + n);
        }
        this._length = n;
        IOUtils.ensureSkip(dataInputStream, 20L);
        int n2 = ByteOrder.leb2int(dataInputStream);
        if (n2 < 0) {
            throw new IOException("ASF file corrupt.  Max bitrate > 2 Gb/s:" + ByteOrder.uint2long(n2));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("maxBitrate: " + n2);
        }
        this._bitrate = n2 / 1000;
    }

    private void parseStreamProperties(DataInputStream dataInputStream) throws IOException {
        LOG.debug("Parsing stream properties");
        byte[] byArray = new byte[16];
        dataInputStream.readFully(byArray);
        if (Arrays.equals(byArray, IDs.AUDIO_STREAM_ID)) {
            this._hasAudio = true;
        } else if (Arrays.equals(byArray, IDs.VIDEO_STREAM_ID)) {
            this._hasVideo = true;
            IOUtils.ensureSkip(dataInputStream, 38L);
            this._width = ByteOrder.leb2int(dataInputStream);
            if (this._width < 0) {
                throw new IOException("ASF file corrupt.  Video width excessive:" + ByteOrder.uint2long(this._width));
            }
            this._height = ByteOrder.leb2int(dataInputStream);
            if (this._height < 0) {
                throw new IOException("ASF file corrupt.  Video height excessive:" + ByteOrder.uint2long(this._height));
            }
        }
    }

    private void parseExtendedStreamProperties(DataInputStream dataInputStream) throws IOException {
        LOG.debug("Parsing extended stream properties");
        IOUtils.ensureSkip(dataInputStream, 56L);
        int n = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
        int n2 = ByteOrder.leb2int(dataInputStream);
        if (n2 < 0) {
            throw new IOException("ASF file corrupt.  Sample rate excessive:" + ByteOrder.uint2long(n2));
        }
        int n3 = ByteOrder.leb2int(dataInputStream);
        if (n3 < 0) {
            throw new IOException("ASF file corrupt.  Byte rate excessive:" + ByteOrder.uint2long(n3));
        }
        if (this._bitrate == -1) {
            this._bitrate = n3 * 8 / 1000;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("channels: " + n + ", sampleRate: " + n2 + ", byteRate: " + n3 + ", bitRate: " + this._bitrate);
        }
    }

    private void parseContentEncryption(DataInputStream dataInputStream) throws IOException {
        LOG.debug("Parsing content encryption");
        long l = ByteOrder.uint2long(ByteOrder.leb2int(dataInputStream));
        IOUtils.ensureSkip(dataInputStream, l);
        int n = ByteOrder.leb2int(dataInputStream);
        if (n < 0) {
            throw new IOException("ASF file is corrupt.  Type size < 0: " + n);
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        this._drmType = new String(byArray).trim();
        l = ByteOrder.uint2long(ByteOrder.leb2int(dataInputStream));
        IOUtils.ensureSkip(dataInputStream, l);
        l = ByteOrder.uint2long(ByteOrder.leb2int(dataInputStream));
        IOUtils.ensureSkip(dataInputStream, l);
    }

    private void parseExtendedContentEncryption(DataInputStream dataInputStream) throws IOException {
        LOG.debug("Parsing extended content encryption");
        int n = ByteOrder.leb2int(dataInputStream);
        if (n < 0) {
            throw new IOException("ASF file reports excessive length of encryption data:" + ByteOrder.uint2long(n));
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        String string = new String(byArray, "UTF-16").trim();
        WRMXML wRMXML = new WRMXML(string);
        if (!wRMXML.isValid()) {
            LOG.debug("WRM Data is invalid.");
            return;
        }
        this._wrmdata = wRMXML;
        WeedInfo weedInfo = new WeedInfo(wRMXML);
        if (weedInfo.isValid()) {
            LOG.debug("Parsed weed data.");
            this._weed = weedInfo;
            this._wrmdata = weedInfo;
            if (this._weed.getAuthor() != null) {
                this._artist = this._weed.getAuthor();
            }
            if (this._weed.getTitle() != null) {
                this._title = this._weed.getTitle();
            }
            if (this._weed.getDescription() != null) {
                this._comment = this._weed.getDescription();
            }
            if (this._weed.getCollection() != null) {
                this._album = this._weed.getCollection();
            }
            if (this._weed.getCopyright() != null) {
                this._copyright = this._weed.getCopyright();
            }
            return;
        }
    }

    private void parseContentDescription(DataInputStream dataInputStream) throws IOException {
        int n;
        LOG.debug("Parsing Content Description");
        int[] nArray = new int[]{-1, -1, -1, -1, -1};
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
        }
        byte[][] byArrayArray = new byte[5][];
        for (n = 0; n < nArray.length; ++n) {
            byArrayArray[n] = new byte[nArray[n]];
        }
        for (n = 0; n < byArrayArray.length; ++n) {
            dataInputStream.readFully(byArrayArray[n]);
        }
        this._title = this.string(byArrayArray[0]);
        this._artist = this.string(byArrayArray[1]);
        this._copyright = this.string(byArrayArray[2]);
        this._comment = this.string(byArrayArray[3]);
        this._rating = this.string(byArrayArray[4]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Standard Tag Values.  Title: " + this._title + ", Author: " + this._artist + ", Copyright: " + this._copyright + ", Description: " + this._comment + ", Rating: " + this._rating);
        }
    }

    private void parseExtendedContentDescription(DataInputStream dataInputStream) throws IOException {
        LOG.debug("Parsing extended content description");
        int n = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Extended fieldCount: " + n);
        }
        block7: for (int i = 0; i < n; ++i) {
            int n2 = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
            byte[] byArray = new byte[n2];
            dataInputStream.readFully(byArray);
            String string = this.string(byArray);
            int n3 = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
            int n4 = ByteOrder.ushort2int(ByteOrder.leb2short(dataInputStream));
            switch (n3) {
                case 0: {
                    this.parseExtendedString(string, n4, dataInputStream);
                    continue block7;
                }
                case 1: {
                    this.parseExtendedBinary(string, n4, dataInputStream);
                    continue block7;
                }
                case 2: {
                    this.parseExtendedBoolean(string, n4, dataInputStream);
                    continue block7;
                }
                case 3: {
                    this.parseExtendedInt(string, n4, dataInputStream);
                    continue block7;
                }
                case 4: {
                    this.parseExtendedInt(string, n4, dataInputStream);
                    continue block7;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unknown dataType: " + n3 + " for field: " + string);
                    }
                    IOUtils.ensureSkip(dataInputStream, n4);
                }
            }
        }
    }

    private void parseExtendedString(String string, int n, DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[Math.min(250, n)];
        dataInputStream.readFully(byArray);
        int n2 = Math.max(0, n - 250);
        IOUtils.ensureSkip(dataInputStream, n2);
        String string2 = this.string(byArray);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing extended String.  field: " + string + ", Value: " + string2);
        }
        if ("WM/Title".equals(string)) {
            if (this._title == null) {
                this._title = string2;
            }
        } else if ("WM/Author".equals(string)) {
            if (this._artist == null) {
                this._artist = string2;
            }
        } else if ("WM/AlbumTitle".equals(string)) {
            if (this._album == null) {
                this._album = string2;
            }
        } else if ("WM/TrackNumber".equals(string)) {
            if (this._track == -1) {
                this._track = this.toShort(string2);
            }
        } else if ("WM/Year".equals(string)) {
            if (this._year == null) {
                this._year = string2;
            }
        } else if ("WM/Genre".equals(string)) {
            if (this._genre == null) {
                this._genre = string2;
            }
        } else if ("WM/Description".equals(string) && this._comment == null) {
            this._comment = string2;
        }
    }

    private void parseExtendedBoolean(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring boolean field: " + string + ", size: " + n);
        }
        IOUtils.ensureSkip(dataInputStream, n);
    }

    private void parseExtendedInt(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (n != 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Int field size != 4, ignoring.   Field: " + string + ", size: " + n);
            }
            IOUtils.ensureSkip(dataInputStream, n);
            return;
        }
        int n2 = ByteOrder.leb2int(dataInputStream);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing extended int, field: " + string + ", size: " + n + ", value: " + n2);
        }
        if ("WM/TrackNumber".equals(string) && this._track == -1) {
            short s = (short)n2;
            if (s < 0) {
                throw new IOException("ASF file reports negative track number " + s);
            }
            this._track = s;
        }
    }

    private void parseExtendedBinary(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring binary field: " + string + ", size: " + n);
        }
        IOUtils.ensureSkip(dataInputStream, n);
    }

    private void parseExtendedLong(String string, int n, DataInputStream dataInputStream) throws IOException {
        if (n != 8) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Long field size != 8, ignoring.   Field: " + string + ", size: " + n);
            }
            IOUtils.ensureSkip(dataInputStream, n);
            return;
        }
        long l = ByteOrder.leb2long(dataInputStream);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring long field: " + string + ", size: " + n + ", value: " + l);
        }
    }

    private short toShort(String string) {
        try {
            return Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String string(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        try {
            return new String(byArray, "UTF-16LE").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            int n = 0;
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 0) continue;
                byArray[n++] = byArray[i];
            }
            return new String(byArray, 0, n, "UTF-8");
        }
    }

    private static class Extended {
        private static final String WM_TITLE = "WM/Title";
        private static final String WM_AUTHOR = "WM/Author";
        private static final String WM_ALBUMTITLE = "WM/AlbumTitle";
        private static final String WM_TRACK = "WM/Track";
        private static final String WM_TRACK_NUMBER = "WM/TrackNumber";
        private static final String WM_YEAR = "WM/Year";
        private static final String WM_GENRE = "WM/Genre";
        private static final String WM_DESCRIPTION = "WM/Description";
        private static final String WM_LYRICS = "WM/Lyrics";
        private static final String VBR = "IsVBR";
        private static final String WM_UNIQUE_FILE_IDENTIFIER = "WM/UniqueFileIdentifier";
        private static final String WM_ALBUMARTIST = "WM/AlbumArtist";
        private static final String ID3 = "ID3";
        private static final String WM_PROVIDER = "WM/Provider";
        private static final String WM_PROVIDER_RATING = "WM/ProviderRating";
        private static final String WM_PUBLISHER = "WM/Publisher";
        private static final String WM_COMPOSER = "WM/Composer";
        private static final String WM_ENCODING_TIME = "WM/EncodingTime";

        private Extended() {
        }
    }

    private static class IDs {
        private static final byte[] HEADER_ID = new byte[]{48, 38, -78, 117, -114, 102, -49, 17, -90, -39, 0, -86, 0, 98, -50, 108};
        private static final byte[] FILE_PROPERTIES_ID = new byte[]{-95, -36, -85, -116, 71, -87, -49, 17, -114, -28, 0, -64, 12, 32, 83, 101};
        private static final byte[] STREAM_PROPERTIES_ID = new byte[]{-111, 7, -36, -73, -73, -87, -49, 17, -114, -26, 0, -64, 12, 32, 83, 101};
        private static final byte[] EXTENDED_STREAM_PROPERTIES_ID = new byte[]{-53, -91, -26, 20, 114, -58, 50, 67, -125, -103, -87, 105, 82, 6, 91, 90};
        private static final byte[] CONTENT_DESCRIPTION_ID = new byte[]{51, 38, -78, 117, -114, 102, -49, 17, -90, -39, 0, -86, 0, 98, -50, 108};
        private static final byte[] EXTENDED_CONTENT_DESCRIPTION_ID = new byte[]{64, -92, -48, -46, 7, -29, -46, 17, -105, -16, 0, -96, -55, 94, -88, 80};
        private static final byte[] CONTENT_ENCRYPTION_ID = new byte[]{-5, -77, 17, 34, 35, -67, -46, 17, -76, -73, 0, -96, -55, 85, -4, 110};
        private static final byte[] EXTENDED_CONTENT_ENCRYPTION_ID = new byte[]{20, -26, -118, 41, 34, 38, 23, 76, -71, 53, -38, -32, 126, -23, 40, -100};
        private static final byte[] CODEC_LIST_ID = new byte[]{64, 82, -47, -122, 29, 49, -48, 17, -93, -92, 0, -96, -55, 3, 72, -10};
        private static final byte[] AUDIO_STREAM_ID = new byte[]{64, -98, 105, -8, 77, 91, -49, 17, -88, -3, 0, -128, 95, 92, 68, 43};
        private static final byte[] VIDEO_STREAM_ID = new byte[]{-64, -17, 25, -68, 77, 91, -49, 17, -88, -3, 0, -128, 95, 92, 68, 43};

        private IDs() {
        }
    }
}

