/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.limewire.security.SecurityToken;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

public final class LimeACKVendorMessage
extends AbstractVendorMessage {
    public static final int VERSION = 3;
    public static final int OLD_VERSION = 2;
    private static final int PAYLOAD_MIN_LENGTH_V3 = LimeACKVendorMessage.derivePayloadV3(255, new byte[1]).length;

    LimeACKVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 11, n, byArray2, network);
        if (this.getVersion() == 1) {
            throw new BadPacketException("UNSUPPORTED OLD VERSION");
        }
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
        if (this.getVersion() == 2 && this.getPayload().length != 1) {
            throw new BadPacketException("VERSION 2 UNSUPPORTED PAYLOAD LEN: " + this.getPayload().length);
        }
        if (this.getVersion() == 3 && this.getPayload().length < PAYLOAD_MIN_LENGTH_V3) {
            throw new BadPacketException("VERSION 3 should have a GGEP");
        }
    }

    public LimeACKVendorMessage(GUID gUID, int n) {
        super(F_LIME_VENDOR_ID, 11, 2, LimeACKVendorMessage.derivePayload(n));
        this.setGUID(gUID);
    }

    public LimeACKVendorMessage(GUID gUID, int n, SecurityToken securityToken) {
        super(F_LIME_VENDOR_ID, 11, 3, LimeACKVendorMessage.derivePayloadV3(n, securityToken.getBytes()));
        this.setGUID(gUID);
    }

    public int getNumResults() {
        return ByteOrder.ubyte2int(this.getPayload()[0]);
    }

    public SecurityToken getSecurityToken() {
        if (this.getVersion() > 2) {
            try {
                GGEP gGEP = new GGEP(this.getPayload(), 1);
                if (gGEP.hasKey("SO")) {
                    return new UnknownSecurityToken(gGEP.getBytes("SO"));
                }
            }
            catch (BadGGEPPropertyException badGGEPPropertyException) {
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                // empty catch block
            }
        }
        return null;
    }

    private static byte[] derivePayload(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Number of results too big: " + n);
        }
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[2];
        ByteOrder.short2leb((short)n, byArray2, 0);
        byArray[0] = byArray2[0];
        return byArray;
    }

    private static byte[] derivePayloadV3(int n, byte[] byArray) {
        if (n <= 0 || n > 255) {
            throw new IllegalArgumentException("Number of results too big: " + n);
        }
        byte[] byArray2 = new byte[2];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteOrder.short2leb((short)n, byArray2, 0);
        byteArrayOutputStream.write(byArray2[0]);
        GGEP gGEP = new GGEP();
        gGEP.put("SO", byArray);
        try {
            gGEP.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public boolean equals(Object object) {
        if (object instanceof LimeACKVendorMessage) {
            LimeACKVendorMessage limeACKVendorMessage = (LimeACKVendorMessage)object;
            GUID gUID = new GUID(this.getGUID());
            GUID gUID2 = new GUID(limeACKVendorMessage.getGUID());
            int n = limeACKVendorMessage.getNumResults();
            return gUID.equals(gUID2) && this.getNumResults() == n && this.areEqualTokens(this.getSecurityToken(), limeACKVendorMessage.getSecurityToken()) && super.equals(object);
        }
        return false;
    }

    private final boolean areEqualTokens(SecurityToken securityToken, SecurityToken securityToken2) {
        return securityToken == securityToken2 || securityToken != null && securityToken2 != null && Arrays.equals(securityToken.getBytes(), securityToken2.getBytes());
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append(", num results: ").append(this.getNumResults());
        stringBuilder.append(", security token: ").append(this.getSecurityToken());
        return stringBuilder.toString();
    }

    private class UnknownSecurityToken
    implements SecurityToken {
        private final byte[] data;

        public UnknownSecurityToken(byte[] byArray) {
            this.data = byArray;
        }

        public byte[] getBytes() {
            return this.data;
        }

        public boolean isFor(SecurityToken.TokenData tokenData) {
            return false;
        }

        public void write(OutputStream outputStream) throws IOException {
            outputStream.write(this.data);
        }
    }
}

