/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.PushEndpointFactory;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.altlocs.AltLocManager;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.DirectAltLoc;
import com.limegroup.gnutella.altlocs.PushAltLoc;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.HeadPong;
import com.limegroup.gnutella.messages.vendor.HeadPongFactory;
import com.limegroup.gnutella.messages.vendor.HeadPongImpl;
import com.limegroup.gnutella.messages.vendor.HeadPongRequestor;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.SSLSettings;
import com.limegroup.gnutella.settings.UploadSettings;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.BitNumbers;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.MultiRRIterator;
import org.limewire.io.Connectable;
import org.limewire.io.CountingOutputStream;
import org.limewire.io.IpPort;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class HeadPongFactoryImpl
implements HeadPongFactory {
    private static final Log LOG = LogFactory.getLog(HeadPongFactoryImpl.class);
    private final NetworkManager networkManager;
    private final Provider<UploadManager> uploadManager;
    private final Provider<FileManager> fileManager;
    private final Provider<AltLocManager> altLocManager;
    private final PushEndpointFactory pushEndpointFactory;
    public static final int DEFAULT_PACKET_SIZE = 1380;
    private static int PACKET_SIZE = 1380;
    private final Provider<DownloadManager> downloadManager;

    @Inject
    public HeadPongFactoryImpl(NetworkManager networkManager, Provider<UploadManager> provider, Provider<FileManager> provider2, Provider<AltLocManager> provider3, PushEndpointFactory pushEndpointFactory, Provider<DownloadManager> provider4) {
        this.networkManager = networkManager;
        this.uploadManager = provider;
        this.fileManager = provider2;
        this.altLocManager = provider3;
        this.pushEndpointFactory = pushEndpointFactory;
        this.downloadManager = provider4;
    }

    @Override
    public HeadPong createFromNetwork(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        return new HeadPongImpl(byArray, by, by2, n, byArray2, network, this.pushEndpointFactory);
    }

    @Override
    public HeadPong create(HeadPongRequestor headPongRequestor) {
        return new HeadPongImpl(new GUID(headPongRequestor.getGUID()), this.versionFor(headPongRequestor), this.derivePayload(headPongRequestor));
    }

    private byte[] writeGGEP(GGEP gGEP) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gGEP.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addLocations(HeadPongRequestor headPongRequestor, URN uRN, OutputStream outputStream, AtomicReference<BitNumbers> atomicReference, int n, boolean bl) {
        if (headPongRequestor.requestsAltlocs()) {
            AlternateLocationCollection<DirectAltLoc> alternateLocationCollection;
            AlternateLocationCollection<DirectAltLoc> alternateLocationCollection2 = alternateLocationCollection = this.altLocManager.get().getDirect(uRN);
            synchronized (alternateLocationCollection2) {
                try {
                    return !this.writeLocs(outputStream, alternateLocationCollection.iterator(), atomicReference, n, bl);
                }
                catch (IOException iOException) {
                    ErrorService.error(iOException);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPushLocations(HeadPongRequestor headPongRequestor, URN uRN, OutputStream outputStream, boolean bl, int n, boolean bl2) {
        if (!headPongRequestor.requestsPushLocs()) {
            return true;
        }
        try {
            boolean bl3 = headPongRequestor.requestsFWTOnlyPushLocs();
            if (bl3) {
                AlternateLocationCollection<PushAltLoc> alternateLocationCollection;
                AlternateLocationCollection<PushAltLoc> alternateLocationCollection2 = alternateLocationCollection = this.altLocManager.get().getPushFWT(uRN);
                synchronized (alternateLocationCollection2) {
                    return !this.writePushLocs(outputStream, alternateLocationCollection.iterator(), bl, n, bl2);
                }
            }
            AlternateLocationCollection<PushAltLoc> alternateLocationCollection = this.altLocManager.get().getPushNoFWT(uRN);
            AlternateLocationCollection<PushAltLoc> alternateLocationCollection3 = this.altLocManager.get().getPushFWT(uRN);
            AlternateLocationCollection<PushAltLoc> alternateLocationCollection4 = alternateLocationCollection;
            synchronized (alternateLocationCollection4) {
                AlternateLocationCollection<PushAltLoc> alternateLocationCollection5 = alternateLocationCollection3;
                synchronized (alternateLocationCollection5) {
                    return !this.writePushLocs(outputStream, new MultiRRIterator<PushAltLoc>(alternateLocationCollection.iterator(), alternateLocationCollection3.iterator()), bl, n, bl2);
                }
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return false;
        }
    }

    private byte calculateQueueStatus() {
        int n = this.uploadManager.get().getNumQueuedUploads();
        if (n >= UploadSettings.UPLOAD_QUEUE_SIZE.getValue()) {
            return 127;
        }
        if (n > 0) {
            return (byte)n;
        }
        return (byte)(this.uploadManager.get().uploadsInProgress() - UploadSettings.HARD_MAX_UPLOADS.getValue());
    }

    private byte calculateCode(FileDesc fileDesc) {
        byte by = 0;
        if (!this.networkManager.acceptedIncomingConnection()) {
            by = 4;
        }
        if (fileDesc instanceof IncompleteFileDesc) {
            by = (byte)(by | 2);
            if (this.downloadManager.get().isActivelyDownloading(fileDesc.getSHA1Urn())) {
                by = (byte)(by | 8);
            }
        } else {
            by = (byte)(by | 1);
        }
        return by;
    }

    private byte[] constructGGEPPayload(HeadPongRequestor headPongRequestor) {
        byte[] byArray;
        Object object;
        Object object2;
        Object object3;
        GGEP gGEP = new GGEP();
        URN uRN = headPongRequestor.getUrn();
        FileDesc fileDesc = this.fileManager.get().getFileDescForUrn(uRN);
        if (fileDesc == null) {
            gGEP.put("C", (byte)0);
            return this.writeGGEP(gGEP);
        }
        int n = 1;
        if (this.networkManager.acceptedIncomingConnection() && SSLSettings.isIncomingTLSEnabled()) {
            gGEP.put("F", (byte)1);
            n += 4;
        }
        byte by = this.calculateCode(fileDesc);
        gGEP.put("C", by);
        n += gGEP.getHeaderOverhead("C");
        gGEP.put("V", VendorMessage.F_LIME_VENDOR_ID);
        n += gGEP.getHeaderOverhead("V");
        gGEP.put("Q", this.calculateQueueStatus());
        n += gGEP.getHeaderOverhead("Q");
        if ((by & 2) == 2 && headPongRequestor.requestsRanges()) {
            object3 = this.deriveRanges(fileDesc);
            if (((IntervalSet.ByteIntervals)object3).length() == 0) {
                gGEP.put("Q", (byte)127);
            } else if (n + ((IntervalSet.ByteIntervals)object3).length() + 11 <= PACKET_SIZE) {
                if (((IntervalSet.ByteIntervals)object3).ints.length > 0) {
                    gGEP.put("R", ((IntervalSet.ByteIntervals)object3).ints);
                    n += gGEP.getHeaderOverhead("R");
                }
                if (((IntervalSet.ByteIntervals)object3).longs.length > 0) {
                    gGEP.put("R5", ((IntervalSet.ByteIntervals)object3).longs);
                    n += gGEP.getHeaderOverhead("R5");
                }
            }
        }
        object3 = new ByteArrayOutputStream();
        this.addPushLocations(headPongRequestor, uRN, (OutputStream)object3, true, n + 5, false);
        if (((ByteArrayOutputStream)object3).size() > 0) {
            object2 = ((ByteArrayOutputStream)object3).toByteArray();
            gGEP.put("P", (byte[])object2);
            n += gGEP.getHeaderOverhead("P");
        }
        ((ByteArrayOutputStream)object3).reset();
        object2 = new AtomicReference();
        this.addLocations(headPongRequestor, uRN, (OutputStream)object3, (AtomicReference<BitNumbers>)object2, n + 5, false);
        if (((ByteArrayOutputStream)object3).size() > 0) {
            object = ((ByteArrayOutputStream)object3).toByteArray();
            gGEP.put("A", (byte[])object);
            n += gGEP.getHeaderOverhead("A");
        }
        assert (n <= PACKET_SIZE) : "size is too big " + n + " vs " + PACKET_SIZE;
        object = (BitNumbers)((AtomicReference)object2).get();
        if (object != null && (byArray = ((BitNumbers)object).toByteArray()).length > 0) {
            gGEP.put("T", byArray);
            n += gGEP.getHeaderOverhead("T");
        }
        byArray = this.writeGGEP(gGEP);
        assert (byArray.length == n) : "expected: " + n + ", was: " + byArray.length;
        return byArray;
    }

    private byte[] constructBinaryPayload(HeadPongRequestor headPongRequestor) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CountingOutputStream countingOutputStream = new CountingOutputStream(byteArrayOutputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(countingOutputStream);
        byte by = 0;
        URN uRN = headPongRequestor.getUrn();
        FileDesc fileDesc = this.fileManager.get().getFileDescForUrn(uRN);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            byte by2 = headPongRequestor.getFeatures();
            by2 = (byte)(by2 & 0xFFFFFFEF);
            dataOutputStream.write(by2);
            if (LOG.isDebugEnabled()) {
                LOG.debug("writing features " + by2);
            }
            if (fileDesc == null || fileDesc.getFileSize() > Integer.MAX_VALUE) {
                LOG.debug("we do not have the file");
                dataOutputStream.write(0);
                return byteArrayOutputStream.toByteArray();
            }
            by = this.calculateCode(fileDesc);
            dataOutputStream.write(by);
            if (LOG.isDebugEnabled()) {
                LOG.debug("our return code is " + by);
            }
            dataOutputStream.write(VendorMessage.F_LIME_VENDOR_ID);
            dataOutputStream.writeByte(this.calculateQueueStatus());
            if ((by & 2) == 2 && headPongRequestor.requestsRanges()) {
                bl3 = !this.writeRanges(countingOutputStream, fileDesc);
            }
            bl2 = this.addPushLocations(headPongRequestor, uRN, countingOutputStream, false, countingOutputStream.getAmountWritten(), true);
            bl = this.addLocations(headPongRequestor, uRN, countingOutputStream, null, countingOutputStream.getAmountWritten(), true);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (bl3) {
            LOG.debug("not sending ranges");
            byArray[0] = (byte)(byArray[0] & 0xFFFFFFFE);
        }
        if (bl) {
            LOG.debug("not sending altlocs");
            byArray[0] = (byte)(byArray[0] & 0xFFFFFFFD);
        }
        if (bl2) {
            LOG.debug("not sending push altlocs");
            byArray[0] = (byte)(byArray[0] & 0xFFFFFFFB);
        }
        return byArray;
    }

    private byte[] derivePayload(HeadPongRequestor headPongRequestor) {
        if (!headPongRequestor.isPongGGEPCapable()) {
            return this.constructBinaryPayload(headPongRequestor);
        }
        return this.constructGGEPPayload(headPongRequestor);
    }

    private int versionFor(HeadPongRequestor headPongRequestor) {
        if (!headPongRequestor.isPongGGEPCapable()) {
            return 1;
        }
        return 2;
    }

    private final IntervalSet.ByteIntervals deriveRanges(FileDesc fileDesc) {
        return ((IncompleteFileDesc)fileDesc).getRangesAsByte();
    }

    private final boolean writeLocs(OutputStream outputStream, Iterator<DirectAltLoc> iterator, AtomicReference<BitNumbers> atomicReference, int n, boolean bl) throws IOException {
        if (!iterator.hasNext()) {
            return false;
        }
        int n2 = (PACKET_SIZE - (n + (bl ? 2 : 0))) / 6;
        if (n2 == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add up to " + n2 + " locs to pong");
        }
        BitNumbers bitNumbers = null;
        if (atomicReference != null) {
            bitNumbers = new BitNumbers(n2);
            atomicReference.set(bitNumbers);
        }
        ByteArrayOutputStream byteArrayOutputStream = bl ? new ByteArrayOutputStream() : (ByteArrayOutputStream)outputStream;
        int n3 = 0;
        long l = System.currentTimeMillis();
        while (iterator.hasNext() && n3 < n2) {
            DirectAltLoc directAltLoc = iterator.next();
            if (directAltLoc.canBeSent(0)) {
                directAltLoc.send(l, 0);
                byteArrayOutputStream.write(directAltLoc.getHost().getInetAddress().getAddress());
                ByteOrder.short2leb((short)directAltLoc.getHost().getPort(), byteArrayOutputStream);
                IpPort ipPort = directAltLoc.getHost();
                if (bitNumbers != null && ipPort instanceof Connectable && ((Connectable)ipPort).isTLSCapable()) {
                    bitNumbers.set(n3);
                }
                ++n3;
                continue;
            }
            if (directAltLoc.canBeSentAny()) continue;
            iterator.remove();
        }
        LOG.debug("adding altlocs");
        if (bl) {
            ByteOrder.short2beb((short)byteArrayOutputStream.size(), outputStream);
            byteArrayOutputStream.writeTo(outputStream);
        }
        return true;
    }

    private final boolean writePushLocs(OutputStream outputStream, Iterator<PushAltLoc> iterator, boolean bl, int n, boolean bl2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (!iterator.hasNext()) {
            return false;
        }
        int n2 = (PACKET_SIZE - (n + (bl2 ? 2 : 0))) / (bl ? 48 : 47);
        if (n2 == 0) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("trying to add up to " + n2 + " push locs to pong");
        }
        long l = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = bl2 ? new ByteArrayOutputStream() : (ByteArrayOutputStream)outputStream;
        while (iterator.hasNext() && n2 > 0) {
            PushAltLoc pushAltLoc = iterator.next();
            if (pushAltLoc.getPushAddress().getProxies().isEmpty()) {
                iterator.remove();
                continue;
            }
            if (pushAltLoc.canBeSent(0)) {
                byteArrayOutputStream.write(pushAltLoc.getPushAddress().toBytes(bl));
                --n2;
                pushAltLoc.send(l, 0);
                continue;
            }
            if (pushAltLoc.canBeSentAny()) continue;
            iterator.remove();
        }
        if (byteArrayOutputStream.size() == 0) {
            LOG.debug("did not send any push locs");
            return false;
        }
        LOG.debug("adding push altlocs");
        if (bl2) {
            ByteOrder.short2beb((short)byteArrayOutputStream.size(), outputStream);
            byteArrayOutputStream.writeTo(outputStream);
        }
        return true;
    }

    private final boolean writeRanges(CountingOutputStream countingOutputStream, FileDesc fileDesc) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(countingOutputStream);
        LOG.debug("adding ranges to pong");
        IntervalSet.ByteIntervals byteIntervals = this.deriveRanges(fileDesc);
        assert (byteIntervals.longs.length == 0) : "long ranges in legacy pong";
        if (countingOutputStream.getAmountWritten() + 2 + byteIntervals.ints.length <= PACKET_SIZE) {
            LOG.debug("added ranges");
            dataOutputStream.writeShort((short)byteIntervals.ints.length);
            countingOutputStream.write(byteIntervals.ints);
            return true;
        }
        LOG.debug("ranges will not fit :(");
        return false;
    }
}

