/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.AbstractVendorMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.limewire.service.ErrorService;

public class ContentRequest
extends AbstractVendorMessage {
    public static final int VERSION = 1;

    public ContentRequest(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, by, by2, F_LIME_VENDOR_ID, 28, n, byArray2, network);
        if (this.getPayload().length < 1) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + this.getPayload().length);
        }
    }

    public ContentRequest(URN uRN) {
        super(F_LIME_VENDOR_ID, 28, 1, ContentRequest.derivePayload(uRN));
    }

    private static byte[] derivePayload(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        GGEP gGEP = new GGEP();
        gGEP.put("S1", uRN.getBytes());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            gGEP.write(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public URN getURN() {
        try {
            GGEP gGEP = new GGEP(this.getPayload(), 0);
            return URN.createSHA1UrnFromBytes(gGEP.getBytes("S1"));
        }
        catch (BadGGEPBlockException badGGEPBlockException) {
        }
        catch (BadGGEPPropertyException badGGEPPropertyException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

