/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.messages.AbstractMessage;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PushRequest;
import com.limegroup.gnutella.util.DataUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.limewire.io.NetworkUtils;
import org.limewire.service.ErrorService;
import org.limewire.util.ByteOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PushRequestImpl
extends AbstractMessage
implements PushRequest {
    private static final int STANDARD_PAYLOAD_SIZE = 26;
    private static final GGEP NULL_GGEP = new GGEP();
    private byte[] payload;
    private GGEP ggep;

    public PushRequestImpl(byte[] byArray, byte by, byte by2, byte[] byArray2, Message.Network network) throws BadPacketException {
        super(byArray, (byte)64, by, by2, byArray2.length, network);
        if (byArray2.length < 26) {
            throw new BadPacketException("Payload too small: " + byArray2.length);
        }
        this.payload = byArray2;
        if (!NetworkUtils.isValidPort(this.getPort())) {
            throw new BadPacketException("invalid port");
        }
        String string = NetworkUtils.ip2string(byArray2, 20);
        if (!NetworkUtils.isValidAddress(string)) {
            throw new BadPacketException("invalid address: " + string);
        }
    }

    public PushRequestImpl(byte[] byArray, byte by, byte[] byArray2, long l, byte[] byArray3, int n) {
        this(byArray, by, byArray2, l, byArray3, n, Message.Network.UNKNOWN);
    }

    public PushRequestImpl(byte[] byArray, byte by, byte[] byArray2, long l, byte[] byArray3, int n, Message.Network network) {
        this(byArray, by, byArray2, l, byArray3, n, network, false);
    }

    public PushRequestImpl(byte[] byArray, byte by, byte[] byArray2, long l, byte[] byArray3, int n, Message.Network network, boolean bl) {
        super(byArray, (byte)64, by, (byte)0, 0, network);
        if (byArray2.length != 16) {
            throw new IllegalArgumentException("invalid guid length: " + byArray2.length);
        }
        if ((l & 0xFFFFFFFF00000000L) != 0L) {
            throw new IllegalArgumentException("invalid index: " + l);
        }
        if (byArray3.length != 4) {
            throw new IllegalArgumentException("invalid ip length: " + byArray3.length);
        }
        if (!NetworkUtils.isValidAddress(byArray3)) {
            throw new IllegalArgumentException("invalid ip " + NetworkUtils.ip2string(byArray3));
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        byte[] byArray4 = DataUtils.EMPTY_BYTE_ARRAY;
        if (bl) {
            byArray4 = PushGGEPHelper.TLS_GGEP;
        }
        int n2 = 26 + byArray4.length;
        this.payload = new byte[n2];
        System.arraycopy(byArray2, 0, this.payload, 0, 16);
        ByteOrder.int2leb((int)l, this.payload, 16);
        this.payload[20] = byArray3[0];
        this.payload[21] = byArray3[1];
        this.payload[22] = byArray3[2];
        this.payload[23] = byArray3[3];
        ByteOrder.short2leb((short)n, this.payload, 24);
        System.arraycopy(byArray4, 0, this.payload, 26, byArray4.length);
        this.updateLength(n2);
    }

    @Override
    public boolean isTLSCapable() {
        this.parseGGEP();
        if (this.ggep != null && this.ggep != NULL_GGEP) {
            return this.ggep.hasKey("TLS");
        }
        return false;
    }

    private void parseGGEP() {
        if (this.ggep == null && this.payload.length > 26) {
            try {
                this.ggep = new GGEP(this.payload, 26);
            }
            catch (BadGGEPBlockException badGGEPBlockException) {
                this.ggep = NULL_GGEP;
            }
        }
    }

    @Override
    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.payload);
    }

    @Override
    public byte[] getClientGUID() {
        byte[] byArray = new byte[16];
        System.arraycopy(this.payload, 0, byArray, 0, 16);
        return byArray;
    }

    @Override
    public long getIndex() {
        return ByteOrder.uint2long(ByteOrder.leb2int(this.payload, 16));
    }

    @Override
    public boolean isFirewallTransferPush() {
        return this.getIndex() == 0x7FFFFFFDL;
    }

    @Override
    public byte[] getIP() {
        byte[] byArray = new byte[]{this.payload[20], this.payload[21], this.payload[22], this.payload[23]};
        return byArray;
    }

    @Override
    public int getPort() {
        return ByteOrder.ushort2int(ByteOrder.leb2short(this.payload, 24));
    }

    @Override
    public Class<? extends Message> getHandlerClass() {
        return PushRequest.class;
    }

    @Override
    public String toString() {
        return "PushRequest(" + super.toString() + " " + NetworkUtils.ip2string(this.getIP()) + ":" + this.getPort() + ")";
    }

    private static class PushGGEPHelper {
        private static final byte[] TLS_GGEP;

        private PushGGEPHelper() {
        }

        static {
            GGEP gGEP = new GGEP();
            gGEP.put("TLS");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                gGEP.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            TLS_GGEP = byteArrayOutputStream.toByteArray();
        }
    }
}

